/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.exoplatform.commons.utils.BinaryOutput;
import org.exoplatform.commons.utils.ByteArrayOutput;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.portal.resource.AbstractResourceHandler;
import org.exoplatform.portal.resource.CachedStylesheet;
import org.exoplatform.portal.resource.CompositeSkin;
import org.exoplatform.portal.resource.GateInSkinConfigDeployer;
import org.exoplatform.portal.resource.GateInSkinConfigRemoval;
import org.exoplatform.portal.resource.MainResourceResolver;
import org.exoplatform.portal.resource.RenderingException;
import org.exoplatform.portal.resource.Resource;
import org.exoplatform.portal.resource.ResourceRenderer;
import org.exoplatform.portal.resource.ResourceResolver;
import org.exoplatform.portal.resource.SimpleSkin;
import org.exoplatform.portal.resource.Skin;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinKey;
import org.exoplatform.portal.resource.compressor.ResourceCompressor;
import org.exoplatform.portal.resource.compressor.ResourceType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.Orientation;
import org.gatein.wci.WebAppListener;
import org.gatein.wci.impl.DefaultServletContainerFactory;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Managed
@NameTemplate(value={@Property(key="view", value="portal"), @Property(key="service", value="management"), @Property(key="type", value="skin")})
@ManagedDescription(value="Skin service")
@RESTEndpoint(path="skinservice")
public class SkinService
implements Startable {
    protected static Log log = ExoLogger.getLogger((String)"portal.SkinService");
    private static final Map<Orientation, String> suffixMap = new EnumMap<Orientation, String>(Orientation.class);
    private static final String LEFT_P = "\\(";
    private static final String RIGHT_P = "\\)";
    private static final Pattern IMPORT_PATTERN;
    private static final Pattern BACKGROUND_PATTERN;
    private static final Pattern LT;
    private static final Pattern RT;
    private static final int ONE_MONTH = 2592000;
    private static final int ONE_HOUR = 3600;
    private final AbstractResourceHandler deployer;
    private final AbstractResourceHandler removal;
    private final Map<SkinKey, SkinConfig> portalSkins_;
    private final Map<SkinKey, SkinConfig> skinConfigs_;
    private final HashSet<String> availableSkins_;
    private final Map<String, CachedStylesheet> ltCache;
    private final Map<String, CachedStylesheet> rtCache;
    private final Map<String, Set<String>> portletThemes_;
    private final MainResourceResolver mainResolver;
    final String portalContainerName;
    final String id = Long.toString(System.currentTimeMillis());
    private ResourceCompressor compressor;

    public SkinService(ExoContainerContext context, ResourceCompressor compressor) {
        this.compressor = compressor;
        this.portalSkins_ = new LinkedHashMap<SkinKey, SkinConfig>();
        this.skinConfigs_ = new LinkedHashMap<SkinKey, SkinConfig>(20);
        this.availableSkins_ = new HashSet(5);
        this.ltCache = new ConcurrentHashMap<String, CachedStylesheet>();
        this.rtCache = new ConcurrentHashMap<String, CachedStylesheet>();
        this.portletThemes_ = new HashMap<String, Set<String>>();
        this.portalContainerName = context.getPortalContainerName();
        this.mainResolver = new MainResourceResolver(this.portalContainerName, this.skinConfigs_);
        this.deployer = new GateInSkinConfigDeployer(this.portalContainerName, this);
        this.removal = new GateInSkinConfigRemoval(this.portalContainerName, this);
    }

    public void addCategoryTheme(String categoryName) {
        if (!this.portletThemes_.containsKey(categoryName)) {
            this.portletThemes_.put(categoryName, new HashSet());
        }
    }

    public void addPortalSkin(String module, String skinName, String cssPath, ServletContext scontext) {
        this.addPortalSkin(module, skinName, cssPath, scontext, false);
    }

    public void addPortalSkin(String module, String skinName, String cssPath, ServletContext scontext, boolean overwrite) {
        this.availableSkins_.add(skinName);
        SkinKey key = new SkinKey(module, skinName);
        SkinConfig skinConfig = this.portalSkins_.get(key);
        if (skinConfig == null || overwrite) {
            skinConfig = new SimpleSkin(this, module, skinName, cssPath);
            this.portalSkins_.put(key, skinConfig);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding Portal skin : Bind " + key + " to " + skinConfig));
            }
        }
    }

    public void addPortalSkin(String module, String skinName, String cssPath, String cssData) {
        SkinKey key = new SkinKey(module, skinName);
        SkinConfig skinConfig = this.portalSkins_.get(key);
        if (skinConfig == null) {
            this.portalSkins_.put(key, new SimpleSkin(this, module, skinName, cssPath));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding Portal skin : Bind " + key + " to " + skinConfig));
            }
        }
        try {
            StringWriter output = new StringWriter();
            this.compressor.compress(new StringReader(cssData), output, ResourceType.STYLESHEET);
            cssData = output.toString();
        }
        catch (Exception e) {
            log.debug((Object)"Error when compressing CSS, will use normal CSS instead", (Throwable)e);
        }
        this.ltCache.put(cssPath, new CachedStylesheet(cssData));
        this.rtCache.put(cssPath, new CachedStylesheet(cssData));
    }

    public void addSkin(String module, String skinName, String cssPath, ServletContext scontext) {
        this.addSkin(module, skinName, cssPath, scontext, false);
    }

    public Skin merge(Collection<SkinConfig> skins) {
        return new CompositeSkin(this, skins);
    }

    public void addResourceResolver(ResourceResolver resolver) {
        this.mainResolver.resolvers.addIfAbsent(resolver);
    }

    public void addSkin(String module, String skinName, String cssPath, ServletContext scontext, boolean overwrite) {
        this.availableSkins_.add(skinName);
        SkinKey key = new SkinKey(module, skinName);
        SkinConfig skinConfig = this.skinConfigs_.get(key);
        if (skinConfig == null || overwrite) {
            skinConfig = new SimpleSkin(this, module, skinName, cssPath);
            this.skinConfigs_.put(key, skinConfig);
        }
    }

    public void addSkin(String module, String skinName, String cssPath, String cssData) {
        this.availableSkins_.add(skinName);
        SkinKey key = new SkinKey(module, skinName);
        SkinConfig skinConfig = this.skinConfigs_.get(key);
        if (skinConfig == null) {
            this.skinConfigs_.put(key, new SimpleSkin(this, module, skinName, cssPath));
        }
        this.ltCache.put(cssPath, new CachedStylesheet(cssData));
        this.rtCache.put(cssPath, new CachedStylesheet(cssData));
    }

    public void addTheme(String categoryName, List<String> themesName) {
        if (!this.portletThemes_.containsKey(categoryName)) {
            this.portletThemes_.put(categoryName, new HashSet());
        }
        Set<String> catThemes = this.portletThemes_.get(categoryName);
        for (String theme : themesName) {
            catThemes.add(theme);
        }
    }

    public Set<String> getAvailableSkinNames() {
        return this.availableSkins_;
    }

    public String getCSS(String cssPath) {
        try {
            final ByteArrayOutput output = new ByteArrayOutput();
            this.renderCSS(new ResourceRenderer(){

                public BinaryOutput getOutput() throws IOException {
                    return output;
                }

                public void setExpiration(long seconds) {
                }
            }, cssPath);
            return output.toString();
        }
        catch (IOException e) {
            log.error((Object)("Error while rendering css " + cssPath), (Throwable)e);
            return null;
        }
        catch (RenderingException e) {
            log.error((Object)("Error while rendering css " + cssPath), (Throwable)e);
            return null;
        }
    }

    public void renderCSS(ResourceRenderer renderer, String path) throws RenderingException, IOException {
        Orientation orientation = Orientation.LT;
        if (path.endsWith("-lt.css")) {
            path = path.substring(0, path.length() - "-lt.css".length()) + ".css";
        } else if (path.endsWith("-rt.css")) {
            path = path.substring(0, path.length() - "-rt.css".length()) + ".css";
            orientation = Orientation.RT;
        }
        if (!PropertyManager.isDevelopping()) {
            Map<String, CachedStylesheet> cache = orientation == Orientation.LT ? this.ltCache : this.rtCache;
            CachedStylesheet cachedCss = cache.get(path);
            if (cachedCss == null) {
                String css;
                StringBuffer sb = new StringBuffer();
                this.processCSS(sb, path, orientation, true);
                try {
                    StringWriter output = new StringWriter();
                    this.compressor.compress(new StringReader(sb.toString()), output, ResourceType.STYLESHEET);
                    css = output.toString();
                }
                catch (Exception e) {
                    log.debug((Object)"Error when compressing CSS, will use normal CSS instead", (Throwable)e);
                    css = sb.toString();
                }
                cachedCss = new CachedStylesheet(css);
                cache.put(path, cachedCss);
            }
            if (path.startsWith("/" + this.portalContainerName + "/resource")) {
                renderer.setExpiration(2592000L);
            } else {
                renderer.setExpiration(3600L);
            }
            cachedCss.writeTo(renderer.getOutput());
        } else {
            StringBuffer sb = new StringBuffer();
            this.processCSS(sb, path, orientation, false);
            byte[] bytes = sb.toString().getBytes("UTF-8");
            renderer.getOutput().write(bytes);
        }
    }

    public String getMergedCSS(String cssPath) {
        CachedStylesheet stylesheet = this.ltCache.get(cssPath);
        return stylesheet != null ? stylesheet.getText() : null;
    }

    public Collection<SkinConfig> getPortalSkins(String skinName) {
        Set<SkinKey> keys = this.portalSkins_.keySet();
        ArrayList<SkinConfig> portalSkins = new ArrayList<SkinConfig>();
        for (SkinKey key : keys) {
            if (!key.getName().equals(skinName)) continue;
            portalSkins.add(this.portalSkins_.get(key));
        }
        return portalSkins;
    }

    public Map<String, Set<String>> getPortletThemes() {
        return this.portletThemes_;
    }

    public SkinConfig getSkin(String module, String skinName) {
        SkinConfig config = this.skinConfigs_.get(new SkinKey(module, skinName));
        if (config == null) {
            this.skinConfigs_.get(new SkinKey(module, "Default"));
        }
        return config;
    }

    public void invalidatePortalSkinCache(String portalName, String skinName) {
        SkinKey key = new SkinKey(portalName, skinName);
        this.skinConfigs_.remove(key);
    }

    public long getLastModified(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        Map<String, CachedStylesheet> cache = this.ltCache;
        Orientation orientation = Orientation.LT;
        if (path.endsWith("-lt.css")) {
            path = path.substring(0, path.length() - "-lt.css".length()) + ".css";
        } else if (path.endsWith("-rt.css")) {
            path = path.substring(0, path.length() - "-rt.css".length()) + ".css";
            orientation = Orientation.RT;
        }
        CachedStylesheet cachedCSS = cache.get(path);
        if (cachedCSS == null) {
            return Long.MAX_VALUE;
        }
        return cachedCSS.getLastModified();
    }

    public void remove(String module, String skinName) throws Exception {
        SkinKey key = skinName.length() == 0 ? new SkinKey(module, "Default") : new SkinKey(module, skinName);
        this.skinConfigs_.remove(key);
    }

    public void removeSupportedSkin(String skinName) throws Exception {
        this.availableSkins_.remove(skinName);
    }

    public void remove(List<SkinKey> keys) throws Exception {
        if (keys == null) {
            return;
        }
        for (SkinKey key : keys) {
            this.skinConfigs_.remove(key);
        }
    }

    public int size() {
        return this.skinConfigs_.size();
    }

    private Resource getCSSResource(String cssPath, String outerCssFile) {
        Resource resource = this.mainResolver.resolve(cssPath);
        if (resource == null) {
            String logMessage;
            if (!cssPath.equals(outerCssFile)) {
                int lastIndexOfSlash = cssPath.lastIndexOf(47);
                String loadedCssFile = lastIndexOfSlash >= 0 ? cssPath.substring(lastIndexOfSlash + 1) : cssPath;
                logMessage = "Invalid <CSS FILE> configuration, please check the @import url(" + loadedCssFile + ") in " + outerCssFile + " , SkinService could not load the skin " + cssPath;
            } else {
                logMessage = "Not found <CSS FILE>, the path " + cssPath + " is invalid, SkinService could not load the skin " + cssPath;
            }
            log.error((Object)logMessage);
        }
        return resource;
    }

    private void processCSS(Appendable appendable, String cssPath, Orientation orientation, boolean merge) throws RenderingException, IOException {
        Resource skin = this.getCSSResource(cssPath, cssPath);
        this.processCSSRecursively(appendable, merge, skin, orientation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCSSRecursively(Appendable appendable, boolean merge, Resource skin, Orientation orientation) throws RenderingException, IOException {
        if (skin == null) {
            return;
        }
        String basePath = skin.getContextPath() + skin.getParentPath();
        String line = "";
        Reader tmp = skin.read();
        if (tmp == null) {
            throw new RenderingException("No skin resolved for path " + skin.getResourcePath());
        }
        BufferedReader reader = new BufferedReader(tmp);
        try {
            while ((line = reader.readLine()) != null) {
                line = this.proccessOrientation(line, orientation);
                line = this.proccessBackgroundUrl(line, basePath);
                Matcher matcher = IMPORT_PATTERN.matcher(line);
                while (matcher.find()) {
                    String includedPath = matcher.group(2);
                    if (!includedPath.startsWith("/")) {
                        includedPath = basePath + includedPath;
                    }
                    String embeddedPath = includedPath.substring(0, includedPath.length() - ".css".length());
                    StringBuffer strReplace = new StringBuffer();
                    if (merge) {
                        Resource ssskin = this.getCSSResource(includedPath, basePath + skin.getFileName());
                        this.processCSSRecursively(strReplace, merge, ssskin, orientation);
                    } else {
                        strReplace.append(matcher.group(1));
                        strReplace.append(embeddedPath);
                        strReplace.append(this.getSuffix(orientation));
                        strReplace.append(matcher.group(3));
                    }
                    String str = strReplace.toString().replaceAll("\\$", "\\\\\\$");
                    matcher.appendReplacement((StringBuffer)appendable, str);
                }
                matcher.appendTail((StringBuffer)appendable);
                appendable.append("\n");
            }
        }
        finally {
            Safe.close((Closeable)reader);
        }
    }

    private String proccessBackgroundUrl(String line, String basePath) {
        Matcher matcher = BACKGROUND_PATTERN.matcher(line);
        StringBuffer tmpBuilder = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group(2).startsWith("\"/") || matcher.group(2).startsWith("'/") || matcher.group(2).startsWith("/")) continue;
            StringBuilder strReplace = new StringBuilder();
            strReplace.append(matcher.group(1));
            strReplace.append(basePath);
            strReplace.append(matcher.group(2));
            strReplace.append(matcher.group(3));
            matcher.appendReplacement(tmpBuilder, strReplace.toString());
        }
        matcher.appendTail(tmpBuilder);
        return tmpBuilder.toString();
    }

    private String proccessOrientation(String line, Orientation orientation) {
        Pattern orientationPattern = orientation == Orientation.LT ? RT : LT;
        Matcher matcher = orientationPattern.matcher(line);
        StringBuffer tmpBuilder = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(tmpBuilder, "");
        }
        matcher.appendTail(tmpBuilder);
        return tmpBuilder.toString();
    }

    String getSuffix(Orientation orientation) {
        if (orientation == null) {
            orientation = Orientation.LT;
        }
        return suffixMap.get(orientation);
    }

    @Managed
    @ManagedDescription(value="The list of registered skins identifiers")
    public String[] getSkinList() {
        ArrayList<String> availableSkin = new ArrayList<String>();
        for (String skin : this.availableSkins_) {
            availableSkin.add(skin);
        }
        Collections.sort(availableSkin);
        return availableSkin.toArray(new String[availableSkin.size()]);
    }

    public void registerContext(ServletContext sContext) {
        this.mainResolver.registerContext(sContext);
    }

    public void unregisterServletContext(ServletContext servletContext) {
        this.mainResolver.removeServletContext(servletContext);
    }

    @Managed
    @ManagedDescription(value="Reload all skins")
    @Impact(value=ImpactType.WRITE)
    public void reloadSkins() {
        this.ltCache.clear();
        this.rtCache.clear();
    }

    @Managed
    @ManagedDescription(value="Reload a specified skin")
    public void reloadSkin(@ManagedDescription(value="The skin id") @ManagedName(value="skinId") String skinId) {
        this.ltCache.remove(skinId);
        this.rtCache.remove(skinId);
    }

    public void start() {
        DefaultServletContainerFactory.getInstance().getServletContainer().addWebAppListener((WebAppListener)this.deployer);
        DefaultServletContainerFactory.getInstance().getServletContainer().addWebAppListener((WebAppListener)this.removal);
    }

    public void stop() {
        DefaultServletContainerFactory.getInstance().getServletContainer().removeWebAppListener((WebAppListener)this.deployer);
        DefaultServletContainerFactory.getInstance().getServletContainer().removeWebAppListener((WebAppListener)this.removal);
    }

    static {
        suffixMap.put(Orientation.LT, "-lt.css");
        suffixMap.put(Orientation.RT, "-rt.css");
        suffixMap.put(Orientation.TL, "-lt.css");
        suffixMap.put(Orientation.TR, "-lt.css");
        IMPORT_PATTERN = Pattern.compile("(@import\\s+url\\(['\"]?)([^'\";]+.css)(['\"]?\\)\\s*;)");
        BACKGROUND_PATTERN = Pattern.compile("(background[^;]+url\\(['\"]?)([^'\";]+)(['\"]?\\)[^;]*;)");
        LT = Pattern.compile("[^{;]*;\\s*/\\*\\s*orientation=lt\\s*\\*/");
        RT = Pattern.compile("[^{;]*;\\s*/\\*\\s*orientation=rt\\s*\\*/");
    }
}

