/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.impl;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.forum.service.BufferAttachment;
import org.exoplatform.forum.service.CalculateModeratorEventListener;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.DataStorage;
import org.exoplatform.forum.service.DeletedUserCalculateEventListener;
import org.exoplatform.forum.service.EmailNotifyPlugin;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumAdministration;
import org.exoplatform.forum.service.ForumAttachment;
import org.exoplatform.forum.service.ForumEventQuery;
import org.exoplatform.forum.service.ForumLinkData;
import org.exoplatform.forum.service.ForumPageList;
import org.exoplatform.forum.service.ForumPrivateMessage;
import org.exoplatform.forum.service.ForumSearch;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.ForumStatistic;
import org.exoplatform.forum.service.ForumSubscription;
import org.exoplatform.forum.service.JCRForumAttachment;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.LazyPageList;
import org.exoplatform.forum.service.MessageBuilder;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.PruneSetting;
import org.exoplatform.forum.service.SortSettings;
import org.exoplatform.forum.service.Tag;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.TopicListAccess;
import org.exoplatform.forum.service.TopicType;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.service.Watch;
import org.exoplatform.forum.service.conf.CategoryData;
import org.exoplatform.forum.service.conf.CategoryEventListener;
import org.exoplatform.forum.service.conf.ForumData;
import org.exoplatform.forum.service.conf.ForumInitialDataPlugin;
import org.exoplatform.forum.service.conf.InitializeForumPlugin;
import org.exoplatform.forum.service.conf.PostData;
import org.exoplatform.forum.service.conf.SendMessageInfo;
import org.exoplatform.forum.service.conf.StatisticEventListener;
import org.exoplatform.forum.service.conf.TopicData;
import org.exoplatform.forum.service.impl.ForumNodeTypes;
import org.exoplatform.ks.common.conf.RoleRulesPlugin;
import org.exoplatform.ks.common.jcr.JCRSessionManager;
import org.exoplatform.ks.common.jcr.JCRTask;
import org.exoplatform.ks.common.jcr.KSDataLocation;
import org.exoplatform.ks.common.jcr.PropertyReader;
import org.exoplatform.ks.common.jcr.SessionManager;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.scheduler.JobInfo;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.exoplatform.services.scheduler.PeriodInfo;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Managed
@NameTemplate(value={@Property(key="service", value="forum"), @Property(key="view", value="storage")})
@ManagedDescription(value="Data Storage for this forum")
public class JCRDataStorage
implements DataStorage,
ForumNodeTypes {
    private static final Log log = ExoLogger.getLogger(JCRDataStorage.class);
    private Map<String, String> serverConfig = new HashMap<String, String>();
    private Map<String, Object> infoMap = new HashMap<String, Object>();
    final Queue<SendMessageInfo> pendingMessagesQueue = new ConcurrentLinkedQueue<SendMessageInfo>();
    private List<RoleRulesPlugin> rulesPlugins = new ArrayList<RoleRulesPlugin>();
    private List<InitializeForumPlugin> defaultPlugins = new ArrayList<InitializeForumPlugin>();
    private List<ForumInitialDataPlugin> dataPlugins = new ArrayList<ForumInitialDataPlugin>();
    private Map<String, EventListener> listeners = new HashMap<String, EventListener>();
    private SessionManager sessionManager;
    private KSDataLocation dataLocator;
    private String repository;
    private String workspace;

    public JCRDataStorage() {
    }

    public JCRDataStorage(KSDataLocation dataLocator) {
        this.setDataLocator(dataLocator);
    }

    @Override
    @Managed
    @ManagedDescription(value="repository for forum storage")
    public String getRepository() {
        return this.repository;
    }

    @Override
    @Managed
    @ManagedDescription(value="workspace for the forum storage")
    public String getWorkspace() {
        return this.workspace;
    }

    @Override
    @Managed
    @ManagedDescription(value="data path for forum storage")
    public String getPath() {
        return this.dataLocator.getForumHomeLocation();
    }

    @Override
    public void addPlugin(ComponentPlugin plugin) throws Exception {
        try {
            if (plugin instanceof EmailNotifyPlugin) {
                this.serverConfig = ((EmailNotifyPlugin)plugin).getServerConfiguration();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to add plugin", (Throwable)e);
        }
    }

    @Override
    public void addRolePlugin(ComponentPlugin plugin) throws Exception {
        if (plugin instanceof RoleRulesPlugin) {
            this.rulesPlugins.add((RoleRulesPlugin)plugin);
        }
    }

    @Override
    public void addInitialDefaultDataPlugin(ComponentPlugin plugin) throws Exception {
        if (plugin instanceof InitializeForumPlugin) {
            this.defaultPlugins.add((InitializeForumPlugin)plugin);
        }
    }

    @Override
    public void addInitialDataPlugin(ComponentPlugin plugin) throws Exception {
        if (plugin instanceof ForumInitialDataPlugin) {
            this.dataPlugins.add((ForumInitialDataPlugin)plugin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCalculateModeratorEventListener() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node categoryHome = this.getCategoryHome(sProvider);
        try {
            NodeIterator iter = categoryHome.getNodes();
            while (iter.hasNext()) {
                Node catNode = iter.nextNode();
                if (!catNode.isNodeType("exo:forumCategory")) continue;
                this.addModeratorCalculateListener(catNode);
                NodeIterator iter1 = catNode.getNodes();
                while (iter1.hasNext()) {
                    Node forumNode = iter1.nextNode();
                    if (!forumNode.isNodeType("exo:forum")) continue;
                    this.addModeratorCalculateListener(forumNode);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to add calculate moderator event listener", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    protected void addModeratorCalculateListener(Node node) throws Exception {
        try {
            String path = node.getPath();
            ObservationManager observation = node.getSession().getWorkspace().getObservationManager();
            CalculateModeratorEventListener moderatorListener = new CalculateModeratorEventListener();
            moderatorListener.setPath(path);
            observation.addEventListener((EventListener)moderatorListener, 28, path, false, null, null, false);
        }
        catch (Exception e) {
            log.error((Object)("Can not add listener for node " + node.getName()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDeletedUserCalculateListener() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node profileHome = this.getUserProfileHome(sProvider);
        try {
            if (profileHome.hasNode(Utils.USER_PROFILE_DELETED)) {
                this.deletedUserCalculateListener(profileHome.getNode(Utils.USER_PROFILE_DELETED));
            }
        }
        catch (Exception exception) {
        }
        finally {
            sProvider.close();
        }
    }

    protected void deletedUserCalculateListener(Node node) throws Exception {
        try {
            String path = node.getPath();
            ObservationManager observation = node.getSession().getWorkspace().getObservationManager();
            DeletedUserCalculateEventListener deleteUserListener = new DeletedUserCalculateEventListener();
            deleteUserListener.setPath(path);
            observation.addEventListener((EventListener)deleteUserListener, 3, path, false, null, null, false);
        }
        catch (Exception e) {
            log.error((Object)("Can not add listener for node " + node.getName()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initCategoryListener() {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        this.listeners.clear();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            ObservationManager observation = categoryHome.getSession().getWorkspace().getObservationManager();
            String wsName = categoryHome.getSession().getWorkspace().getName();
            String repoName = ((RepositoryImpl)categoryHome.getSession().getRepository()).getName();
            if (!this.listeners.containsKey(categoryHome.getPath())) {
                CategoryEventListener categoryListener = new CategoryEventListener(wsName, repoName);
                observation.addEventListener((EventListener)categoryListener, 3, categoryHome.getPath(), false, null, null, false);
                this.listeners.put(categoryHome.getPath(), categoryListener);
            }
            NodeIterator iter = categoryHome.getNodes();
            while (iter.hasNext()) {
                Node catNode = iter.nextNode();
                if (this.listeners.containsKey(catNode.getPath())) continue;
                StatisticEventListener sListener = new StatisticEventListener(wsName, repoName);
                observation.addEventListener((EventListener)sListener, 3, catNode.getPath(), true, null, null, false);
                this.listeners.put(catNode.getPath(), sListener);
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to init category listenner", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initAutoPruneSchedules() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node categoryHNode = this.getCategoryHome(sProvider);
            QueryManager qm = categoryHNode.getSession().getWorkspace().getQueryManager();
            StringBuilder pathQuery = new StringBuilder();
            pathQuery.append("/jcr:root").append(categoryHNode.getPath()).append("//element(*,exo:pruneSetting) [@exo:isActive = 'true']");
            Query query = qm.createQuery(pathQuery.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                this.addOrRemoveSchedule(this.getPruneSetting(iter.nextNode()));
            }
        }
        finally {
            sProvider.close();
        }
    }

    @Override
    public boolean isAdminRole(String userName) throws Exception {
        try {
            for (int i = 0; i < this.rulesPlugins.size(); ++i) {
                ArrayList<String> list = new ArrayList<String>();
                list.addAll(this.rulesPlugins.get(i).getRules(Utils.ADMIN_ROLE));
                if (list.contains(userName)) {
                    return true;
                }
                String[] adminrules = Utils.getStringsInList(list);
                if (!ForumServiceUtils.hasPermission(adminrules, userName)) continue;
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to check admin role", (Throwable)e);
        }
        return false;
    }

    protected Node getForumHomeNode(SessionProvider sProvider) throws Exception {
        String path = this.dataLocator.getForumHomeLocation();
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }

    private Node getTopicTypeHome(SessionProvider sProvider) throws Exception {
        String path = this.dataLocator.getTopicTypesLocation();
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }

    private Node getForumSystemHome(SessionProvider sProvider) throws Exception {
        String path = this.dataLocator.getForumSystemLocation();
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }

    private Node getBanIPHome(SessionProvider sProvider) throws Exception {
        String path = this.dataLocator.getBanIPLocation();
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }

    protected Node getStatisticHome(SessionProvider sProvider) throws Exception {
        String path = this.dataLocator.getStatisticsLocation();
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }

    private Node getForumStatisticsNode(SessionProvider sProvider) throws Exception {
        String path = this.dataLocator.getForumStatisticsLocation();
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }

    private Node getAdminHome(SessionProvider sProvider) throws Exception {
        String path = this.dataLocator.getAdministrationLocation();
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }

    @Deprecated
    protected Node getUserProfileHome(SessionProvider sProvider) throws Exception {
        String path = this.dataLocator.getUserProfilesLocation();
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }

    private Node getUserProfileHome() throws Exception {
        return this.getNodeAt(this.dataLocator.getUserProfilesLocation());
    }

    private Node getCategoryHome(SessionProvider sProvider) throws Exception {
        String path = this.dataLocator.getForumCategoriesLocation();
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }

    private Node getTagHome(SessionProvider sProvider) throws Exception {
        String path = this.dataLocator.getTagsLocation();
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }

    private Node getKSUserAvatarHomeNode() throws Exception {
        return this.getNodeAt(this.dataLocator.getAvatarsLocation());
    }

    private Node getForumBanNode(SessionProvider sProvider) throws Exception {
        String path = this.dataLocator.getForumBanIPLocation();
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }

    private Node getBBCodesHome(SessionProvider sProvider) throws Exception {
        String path = this.dataLocator.getBBCodesLocation();
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }

    private Node getNodeAt(String relPath) throws Exception {
        return this.sessionManager.getCurrentSession().getRootNode().getNode(relPath);
    }

    @Override
    public void setDefaultAvatar(String userName) throws Exception {
        Boolean wasReset = (Boolean)this.sessionManager.executeAndSave((JCRTask)new ResetAvatarTask(userName));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Avatar for user " + userName + " was " + (wasReset != false ? "" : "not") + " reset"));
        }
    }

    @Override
    public ForumAttachment getUserAvatar(String userName) throws Exception {
        ForumAttachment avatar = (ForumAttachment)this.sessionManager.execute((JCRTask)new LoadAvatarTask(userName));
        return avatar;
    }

    @Override
    public void saveUserAvatar(String userId, ForumAttachment fileAttachment) throws Exception {
        Boolean wasNew = (Boolean)this.sessionManager.executeAndSave((JCRTask)new SaveAvatarTask(userId, fileAttachment));
        if (log.isDebugEnabled()) {
            log.error((Object)("avatar was " + (wasNew != false ? "added" : "updated") + " for user " + userId + ": " + fileAttachment));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveForumAdministration(ForumAdministration forumAdministration) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumAdminNode;
            Node administrationHome = this.getAdminHome(sProvider);
            try {
                forumAdminNode = administrationHome.getNode(Utils.FORUMADMINISTRATION);
            }
            catch (PathNotFoundException e) {
                forumAdminNode = administrationHome.addNode(Utils.FORUMADMINISTRATION, "exo:administration");
            }
            forumAdminNode.setProperty("exo:forumSortBy", forumAdministration.getForumSortBy());
            forumAdminNode.setProperty("exo:forumSortByType", forumAdministration.getForumSortByType());
            forumAdminNode.setProperty("exo:topicSortBy", forumAdministration.getTopicSortBy());
            forumAdminNode.setProperty("exo:topicSortByType", forumAdministration.getTopicSortByType());
            forumAdminNode.setProperty("exo:censoredKeyword", forumAdministration.getCensoredKeyword());
            forumAdminNode.setProperty("exo:enableHeaderSubject", forumAdministration.getEnableHeaderSubject());
            forumAdminNode.setProperty("exo:headerSubject", forumAdministration.getHeaderSubject());
            forumAdminNode.setProperty("exo:notifyEmailContent", forumAdministration.getNotifyEmailContent());
            forumAdminNode.setProperty("exo:notifyEmailMoved", forumAdministration.getNotifyEmailMoved());
            if (forumAdminNode.isNew()) {
                forumAdminNode.getSession().save();
            } else {
                forumAdminNode.save();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to save forum administration.", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ForumAdministration getForumAdministration() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            ForumAdministration forumAdministration = new ForumAdministration();
            try {
                Node forumAdminNode = this.getAdminHome(sProvider).getNode(Utils.FORUMADMINISTRATION);
                PropertyReader reader = new PropertyReader(forumAdminNode);
                forumAdministration.setForumSortBy(reader.string("exo:forumSortBy"));
                forumAdministration.setForumSortByType(reader.string("exo:forumSortByType"));
                forumAdministration.setTopicSortBy(reader.string("exo:topicSortBy"));
                forumAdministration.setTopicSortByType(reader.string("exo:topicSortByType"));
                forumAdministration.setCensoredKeyword(reader.string("exo:censoredKeyword"));
                forumAdministration.setEnableHeaderSubject(reader.bool("exo:enableHeaderSubject"));
                forumAdministration.setHeaderSubject(reader.string("exo:headerSubject"));
                forumAdministration.setNotifyEmailContent(reader.string("exo:notifyEmailContent"));
                forumAdministration.setNotifyEmailMoved(reader.string("exo:notifyEmailMoved"));
                ForumAdministration forumAdministration2 = forumAdministration;
                return forumAdministration2;
            }
            catch (PathNotFoundException e) {
                ForumAdministration forumAdministration3 = forumAdministration;
                sProvider.close();
                return forumAdministration3;
            }
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortSettings getForumSortSettings() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumAdminNode = this.getAdminHome(sProvider).getNode(Utils.FORUMADMINISTRATION);
            PropertyReader reader = new PropertyReader(forumAdminNode);
            SortSettings sortSettings = new SortSettings(reader.string("exo:forumSortBy"), reader.string("exo:forumSortByType"));
            return sortSettings;
        }
        catch (PathNotFoundException e) {
            SortSettings sortSettings = new SortSettings(SortSettings.SortField.ORDER, SortSettings.Direction.ASC);
            return sortSettings;
        }
        catch (Exception e) {
            log.warn((Object)("Could not log forum sort order in forum administration node: " + e.getMessage()));
        }
        finally {
            sProvider.close();
        }
        return new SortSettings(SortSettings.SortField.ORDER, SortSettings.Direction.ASC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortSettings getTopicSortSettings() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumAdminNode = this.getAdminHome(sProvider).getNode(Utils.FORUMADMINISTRATION);
            PropertyReader reader = new PropertyReader(forumAdminNode);
            SortSettings sortSettings = new SortSettings(reader.string("exo:topicSortBy"), reader.string("exo:topicSortByType"));
            return sortSettings;
        }
        catch (PathNotFoundException e) {
            SortSettings sortSettings = new SortSettings(SortSettings.SortField.LASTPOST, SortSettings.Direction.DESC);
            return sortSettings;
        }
        catch (Exception e) {
            log.warn((Object)("Could not log topic sort order in forum administration node: " + e.getMessage()));
        }
        finally {
            sProvider.close();
        }
        return new SortSettings(SortSettings.SortField.LASTPOST, SortSettings.Direction.DESC);
    }

    @Override
    public void initDataPlugin() throws Exception {
        for (ForumInitialDataPlugin pln : this.dataPlugins) {
            List<ByteArrayInputStream> arrayInputStreams = pln.importData();
            if (arrayInputStreams == null) continue;
            for (ByteArrayInputStream bis : arrayInputStreams) {
                this.importXML(this.dataLocator.getForumHomeLocation(), bis, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initDefaultData() throws Exception {
        SessionProvider sProvider = ForumServiceUtils.getSessionProvider();
        HashSet<String> set = new HashSet<String>();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            if (categoryHome.hasNodes()) {
                return;
            }
            String ct = "";
            for (InitializeForumPlugin pln : this.defaultPlugins) {
                List<CategoryData> categories = pln.getForumInitialData().getCategories();
                for (CategoryData categoryData : categories) {
                    Category category = new Category();
                    category.setCategoryName(categoryData.getName());
                    category.setDescription(categoryData.getDescription());
                    category.setOwner(categoryData.getOwner());
                    this.saveCategory(category, true);
                    List<ForumData> forums = categoryData.getForums();
                    for (ForumData forumData : forums) {
                        Forum forum = new Forum();
                        forum.setForumName(forumData.getName());
                        forum.setDescription(forumData.getDescription());
                        forum.setOwner(forumData.getOwner());
                        this.saveForum(category.getId(), forum, true);
                        List<TopicData> topics = forumData.getTopics();
                        for (TopicData topicData : topics) {
                            Topic topic = new Topic();
                            topic.setTopicName(topicData.getName());
                            ct = topicData.getContent();
                            ct = StringUtils.replace((String)ct, (String)"\\n", (String)"<br/>");
                            ct = Utils.removeCharterStrange(ct);
                            topic.setDescription(ct);
                            topic.setOwner(topicData.getOwner());
                            topic.setIcon(topicData.getIcon());
                            this.saveTopic(category.getId(), forum.getId(), topic, true, false, new MessageBuilder());
                            set.add(topic.getOwner());
                            List<PostData> posts = topicData.getPosts();
                            for (PostData postData : posts) {
                                Post post = new Post();
                                post.setName(postData.getName());
                                ct = postData.getContent();
                                ct = StringUtils.replace((String)ct, (String)"\\n", (String)"<br/>");
                                ct = Utils.removeCharterStrange(ct);
                                post.setMessage(ct);
                                post.setOwner(postData.getOwner());
                                post.setIcon(postData.getIcon());
                                this.savePost(category.getId(), forum.getId(), topic.getId(), post, true, new MessageBuilder());
                                set.add(post.getOwner());
                            }
                        }
                    }
                }
            }
            Node forumStatisticNode = this.getForumStatisticsNode(sProvider);
            PropertyReader reader = new PropertyReader(forumStatisticNode);
            forumStatisticNode.setProperty("exo:membersCount", reader.l("exo:membersCount") + (long)set.size());
            forumStatisticNode.save();
        }
        catch (Exception e) {
            log.error((Object)"Init default data is failed!!", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Category> getCategories() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<Category> categories = new ArrayList<Category>();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root" + categoryHome.getPath() + "/element(*,exo:forumCategory) order by @exo:categoryOrder ascending, @exo:createdDate ascending");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                try {
                    Node cateNode = iter.nextNode();
                    categories.add(this.getCategory(cateNode));
                }
                catch (Exception e) {}
            }
            ArrayList<Category> arrayList = categories;
            return arrayList;
        }
        catch (Exception e) {
            log.warn((Object)"Can not get all categories.", (Throwable)e);
            ArrayList<Category> arrayList = categories;
            return arrayList;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Category getCategory(String categoryId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Category category = this.getCategory(this.getCategoryHome(sProvider).getNode(categoryId));
            return category;
        }
        catch (Exception e) {
            log.error((Object)("Failed to get category, categoryId: " + categoryId), (Throwable)e);
            Category category = null;
            return category;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getPermissionTopicByCategory(String categoryId, String type) throws Exception {
        String[] canCreated = new String[]{" "};
        type = "exo:" + type;
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node cateNode = this.getCategoryHome(sProvider).getNode(categoryId);
            if (cateNode.hasProperty(type)) {
                canCreated = Utils.valuesToArray(cateNode.getProperty(type).getValues());
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to get permission topic by category", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return canCreated;
    }

    private Category getCategory(Node cateNode) throws Exception {
        Category cat = new Category(cateNode.getName());
        cat.setPath(cateNode.getPath());
        PropertyReader reader = new PropertyReader(cateNode);
        cat.setOwner(reader.string("exo:owner"));
        cat.setCategoryName(reader.string("exo:name"));
        cat.setCategoryOrder(reader.l("exo:categoryOrder"));
        cat.setCreatedDate(reader.date("exo:createdDate"));
        cat.setDescription(reader.string("exo:description"));
        cat.setModifiedBy(reader.string("exo:modifiedBy"));
        cat.setModifiedDate(reader.date("exo:modifiedDate"));
        cat.setUserPrivate(reader.strings("exo:userPrivate"));
        cat.setModerators(reader.strings("exo:moderators"));
        cat.setForumCount(reader.l("exo:forumCount"));
        if (cateNode.isNodeType("exo:forumWatching")) {
            cat.setEmailNotification(reader.strings("exo:emailWatching"));
        }
        cat.setViewer(reader.strings("exo:viewer"));
        cat.setCreateTopicRole(reader.strings("exo:createTopicRole"));
        cat.setPoster(reader.strings("exo:poster"));
        return cat;
    }

    @Override
    public void saveCategory(Category category, boolean isNew) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node catNode = null;
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            if (isNew) {
                catNode = categoryHome.addNode(category.getId(), "exo:forumCategory");
                catNode.setProperty("exo:id", category.getId());
                catNode.setProperty("exo:owner", category.getOwner());
                catNode.setProperty("exo:createdDate", this.getGreenwichMeanTime());
                categoryHome.getSession().save();
                this.addModeratorCalculateListener(catNode);
            } else {
                catNode = categoryHome.getNode(category.getId());
                String[] oldcategoryMod = new String[]{""};
                try {
                    oldcategoryMod = Utils.valuesToArray(catNode.getProperty("exo:moderators").getValues());
                }
                catch (Exception e) {
                    // empty catch block
                }
                catNode.setProperty("exo:tempModerators", oldcategoryMod);
            }
            catNode.setProperty("exo:name", category.getCategoryName());
            catNode.setProperty("exo:categoryOrder", category.getCategoryOrder());
            catNode.setProperty("exo:description", category.getDescription());
            catNode.setProperty("exo:modifiedBy", category.getModifiedBy());
            catNode.setProperty("exo:modifiedDate", this.getGreenwichMeanTime());
            catNode.setProperty("exo:userPrivate", category.getUserPrivate());
            catNode.setProperty("exo:createTopicRole", category.getCreateTopicRole());
            catNode.setProperty("exo:poster", category.getPoster());
            catNode.setProperty("exo:viewer", category.getViewer());
            catNode.save();
            try {
                if (isNew && category.getModerators().length > 0 || !isNew) {
                    catNode.setProperty("exo:moderators", category.getModerators());
                    catNode.save();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to save category", (Throwable)e);
            throw e;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveModOfCategory(List<String> moderatorCate, String userId, boolean isAdd) {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node cateHome = this.getCategoryHome(sProvider);
            Node cateNode = null;
            for (String cateId : moderatorCate) {
                boolean isAddNew = true;
                try {
                    cateNode = cateHome.getNode(cateId);
                    List<String> listTemp = Utils.valuesToList(cateNode.getProperty("exo:moderators").getValues());
                    ArrayList<String> list = new ArrayList<String>();
                    list.addAll(listTemp);
                    if (isAdd) {
                        if (list.isEmpty() || list.size() == 1 && Utils.isEmpty((String)list.get(0))) {
                            list = new ArrayList();
                            list.add(userId);
                        } else if (!list.contains(userId)) {
                            list.add(userId);
                        } else {
                            isAddNew = false;
                        }
                        if (!isAddNew) continue;
                        cateNode.setProperty("exo:tempModerators", Utils.getStringsInList(listTemp));
                        cateNode.setProperty("exo:moderators", Utils.getStringsInList(list));
                        continue;
                    }
                    if (list.isEmpty() || !list.contains(userId)) continue;
                    list.remove(userId);
                    if (list.isEmpty()) {
                        list.add("");
                    }
                    cateNode.setProperty("exo:moderators", Utils.getStringsInList(list));
                    cateNode.setProperty("exo:tempModerators", Utils.getStringsInList(listTemp));
                }
                catch (Exception e) {
                    log.debug((Object)("Failed to save moderater of categoryId: " + cateId), (Throwable)e);
                }
            }
            cateHome.save();
        }
        catch (Exception e) {
            log.error((Object)"Failed to save moderator of category", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void calculateModerator(String nodePath, boolean isNew) throws Exception {
        try {
            JCRSessionManager manager = new JCRSessionManager(this.workspace);
            Session session = manager.createSession();
            try {
                Node node = (Node)session.getItem(nodePath);
                String[] modTemp = new String[]{};
                if (node.hasProperty("exo:tempModerators")) {
                    modTemp = Utils.valuesToArray(node.getProperty("exo:tempModerators").getValues());
                }
                if (node.isNodeType("exo:forumCategory")) {
                    Category category = new Category(node.getName());
                    category.setCategoryName(node.getProperty("exo:name").getString());
                    category.setModerators(Utils.valuesToArray(node.getProperty("exo:moderators").getValues()));
                    if (isNew || Utils.arraysHaveDifferentContent(modTemp, category.getModerators())) {
                        this.updateModeratorInForums(node, category.getModerators());
                        this.updateUserProfileModInCategory(session, node, modTemp, category, isNew);
                    }
                } else {
                    Forum forum = new Forum();
                    forum.setId(node.getName());
                    forum.setForumName(node.getProperty("exo:name").getString());
                    forum.setModerators(Utils.valuesToArray(node.getProperty("exo:moderators").getValues()));
                    if (isNew || Utils.arraysHaveDifferentContent(modTemp, forum.getModerators())) {
                        String categoryId = nodePath.substring(nodePath.indexOf(Utils.CATEGORY), nodePath.lastIndexOf("/"));
                        this.setModeratorForum(session, forum.getModerators(), modTemp, forum, categoryId, isNew);
                    }
                }
                node.setProperty("exo:tempModerators", new String[0]);
                node.save();
            }
            finally {
                session.logout();
            }
        }
        catch (Exception e) {
            log.debug((Object)"PathNotFoundException\tcategory node or forum node not found");
        }
    }

    private void updateModeratorInForums(Node cateNode, String[] moderatorCat) throws Exception {
        NodeIterator iter = cateNode.getNodes();
        while (iter.hasNext()) {
            ArrayList<String> list = new ArrayList<String>();
            try {
                String[] oldModeratoForums;
                Node node = iter.nextNode();
                if (!node.isNodeType("exo:forum")) continue;
                try {
                    oldModeratoForums = Utils.valuesToArray(node.getProperty("exo:moderators").getValues());
                }
                catch (Exception e) {
                    oldModeratoForums = new String[]{};
                }
                list.addAll(Arrays.asList(oldModeratoForums));
                for (int i = 0; i < moderatorCat.length; ++i) {
                    if (list.contains(moderatorCat[i])) continue;
                    list.add(moderatorCat[i]);
                }
                String[] strModerators = Utils.getStringsInList(list);
                node.setProperty("exo:moderators", strModerators);
                node.setProperty("exo:tempModerators", oldModeratoForums);
            }
            catch (Exception e) {}
        }
        cateNode.save();
    }

    /*
     * WARNING - void declaration
     */
    private void updateUserProfileModInCategory(Session session, Node catNode, String[] oldcategoryMod, Category category, boolean isNew) throws Exception {
        Node userProfileNode;
        Node userProfileHomeNode = session.getRootNode().getNode(this.dataLocator.getUserProfilesLocation());
        String categoryId = category.getId();
        String cateName = category.getCategoryName();
        List<String> moderators = ForumServiceUtils.getUserPermission(category.getModerators());
        if (!moderators.isEmpty()) {
            for (String string : moderators) {
                try {
                    boolean isAdd = true;
                    userProfileNode = userProfileHomeNode.getNode(string);
                    List<Object> moderateCategory = new ArrayList();
                    try {
                        moderateCategory = Utils.valuesToList(userProfileNode.getProperty("exo:moderateCategory").getValues());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    for (String string2 : moderateCategory) {
                        if (string2.indexOf(categoryId) <= 0) continue;
                        isAdd = false;
                        break;
                    }
                    if (!isAdd) continue;
                    moderateCategory.add(cateName + "(" + categoryId);
                    userProfileNode.setProperty("exo:moderateCategory", Utils.getStringsInList(moderateCategory));
                }
                catch (Exception e) {
                    log.debug((Object)"Failed to get user profile ", (Throwable)e);
                }
            }
        }
        if (!isNew && oldcategoryMod != null && oldcategoryMod.length > 0 && !Utils.isEmpty(oldcategoryMod[0]) && Utils.arraysHaveDifferentContent(oldcategoryMod, category.getModerators())) {
            ArrayList<String> olds = new ArrayList<String>(Arrays.asList(oldcategoryMod));
            String[] mods = category.getModerators();
            for (int i = 0; i < mods.length; ++i) {
                if (!olds.contains(mods[i])) continue;
                olds.remove(mods[i]);
            }
            List<String> oldmoderators = ForumServiceUtils.getUserPermission(olds.toArray(new String[olds.size()]));
            for (String oldUserId : oldmoderators) {
                void var16_25;
                if (moderators.contains(oldUserId)) continue;
                userProfileNode = userProfileHomeNode.getNode(oldUserId);
                ArrayList arrayList = new ArrayList();
                try {
                    List<String> list = Utils.valuesToList(userProfileNode.getProperty("exo:moderateCategory").getValues());
                }
                catch (Exception e) {
                    // empty catch block
                }
                for (String string : var16_25) {
                    if (string.indexOf(categoryId) <= 0) continue;
                    var16_25.remove(string);
                    userProfileNode.setProperty("exo:moderateCategory", Utils.getStringsInList((List<String>)var16_25));
                    break;
                }
                List<String> list = Utils.valuesToList(userProfileNode.getProperty("exo:moderateForums").getValues());
                NodeIterator iter = catNode.getNodes();
                while (iter.hasNext()) {
                    Node node = iter.nextNode();
                    if (!node.isNodeType("exo:forum")) continue;
                    for (String string : list) {
                        if (string.indexOf(node.getName()) < 0) continue;
                        list.remove(string);
                        break;
                    }
                    List<String> forumMode = Utils.valuesToList(node.getProperty("exo:moderators").getValues());
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    arrayList2.addAll(forumMode);
                    for (String old : olds) {
                        if (!forumMode.contains(old)) continue;
                        forumMode.remove(old);
                    }
                    node.setProperty("exo:moderators", Utils.getStringsInList(forumMode));
                    node.setProperty("exo:tempModerators", Utils.getStringsInList(arrayList2));
                }
                catNode.save();
                if (list.isEmpty() || list.size() == 1 && Utils.isEmpty(list.get(0))) {
                    if (userProfileNode.hasProperty("exo:userRole")) {
                        long l = userProfileNode.getProperty("exo:userRole").getLong();
                        if (l == 1L) {
                            userProfileNode.setProperty("exo:userRole", 2L);
                            userProfileNode.setProperty("exo:userTitle", Utils.USER);
                        }
                    } else {
                        userProfileNode.setProperty("exo:userRole", 2L);
                        userProfileNode.setProperty("exo:userTitle", Utils.USER);
                    }
                }
                userProfileNode.setProperty("exo:moderateForums", Utils.getStringsInList(list));
            }
        }
        try {
            userProfileHomeNode.save();
        }
        catch (Exception e) {
            log.error((Object)"Failed to update user profile of moderator in category.", (Throwable)e);
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListenerForCategory(String path) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            String id = path.substring(path.lastIndexOf("/") + 1);
            Node catNode = categoryHome.getNode(id);
            if (!this.listeners.containsKey(catNode.getPath())) {
                String wsName = catNode.getSession().getWorkspace().getName();
                RepositoryImpl repo = (RepositoryImpl)catNode.getSession().getRepository();
                ObservationManager observation = catNode.getSession().getWorkspace().getObservationManager();
                StatisticEventListener statisticEventListener = new StatisticEventListener(wsName, repo.getName());
                observation.addEventListener((EventListener)statisticEventListener, 3, catNode.getPath(), true, null, null, false);
                this.listeners.put(catNode.getPath(), statisticEventListener);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to register listener for category " + path), (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unRegisterListenerForCategory(String path) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            this.unRegisterListenerForCategory(sProvider, path);
        }
        catch (Exception e) {
            log.error((Object)("Failed to unregister listener for category " + path), (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    public void unRegisterListenerForCategory(SessionProvider sProvider, String path) throws Exception {
        if (this.listeners.containsKey(path)) {
            ObservationManager obserManager = this.getForumHomeNode(sProvider).getSession().getWorkspace().getObservationManager();
            obserManager.removeEventListener((EventListener)((StatisticEventListener)this.listeners.get(path)));
            this.listeners.remove(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Category removeCategory(String categoryId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            Node categoryNode = categoryHome.getNode(categoryId);
            String path = categoryNode.getPath();
            Map<String, Long> userPostMap = this.getDeletePostByUser(categoryNode);
            Category category = this.getCategory(categoryNode);
            try {
                categoryNode.setProperty("exo:tempModerators", Utils.valuesToArray(categoryNode.getProperty("exo:moderators").getValues()));
                categoryNode.setProperty("exo:moderators", new String[]{" "});
                NodeIterator iter = categoryNode.getNodes();
                while (iter.hasNext()) {
                    Node node = iter.nextNode();
                    if (!node.isNodeType("exo:forum")) continue;
                    node.setProperty("exo:tempModerators", Utils.valuesToArray(node.getProperty("exo:moderators").getValues()));
                    node.setProperty("exo:moderators", new String[]{" "});
                }
                categoryNode.save();
            }
            catch (Exception e) {
                // empty catch block
            }
            categoryNode.remove();
            categoryHome.save();
            this.addUpdateUserProfileJob(userPostMap);
            this.unRegisterListenerForCategory(sProvider, path);
            Category category2 = category;
            return category2;
        }
        catch (Exception e) {
            log.error((Object)("failed to remove category " + categoryId));
            Category category = null;
            return category;
        }
        finally {
            sProvider.close();
        }
    }

    @Override
    public List<Forum> getForums(String categoryId, String strQuery) throws Exception {
        return this.getForums(categoryId, strQuery, false);
    }

    @Override
    public List<Forum> getForumSummaries(String categoryId, String strQuery) throws Exception {
        return this.getForums(categoryId, strQuery, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Forum> getForums(String categoryId, String strQuery, boolean summary) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            SortSettings sort = this.getForumSortSettings();
            SortSettings.SortField orderBy = sort.getField();
            SortSettings.Direction orderType = sort.getDirection();
            Node catNode = this.getCategoryHome(sProvider).getNode(categoryId);
            String categoryPath = catNode.getPath();
            StringBuffer queryBuffer = new StringBuffer();
            queryBuffer.append("/jcr:root").append(categoryPath).append("/element(*,exo:forum)");
            if (!Utils.isEmpty(strQuery)) {
                queryBuffer.append("[").append(strQuery).append("]");
            }
            queryBuffer.append(" order by @exo:").append((Object)orderBy).append(" ").append((Object)orderType);
            if (orderBy != SortSettings.SortField.ORDER) {
                queryBuffer.append(", @exo:forumOrder ascending");
                if (orderBy != SortSettings.SortField.CREATED) {
                    queryBuffer.append(", @exo:createdDate ascending");
                }
            } else {
                queryBuffer.append(", @exo:createdDate ascending");
            }
            QueryManager qm = catNode.getSession().getWorkspace().getQueryManager();
            Query query = qm.createQuery(queryBuffer.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ArrayList<Forum> forums = new ArrayList<Forum>();
            while (iter.hasNext()) {
                Node forumNode = null;
                try {
                    forumNode = iter.nextNode();
                    if (summary) {
                        forums.add(this.getForum(forumNode));
                        continue;
                    }
                    forums.add(this.getForumSummary(forumNode));
                }
                catch (Exception e) {
                    log.debug((Object)("Failed to load forum node " + forumNode.getPath()), (Throwable)e);
                }
            }
            ArrayList<Forum> arrayList = forums;
            return arrayList;
        }
        catch (Exception e) {
            log.error((Object)("Error retrieving forums for category " + categoryId), (Throwable)e);
            ArrayList<Forum> arrayList = new ArrayList<Forum>();
            return arrayList;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Forum getForum(String categoryId, String forumId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumNode = this.getCategoryHome(sProvider).getNode(categoryId + "/" + forumId);
            Forum forum = this.getForum(forumNode);
            return forum;
        }
        catch (Exception e) {
            log.error((Object)("\nCould not get " + forumId + " in " + categoryId + " fail: " + e.getCause()));
            Forum forum = null;
            return forum;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyForum(Forum forum, int type) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumHomeNode = this.getForumHomeNode(sProvider);
            String forumPath = forum.getPath();
            Node forumNode = (Node)forumHomeNode.getSession().getItem(forumPath);
            switch (type) {
                case 1: {
                    forumNode.setProperty("exo:isClosed", forum.getIsClosed());
                    this.setActiveTopicByForum(sProvider, forumNode, forum.getIsClosed());
                    break;
                }
                case 2: {
                    forumNode.setProperty("exo:isLock", forum.getIsLock());
                    break;
                }
            }
            if (forumNode.isNew()) {
                forumNode.getSession().save();
            } else {
                forumNode.save();
            }
        }
        catch (RepositoryException e) {
            log.error((Object)("Failed to modify forum " + forum.getForumName()), (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    String[] updateModeratorInForum(Node node, String[] mods) throws Exception {
        PropertyReader reader = new PropertyReader(node);
        Set set = reader.set("exo:moderators");
        if (set == null || set.contains("")) {
            return mods;
        }
        set.addAll(Arrays.asList(mods));
        return set.toArray(new String[set.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveForum(String categoryId, Forum forum, boolean isNew) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node forumNode = null;
        String[] strModerators = forum.getModerators();
        try {
            boolean isNewModerateTopic;
            Node catNode = this.getCategoryHome(sProvider).getNode(categoryId);
            boolean isModerateTopic = isNewModerateTopic = forum.getIsModerateTopic();
            String[] oldMod = new String[]{};
            if (isNew) {
                forumNode = catNode.addNode(forum.getId(), "exo:forum");
                forumNode.setProperty("exo:id", forum.getId());
                forumNode.setProperty("exo:owner", forum.getOwner());
                forumNode.setProperty("exo:createdDate", this.getGreenwichMeanTime());
                forumNode.setProperty("exo:lastTopicPath", forum.getLastTopicPath());
                forumNode.setProperty("exo:postCount", 0L);
                forumNode.setProperty("exo:topicCount", 0L);
                forumNode.setProperty("exo:banIPs", new String[0]);
                forum.setPath(forumNode.getPath());
                long forumCount = 1L;
                if (catNode.hasProperty("exo:forumCount")) {
                    forumCount = catNode.getProperty("exo:forumCount").getLong() + 1L;
                }
                catNode.setProperty("exo:forumCount", forumCount);
                catNode.getSession().save();
                this.addModeratorCalculateListener(forumNode);
            } else {
                forumNode = catNode.getNode(forum.getId());
                oldMod = Utils.valuesToArray(forumNode.getProperty("exo:moderators").getValues());
                forumNode.setProperty("exo:tempModerators", oldMod);
                if (forumNode.hasProperty("exo:isModerateTopic")) {
                    isModerateTopic = forumNode.getProperty("exo:isModerateTopic").getBoolean();
                }
            }
            forumNode.setProperty("exo:name", forum.getForumName());
            forumNode.setProperty("exo:forumOrder", (long)forum.getForumOrder());
            forumNode.setProperty("exo:modifiedBy", forum.getModifiedBy());
            forumNode.setProperty("exo:modifiedDate", this.getGreenwichMeanTime());
            forumNode.setProperty("exo:description", forum.getDescription());
            forumNode.setProperty("exo:isAutoAddEmailNotify", forum.getIsAutoAddEmailNotify());
            forumNode.setProperty("exo:notifyWhenAddPost", forum.getNotifyWhenAddPost());
            forumNode.setProperty("exo:notifyWhenAddTopic", forum.getNotifyWhenAddTopic());
            forumNode.setProperty("exo:isModerateTopic", isNewModerateTopic);
            forumNode.setProperty("exo:isModeratePost", forum.getIsModeratePost());
            forumNode.setProperty("exo:isClosed", forum.getIsClosed());
            forumNode.setProperty("exo:isLock", forum.getIsLock());
            forumNode.setProperty("exo:createTopicRole", forum.getCreateTopicRole());
            forumNode.setProperty("exo:poster", forum.getPoster());
            strModerators = this.updateModeratorInForum(catNode, strModerators);
            boolean isEditMod = isNew;
            if (!isNew && Utils.arraysHaveDifferentContent(oldMod, strModerators)) {
                isEditMod = true;
            }
            if (isEditMod && strModerators != null && strModerators.length > 0 && !Utils.isEmpty(strModerators[0]) && catNode.hasProperty("exo:userPrivate")) {
                ArrayList<String> listPrivate = new ArrayList<String>();
                listPrivate.addAll(Utils.valuesToList(catNode.getProperty("exo:userPrivate").getValues()));
                if (listPrivate.size() > 0 && !Utils.isEmpty((String)listPrivate.get(0))) {
                    for (int i = 0; i < strModerators.length; ++i) {
                        if (listPrivate.contains(strModerators[i])) continue;
                        listPrivate.add(strModerators[i]);
                    }
                    catNode.setProperty("exo:userPrivate", listPrivate.toArray(new String[listPrivate.size()]));
                }
            }
            forumNode.setProperty("exo:viewer", forum.getViewer());
            catNode.save();
            try {
                forumNode.setProperty("exo:moderators", strModerators);
                forumNode.save();
            }
            catch (Exception e) {
                // empty catch block
            }
            StringBuilder id = new StringBuilder();
            id.append(catNode.getProperty("exo:categoryOrder").getString());
            id.append(catNode.getProperty("exo:createdDate").getDate().getTimeInMillis());
            id.append(forum.getForumOrder());
            if (isNew) {
                id.append(this.getGreenwichMeanTime());
                PruneSetting pruneSetting = new PruneSetting();
                pruneSetting.setId(id.toString());
                pruneSetting.setForumPath(forum.getPath());
                this.savePruneSetting(pruneSetting);
            } else {
                id.append(forum.getCreatedDate().getTime());
                if (isModerateTopic != isNewModerateTopic) {
                    this.queryLastTopic(sProvider, forumNode.getPath());
                }
                Node pruneSetting = forumNode.getNode(Utils.PRUNESETTING);
                pruneSetting.setProperty("exo:id", id.toString());
                pruneSetting.save();
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to save forum " + forum.getForumName()), (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    private void setModeratorForum(Session session, String[] strModerators, String[] oldModeratoForums, Forum forum, String categoryId, boolean isNew) throws Exception {
        Node userProfileNode;
        Node userProfileHomeNode = session.getRootNode().getNode(this.dataLocator.getUserProfilesLocation());
        List<String> moderators = ForumServiceUtils.getUserPermission(strModerators);
        if (moderators.size() > 0) {
            for (String string : moderators) {
                string = string.trim();
                ArrayList<String> list = new ArrayList<String>();
                try {
                    userProfileNode = userProfileHomeNode.getNode(string);
                    List<String> moderatorForums = Utils.valuesToList(userProfileNode.getProperty("exo:moderateForums").getValues());
                    boolean hasMod = false;
                    for (String string2 : moderatorForums) {
                        if (string2.indexOf(forum.getId()) > 0) {
                            hasMod = true;
                        }
                        if (Utils.isEmpty(string2)) continue;
                        list.add(string2);
                    }
                    if (hasMod) continue;
                    list.add(forum.getForumName() + "(" + categoryId + "/" + forum.getId());
                    userProfileNode.setProperty("exo:moderateForums", Utils.getStringsInList(list));
                    if (userProfileNode.getProperty("exo:userRole").getLong() >= 2L) {
                        userProfileNode.setProperty("exo:userRole", 1L);
                        userProfileNode.setProperty("exo:userTitle", Utils.MODERATOR);
                    }
                    this.getTotalJobWaitingForModerator(session, string);
                }
                catch (PathNotFoundException e) {
                    userProfileNode = userProfileHomeNode.addNode(string, Utils.USER_PROFILES_TYPE);
                    String[] strings = new String[]{forum.getForumName() + "(" + categoryId + "/" + forum.getId()};
                    userProfileNode.setProperty("exo:moderateForums", strings);
                    userProfileNode.setProperty("exo:userRole", 1L);
                    userProfileNode.setProperty("exo:userTitle", Utils.MODERATOR);
                    if (userProfileNode.isNew()) {
                        userProfileNode.getSession().save();
                    } else {
                        userProfileNode.save();
                    }
                    this.getTotalJobWaitingForModerator(session, string);
                }
            }
        }
        if (!isNew) {
            List<String> oldmoderators = ForumServiceUtils.getUserPermission(oldModeratoForums);
            for (String string : oldmoderators) {
                boolean isDelete = true;
                if (moderators.contains(string)) {
                    isDelete = false;
                }
                if (!isDelete) continue;
                try {
                    String[] moderatorForums;
                    ArrayList<String> list = new ArrayList<String>();
                    userProfileNode = userProfileHomeNode.getNode(string);
                    for (String string2 : moderatorForums = Utils.valuesToArray(userProfileNode.getProperty("exo:moderateForums").getValues())) {
                        if (string2.indexOf(forum.getId()) >= 0) continue;
                        list.add(string2);
                    }
                    userProfileNode.setProperty("exo:moderateForums", Utils.getStringsInList(list));
                    if (list.size() > 0) continue;
                    if (userProfileNode.hasProperty("exo:userRole")) {
                        long role = userProfileNode.getProperty("exo:userRole").getLong();
                        if (role != 1L) continue;
                        userProfileNode.setProperty("exo:userRole", 2L);
                        userProfileNode.setProperty("exo:userTitle", Utils.USER);
                        continue;
                    }
                    userProfileNode.setProperty("exo:userRole", 2L);
                    userProfileNode.setProperty("exo:userTitle", Utils.USER);
                }
                catch (PathNotFoundException e) {}
            }
        }
        if (userProfileHomeNode.isNew()) {
            userProfileHomeNode.getSession().save();
        } else {
            userProfileHomeNode.save();
        }
    }

    @Override
    public void saveModerateOfForums(List<String> forumPaths, String userName, boolean isDelete) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node categoryHomeNode = this.getCategoryHome(sProvider);
        for (String path : forumPaths) {
            String forumPath = categoryHomeNode.getPath() + "/" + path;
            try {
                Node forumNode = (Node)categoryHomeNode.getSession().getItem(forumPath);
                Node cateNode = forumNode.getParent();
                if (isDelete) {
                    List<String> moderators;
                    String[] cateMods = Utils.valuesToArray(cateNode.getProperty("exo:moderators").getValues());
                    if (cateMods != null && cateMods.length > 0 && !Utils.isEmpty(cateMods[0]) && (moderators = ForumServiceUtils.getUserPermission(cateMods)).contains(userName) || !forumNode.hasProperty("exo:moderators")) continue;
                    String[] oldUserNamesModerate = Utils.valuesToArray(forumNode.getProperty("exo:moderators").getValues());
                    ArrayList<String> list = new ArrayList<String>();
                    for (String string : oldUserNamesModerate) {
                        if (string.equals(userName)) continue;
                        list.add(string);
                    }
                    forumNode.setProperty("exo:moderators", Utils.getStringsInList(list));
                    forumNode.setProperty("exo:tempModerators", oldUserNamesModerate);
                    continue;
                }
                String[] oldUserNamesModerate = new String[]{};
                if (forumNode.hasProperty("exo:moderators")) {
                    oldUserNamesModerate = Utils.valuesToArray(forumNode.getProperty("exo:moderators").getValues());
                }
                List<String> list = new ArrayList<String>();
                for (String string : oldUserNamesModerate) {
                    if (string.equals(userName)) continue;
                    list.add(string);
                }
                list.add(userName);
                forumNode.setProperty("exo:moderators", Utils.getStringsInList(list));
                forumNode.setProperty("exo:tempModerators", oldUserNamesModerate);
                if (!cateNode.hasProperty("exo:userPrivate") || (list = Utils.valuesToList(cateNode.getProperty("exo:userPrivate").getValues())).size() <= 0 || Utils.isEmpty(list.get(0)) || list.contains(userName)) continue;
                String[] strings = new String[list.size() + 1];
                int i = 0;
                Iterator<String> i$ = list.iterator();
                while (i$.hasNext()) {
                    String string;
                    strings[i] = string = i$.next();
                    ++i;
                }
                strings[i] = userName;
                cateNode.setProperty("exo:userPrivate", strings);
            }
            catch (Exception e) {
                log.error((Object)"Failed to save moderate of forums", (Throwable)e);
            }
        }
        if (categoryHomeNode.isNew()) {
            categoryHomeNode.getSession().save();
        } else {
            categoryHomeNode.save();
        }
        sProvider.close();
    }

    private Forum getForumSummary(Node forumNode) throws Exception {
        Forum forum = new Forum();
        PropertyReader reader = new PropertyReader(forumNode);
        forum.setId(forumNode.getName());
        forum.setPath(forumNode.getPath());
        forum.setForumName(reader.string("exo:name"));
        forum.setDescription(reader.string("exo:description"));
        forum.setModerators(reader.strings("exo:moderators"));
        forum.setPostCount(reader.l("exo:postCount"));
        forum.setTopicCount(reader.l("exo:topicCount"));
        forum.setIsModerateTopic(reader.bool("exo:isModerateTopic"));
        String lastTopicPath = "";
        if (forumNode.hasProperty("exo:lastTopicPath") && !Utils.isEmpty(lastTopicPath = forumNode.getProperty("exo:lastTopicPath").getString())) {
            lastTopicPath = lastTopicPath.lastIndexOf("/") > 0 ? forum.getPath() + lastTopicPath.substring(lastTopicPath.lastIndexOf("/")) : forum.getPath() + "/" + lastTopicPath;
        }
        forum.setLastTopicPath(lastTopicPath);
        forum.setIsClosed(reader.bool("exo:isClosed"));
        forum.setIsLock(reader.bool("exo:isLock"));
        return forum;
    }

    private Forum getForum(Node forumNode) throws Exception {
        Forum forum = new Forum();
        PropertyReader reader = new PropertyReader(forumNode);
        forum.setId(forumNode.getName());
        forum.setPath(forumNode.getPath());
        forum.setOwner(reader.string("exo:owner"));
        forum.setForumName(reader.string("exo:name"));
        forum.setForumOrder(Integer.valueOf(reader.string("exo:forumOrder")));
        forum.setCreatedDate(reader.date("exo:createdDate"));
        forum.setModifiedBy(reader.string("exo:modifiedBy"));
        forum.setModifiedDate(reader.date("exo:modifiedDate"));
        String lastTopicPath = "";
        if (forumNode.hasProperty("exo:lastTopicPath") && !Utils.isEmpty(lastTopicPath = forumNode.getProperty("exo:lastTopicPath").getString())) {
            lastTopicPath = lastTopicPath.lastIndexOf("/") > 0 ? forum.getPath() + lastTopicPath.substring(lastTopicPath.lastIndexOf("/")) : forum.getPath() + "/" + lastTopicPath;
        }
        forum.setLastTopicPath(lastTopicPath);
        forum.setDescription(reader.string("exo:description"));
        forum.setPostCount(reader.l("exo:postCount"));
        forum.setTopicCount(reader.l("exo:topicCount"));
        forum.setIsModerateTopic(reader.bool("exo:isModerateTopic"));
        forum.setIsModeratePost(reader.bool("exo:isModeratePost"));
        forum.setIsClosed(reader.bool("exo:isClosed"));
        forum.setIsLock(reader.bool("exo:isLock"));
        forum.setIsAutoAddEmailNotify(reader.bool("exo:isAutoAddEmailNotify", false));
        forum.setNotifyWhenAddPost(reader.strings("exo:notifyWhenAddPost"));
        forum.setNotifyWhenAddTopic(reader.strings("exo:notifyWhenAddTopic"));
        forum.setViewer(reader.strings("exo:viewer"));
        forum.setCreateTopicRole(reader.strings("exo:createTopicRole"));
        forum.setPoster(reader.strings("exo:poster"));
        forum.setModerators(reader.strings("exo:moderators"));
        forum.setBanIP(reader.list("exo:banIPs"));
        if (forumNode.isNodeType("exo:forumWatching") && forumNode.hasProperty("exo:emailWatching")) {
            forum.setEmailNotification(reader.strings("exo:emailWatching"));
        }
        return forum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Forum removeForum(String categoryId, String forumId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Forum forum = null;
        try {
            Node catNode = this.getCategoryHome(sProvider).getNode(categoryId);
            Node forumNode = catNode.getNode(forumId);
            Map<String, Long> userPostMap = this.getDeletePostByUser(forumNode);
            forum = this.getForum(forumNode);
            forumNode.setProperty("exo:tempModerators", Utils.valuesToArray(forumNode.getProperty("exo:moderators").getValues()));
            forumNode.setProperty("exo:moderators", new String[]{" "});
            forumNode.save();
            forumNode.remove();
            catNode.setProperty("exo:forumCount", catNode.getProperty("exo:forumCount").getLong() - 1L);
            catNode.save();
            try {
                this.addUpdateUserProfileJob(userPostMap);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        catch (Exception e) {
            Forum forum2 = null;
            return forum2;
        }
        finally {
            sProvider.close();
        }
        return forum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveForum(List<Forum> forums, String destCategoryPath) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumHomeNode = this.getForumHomeNode(sProvider);
            String oldCatePath = "";
            if (forums.isEmpty()) {
                return;
            }
            String forumPath = forums.get(0).getPath();
            oldCatePath = forumPath.substring(0, forumPath.lastIndexOf("/"));
            Node oldCatNode = (Node)forumHomeNode.getSession().getItem(oldCatePath);
            Node newCatNode = (Node)forumHomeNode.getSession().getItem(destCategoryPath);
            for (Forum forum : forums) {
                String newForumPath = destCategoryPath + "/" + forum.getId();
                forumHomeNode.getSession().getWorkspace().move(forum.getPath(), newForumPath);
                Node forumNode = (Node)forumHomeNode.getSession().getItem(newForumPath);
                forumNode.setProperty("exo:path", newForumPath);
                String[] strModerators = forum.getModerators();
                forumNode.setProperty("exo:moderators", strModerators);
                if (strModerators == null || strModerators.length <= 0 || Utils.isEmpty(strModerators[0]) || !newCatNode.hasProperty("exo:userPrivate")) continue;
                ArrayList<String> listPrivate = new ArrayList<String>();
                listPrivate.addAll(Utils.valuesToList(newCatNode.getProperty("exo:userPrivate").getValues()));
                if (Utils.isEmpty((String)listPrivate.get(0))) continue;
                for (int i = 0; i < strModerators.length; ++i) {
                    if (listPrivate.contains(strModerators[i])) continue;
                    listPrivate.add(strModerators[i]);
                }
                newCatNode.setProperty("exo:userPrivate", listPrivate.toArray(new String[listPrivate.size()]));
            }
            long forumCount = forums.size();
            oldCatNode.setProperty("exo:forumCount", oldCatNode.getProperty("exo:forumCount").getLong() - forumCount);
            if (newCatNode.hasProperty("exo:forumCount")) {
                forumCount = newCatNode.getProperty("exo:forumCount").getLong() + forumCount;
            }
            newCatNode.setProperty("exo:forumCount", forumCount);
            if (forumHomeNode.isNew()) {
                forumHomeNode.getSession().save();
            } else {
                forumHomeNode.save();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to move forum", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    private void setActiveTopicByForum(SessionProvider sProvider, Node forumNode, boolean isClosed) throws Exception {
        NodeIterator iter = forumNode.getNodes();
        Node topicNode = null;
        boolean bl = isClosed = !isClosed;
        while (iter.hasNext()) {
            topicNode = iter.nextNode();
            if (!topicNode.isNodeType("exo:topic")) continue;
            topicNode.setProperty("exo:isActiveByForum", isClosed);
            this.setActivePostByTopic(sProvider, topicNode, isClosed);
        }
        if (forumNode.isNew()) {
            forumNode.getSession().save();
        } else {
            forumNode.save();
        }
    }

    private void setActivePostByTopic(SessionProvider sProvider, Node topicNode, boolean isActiveTopic) throws Exception {
        if (isActiveTopic) {
            isActiveTopic = topicNode.getProperty("exo:isApproved").getBoolean();
        }
        if (isActiveTopic) {
            boolean bl = isActiveTopic = !topicNode.getProperty("exo:isWaiting").getBoolean();
        }
        if (isActiveTopic) {
            boolean bl = isActiveTopic = !topicNode.getProperty("exo:isClosed").getBoolean();
        }
        if (isActiveTopic) {
            isActiveTopic = topicNode.getProperty("exo:isActive").getBoolean();
        }
        Node postNode = null;
        NodeIterator iter = topicNode.getNodes();
        while (iter.hasNext()) {
            postNode = iter.nextNode();
            if (!postNode.isNodeType("exo:post")) continue;
            postNode.setProperty("exo:isActiveByTopic", isActiveTopic);
        }
        if (topicNode.isNew()) {
            topicNode.getSession().save();
        } else {
            topicNode.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JCRPageList getPageTopic(String categoryId, String forumId, String strQuery, String strOrderBy) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            ForumPageList pagelist;
            Node categoryNode = this.getCategoryHome(sProvider).getNode(categoryId);
            Node forumNode = categoryNode.getNode(forumId);
            String forumPath = forumNode.getPath();
            String pathQuery = this.buildTopicQuery(strQuery, strOrderBy, forumPath);
            QueryManager qm = categoryNode.getSession().getWorkspace().getQueryManager();
            Query query = qm.createQuery(pathQuery, "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ForumPageList forumPageList = pagelist = new ForumPageList(iter, 10, pathQuery, true);
            return forumPageList;
        }
        catch (Exception e) {
            JCRPageList jCRPageList = null;
            return jCRPageList;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyPageList<Topic> getTopicList(String categoryId, String forumId, String xpathConditions, String strOrderBy, int pageSize) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            String str;
            Node categoryNode = this.getCategoryHome(sProvider).getNode(categoryId);
            Node forumNode = categoryNode.getNode(forumId);
            String forumPath = forumNode.getPath();
            if (xpathConditions != null && xpathConditions.length() > 0 && xpathConditions.contains("topicPermission") && (str = this.buildXpath(sProvider, forumNode)).length() > 0) {
                xpathConditions = StringUtils.replace((String)xpathConditions, (String)"topicPermission", (String)("(" + str + "))"));
            }
            String topicQuery = this.buildTopicQuery(xpathConditions, strOrderBy, forumPath);
            TopicListAccess topicListAccess = new TopicListAccess(this.sessionManager, topicQuery);
            LazyPageList<Topic> lazyPageList = new LazyPageList<Topic>((ListAccess<Topic>)topicListAccess, pageSize);
            return lazyPageList;
        }
        catch (Exception e) {
            log.error((Object)("Failed to retrieve topic list for forum " + forumId), (Throwable)e);
            LazyPageList<Topic> lazyPageList = null;
            return lazyPageList;
        }
        finally {
            sProvider.close();
        }
    }

    private String buildXpath(SessionProvider sProvider, Node forumNode) throws Exception {
        QueryManager qm = this.getCategoryHome(sProvider).getSession().getWorkspace().getQueryManager();
        String queryString = "/jcr:root" + forumNode.getPath() + "//element(*,exo:topic)[@exo:isWaiting='false' and @exo:isActive='true' and @exo:isClosed='false' and (not(@exo:canView) or @exo:canView='' or @exo:canView=' ')]";
        Query query = qm.createQuery(queryString, "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        StringBuilder builder = new StringBuilder();
        boolean isOr = false;
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            if (isOr) {
                builder.append(" and ");
            }
            builder.append("@exo:id!='").append(node.getName()).append("'");
            isOr = true;
        }
        return builder.toString();
    }

    private String buildTopicQuery(String strQuery, String strOrderBy, String forumPath) throws Exception {
        SortSettings sortSettings = this.getTopicSortSettings();
        SortSettings.SortField orderBy = sortSettings.getField();
        SortSettings.Direction orderType = sortSettings.getDirection();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/jcr:root").append(forumPath).append("//element(*,exo:topic)");
        if (strQuery != null && strQuery.length() > 0) {
            stringBuffer.append("[").append(strQuery).append("]");
        }
        stringBuffer.append(" order by @exo:isSticky descending");
        if (strOrderBy == null || Utils.isEmpty(strOrderBy)) {
            if (orderBy != null) {
                stringBuffer.append(", @exo:").append((Object)orderBy).append(" ").append((Object)orderType);
                if (!orderBy.equals((Object)SortSettings.SortField.LASTPOST)) {
                    stringBuffer.append(", @exo:lastPostDate descending");
                }
            } else {
                stringBuffer.append(", @exo:lastPostDate descending");
            }
        } else {
            stringBuffer.append(", @exo:").append(strOrderBy);
            if (strOrderBy.indexOf("lastPostDate") < 0) {
                stringBuffer.append(", @exo:lastPostDate descending");
            }
        }
        String pathQuery = stringBuffer.toString();
        return pathQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Topic> getTopics(String categoryId, String forumId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumNode = this.getCategoryHome(sProvider).getNode(categoryId).getNode(forumId);
            NodeIterator iter = forumNode.getNodes();
            ArrayList<Topic> topics = new ArrayList<Topic>();
            while (iter.hasNext()) {
                try {
                    Node topicNode = iter.nextNode();
                    if (!topicNode.isNodeType("exo:topic")) continue;
                    topics.add(this.getTopicNode(topicNode));
                }
                catch (Exception e) {}
            }
            ArrayList<Topic> arrayList = topics;
            return arrayList;
        }
        catch (Exception e) {
            List<Topic> list = null;
            return list;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setViewCountTopic(String path, String userRead) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node topicNode = this.getCategoryHome(sProvider).getNode(path);
            if (userRead != null && userRead.length() > 0 && !userRead.equals("user_gest_uoom")) {
                long newViewCount = topicNode.getProperty("exo:viewCount").getLong() + 1L;
                topicNode.setProperty("exo:viewCount", newViewCount);
                if (topicNode.isNew()) {
                    topicNode.getSession().save();
                } else {
                    topicNode.save();
                }
            }
        }
        catch (Exception e) {
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Topic getTopic(String categoryId, String forumId, String topicId, String userRead) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node topicNode = this.getCategoryHome(sProvider).getNode(categoryId + "/" + forumId + "/" + topicId);
            Topic topic = this.getTopicNode(topicNode);
            return topic;
        }
        catch (Exception e) {
            log.error((Object)("Getting Topic fail: " + e.getMessage() + "\n" + e.getCause()));
            Topic topic = null;
            return topic;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Topic getTopicSummary(String topicPath, boolean isLastPost) throws Exception {
        Topic topic = null;
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node topicNode;
            Node cateHomeNode = this.getCategoryHome(sProvider);
            if (topicPath == null || topicPath.length() <= 0) {
                Topic topic2 = null;
                return topic2;
            }
            if (topicPath.indexOf(cateHomeNode.getName()) < 0) {
                topicPath = cateHomeNode.getPath() + "/" + topicPath;
            }
            if ((topic = this.getTopicNodeSummary(topicNode = (Node)cateHomeNode.getSession().getItem(topicPath))) == null && isLastPost && topicPath != null && topicPath.length() > 0) {
                String forumPath = topicPath.substring(0, topicPath.lastIndexOf("/"));
                topic = this.getTopicNodeSummary(this.queryLastTopic(sProvider, forumPath));
            }
            Topic topic3 = topic;
            return topic3;
        }
        catch (RepositoryException e) {
            if (topicPath != null && topicPath.length() > 0 && isLastPost) {
                String forumPath = topicPath.substring(0, topicPath.lastIndexOf("/"));
                topic = this.getTopicNodeSummary(this.queryLastTopic(sProvider, forumPath));
            }
            Topic topic4 = topic;
            return topic4;
        }
        catch (Exception e) {
            Topic topic5 = null;
            return topic5;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Topic getTopicByPath(String topicPath, boolean isLastPost) throws Exception {
        Topic topic = null;
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node topicNode;
            Node catogoryHome = this.getCategoryHome(sProvider);
            if (topicPath == null || topicPath.length() <= 0) {
                Topic topic2 = null;
                return topic2;
            }
            if (topicPath.indexOf(catogoryHome.getName()) < 0) {
                topicPath = catogoryHome.getPath() + "/" + topicPath;
            }
            if ((topic = this.getTopicNode(topicNode = (Node)catogoryHome.getSession().getItem(topicPath))) == null && isLastPost && topicPath != null && topicPath.length() > 0) {
                String forumPath = topicPath.substring(0, topicPath.lastIndexOf("/"));
                topic = this.getTopicNode(this.queryLastTopic(sProvider, forumPath));
            }
            Topic topic3 = topic;
            return topic3;
        }
        catch (RepositoryException e) {
            if (topicPath != null && topicPath.length() > 0 && isLastPost) {
                String forumPath = topicPath.substring(0, topicPath.lastIndexOf("/"));
                topic = this.getTopicNode(this.queryLastTopic(sProvider, forumPath));
            }
            Topic topic4 = topic;
            return topic4;
        }
        catch (Exception e) {
            Topic topic5 = null;
            return topic5;
        }
        finally {
            sProvider.close();
        }
    }

    private Node queryLastTopic(SessionProvider sProvider, String forumPath) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        Node forumNode = (Node)forumHomeNode.getSession().getItem(forumPath);
        QueryManager qm = forumHomeNode.getSession().getWorkspace().getQueryManager();
        String queryString = "/jcr:root" + forumPath + "//element(*,exo:topic)[@exo:isWaiting='false' and @exo:isActive='true' and @exo:isClosed='false'] order by @exo:lastPostDate descending";
        Query query = qm.createQuery(queryString, "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        Node topicNode = null;
        boolean isSavePath = false;
        try {
            while (iter.hasNext()) {
                topicNode = iter.nextNode();
                if (!forumNode.hasProperty("exo:isModerateTopic") && !forumNode.getProperty("exo:isModerateTopic").getBoolean()) {
                    forumNode.setProperty("exo:lastTopicPath", topicNode.getName());
                    isSavePath = true;
                    break;
                }
                if (!topicNode.getProperty("exo:isApproved").getBoolean()) continue;
                forumNode.setProperty("exo:lastTopicPath", topicNode.getName());
                isSavePath = true;
                break;
            }
            if (!isSavePath) {
                forumNode.setProperty("exo:lastTopicPath", "");
            }
            if (forumNode.isNew()) {
                forumNode.getSession().save();
            } else {
                forumNode.save();
            }
        }
        catch (PathNotFoundException e) {
            log.error((Object)"Failed to query last topic", (Throwable)e);
            return null;
        }
        return topicNode;
    }

    private Topic getTopicNodeSummary(Node topicNode) throws Exception {
        if (topicNode == null) {
            return null;
        }
        Topic topicNew = new Topic();
        PropertyReader reader = new PropertyReader(topicNode);
        topicNew.setId(topicNode.getName());
        topicNew.setPath(topicNode.getPath());
        topicNew.setIcon(reader.string("exo:icon"));
        topicNew.setTopicName(reader.string("exo:name"));
        topicNew.setLastPostBy(reader.string("exo:lastPostBy"));
        topicNew.setLastPostDate(reader.date("exo:lastPostDate"));
        topicNew.setIsClosed(reader.bool("exo:isClosed"));
        topicNew.setIsApproved(reader.bool("exo:isApproved"));
        topicNew.setIsActive(reader.bool("exo:isActive"));
        topicNew.setIsPoll(reader.bool("exo:isPoll"));
        return topicNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Topic getTopicUpdate(Topic topic, boolean isSummary) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumHomeNode = this.getForumHomeNode(sProvider);
            Node topicNode = (Node)forumHomeNode.getSession().getItem(topic.getPath());
            PropertyReader reader = new PropertyReader(topicNode);
            if (isSummary) {
                topic.setLastPostDate(reader.date("exo:lastPostDate"));
                topic.setLastPostBy(reader.string("exo:lastPostBy"));
                topic.setOwner(reader.string("exo:owner"));
                topic.setTopicName(reader.string("exo:name"));
                topic.setTopicType(reader.string("exo:topicType", " "));
                topic.setDescription(reader.string("exo:description"));
                topic.setPostCount(reader.l("exo:postCount"));
                topic.setViewCount(reader.l("exo:viewCount"));
                topic.setNumberAttachment(reader.l("exo:numberAttachments"));
                if (topicNode.getParent().getProperty("exo:isLock").getBoolean()) {
                    topic.setIsLock(true);
                } else {
                    topic.setIsLock(topicNode.getProperty("exo:isLock").getBoolean());
                }
                topic.setIsSticky(reader.bool("exo:isSticky"));
                topic.setIsWaiting(reader.bool("exo:isWaiting"));
                topic.setIsActiveByForum(reader.bool("exo:isActiveByForum"));
                topic.setUserVoteRating(reader.strings("exo:userVoteRating"));
                topic.setVoteRating(reader.d("exo:voteRating"));
            }
            topic.setCreatedDate(reader.date("exo:createdDate"));
            topic.setModifiedBy(reader.string("exo:modifiedBy"));
            topic.setModifiedDate(reader.date("exo:modifiedDate"));
            topic.setIsModeratePost(reader.bool("exo:isModeratePost"));
            topic.setIsNotifyWhenAddPost(reader.string("exo:isNotifyWhenAddPost", null));
            topic.setLink(reader.string("exo:link"));
            topic.setTagId(reader.strings("exo:tagId"));
            topic.setCanView(reader.strings("exo:canView", new String[0]));
            topic.setCanPost(reader.strings("exo:canPost", new String[0]));
            topic.setEmailNotification(reader.strings("exo:emailWatching", new String[0]));
            String idFirstPost = topicNode.getName().replaceFirst(Utils.TOPIC, Utils.POST);
            try {
                Node FirstPostNode = topicNode.getNode(idFirstPost);
                if (reader.l("exo:numberAttachments") > 0L) {
                    NodeIterator postAttachments = FirstPostNode.getNodes();
                    ArrayList<ForumAttachment> attachments = new ArrayList<ForumAttachment>();
                    while (postAttachments.hasNext()) {
                        Node node = postAttachments.nextNode();
                        if (!node.isNodeType("exo:forumAttachment")) continue;
                        JCRForumAttachment attachment = new JCRForumAttachment();
                        Node nodeFile = node.getNode("jcr:content");
                        attachment.setId(node.getName());
                        attachment.setPathNode(node.getPath());
                        attachment.setMimeType(nodeFile.getProperty("jcr:mimeType").getString());
                        attachment.setName(nodeFile.getProperty("exo:fileName").getString());
                        String workspace = node.getSession().getWorkspace().getName();
                        attachment.setWorkspace(workspace);
                        attachment.setSize(nodeFile.getProperty("jcr:data").getStream().available());
                        attachment.setPath("/" + workspace + node.getPath());
                        attachments.add(attachment);
                    }
                    topic.setAttachments(attachments);
                }
            }
            catch (Exception e) {
                log.debug((Object)"Failed to set attachments in topic.", (Throwable)e);
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to get topic", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return topic;
    }

    public Topic getTopicNode(Node topicNode) throws Exception {
        if (topicNode == null) {
            return null;
        }
        Topic topicNew = new Topic();
        PropertyReader reader = new PropertyReader(topicNode);
        topicNew.setId(topicNode.getName());
        topicNew.setPath(topicNode.getPath());
        topicNew.setOwner(reader.string("exo:owner"));
        topicNew.setTopicName(reader.string("exo:name"));
        topicNew.setCreatedDate(reader.date("exo:createdDate"));
        topicNew.setModifiedBy(reader.string("exo:modifiedBy"));
        topicNew.setModifiedDate(reader.date("exo:modifiedDate"));
        topicNew.setLastPostBy(reader.string("exo:lastPostBy"));
        topicNew.setLastPostDate(reader.date("exo:lastPostDate"));
        topicNew.setDescription(reader.string("exo:description"));
        topicNew.setTopicType(reader.string("exo:topicType", " "));
        topicNew.setPostCount(reader.l("exo:postCount"));
        topicNew.setViewCount(reader.l("exo:viewCount"));
        topicNew.setNumberAttachment(reader.l("exo:numberAttachments"));
        topicNew.setIcon(reader.string("exo:icon"));
        topicNew.setLink(reader.string("exo:link"));
        topicNew.setIsNotifyWhenAddPost(reader.string("exo:isNotifyWhenAddPost", null));
        topicNew.setIsModeratePost(reader.bool("exo:isModeratePost"));
        topicNew.setIsClosed(reader.bool("exo:isClosed"));
        if (topicNode.getParent().getProperty("exo:isLock").getBoolean()) {
            topicNew.setIsLock(true);
        } else {
            topicNew.setIsLock(topicNode.getProperty("exo:isLock").getBoolean());
        }
        topicNew.setIsApproved(reader.bool("exo:isApproved"));
        topicNew.setIsSticky(reader.bool("exo:isSticky"));
        topicNew.setIsWaiting(reader.bool("exo:isWaiting"));
        topicNew.setIsActive(reader.bool("exo:isActive"));
        topicNew.setIsActiveByForum(reader.bool("exo:isActiveByForum"));
        topicNew.setCanView(reader.strings("exo:canView", new String[0]));
        topicNew.setCanPost(reader.strings("exo:canPost", new String[0]));
        topicNew.setIsPoll(reader.bool("exo:isPoll"));
        topicNew.setUserVoteRating(reader.strings("exo:userVoteRating"));
        topicNew.setTagId(reader.strings("exo:tagId"));
        topicNew.setVoteRating(reader.d("exo:voteRating"));
        if (topicNode.isNodeType("exo:forumWatching") && topicNode.hasProperty("exo:emailWatching")) {
            topicNew.setEmailNotification(reader.strings("exo:emailWatching"));
        }
        String idFirstPost = topicNode.getName().replaceFirst(Utils.TOPIC, Utils.POST);
        try {
            Node FirstPostNode = topicNode.getNode(idFirstPost);
            if (reader.l("exo:numberAttachments") > 0L) {
                NodeIterator postAttachments = FirstPostNode.getNodes();
                ArrayList<ForumAttachment> attachments = new ArrayList<ForumAttachment>();
                while (postAttachments.hasNext()) {
                    Node node = postAttachments.nextNode();
                    if (!node.isNodeType("exo:forumAttachment")) continue;
                    JCRForumAttachment attachment = new JCRForumAttachment();
                    Node nodeFile = node.getNode("jcr:content");
                    attachment.setId(node.getName());
                    attachment.setPathNode(node.getPath());
                    attachment.setMimeType(nodeFile.getProperty("jcr:mimeType").getString());
                    attachment.setName(nodeFile.getProperty("exo:fileName").getString());
                    String workspace = node.getSession().getWorkspace().getName();
                    attachment.setWorkspace(workspace);
                    attachment.setSize(nodeFile.getProperty("jcr:data").getStream().available());
                    attachment.setPath("/" + workspace + node.getPath());
                    attachments.add(attachment);
                }
                topicNew.setAttachments(attachments);
            }
            return topicNew;
        }
        catch (PathNotFoundException e) {
            return topicNew;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JCRPageList getPageTopicOld(long date, String forumPatch) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            ForumPageList pagelist;
            Node categoryHome = this.getCategoryHome(sProvider);
            Calendar newDate = this.getGreenwichMeanTime();
            if (forumPatch == null || forumPatch.length() <= 0) {
                forumPatch = categoryHome.getPath();
            }
            newDate.setTimeInMillis(newDate.getTimeInMillis() - date * 86400000L);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(forumPatch).append("//element(*,exo:topic)[@exo:lastPostDate <= xs:dateTime('").append(ISO8601.format((Calendar)newDate)).append("')] order by @exo:createdDate ascending");
            Query query = qm.createQuery(stringBuffer.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ForumPageList forumPageList = pagelist = new ForumPageList(iter, 10, stringBuffer.toString(), true);
            return forumPageList;
        }
        catch (Exception e) {
            JCRPageList jCRPageList = null;
            return jCRPageList;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Topic> getAllTopicsOld(long date, String forumPatch) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<Topic> topics = new ArrayList<Topic>();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            Calendar newDate = this.getGreenwichMeanTime();
            if (forumPatch == null || forumPatch.length() <= 0) {
                forumPatch = categoryHome.getPath();
            }
            newDate.setTimeInMillis(newDate.getTimeInMillis() - date * 86400000L);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(forumPatch).append("//element(*,exo:topic)[@exo:lastPostDate <= xs:dateTime('").append(ISO8601.format((Calendar)newDate)).append("')] order by @exo:createdDate ascending");
            Query query = qm.createQuery(stringBuffer.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                Node node = iter.nextNode();
                Topic topic = new Topic();
                topic.setId(node.getName());
                topic.setPath(node.getPath());
                topic.setIsActive(node.getProperty("exo:isActive").getBoolean());
                topic.setPostCount(node.getProperty("exo:postCount").getLong());
                topics.add(topic);
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to get all topic old", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return topics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTotalTopicOld(long date, String forumPatch) {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            Calendar newDate = this.getGreenwichMeanTime();
            newDate.setTimeInMillis(newDate.getTimeInMillis() - date * 86400000L);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(forumPatch).append("//element(*,exo:topic)[@exo:lastPostDate <= xs:dateTime('").append(ISO8601.format((Calendar)newDate)).append("') and @exo:isActive='true'] order by @exo:createdDate ascending");
            Query query = qm.createQuery(stringBuffer.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            long l = iter.getSize();
            return l;
        }
        catch (Exception e) {
            long l = 0L;
            return l;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JCRPageList getPageTopicByUser(String userName, boolean isMod, String strOrderBy) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            ForumPageList pagelist;
            Node categoryHome = this.getCategoryHome(sProvider);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:topic)[@exo:owner='").append(userName).append("'");
            if (!isMod) {
                stringBuffer.append(" and @exo:isClosed='false' and @exo:isWaiting='false' and @exo:isApproved='true' ").append("and @exo:isActive='true' and @exo:isActiveByForum='true'");
            }
            stringBuffer.append("] order by @exo:isSticky descending");
            if (!Utils.isEmpty(strOrderBy)) {
                stringBuffer.append(",@exo:").append(strOrderBy);
            }
            stringBuffer.append(",exo:createdDate ascending");
            String pathQuery = stringBuffer.toString();
            Query query = qm.createQuery(pathQuery, "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ForumPageList forumPageList = pagelist = new ForumPageList(iter, 10, pathQuery, true);
            return forumPageList;
        }
        catch (Exception e) {
            JCRPageList jCRPageList = null;
            return jCRPageList;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyTopic(List<Topic> topics, int type) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumHomeNode = this.getForumHomeNode(sProvider);
            ArrayList<String> userIdsp = new ArrayList<String>();
            long topicCount = 0L;
            long postCount = 0L;
            Node forumNode = null;
            try {
                String topicPath = topics.get(0).getPath();
                forumNode = forumHomeNode.getSession().getItem(topicPath).getParent();
                topicCount = forumNode.getProperty("exo:topicCount").getLong();
                postCount = forumNode.getProperty("exo:postCount").getLong();
                if (forumNode.hasProperty("exo:moderators")) {
                    userIdsp.addAll(Utils.valuesToList(forumNode.getProperty("exo:moderators").getValues()));
                }
                userIdsp.addAll(this.getAllAdministrator(sProvider));
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
            for (Topic topic : topics) {
                try {
                    String topicPath = topic.getPath();
                    Node topicNode = (Node)forumHomeNode.getSession().getItem(topicPath);
                    switch (type) {
                        case 1: {
                            topicNode.setProperty("exo:isClosed", topic.getIsClosed());
                            this.setActivePostByTopic(sProvider, topicNode, !topic.getIsClosed());
                            break;
                        }
                        case 2: {
                            topicNode.setProperty("exo:isLock", topic.getIsLock());
                            break;
                        }
                        case 3: {
                            topicNode.setProperty("exo:isApproved", topic.getIsApproved());
                            this.sendNotification(topicNode.getParent(), topic, null, new MessageBuilder(), true);
                            this.setActivePostByTopic(sProvider, topicNode, topic.getIsApproved());
                            this.getTotalJobWatting(sProvider, userIdsp);
                            break;
                        }
                        case 4: {
                            topicNode.setProperty("exo:isSticky", topic.getIsSticky());
                            break;
                        }
                        case 5: {
                            boolean isWaiting = topic.getIsWaiting();
                            topicNode.setProperty("exo:isWaiting", isWaiting);
                            this.setActivePostByTopic(sProvider, topicNode, !isWaiting);
                            if (!isWaiting) {
                                this.sendNotification(topicNode.getParent(), topic, null, new MessageBuilder(), true);
                            }
                            this.getTotalJobWatting(sProvider, userIdsp);
                            break;
                        }
                        case 6: {
                            topicNode.setProperty("exo:isActive", topic.getIsActive());
                            this.setActivePostByTopic(sProvider, topicNode, topic.getIsActive());
                            this.getTotalJobWatting(sProvider, userIdsp);
                            break;
                        }
                        case 7: {
                            topicNode.setProperty("exo:name", topic.getTopicName());
                            try {
                                Node nodeFirstPost = topicNode.getNode(topicNode.getName().replaceFirst(Utils.TOPIC, Utils.POST));
                                nodeFirstPost.setProperty("exo:name", topic.getTopicName());
                            }
                            catch (PathNotFoundException e) {}
                            break;
                        }
                        case 8: {
                            topicNode.setProperty("exo:userVoteRating", topic.getUserVoteRating());
                            topicNode.setProperty("exo:voteRating", topic.getVoteRating().doubleValue());
                            break;
                        }
                    }
                    if ((type == 3 || type == 5) && !topic.getIsWaiting() && topic.getIsApproved()) {
                        ++topicCount;
                        postCount += topicNode.getProperty("exo:postCount").getLong() + 1L;
                    }
                    if (type == 2 || type == 4 || type == 7 || type == 8 || !forumNode.hasProperty("exo:lastTopicPath") || !forumNode.getProperty("exo:lastTopicPath").getString().equals(topicNode.getName()) && !Utils.isEmpty(forumNode.getProperty("exo:lastTopicPath").getString())) continue;
                    this.queryLastTopic(sProvider, forumNode.getPath());
                }
                catch (PathNotFoundException e) {}
            }
            if (type == 3 || type == 5) {
                forumNode.setProperty("exo:topicCount", topicCount);
                forumNode.setProperty("exo:postCount", postCount);
            }
            if (forumNode.isNew()) {
                forumNode.getSession().save();
            } else {
                forumNode.save();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to modify topic.", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveTopic(String categoryId, String forumId, Topic topic, boolean isNew, boolean isMove, MessageBuilder messageBuilder) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node topicNode;
            Node forumNode = this.getCategoryHome(sProvider).getNode(categoryId + "/" + forumId);
            if (isNew) {
                Node newProfileNode;
                topicNode = forumNode.addNode(topic.getId(), "exo:topic");
                topicNode.setProperty("exo:id", topic.getId());
                topicNode.setProperty("exo:owner", topic.getOwner());
                Calendar calendar = this.getGreenwichMeanTime();
                topic.setCreatedDate(calendar.getTime());
                topicNode.setProperty("exo:createdDate", calendar);
                topicNode.setProperty("exo:lastPostBy", topic.getOwner());
                if (isMove && topic.getLastPostDate() != null) {
                    calendar.setTime(topic.getLastPostDate());
                }
                topicNode.setProperty("exo:lastPostDate", calendar);
                topicNode.setProperty("exo:postCount", -1L);
                topicNode.setProperty("exo:viewCount", 0L);
                topicNode.setProperty("exo:tagId", topic.getTagId());
                topicNode.setProperty("exo:isActiveByForum", true);
                topicNode.setProperty("exo:isPoll", topic.getIsPoll());
                topicNode.setProperty("exo:link", topic.getLink());
                topicNode.setProperty("exo:path", forumId);
                if (!forumNode.getProperty("exo:isModerateTopic").getBoolean() && !topic.getIsWaiting()) {
                    long newTopicCount = forumNode.getProperty("exo:topicCount").getLong() + 1L;
                    forumNode.setProperty("exo:topicCount", newTopicCount);
                }
                Node userProfileNode = this.getUserProfileHome(sProvider);
                try {
                    newProfileNode = userProfileNode.getNode(topic.getOwner());
                    long totalTopicByUser = newProfileNode.getProperty("exo:totalTopic").getLong();
                    newProfileNode.setProperty("exo:totalTopic", totalTopicByUser + 1L);
                }
                catch (PathNotFoundException e) {
                    newProfileNode = userProfileNode.addNode(topic.getOwner(), Utils.USER_PROFILES_TYPE);
                    newProfileNode.setProperty("exo:userId", topic.getOwner());
                    newProfileNode.setProperty("exo:userTitle", Utils.USER);
                    if (this.isAdminRole(topic.getOwner())) {
                        newProfileNode.setProperty("exo:userTitle", Utils.ADMIN);
                    }
                    newProfileNode.setProperty("exo:totalTopic", 1L);
                }
                if (userProfileNode.isNew()) {
                    userProfileNode.getSession().save();
                } else {
                    userProfileNode.save();
                }
                this.sendNotification(forumNode, topic, null, messageBuilder, true);
            } else {
                topicNode = forumNode.getNode(topic.getId());
            }
            topicNode.setProperty("exo:name", topic.getTopicName());
            topicNode.setProperty("exo:modifiedBy", topic.getModifiedBy());
            topicNode.setProperty("exo:modifiedDate", this.getGreenwichMeanTime());
            topicNode.setProperty("exo:description", topic.getDescription());
            topicNode.setProperty("exo:topicType", topic.getTopicType());
            topicNode.setProperty("exo:icon", topic.getIcon());
            topicNode.setProperty("exo:isModeratePost", topic.getIsModeratePost());
            topicNode.setProperty("exo:isNotifyWhenAddPost", topic.getIsNotifyWhenAddPost());
            topicNode.setProperty("exo:isClosed", topic.getIsClosed());
            topicNode.setProperty("exo:isLock", topic.getIsLock());
            topicNode.setProperty("exo:isApproved", topic.getIsApproved());
            topicNode.setProperty("exo:isSticky", topic.getIsSticky());
            topicNode.setProperty("exo:isWaiting", topic.getIsWaiting());
            topicNode.setProperty("exo:isActive", topic.getIsActive());
            String[] strs = topic.getCanView();
            boolean isGetLastTopic = false;
            if (strs == null || strs.length == 0) {
                strs = new String[]{""};
            }
            topicNode.setProperty("exo:canView", strs);
            strs = topic.getCanPost();
            if (strs == null || strs.length == 0) {
                strs = new String[]{""};
            }
            topicNode.setProperty("exo:canPost", strs);
            topicNode.setProperty("exo:userVoteRating", topic.getUserVoteRating());
            topicNode.setProperty("exo:voteRating", topic.getVoteRating().doubleValue());
            topicNode.setProperty("exo:numberAttachments", topic.getNumberAttachment());
            if (isNew) {
                forumNode.getSession().save();
            } else {
                forumNode.save();
            }
            if (topic.getIsWaiting() || !topic.getIsApproved()) {
                ArrayList<String> userIdsp = new ArrayList<String>();
                if (forumNode.hasProperty("exo:moderators")) {
                    userIdsp.addAll(Utils.valuesToList(forumNode.getProperty("exo:moderators").getValues()));
                }
                userIdsp.addAll(this.getAllAdministrator(sProvider));
                this.getTotalJobWatting(sProvider, userIdsp);
                isGetLastTopic = true;
            }
            if (!isNew && (isGetLastTopic || topic.getIsActive() || topic.getIsClosed())) {
                this.queryLastTopic(sProvider, forumNode.getPath());
            }
            if (!isMove) {
                String id;
                if (isNew) {
                    id = topic.getId().replaceFirst(Utils.TOPIC, Utils.POST);
                    Post post = new Post();
                    post.setId(id);
                    post.setOwner(topic.getOwner());
                    post.setCreatedDate(new Date());
                    post.setName(topic.getTopicName());
                    post.setMessage(topic.getDescription());
                    post.setRemoteAddr("");
                    post.setIcon(topic.getIcon());
                    post.setIsApproved(true);
                    post.setAttachments(topic.getAttachments());
                    post.setUserPrivate(new String[]{"exoUserPri"});
                    post.setLink(topic.getLink());
                    post.setRemoteAddr(topic.getRemoteAddr());
                    this.savePost(categoryId, forumId, topic.getId(), post, true, messageBuilder);
                } else {
                    id = topic.getId().replaceFirst(Utils.TOPIC, Utils.POST);
                    if (topicNode.hasNode(id)) {
                        Node fistPostNode = topicNode.getNode(id);
                        Post post = this.getPost(fistPostNode);
                        post.setModifiedBy(topic.getModifiedBy());
                        post.setModifiedDate(new Date());
                        post.setEditReason(topic.getEditReason());
                        post.setName(topic.getTopicName());
                        post.setMessage(topic.getDescription());
                        post.setIcon(topic.getIcon());
                        post.setAttachments(topic.getAttachments());
                        this.savePost(categoryId, forumId, topic.getId(), post, false, messageBuilder);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to save topic", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    private Map<String, Long> getDeletePostByUser(Node node) throws Exception {
        HashMap<String, Long> userPostMap = new HashMap<String, Long>();
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("/jcr:root").append(node.getPath()).append("//element(*,exo:post)");
        QueryManager qm = node.getSession().getWorkspace().getQueryManager();
        Query query = qm.createQuery(strBuilder.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        Node post = null;
        String owner = null;
        while (iter.hasNext()) {
            post = iter.nextNode();
            try {
                owner = post.getProperty("exo:owner").getString();
                userPostMap.put(owner, (Long)userPostMap.get(owner) + 1L);
            }
            catch (Exception e) {
                userPostMap.put(owner, Long.parseLong("1"));
            }
        }
        return userPostMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUserProfileInfo(String name) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node userProfileHome = this.getUserProfileHome(sProvider);
            Node userNode = null;
            HashMap userPostMap = (HashMap)this.infoMap.get(name);
            for (Map.Entry entry : userPostMap.entrySet()) {
                String user = (String)entry.getKey();
                try {
                    userNode = userProfileHome.getNode(user);
                    long totalPost = userNode.getProperty("exo:totalPost").getLong();
                    userNode.setProperty("exo:totalPost", totalPost - (Long)userPostMap.get(user));
                    userNode.save();
                }
                catch (PathNotFoundException e) {
                    log.debug((Object)("UserProfile of user: " + user + " not existing."));
                }
            }
            this.infoMap.remove(name);
        }
        catch (Exception e) {
            log.error((Object)"Failed to update user profile info", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    private void addUpdateUserProfileJob(Map<String, Long> userPostMap) throws Exception {
        try {
            GregorianCalendar cal = new GregorianCalendar();
            PeriodInfo periodInfo = new PeriodInfo(cal.getTime(), null, 1, 86400000L);
            String name = String.valueOf(cal.getTime().getTime());
            Class<?> clazz = Class.forName("org.exoplatform.forum.service.conf.UpdateUserProfileJob");
            JobInfo info = new JobInfo(name, "KnowledgeSuite-forum", clazz);
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            JobSchedulerService schedulerService = (JobSchedulerService)container.getComponentInstanceOfType(JobSchedulerService.class);
            this.infoMap.put(name, userPostMap);
            schedulerService.addPeriodJob(info, periodInfo);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to add job for update user profile ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Topic removeTopic(String categoryId, String forumId, String topicId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumNode = this.getCategoryHome(sProvider).getNode(categoryId + "/" + forumId);
            Topic topic = this.getTopic(categoryId, forumId, topicId, "user_gest_uoom");
            Node topicNode = forumNode.getNode(topicId);
            Map<String, Long> userPostMap = this.getDeletePostByUser(topicNode);
            forumNode.setProperty("exo:topicCount", forumNode.getProperty("exo:topicCount").getLong() - 1L);
            long newPostCount = forumNode.getProperty("exo:postCount").getLong() - (topic.getPostCount() + 1L);
            forumNode.setProperty("exo:postCount", newPostCount);
            topicNode.remove();
            forumNode.save();
            if (!topic.getIsActive() || !topic.getIsApproved() || topic.getIsWaiting()) {
                ArrayList<String> userIdsp = new ArrayList<String>();
                if (forumNode.hasProperty("exo:moderators")) {
                    userIdsp.addAll(Utils.valuesToList(forumNode.getProperty("exo:moderators").getValues()));
                }
                userIdsp.addAll(this.getAllAdministrator(sProvider));
                this.getTotalJobWatting(sProvider, userIdsp);
            }
            try {
                this.queryLastTopic(sProvider, forumNode.getPath());
            }
            catch (Exception e) {
                log.trace((Object)("\nThe last topic is null: " + e.getMessage() + "\n" + e.getCause()));
            }
            try {
                this.calculateLastRead(sProvider, null, forumId, topicId);
            }
            catch (Exception e) {
                log.debug((Object)"Failed to update last read topic", (Throwable)e);
            }
            this.addUpdateUserProfileJob(userPostMap);
            Topic topic2 = topic;
            return topic2;
        }
        catch (Exception e) {
            log.error((Object)"Failed to remove topic", (Throwable)e);
            Topic topic = null;
            return topic;
        }
        finally {
            sProvider.close();
        }
    }

    private String getEmailUser(SessionProvider sProvider, String userId) throws Exception {
        return new PropertyReader(this.getUserProfileHome(sProvider).getNode(userId)).string("exo:email", "");
    }

    @Override
    public void moveTopic(List<Topic> topics, String destForumPath, String mailContent, String link) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumHomeNode = this.getForumHomeNode(sProvider);
            long tmp = 0L;
            String forumName = null;
            Node destForumNode = (Node)forumHomeNode.getSession().getItem(destForumPath);
            forumName = destForumNode.getProperty("exo:name").getString();
            String owner = destForumNode.getProperty("exo:owner").getString();
            if (owner.indexOf(":") > 0 && Utils.isEmpty(owner = ForumServiceUtils.getUserPermission(new String[]{owner}).get(0))) {
                owner = topics.get(0).getEditReason();
            }
            Message message = new Message();
            message.setMimeType("text/html");
            String headerSubject = "";
            String objectName = "[" + destForumNode.getParent().getProperty("exo:name").getString() + "][" + destForumNode.getProperty("exo:name").getString() + "] ";
            try {
                String str;
                Node node = this.getAdminHome(sProvider).getNode(Utils.FORUMADMINISTRATION);
                if (node.hasProperty("exo:enableHeaderSubject") && node.getProperty("exo:enableHeaderSubject").getBoolean() && node.hasProperty("exo:headerSubject")) {
                    headerSubject = node.getProperty("exo:headerSubject").getString() + " ";
                }
                if (node.hasProperty("exo:notifyEmailMoved") && !Utils.isEmpty(str = node.getProperty("exo:notifyEmailMoved").getString())) {
                    mailContent = str;
                }
            }
            catch (PathNotFoundException e) {
                log.debug((Object)"Forum node not exist.");
            }
            mailContent = StringUtils.replace((String)mailContent, (String)"$OBJECT_TYPE", (String)Utils.TOPIC);
            mailContent = StringUtils.replace((String)mailContent, (String)"$OBJECT_PARENT_TYPE", (String)Utils.FORUM);
            message.setFrom(this.getScreenName(sProvider, owner));
            String destForumId = destForumNode.getName();
            String srcForumId = "";
            for (Topic topic : topics) {
                String topicPath = topic.getPath();
                String newTopicPath = destForumPath + "/" + topic.getId();
                Node srcForumNode = forumHomeNode.getSession().getItem(topicPath).getParent();
                srcForumId = srcForumNode.getName();
                forumHomeNode.getSession().getWorkspace().move(topicPath, newTopicPath);
                tmp = srcForumNode.getProperty("exo:topicCount").getLong();
                tmp = tmp > 0L ? --tmp : 0L;
                srcForumNode.setProperty("exo:topicCount", tmp);
                this.queryLastTopic(sProvider, srcForumNode.getPath());
                Node topicNode = (Node)forumHomeNode.getSession().getItem(newTopicPath);
                topicNode.setProperty("exo:path", destForumNode.getName());
                long topicPostCount = topicNode.getProperty("exo:postCount").getLong() + 1L;
                destForumNode.setProperty("exo:topicCount", destForumNode.getProperty("exo:topicCount").getLong() + 1L);
                this.queryLastTopic(sProvider, destForumNode.getPath());
                tmp = srcForumNode.getProperty("exo:postCount").getLong();
                tmp = tmp > topicPostCount ? (tmp -= topicPostCount) : 0L;
                srcForumNode.setProperty("exo:postCount", tmp);
                destForumNode.setProperty("exo:postCount", destForumNode.getProperty("exo:postCount").getLong() + topicPostCount);
                message.setSubject(headerSubject + objectName + topic.getTopicName());
                message.setBody(mailContent.replace("$OBJECT_NAME", topic.getTopicName()).replace("$OBJECT_PARENT_NAME", forumName).replace("$VIEWPOST_LINK", link.replaceFirst("pathId", topic.getId())));
                HashSet<String> set = new HashSet<String>();
                set.add(this.getEmailUser(sProvider, topic.getOwner()));
                set.addAll(this.calculateMoveEmail(topicNode));
                set.addAll(this.calculateMoveEmail(srcForumNode));
                this.sendEmailNotification(new ArrayList<String>(set), message);
                try {
                    this.calculateLastRead(sProvider, destForumId, srcForumId, topic.getId());
                }
                catch (Exception e) {
                    log.error((Object)"Failed to calculate last read", (Throwable)e);
                }
            }
            if (forumHomeNode.isNew()) {
                forumHomeNode.getSession().save();
            } else {
                forumHomeNode.save();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to move topic", (Throwable)e);
            throw e;
        }
        finally {
            sProvider.close();
        }
    }

    private Set<String> calculateMoveEmail(Node node) throws Exception {
        HashSet<String> set = new HashSet<String>();
        while (!node.getName().equals("CategoryHome")) {
            if (node.isNodeType("exo:forumWatching")) {
                set.addAll(new PropertyReader(node).list("exo:emailWatching", new ArrayList()));
            }
            node = node.getParent();
        }
        return set;
    }

    private void calculateLastRead(SessionProvider sProvider, String destForumId, String srcForumId, String topicId) throws Exception {
        Node profileHome = this.getUserProfileHome(sProvider);
        QueryManager qm = profileHome.getSession().getWorkspace().getQueryManager();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/jcr:root").append(profileHome.getPath()).append("//element(*,").append(Utils.USER_PROFILES_TYPE).append(")").append("[(jcr:contains(@exo:lastReadPostOfForum, '").append("*" + topicId + "*").append("'))]");
        Query query = qm.createQuery(stringBuffer.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        while (iter.hasNext()) {
            ArrayList<String> list = new ArrayList<String>();
            ArrayList<String> list2 = new ArrayList<String>();
            Node profileNode = iter.nextNode();
            list.addAll(Utils.valuesToList(profileNode.getProperty("exo:lastReadPostOfForum").getValues()));
            list2.addAll(list);
            boolean isRead = false;
            for (String string : list) {
                block10: {
                    if (destForumId != null && string.indexOf(destForumId) >= 0) {
                        isRead = true;
                        try {
                            long lastAccessTopicTime = 0L;
                            long lastAccessForumTime = 0L;
                            if (!profileNode.hasProperty("exo:lastReadPostOfTopic")) break block10;
                            ArrayList<String> listAccess = new ArrayList<String>();
                            listAccess.addAll(Utils.valuesToList(profileNode.getProperty("exo:lastReadPostOfTopic").getValues()));
                            for (String string2 : listAccess) {
                                if (string2.indexOf(topicId) < 0) continue;
                                lastAccessTopicTime = Long.parseLong(string2.split(",")[2]);
                                if (lastAccessTopicTime > 0L) {
                                    Value[] values;
                                    for (Value vl : values = profileNode.getProperty("exo:readForum").getValues()) {
                                        String str = vl.getString();
                                        if (str.indexOf(destForumId) < 0 || str.indexOf(":") <= 0) continue;
                                        lastAccessForumTime = Long.parseLong(str.split(":")[1]);
                                        break;
                                    }
                                }
                                if (lastAccessTopicTime > lastAccessForumTime) {
                                    list2.remove(string);
                                    list2.add(destForumId + "," + string2.substring(0, string2.lastIndexOf(",")));
                                }
                                break;
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)"Failed to calculate last read", (Throwable)e);
                        }
                    }
                }
                if (string.indexOf(srcForumId) < 0) continue;
                list2.remove(string);
            }
            if (!isRead && destForumId != null) {
                list2.add(destForumId + "," + topicId + "/" + topicId.replace(Utils.TOPIC, Utils.POST));
            }
            profileNode.setProperty("exo:lastReadPostOfForum", list2.toArray(new String[list2.size()]));
        }
        profileHome.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastReadIndex(String path, String isApproved, String isHidden, String userLogin) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node catNode = this.getCategoryHome(sProvider);
            Node postNode = catNode.getNode(path);
            if (postNode != null) {
                Calendar cal = postNode.getProperty("exo:createdDate").getDate();
                StringBuilder builder = new StringBuilder();
                builder.append("/jcr:root").append(postNode.getParent().getPath()).append("/element(*,exo:post)");
                StringBuilder strBd = Utils.getPathQuery(isApproved, isHidden, userLogin);
                if (strBd.length() > 0) {
                    builder.append(strBd.toString().replace("]", "")).append(" and ");
                } else {
                    builder.append("[");
                }
                builder.append("(@exo:createdDate <= xs:dateTime('").append(ISO8601.format((Calendar)cal)).append("'))]");
                QueryManager qm = postNode.getSession().getWorkspace().getQueryManager();
                Query query = qm.createQuery(builder.toString(), "xpath");
                QueryResult result = query.execute();
                NodeIterator iter = result.getNodes();
                long size = iter.getSize();
                boolean isView = false;
                while (iter.hasNext()) {
                    if (!iter.nextNode().getName().equals(postNode.getName())) continue;
                    isView = true;
                    break;
                }
                if (!isView) {
                    size = 1L;
                }
                long l = size;
                return l;
            }
        }
        catch (Exception e) {
        }
        finally {
            sProvider.close();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JCRPageList getPostForSplitTopic(String topicPath) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            ForumPageList pagelist;
            Node topicNode = this.getCategoryHome(sProvider).getNode(topicPath);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(topicNode.getPath()).append("//element(*,exo:post)");
            stringBuffer.append(Utils.getPathQuery(null, "", "exoUserPri").toString().replaceAll("]", "")).append(" and exo:isFirstPost='false'] order by @exo:createdDate ascending");
            QueryManager qm = topicNode.getSession().getWorkspace().getQueryManager();
            Query query = qm.createQuery(stringBuffer.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ForumPageList forumPageList = pagelist = new ForumPageList(iter, 10, stringBuffer.toString(), true);
            return forumPageList;
        }
        catch (PathNotFoundException pathNotFoundException) {
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JCRPageList getPosts(String categoryId, String forumId, String topicId, String isApproved, String isHidden, String strQuery, String userLogin) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            ForumPageList pagelist;
            Node topicNode = this.getCategoryHome(sProvider).getNode(categoryId + "/" + forumId + "/" + topicId);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(topicNode.getPath()).append("//element(*,exo:post)");
            stringBuffer.append((CharSequence)Utils.getPathQuery(isApproved, isHidden, userLogin));
            stringBuffer.append(" order by @exo:createdDate ascending");
            ForumPageList forumPageList = pagelist = new ForumPageList(null, 10, stringBuffer.toString(), true);
            return forumPageList;
        }
        catch (PathNotFoundException e) {
            JCRPageList jCRPageList = null;
            return jCRPageList;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAvailablePost(String categoryId, String forumId, String topicId, String isApproved, String isHidden, String userLogin) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append(categoryId).append("/").append(forumId).append("/").append(topicId);
            Node topicNode = this.getCategoryHome(sProvider).getNode(strBuilder.toString());
            strBuilder = new StringBuilder();
            strBuilder.append("/jcr:root").append(topicNode.getPath()).append("//element(*,exo:post)");
            strBuilder.append((CharSequence)Utils.getPathQuery(isApproved, isHidden, userLogin));
            QueryManager qm = topicNode.getSession().getWorkspace().getQueryManager();
            Query query = qm.createQuery(strBuilder.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            long l = iter.getSize();
            return l;
        }
        catch (PathNotFoundException e) {
            long l = 0L;
            return l;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JCRPageList getPagePostByUser(String userName, String userId, boolean isMod, String strOrderBy) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            ForumPageList pagelist;
            Node categoryHome = this.getCategoryHome(sProvider);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer pathQuery = new StringBuffer();
            pathQuery.append("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:post)[@exo:isFirstPost='false' and @exo:owner='").append(userName);
            if (isMod) {
                pathQuery.append("' and ((@exo:userPrivate='").append(userId).append("') or (@exo:userPrivate='exoUserPri'))]");
            } else {
                pathQuery.append("' and @exo:isApproved='true' and @exo:isHidden='false' and @exo:isActiveByTopic='true' and ((@exo:userPrivate='").append(userId).append("') or (@exo:userPrivate='exoUserPri'))]");
            }
            if (!Utils.isEmpty(strOrderBy)) {
                pathQuery.append("order by @exo:").append(strOrderBy);
                if (strOrderBy.indexOf("createdDate") < 0) {
                    pathQuery.append(",@exo:createdDate descending");
                }
            }
            Query query = qm.createQuery(pathQuery.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ForumPageList forumPageList = pagelist = new ForumPageList(iter, 10, pathQuery.toString(), true);
            return forumPageList;
        }
        catch (Exception e) {
            JCRPageList jCRPageList = null;
            return jCRPageList;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Post getPost(String categoryId, String forumId, String topicId, String postId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node postNode;
            Node categoryHome = this.getCategoryHome(sProvider);
            if (postId.lastIndexOf("/") > 0) {
                if (postId.indexOf(categoryHome.getName()) < 0) {
                    postId = categoryHome.getPath() + "/" + postId;
                }
                postNode = (Node)categoryHome.getSession().getItem(postId);
            } else {
                postNode = categoryHome.getNode(categoryId + "/" + forumId + "/" + topicId + "/" + postId);
            }
            Post post = this.getPost(postNode);
            return post;
        }
        catch (PathNotFoundException e) {
            Post post = null;
            return post;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JCRPageList getListPostsByIP(String ip, String strOrderBy) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            ForumPageList pagelist;
            Node categoryHome = this.getCategoryHome(sProvider);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuilder builder = new StringBuilder();
            builder.append("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:post)[@exo:remoteAddr='").append(ip).append("']");
            if (Utils.isEmpty(strOrderBy)) {
                builder.append(" order by @exo:lastPostDate descending");
            } else {
                builder.append(" order by @exo:").append(strOrderBy);
                if (strOrderBy.indexOf("lastPostDate") < 0) {
                    builder.append(", @exo:lastPostDate descending");
                }
            }
            String pathQuery = builder.toString();
            Query query = qm.createQuery(pathQuery, "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ForumPageList forumPageList = pagelist = new ForumPageList(iter, 5, pathQuery, true);
            return forumPageList;
        }
        catch (Exception e) {
            JCRPageList jCRPageList = null;
            return jCRPageList;
        }
        finally {
            sProvider.close();
        }
    }

    public Post getPost(Node postNode) throws Exception {
        Post postNew = new Post();
        PropertyReader reader = new PropertyReader(postNode);
        postNew.setId(postNode.getName());
        postNew.setPath(postNode.getPath());
        postNew.setOwner(reader.string("exo:owner"));
        postNew.setCreatedDate(reader.date("exo:createdDate"));
        postNew.setModifiedBy(reader.string("exo:modifiedBy"));
        postNew.setModifiedDate(reader.date("exo:modifiedDate"));
        postNew.setEditReason(reader.string("exo:editReason"));
        postNew.setName(reader.string("exo:name"));
        postNew.setMessage(reader.string("exo:message"));
        postNew.setRemoteAddr(reader.string("exo:remoteAddr"));
        postNew.setIcon(reader.string("exo:icon"));
        postNew.setLink(reader.string("exo:link"));
        postNew.setIsApproved(reader.bool("exo:isApproved"));
        postNew.setIsHidden(reader.bool("exo:isHidden"));
        postNew.setIsActiveByTopic(reader.bool("exo:isActiveByTopic"));
        postNew.setUserPrivate(reader.strings("exo:userPrivate"));
        postNew.setNumberAttach(reader.l("exo:numberAttach"));
        if (postNew.getNumberAttach() > 0L) {
            NodeIterator postAttachments = postNode.getNodes();
            ArrayList<ForumAttachment> attachments = new ArrayList<ForumAttachment>();
            while (postAttachments.hasNext()) {
                Node node = postAttachments.nextNode();
                if (!node.isNodeType("exo:forumAttachment")) continue;
                JCRForumAttachment attachment = new JCRForumAttachment();
                Node nodeFile = node.getNode("jcr:content");
                attachment.setId(node.getName());
                attachment.setPathNode(node.getPath());
                attachment.setMimeType(nodeFile.getProperty("jcr:mimeType").getString());
                attachment.setName(nodeFile.getProperty("exo:fileName").getString());
                String workspace = node.getSession().getWorkspace().getName();
                attachment.setWorkspace(workspace);
                attachment.setSize(nodeFile.getProperty("jcr:data").getStream().available());
                attachment.setPath("/" + workspace + node.getPath());
                attachments.add(attachment);
            }
            postNew.setAttachments(attachments);
        }
        return postNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void savePost(String categoryId, String forumId, String topicId, Post post, boolean isNew, MessageBuilder messageBuilder) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node postNode;
            Node CategoryNode = this.getCategoryHome(sProvider).getNode(categoryId);
            Node forumNode = CategoryNode.getNode(forumId);
            Node topicNode = forumNode.getNode(topicId);
            Calendar calendar = this.getGreenwichMeanTime();
            if (isNew) {
                Node newProfileNode;
                postNode = topicNode.addNode(post.getId(), "exo:post");
                postNode.setProperty("exo:id", post.getId());
                postNode.setProperty("exo:path", forumId);
                postNode.setProperty("exo:owner", post.getOwner());
                post.setCreatedDate(calendar.getTime());
                postNode.setProperty("exo:createdDate", calendar);
                postNode.setProperty("exo:userPrivate", post.getUserPrivate());
                postNode.setProperty("exo:isActiveByTopic", true);
                postNode.setProperty("exo:link", post.getLink());
                if (topicId.replaceFirst(Utils.TOPIC, Utils.POST).equals(post.getId())) {
                    postNode.setProperty("exo:isFirstPost", true);
                } else {
                    postNode.setProperty("exo:isFirstPost", false);
                }
                Node userProfileNode = this.getUserProfileHome(sProvider);
                try {
                    newProfileNode = userProfileNode.getNode(post.getOwner());
                    long totalPostByUser = 0L;
                    totalPostByUser = newProfileNode.getProperty("exo:totalPost").getLong();
                    newProfileNode.setProperty("exo:totalPost", totalPostByUser + 1L);
                }
                catch (PathNotFoundException e) {
                    newProfileNode = userProfileNode.addNode(post.getOwner(), Utils.USER_PROFILES_TYPE);
                    newProfileNode.setProperty("exo:userId", post.getOwner());
                    newProfileNode.setProperty("exo:userTitle", Utils.USER);
                    if (this.isAdminRole(post.getOwner())) {
                        newProfileNode.setProperty("exo:userTitle", Utils.ADMIN);
                    }
                    newProfileNode.setProperty("exo:totalPost", 1L);
                }
                newProfileNode.setProperty("exo:lastPostDate", calendar);
                if (userProfileNode.isNew()) {
                    userProfileNode.getSession().save();
                } else {
                    userProfileNode.save();
                }
            } else {
                postNode = topicNode.getNode(post.getId());
            }
            if (post.getModifiedBy() != null && post.getModifiedBy().length() > 0) {
                postNode.setProperty("exo:modifiedBy", post.getModifiedBy());
                postNode.setProperty("exo:modifiedDate", calendar);
                postNode.setProperty("exo:editReason", post.getEditReason());
            }
            postNode.setProperty("exo:name", post.getName());
            postNode.setProperty("exo:message", post.getMessage());
            postNode.setProperty("exo:remoteAddr", post.getRemoteAddr());
            postNode.setProperty("exo:icon", post.getIcon());
            postNode.setProperty("exo:isApproved", post.getIsApproved());
            postNode.setProperty("exo:isHidden", post.getIsHidden());
            long numberAttach = 0L;
            ArrayList<String> listFileName = new ArrayList<String>();
            List<ForumAttachment> attachments = post.getAttachments();
            if (attachments != null) {
                Iterator<ForumAttachment> it = attachments.iterator();
                for (ForumAttachment attachment : attachments) {
                    ++numberAttach;
                    BufferAttachment file = null;
                    listFileName.add(attachment.getId());
                    try {
                        file = (BufferAttachment)it.next();
                        Node nodeFile = null;
                        nodeFile = !postNode.hasNode(file.getId()) ? postNode.addNode(file.getId(), "exo:forumAttachment") : postNode.getNode(file.getId());
                        ForumServiceUtils.reparePermissions(nodeFile, "any");
                        Node nodeContent = null;
                        if (nodeFile.hasNode("jcr:content")) continue;
                        nodeContent = nodeFile.addNode("jcr:content", "exo:forumResource");
                        nodeContent.setProperty("jcr:mimeType", file.getMimeType());
                        nodeContent.setProperty("jcr:data", file.getInputStream());
                        nodeContent.setProperty("jcr:lastModified", Calendar.getInstance().getTimeInMillis());
                        nodeContent.setProperty("exo:fileName", file.getName());
                    }
                    catch (Exception e) {
                        log.error((Object)"Failed to save attachment", (Throwable)e);
                    }
                }
            }
            NodeIterator postAttachments = postNode.getNodes();
            Node postAttachmentNode = null;
            while (postAttachments.hasNext()) {
                postAttachmentNode = postAttachments.nextNode();
                if (listFileName.contains(postAttachmentNode.getName())) continue;
                postAttachmentNode.remove();
            }
            boolean sendAlertJob = true;
            boolean isFistPost = false;
            if (isNew) {
                long topicPostCount = topicNode.getProperty("exo:postCount").getLong() + 1L;
                long newNumberAttach = topicNode.getProperty("exo:numberAttachments").getLong() + numberAttach;
                if (topicPostCount == 0L) {
                    topicNode.setProperty("exo:postCount", topicPostCount);
                }
                long forumPostCount = forumNode.getProperty("exo:postCount").getLong() + 1L;
                boolean isSetLastPost = true;
                if (topicNode.getProperty("exo:isClosed").getBoolean()) {
                    sendAlertJob = false;
                    postNode.setProperty("exo:isActiveByTopic", false);
                } else {
                    if (isSetLastPost && topicNode.getProperty("exo:isWaiting").getBoolean()) {
                        isSetLastPost = false;
                        sendAlertJob = false;
                    }
                    if (isSetLastPost) {
                        sendAlertJob = false;
                        isSetLastPost = topicNode.getProperty("exo:isActive").getBoolean();
                    }
                    boolean canView = true;
                    Node categoryNode = forumNode.getParent();
                    if (this.hasProperty(categoryNode, "exo:viewer") || this.hasProperty(forumNode, "exo:viewer") || this.hasProperty(topicNode, "exo:canView")) {
                        canView = false;
                    }
                    if (isSetLastPost) {
                        if (topicId.replaceFirst(Utils.TOPIC, Utils.POST).equals(post.getId())) {
                            isFistPost = true;
                            if (!forumNode.getProperty("exo:isModerateTopic").getBoolean()) {
                                forumNode.setProperty("exo:postCount", forumPostCount);
                                if (canView) {
                                    forumNode.setProperty("exo:lastTopicPath", topicNode.getName());
                                }
                                sendAlertJob = false;
                            } else if (canView && topicNode.getProperty("exo:isApproved").getBoolean()) {
                                forumNode.setProperty("exo:lastTopicPath", topicNode.getName());
                                sendAlertJob = false;
                            }
                            if (!post.getIsHidden()) {
                                topicNode.setProperty("exo:postCount", topicPostCount);
                                topicNode.setProperty("exo:numberAttachments", newNumberAttach);
                                topicNode.setProperty("exo:lastPostDate", calendar);
                                topicNode.setProperty("exo:lastPostBy", post.getOwner());
                            }
                        } else if (canView) {
                            if (forumNode.getProperty("exo:isModerateTopic").getBoolean()) {
                                if (topicNode.getProperty("exo:isApproved").getBoolean() && !topicNode.getProperty("exo:isModeratePost").getBoolean()) {
                                    forumNode.setProperty("exo:lastTopicPath", topicNode.getName());
                                    sendAlertJob = false;
                                }
                            } else if (!topicNode.getProperty("exo:isModeratePost").getBoolean()) {
                                forumNode.setProperty("exo:lastTopicPath", topicNode.getName());
                                sendAlertJob = false;
                            } else if (post.getIsApproved()) {
                                forumNode.setProperty("exo:lastTopicPath", topicNode.getName());
                                sendAlertJob = false;
                            }
                            if (post.getIsApproved()) {
                                if (!post.getIsHidden() && post.getUserPrivate().length != 2) {
                                    forumNode.setProperty("exo:postCount", forumPostCount);
                                    topicNode.setProperty("exo:numberAttachments", newNumberAttach);
                                    topicNode.setProperty("exo:postCount", topicPostCount);
                                    topicNode.setProperty("exo:lastPostDate", calendar);
                                    topicNode.setProperty("exo:lastPostBy", post.getOwner());
                                }
                                if (post.getIsHidden()) {
                                    sendAlertJob = true;
                                }
                            } else {
                                sendAlertJob = true;
                            }
                        } else {
                            forumNode.setProperty("exo:postCount", forumPostCount);
                            topicNode.setProperty("exo:postCount", topicPostCount);
                        }
                    } else {
                        postNode.setProperty("exo:isActiveByTopic", false);
                        sendAlertJob = true;
                    }
                }
                if (isNew && messageBuilder.getLink().length() == 0) {
                    sendAlertJob = false;
                }
            } else {
                if (post.getIsApproved() && !post.getIsHidden()) {
                    sendAlertJob = false;
                }
                long temp = topicNode.getProperty("exo:numberAttachments").getLong() - postNode.getProperty("exo:numberAttach").getLong();
                topicNode.setProperty("exo:numberAttachments", temp + numberAttach);
            }
            postNode.setProperty("exo:numberAttach", numberAttach);
            if (isNew) {
                forumNode.getSession().save();
            } else {
                forumNode.save();
            }
            if (!isFistPost && isNew) {
                this.sendNotification(topicNode, null, post, messageBuilder, true);
            }
            if (sendAlertJob) {
                ArrayList<String> userIdsp = new ArrayList<String>();
                if (forumNode.hasProperty("exo:moderators")) {
                    userIdsp.addAll(Utils.valuesToList(forumNode.getProperty("exo:moderators").getValues()));
                }
                userIdsp.addAll(this.getAllAdministrator(sProvider));
                this.getTotalJobWatting(sProvider, userIdsp);
            }
            if (post.getUserPrivate().length > 1) {
                ForumPrivateMessage message = new ForumPrivateMessage();
                message.setFrom(this.getScreenName(sProvider, post.getOwner()));
                message.setSendTo(post.getUserPrivate()[0] + "," + post.getUserPrivate()[1]);
                message.setType("PrivatePost");
                message.setName(post.getName());
                message.setMessage(post.getMessage());
                message.setId(post.getLink() + "/" + post.getId());
                this.sendNotificationMessage(message);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to save post" + post.getName()), (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    private boolean hasProperty(Node node, String property) throws Exception {
        return node.hasProperty(property) && node.getProperty(property).getValues().length > 0 && !Utils.isEmpty(node.getProperty(property).getValues()[0].getString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNotification(Node node, Topic topic, Post post, MessageBuilder messageBuilder, boolean isApprovePost) throws Exception {
        block70: {
            Node forumAdminNode = null;
            SessionProvider sProvider = SessionProvider.createSystemProvider();
            try {
                try {
                    forumAdminNode = this.getAdminHome(sProvider).getNode(Utils.FORUMADMINISTRATION);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (forumAdminNode != null) {
                    if (forumAdminNode.hasProperty("exo:notifyEmailContent")) {
                        messageBuilder.setContent(forumAdminNode.getProperty("exo:notifyEmailContent").getString());
                    }
                    if (forumAdminNode.hasProperty("exo:enableHeaderSubject") && forumAdminNode.getProperty("exo:enableHeaderSubject").getBoolean() && forumAdminNode.hasProperty("exo:headerSubject")) {
                        messageBuilder.setHeaderSubject(forumAdminNode.getProperty("exo:headerSubject").getString());
                    }
                }
                List<String> listUser = new ArrayList<String>();
                List<Object> emailList = new ArrayList<String>();
                ArrayList<String> emailListCate = new ArrayList<String>();
                Node userProfileHome = null;
                userProfileHome = this.getUserProfileHome(sProvider);
                int count = 0;
                if (post == null) {
                    Node forumNode = node;
                    messageBuilder.setForumName(node.getProperty("exo:name").getString());
                    node = node.getParent();
                    messageBuilder.setCatName(node.getProperty("exo:name").getString());
                    messageBuilder.setTopicName(topic.getTopicName());
                    while (true) {
                        List<String> notyfys;
                        emailListCate.addAll(emailList);
                        emailList = new ArrayList();
                        if (node.isNodeType("exo:forumWatching") && topic.getIsActive() && topic.getIsApproved() && topic.getIsActiveByForum() && !topic.getIsClosed() && !topic.getIsLock() && !topic.getIsWaiting()) {
                            Node categoryNode = null;
                            categoryNode = node.isNodeType("exo:forumCategory") ? node : node.getParent();
                            if (categoryNode.hasProperty("exo:userPrivate")) {
                                listUser.addAll(Utils.valuesToList(categoryNode.getProperty("exo:userPrivate").getValues()));
                            }
                            if (!listUser.isEmpty() && !Utils.isEmpty((String)listUser.get(0))) {
                                if (node.hasProperty("exo:emailWatching")) {
                                    List<String> emails = Utils.valuesToList(node.getProperty("exo:emailWatching").getValues());
                                    int i = 0;
                                    for (String user : Utils.valuesToList(node.getProperty("exo:userWatching").getValues())) {
                                        if (ForumServiceUtils.hasPermission(listUser.toArray(new String[listUser.size()]), user)) {
                                            emailList.add(emails.get(i));
                                        }
                                        ++i;
                                    }
                                }
                            } else if (node.hasProperty("exo:emailWatching")) {
                                emailList.addAll(Utils.valuesToList(node.getProperty("exo:emailWatching").getValues()));
                            }
                        }
                        if (node.hasProperty("exo:notifyWhenAddTopic") && !(notyfys = Utils.valuesToList(node.getProperty("exo:notifyWhenAddTopic").getValues())).isEmpty()) {
                            emailList.addAll(notyfys);
                        }
                        for (String string : emailListCate) {
                            while (emailList.contains(string)) {
                                emailList.remove(string);
                            }
                        }
                        if (emailList.size() > 0) {
                            String owner = this.getScreenName(sProvider, topic.getOwner());
                            messageBuilder.setObjName(node.getProperty("exo:name").getString());
                            if (node.isNodeType("exo:forum")) {
                                messageBuilder.setWatchType(Utils.FORUM);
                            } else {
                                messageBuilder.setWatchType(Utils.CATEGORY);
                            }
                            messageBuilder.setId(topic.getId().replaceFirst(Utils.TOPIC, Utils.POST));
                            messageBuilder.setAddType(Utils.TOPIC);
                            messageBuilder.setMessage(topic.getDescription());
                            messageBuilder.setCreatedDate(topic.getCreatedDate());
                            messageBuilder.setOwner(owner);
                            messageBuilder.setLink(topic.getLink());
                            this.sendEmailNotification(emailList, messageBuilder.getContentEmail());
                        }
                        if (node.isNodeType("exo:forum")) break block70;
                        if (count > 1) {
                            break block70;
                        }
                        ++count;
                        node = forumNode;
                    }
                }
                if (node.getName().replaceFirst(Utils.TOPIC, Utils.POST).equals(post.getId())) break block70;
                Node forumNode = node.getParent();
                Node categoryNode = forumNode.getParent();
                messageBuilder.setForumName(categoryNode.getProperty("exo:name").getString());
                messageBuilder.setCatName(forumNode.getProperty("exo:name").getString());
                messageBuilder.setTopicName(node.getProperty("exo:name").getString());
                boolean isSend = false;
                if (post.getIsApproved() && post.getIsActiveByTopic() && !post.getIsHidden()) {
                    isSend = true;
                    ArrayList<String> listCanViewInTopic = new ArrayList<String>();
                    if (node.hasProperty("exo:canView")) {
                        listCanViewInTopic.addAll(Utils.valuesToList(node.getProperty("exo:canView").getValues()));
                    }
                    if (post.getUserPrivate() != null && post.getUserPrivate().length > 1) {
                        listUser.addAll(Arrays.asList(post.getUserPrivate()));
                    }
                    if (listUser.isEmpty() || listUser.size() == 1) {
                        if (!listCanViewInTopic.isEmpty() && !Utils.isEmpty((String)listCanViewInTopic.get(0))) {
                            listCanViewInTopic.addAll(Utils.valuesToList(forumNode.getProperty("exo:poster").getValues()));
                            listCanViewInTopic.addAll(Utils.valuesToList(forumNode.getProperty("exo:viewer").getValues()));
                        }
                        if (categoryNode.hasProperty("exo:userPrivate")) {
                            listUser.addAll(Utils.valuesToList(categoryNode.getProperty("exo:userPrivate").getValues()));
                        }
                        if (!listUser.isEmpty() && !Utils.isEmpty((String)listUser.get(0))) {
                            if (!listCanViewInTopic.isEmpty() && !Utils.isEmpty((String)listCanViewInTopic.get(0)) && ((listUser = Utils.extractSameItems(listUser, listCanViewInTopic)).isEmpty() || Utils.isEmpty(listUser.get(0)))) {
                                isSend = false;
                            }
                        } else {
                            listUser = listCanViewInTopic;
                        }
                    }
                }
                if (node.isNodeType("exo:forumWatching") && node.hasProperty("exo:emailWatching") && isSend) {
                    if (!(listUser.isEmpty() || ((String)listUser.get(0)).equals("exoUserPri") || Utils.isEmpty((String)listUser.get(0)))) {
                        List<String> emails = Utils.valuesToList(node.getProperty("exo:emailWatching").getValues());
                        int i = 0;
                        for (String user : Utils.valuesToList(node.getProperty("exo:userWatching").getValues())) {
                            if (ForumServiceUtils.hasPermission(listUser.toArray(new String[listUser.size()]), user)) {
                                emailList.add(emails.get(i));
                            }
                            ++i;
                        }
                    } else {
                        emailList = Utils.valuesToList(node.getProperty("exo:emailWatching").getValues());
                    }
                }
                ArrayList<String> emailListForum = new ArrayList<String>();
                if (isApprovePost) {
                    String[] users;
                    String ownerTopicEmail = "";
                    String owner = node.getProperty("exo:owner").getString();
                    if (node.hasProperty("exo:isNotifyWhenAddPost") && !Utils.isEmpty(node.getProperty("exo:isNotifyWhenAddPost").getString())) {
                        try {
                            Node userOwner = userProfileHome.getNode(owner);
                            ownerTopicEmail = userOwner.getProperty("exo:email").getString();
                        }
                        catch (Exception e) {
                            ownerTopicEmail = node.getProperty("exo:isNotifyWhenAddPost").getString();
                        }
                    }
                    if ((users = post.getUserPrivate()) != null && users.length == 2) {
                        if (!Utils.isEmpty(ownerTopicEmail) && (users[0].equals(owner) || users[1].equals(owner))) {
                            emailList.add(ownerTopicEmail);
                        }
                        owner = forumNode.getProperty("exo:owner").getString();
                        if (forumNode.hasProperty("exo:notifyWhenAddPost") && (users[0].equals(owner) || users[1].equals(owner))) {
                            emailListForum.addAll(Utils.valuesToList(forumNode.getProperty("exo:notifyWhenAddPost").getValues()));
                        }
                    } else {
                        if (!Utils.isEmpty(ownerTopicEmail)) {
                            emailList.add(ownerTopicEmail);
                        }
                        if (forumNode.hasProperty("exo:notifyWhenAddPost")) {
                            emailListForum.addAll(Utils.valuesToList(forumNode.getProperty("exo:notifyWhenAddPost").getValues()));
                        }
                    }
                }
                if (forumNode.isNodeType("exo:forumWatching") && forumNode.hasProperty("exo:emailWatching") && isSend) {
                    if (!(listUser.isEmpty() || ((String)listUser.get(0)).equals("exoUserPri") || Utils.isEmpty((String)listUser.get(0)))) {
                        List<String> emails = Utils.valuesToList(forumNode.getProperty("exo:emailWatching").getValues());
                        int i = 0;
                        for (String user : Utils.valuesToList(forumNode.getProperty("exo:userWatching").getValues())) {
                            if (ForumServiceUtils.hasPermission(listUser.toArray(new String[listUser.size()]), user)) {
                                emailListForum.add(emails.get(i));
                            }
                            ++i;
                        }
                    } else {
                        emailListForum.addAll(Utils.valuesToList(forumNode.getProperty("exo:emailWatching").getValues()));
                    }
                }
                ArrayList<String> emailListCategory = new ArrayList<String>();
                if (categoryNode.isNodeType("exo:forumWatching") && categoryNode.hasProperty("exo:emailWatching") && isSend) {
                    if (!(listUser.isEmpty() || ((String)listUser.get(0)).equals("exoUserPri") || Utils.isEmpty((String)listUser.get(0)))) {
                        List<String> emails = Utils.valuesToList(categoryNode.getProperty("exo:emailWatching").getValues());
                        int i = 0;
                        for (String user : Utils.valuesToList(categoryNode.getProperty("exo:userWatching").getValues())) {
                            if (ForumServiceUtils.hasPermission(listUser.toArray(new String[listUser.size()]), user)) {
                                emailListCategory.add(emails.get(i));
                            }
                            ++i;
                        }
                    } else {
                        emailListCategory.addAll(Utils.valuesToList(categoryNode.getProperty("exo:emailWatching").getValues()));
                    }
                }
                String fullName = this.getScreenName(sProvider, post.getOwner());
                messageBuilder.setOwner(fullName);
                messageBuilder.setId(post.getId());
                messageBuilder.setAddType(Utils.POST);
                messageBuilder.setMessage(post.getMessage());
                messageBuilder.setCreatedDate(post.getCreatedDate());
                messageBuilder.setLink(post.getLink());
                if (emailListCategory.size() > 0) {
                    messageBuilder.setObjName(messageBuilder.getCatName());
                    messageBuilder.setWatchType(Utils.CATEGORY);
                    this.sendEmailNotification(emailListCategory, messageBuilder.getContentEmail());
                }
                for (String string : emailListCategory) {
                    while (emailListForum.contains(string)) {
                        emailListForum.remove(string);
                    }
                }
                if (emailListForum.size() > 0) {
                    messageBuilder.setObjName(messageBuilder.getForumName());
                    messageBuilder.setWatchType(Utils.FORUM);
                    this.sendEmailNotification(emailListForum, messageBuilder.getContentEmail());
                }
                for (String string : emailListCategory) {
                    while (emailList.contains(string)) {
                        emailList.remove(string);
                    }
                }
                for (String string : emailListForum) {
                    while (emailList.contains(string)) {
                        emailList.remove(string);
                    }
                }
                if (emailList.size() > 0) {
                    messageBuilder.setObjName(messageBuilder.getTopicName());
                    messageBuilder.setWatchType(Utils.TOPIC);
                    this.sendEmailNotification(emailList, messageBuilder.getContentEmail());
                }
            }
            catch (Exception e) {
                log.error((Object)"Failed to send notification.", (Throwable)e);
            }
            finally {
                sProvider.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyPost(List<Post> posts, int type) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumHomeNode = this.getForumHomeNode(sProvider);
            for (Post post : posts) {
                try {
                    boolean isGetLastPost = false;
                    String postPath = post.getPath();
                    String topicPath = postPath.substring(0, postPath.lastIndexOf("/"));
                    String forumPath = postPath.substring(0, topicPath.lastIndexOf("/"));
                    Node postNode = (Node)forumHomeNode.getSession().getItem(postPath);
                    Node topicNode = (Node)forumHomeNode.getSession().getItem(topicPath);
                    Node forumNode = (Node)forumHomeNode.getSession().getItem(forumPath);
                    Calendar lastPostDate = topicNode.getProperty("exo:lastPostDate").getDate();
                    Calendar postDate = postNode.getProperty("exo:createdDate").getDate();
                    long topicPostCount = topicNode.getProperty("exo:postCount").getLong();
                    long newNumberAttach = topicNode.getProperty("exo:numberAttachments").getLong();
                    long forumPostCount = forumNode.getProperty("exo:postCount").getLong();
                    ArrayList<String> userIdsp = new ArrayList<String>();
                    try {
                        if (forumNode.hasProperty("exo:moderators")) {
                            userIdsp.addAll(Utils.valuesToList(forumNode.getProperty("exo:moderators").getValues()));
                        }
                        userIdsp.addAll(this.getAllAdministrator(sProvider));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    switch (type) {
                        case 3: {
                            postNode.setProperty("exo:isApproved", true);
                            post.setIsApproved(true);
                            this.sendNotification(topicNode, null, post, new MessageBuilder(), false);
                            break;
                        }
                        case 9: {
                            if (post.getIsHidden()) {
                                postNode.setProperty("exo:isHidden", true);
                                Node postLastNode = this.getLastDatePost(forumHomeNode, topicNode, postNode);
                                if (postLastNode != null) {
                                    topicNode.setProperty("exo:lastPostDate", postLastNode.getProperty("exo:createdDate").getDate());
                                    topicNode.setProperty("exo:lastPostBy", postLastNode.getProperty("exo:owner").getString());
                                    isGetLastPost = true;
                                }
                                if ((newNumberAttach -= postNode.getProperty("exo:numberAttach").getLong()) < 0L) {
                                    newNumberAttach = 0L;
                                }
                                topicNode.setProperty("exo:numberAttachments", newNumberAttach);
                                topicNode.setProperty("exo:postCount", topicPostCount - 1L);
                                forumNode.setProperty("exo:postCount", forumPostCount - 1L);
                                break;
                            }
                            postNode.setProperty("exo:isHidden", false);
                            this.sendNotification(topicNode, null, post, new MessageBuilder(), false);
                            break;
                        }
                    }
                    if (!post.getIsHidden() && post.getIsApproved()) {
                        if (postDate.getTimeInMillis() > lastPostDate.getTimeInMillis()) {
                            topicNode.setProperty("exo:lastPostDate", postDate);
                            topicNode.setProperty("exo:lastPostBy", post.getOwner());
                            isGetLastPost = true;
                        }
                        topicNode.setProperty("exo:numberAttachments", newNumberAttach += postNode.getProperty("exo:numberAttach").getLong());
                        topicNode.setProperty("exo:postCount", topicPostCount + 1L);
                        forumNode.setProperty("exo:postCount", forumPostCount + 1L);
                    }
                    if (forumNode.isNew()) {
                        forumNode.getSession().save();
                    } else {
                        forumNode.save();
                    }
                    if (isGetLastPost) {
                        this.queryLastTopic(sProvider, topicPath.substring(0, topicPath.lastIndexOf("/")));
                    }
                    this.getTotalJobWatting(sProvider, userIdsp);
                }
                catch (PathNotFoundException e) {
                    log.error((Object)("Failed to modify post" + post.getName()), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to modify posts", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    private Node getLastDatePost(Node forumHomeNode, Node node, Node postNode_) throws Exception {
        QueryManager qm = forumHomeNode.getSession().getWorkspace().getQueryManager();
        StringBuffer pathQuery = new StringBuffer();
        pathQuery.append("/jcr:root").append(node.getPath()).append("//element(*,exo:post)[@exo:isHidden='false' and @exo:isApproved='true'] order by @exo:createdDate descending");
        Query query = qm.createQuery(pathQuery.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        Node postNode = null;
        while (iter.hasNext() && (postNode = iter.nextNode()).getName().equals(postNode_.getName())) {
        }
        return postNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Post removePost(String categoryId, String forumId, String topicId, String postId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node CategoryNode = this.getCategoryHome(sProvider).getNode(categoryId);
            Post post = this.getPost(categoryId, forumId, topicId, postId);
            Node forumNode = CategoryNode.getNode(forumId);
            Node topicNode = forumNode.getNode(topicId);
            Node postNode = topicNode.getNode(postId);
            long numberAttachs = postNode.getProperty("exo:numberAttach").getLong();
            String owner = postNode.getProperty("exo:owner").getString();
            Node userProfileNode = this.getUserProfileHome(sProvider);
            try {
                Node newProfileNode = userProfileNode.getNode(owner);
                newProfileNode.setProperty("exo:totalPost", newProfileNode.getProperty("exo:totalPost").getLong() - 1L);
                newProfileNode.save();
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
            postNode.remove();
            if (!post.getIsHidden() && post.getIsApproved() && (post.getUserPrivate() == null || post.getUserPrivate().length == 1)) {
                long topicPostCount = topicNode.getProperty("exo:postCount").getLong() - 1L;
                topicNode.setProperty("exo:postCount", topicPostCount);
                long newNumberAttachs = topicNode.getProperty("exo:numberAttachments").getLong();
                newNumberAttachs = newNumberAttachs > numberAttachs ? (newNumberAttachs -= numberAttachs) : 0L;
                topicNode.setProperty("exo:numberAttachments", newNumberAttachs);
            }
            NodeIterator nodeIterator = topicNode.getNodes();
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                if (!node.isNodeType("exo:post")) continue;
                postNode = node;
            }
            topicNode.setProperty("exo:lastPostBy", postNode.getProperty("exo:owner").getValue().getString());
            topicNode.setProperty("exo:lastPostDate", postNode.getProperty("exo:createdDate").getValue().getDate());
            forumNode.save();
            if (!post.getIsHidden() && post.getIsApproved() && (post.getUserPrivate() == null || post.getUserPrivate().length == 1)) {
                long forumPostCount = forumNode.getProperty("exo:postCount").getLong() - 1L;
                forumNode.setProperty("exo:postCount", forumPostCount);
                forumNode.save();
            } else if (post.getUserPrivate() == null || post.getUserPrivate().length == 1) {
                ArrayList<String> list = new ArrayList<String>();
                if (forumNode.hasProperty("exo:moderators")) {
                    list.addAll(Utils.valuesToList(forumNode.getProperty("exo:moderators").getValues()));
                }
                list.addAll(this.getAllAdministrator(sProvider));
                this.getTotalJobWatting(sProvider, list);
            }
            Post post2 = post;
            return post2;
        }
        catch (Exception e) {
            log.error((Object)"Failed to remove post in topic.");
            Post post = null;
            return post;
        }
        finally {
            sProvider.close();
        }
    }

    @Override
    public void movePost(String[] postPaths, String destTopicPath, boolean isCreatNewTopic, String mailContent, String link) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumHomeNode = this.getForumHomeNode(sProvider);
            String srcTopicPath = postPaths[0];
            srcTopicPath = srcTopicPath.substring(0, srcTopicPath.lastIndexOf("/"));
            Node srcTopicNode = (Node)forumHomeNode.getSession().getItem(srcTopicPath);
            Node srcForumNode = srcTopicNode.getParent();
            Node destTopicNode = (Node)forumHomeNode.getSession().getItem(destTopicPath);
            Node destForumNode = destTopicNode.getParent();
            long totalAtt = 0L;
            long totalpost = postPaths.length;
            Node postNode = null;
            boolean destModeratePost = false;
            if (destTopicNode.hasProperty("exo:isModeratePost")) {
                destModeratePost = destTopicNode.getProperty("exo:isModeratePost").getBoolean();
            }
            boolean srcModeratePost = false;
            if (srcTopicNode.hasProperty("exo:isModeratePost")) {
                srcModeratePost = srcTopicNode.getProperty("exo:isModeratePost").getBoolean();
            }
            boolean unAproved = false;
            int i = 0;
            while ((long)i < totalpost) {
                String path = postPaths[i];
                String newPostPath = destTopicPath + path.substring(path.lastIndexOf("/"));
                forumHomeNode.getSession().getWorkspace().move(path, newPostPath);
                postPaths[i] = newPostPath;
                postNode = (Node)forumHomeNode.getSession().getItem(newPostPath);
                postNode.setProperty("exo:path", destForumNode.getName());
                postNode.setProperty("exo:createdDate", this.getGreenwichMeanTime());
                if (isCreatNewTopic && i == 0) {
                    postNode.setProperty("exo:isFirstPost", true);
                } else {
                    postNode.setProperty("exo:isFirstPost", false);
                }
                if (!destModeratePost) {
                    postNode.setProperty("exo:isApproved", true);
                } else if (!postNode.getProperty("exo:isApproved").getBoolean()) {
                    unAproved = true;
                }
                ++i;
            }
            destTopicNode.setProperty("exo:postCount", destTopicNode.getProperty("exo:postCount").getLong() + totalpost);
            destTopicNode.setProperty("exo:numberAttachments", destTopicNode.getProperty("exo:numberAttachments").getLong() + totalAtt);
            destForumNode.setProperty("exo:postCount", destForumNode.getProperty("exo:postCount").getLong() + totalpost);
            destTopicNode.setProperty("exo:lastPostBy", postNode.getProperty("exo:owner").getValue().getString());
            destTopicNode.setProperty("exo:lastPostDate", postNode.getProperty("exo:createdDate").getValue().getDate());
            long temp = srcTopicNode.getProperty("exo:postCount").getLong();
            if ((temp -= totalpost) < 0L) {
                temp = 0L;
            }
            srcTopicNode.setProperty("exo:postCount", temp);
            temp = srcTopicNode.getProperty("exo:numberAttachments").getLong();
            if ((temp -= totalAtt) < 0L) {
                temp = 0L;
            }
            srcTopicNode.setProperty("exo:numberAttachments", temp);
            NodeIterator nodeIterator = srcTopicNode.getNodes();
            long posLast = nodeIterator.getSize() - 1L;
            nodeIterator.skip(posLast);
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                if (!node.isNodeType("exo:post")) continue;
                postNode = node;
            }
            srcTopicNode.setProperty("exo:lastPostBy", postNode.getProperty("exo:owner").getValue().getString());
            srcTopicNode.setProperty("exo:lastPostDate", postNode.getProperty("exo:createdDate").getValue().getDate());
            temp = srcForumNode.getProperty("exo:postCount").getLong();
            if ((temp -= totalpost) < 0L) {
                temp = 0L;
            }
            srcForumNode.setProperty("exo:postCount", temp);
            if (forumHomeNode.isNew()) {
                forumHomeNode.getSession().save();
            } else {
                forumHomeNode.save();
            }
            String topicName = destTopicNode.getProperty("exo:name").getString();
            String ownerTopic = destTopicNode.getProperty("exo:owner").getString();
            String headerSubject = "";
            String objectName = "[" + destForumNode.getParent().getProperty("exo:name").getString() + "][" + destForumNode.getProperty("exo:name").getString() + "] " + topicName;
            try {
                String str;
                Node node = forumHomeNode.getNode(Utils.FORUMADMINISTRATION);
                if (node.hasProperty("exo:enableHeaderSubject") && node.getProperty("exo:enableHeaderSubject").getBoolean() && node.hasProperty("exo:headerSubject")) {
                    headerSubject = node.getProperty("exo:headerSubject").getString() + " ";
                }
                if (node.hasProperty("exo:notifyEmailMoved") && !Utils.isEmpty(str = node.getProperty("exo:notifyEmailMoved").getString())) {
                    mailContent = str;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            mailContent = StringUtils.replace((String)mailContent, (String)"$OBJECT_TYPE", (String)Utils.POST);
            mailContent = StringUtils.replace((String)mailContent, (String)"$OBJECT_PARENT_TYPE", (String)Utils.TOPIC);
            link = link.replaceFirst("pathId", destTopicNode.getProperty("exo:id").getString());
            int i2 = 0;
            while ((long)i2 < totalpost) {
                postNode = (Node)forumHomeNode.getSession().getItem(postPaths[i2]);
                Message message = new Message();
                message.setMimeType("text/html");
                message.setFrom(this.getScreenName(sProvider, ownerTopic));
                message.setSubject(headerSubject + objectName);
                message.setBody(mailContent.replace("$OBJECT_NAME", postNode.getProperty("exo:name").getString()).replace("$OBJECT_PARENT_NAME", topicName).replace("$VIEWPOST_LINK", link));
                HashSet<String> set = new HashSet<String>();
                set.add(this.getEmailUser(sProvider, postNode.getProperty("exo:owner").getString()));
                set.addAll(this.calculateMoveEmail(destTopicNode));
                set.addAll(this.calculateMoveEmail(srcTopicNode));
                this.sendEmailNotification(new ArrayList<String>(set), message);
                ++i2;
            }
            ArrayList<String> userIdsp = new ArrayList<String>();
            if (destModeratePost && srcModeratePost) {
                if (srcForumNode.hasProperty("exo:moderators")) {
                    userIdsp.addAll(Utils.valuesToList(srcForumNode.getProperty("exo:moderators").getValues()));
                }
                if (unAproved && destForumNode.hasProperty("exo:moderators")) {
                    userIdsp.addAll(Utils.valuesToList(destForumNode.getProperty("exo:moderators").getValues()));
                }
            } else if (srcModeratePost && !destModeratePost) {
                if (srcForumNode.hasProperty("exo:moderators")) {
                    userIdsp.addAll(Utils.valuesToList(srcForumNode.getProperty("exo:moderators").getValues()));
                }
                userIdsp.addAll(this.getAllAdministrator(sProvider));
            } else if (!srcModeratePost && destModeratePost && unAproved && destForumNode.hasProperty("exo:moderators")) {
                userIdsp.addAll(Utils.valuesToList(destForumNode.getProperty("exo:moderators").getValues()));
            }
            if (!userIdsp.isEmpty()) {
                this.getTotalJobWatting(sProvider, userIdsp);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            sProvider.close();
        }
    }

    @Override
    public void mergeTopic(String srcTopicPath, String destTopicPath, String mailContent, String link) throws Exception {
        block9: {
            SessionProvider sProvider = SessionProvider.createSystemProvider();
            try {
                Node srcTopicNode = this.getCategoryHome(sProvider).getNode(srcTopicPath);
                NodeIterator iter = srcTopicNode.getNodes();
                ArrayList<Post> posts = new ArrayList<Post>();
                while (iter.hasNext()) {
                    Post post = new Post();
                    Node node = iter.nextNode();
                    if (!node.isNodeType("exo:post")) continue;
                    post.setPath(node.getPath());
                    post.setCreatedDate(node.getProperty("exo:createdDate").getDate().getTime());
                    posts.add(post);
                }
                if (posts.size() <= 0) break block9;
                try {
                    Collections.sort(posts, new Utils.DatetimeComparatorPostDESC());
                }
                catch (Exception e) {
                    // empty catch block
                }
                String[] postPaths = new String[posts.size()];
                int i = 0;
                for (Post p : posts) {
                    postPaths[i] = p.getPath();
                    ++i;
                }
                this.movePost(postPaths, destTopicPath, false, mailContent, link);
                String[] ids = srcTopicPath.split("/");
                this.removeTopic(ids[0], ids[1], srcTopicNode.getName());
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                sProvider.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTag(List<Tag> tags, String userName, String topicPath) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node topicNode = (Node)this.getCategoryHome(sProvider).getSession().getItem(topicPath);
            List<Object> listId = new ArrayList();
            ArrayList<String> list = new ArrayList<String>();
            if (topicNode.hasProperty("exo:tagId")) {
                listId = Utils.valuesToList(topicNode.getProperty("exo:tagId").getValues());
            }
            list.addAll(listId);
            for (Tag tag : tags) {
                boolean isAdd = true;
                String userIdAndTagId = userName + ":" + tag.getId();
                for (String string : listId) {
                    if (!userIdAndTagId.equals(string)) continue;
                    isAdd = false;
                    break;
                }
                if (!isAdd) continue;
                list.add(userIdAndTagId);
                this.saveTag(tag);
            }
            topicNode.setProperty("exo:tagId", Utils.getStringsInList(list));
            if (topicNode.isNew()) {
                topicNode.getSession().save();
            } else {
                topicNode.save();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to add tags", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unTag(String tagId, String userName, String topicPath) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            Node topicNode = (Node)categoryHome.getSession().getItem(topicPath);
            List<String> oldTagsId = Utils.valuesToList(topicNode.getProperty("exo:tagId").getValues());
            String userIdTagId = userName + ":" + tagId;
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuilder builder = new StringBuilder();
            builder.append("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:topic)[@exo:tagId='").append(userIdTagId).append("']");
            Query query = qm.createQuery(builder.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            if (oldTagsId.contains(userIdTagId)) {
                oldTagsId.remove(userIdTagId);
                topicNode.setProperty("exo:tagId", oldTagsId.toArray(new String[oldTagsId.size()]));
                if (topicNode.isNew()) {
                    topicNode.getSession().save();
                } else {
                    topicNode.save();
                }
            }
            Tag tag = this.getTag(tagId);
            ArrayList<String> userTags = new ArrayList<String>();
            userTags.addAll(Arrays.asList(tag.getUserTag()));
            if (iter.getSize() == 1L && userTags.size() > 1) {
                if (userTags.contains(userName)) {
                    userTags.remove(userName);
                    tag.setUserTag(userTags.toArray(new String[userTags.size()]));
                    Node tagNode = this.getTagHome(sProvider).getNode(tagId);
                    long count = tagNode.getProperty("exo:useCount").getLong();
                    if (count > 1L) {
                        tagNode.setProperty("exo:useCount", count - 1L);
                    }
                    tagNode.setProperty("exo:userTag", userTags.toArray(new String[userTags.size()]));
                    tagNode.save();
                }
            } else if (iter.getSize() == 1L && userTags.size() == 1) {
                Node tagHomNode = this.getTagHome(sProvider);
                tagHomNode.getNode(tagId).remove();
                tagHomNode.save();
            } else if (iter.getSize() > 1L) {
                Node tagNode = this.getTagHome(sProvider).getNode(tagId);
                long count = tagNode.getProperty("exo:useCount").getLong();
                if (count > 1L) {
                    tagNode.setProperty("exo:useCount", count - 1L);
                }
                tagNode.save();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to untag.", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tag getTag(String tagId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node tagNode = this.getTagHome(sProvider).getNode(tagId);
            Tag tag = this.getTagNode(tagNode);
            return tag;
        }
        catch (Exception e) {
            Tag tag = null;
            return tag;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getTagNameInTopic(String userAndTopicId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<String> tagNames = new ArrayList<String>();
        try {
            Object node;
            Node tagHome = this.getTagHome(sProvider);
            Node categoryHome = this.getCategoryHome(sProvider);
            QueryManager qm = tagHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer();
            int t = userAndTopicId.indexOf(",");
            String userId = userAndTopicId.substring(0, t);
            String topicId = userAndTopicId.substring(t + 1);
            queryString.append("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:topic)[exo:id='").append(topicId).append("']");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            StringBuilder builder = new StringBuilder();
            StringBuilder builder1 = new StringBuilder();
            if (iter.getSize() > 0L && (node = iter.nextNode()).hasProperty("exo:tagId")) {
                boolean b = true;
                t = 0;
                ArrayList<String> list = new ArrayList<String>();
                for (String string : Utils.valuesToList(node.getProperty("exo:tagId").getValues())) {
                    String[] temp = string.split(":");
                    if (temp.length != 2) continue;
                    if (temp[0].equals(userId)) {
                        if (t == 0) {
                            builder.append("(@exo:id != '").append(temp[1]).append("'");
                        } else {
                            builder.append(" and @exo:id != '").append(temp[1]).append("'");
                        }
                        list.add(temp[1]);
                        t = 1;
                        continue;
                    }
                    if (list.contains(temp[1])) continue;
                    if (b) {
                        builder1.append(" (@exo:id='").append(temp[1]).append("'");
                    } else {
                        builder1.append(" or @exo:id='").append(temp[1]).append("'");
                    }
                    b = false;
                }
                if (!b) {
                    builder1.append(")");
                }
                if (t == 1) {
                    builder.append(")");
                }
            }
            if (builder1.length() == 0) {
                node = tagNames;
                return node;
            }
            queryString = new StringBuffer();
            queryString.append("/jcr:root").append(tagHome.getPath()).append("//element(*,exo:forumTag)");
            boolean isQr = false;
            if (builder.length() > 0) {
                queryString.append("[").append((CharSequence)builder);
                isQr = true;
            }
            if (builder1.length() > 0) {
                if (isQr) {
                    queryString.append(" and ").append((CharSequence)builder1);
                } else {
                    queryString.append("[").append((CharSequence)builder1);
                    isQr = true;
                }
            }
            if (isQr) {
                queryString.append("]");
            }
            queryString.append("order by @exo:useCount descending, @exo:name ascending ");
            query = qm.createQuery(queryString.toString(), "xpath");
            result = query.execute();
            iter = result.getNodes();
            String str = "";
            while (iter.hasNext()) {
                try {
                    Node node2 = iter.nextNode();
                    str = node2.getProperty("exo:name").getString();
                    str = str + Utils.SPACE + "<font color=\"Salmon\">(" + node2.getProperty("exo:useCount").getString() + ")</font>";
                    tagNames.add(str);
                    if (tagNames.size() != 5) continue;
                    break;
                }
                catch (Exception e) {
                }
            }
            ArrayList<String> arrayList = tagNames;
            return arrayList;
        }
        catch (Exception e) {
            ArrayList<String> arrayList = tagNames;
            return arrayList;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllTagName(String keyValue, String userAndTopicId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<String> tagNames = new ArrayList<String>();
        try {
            Node node;
            Node tagHome = this.getTagHome(sProvider);
            Node categoryHome = this.getCategoryHome(sProvider);
            QueryManager qm = tagHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer();
            int t = userAndTopicId.indexOf(",");
            String userId = userAndTopicId.substring(0, t);
            String topicId = userAndTopicId.substring(t + 1);
            queryString.append("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:topic)[exo:id='").append(topicId).append("']");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            StringBuilder builder = new StringBuilder();
            if (iter.getSize() > 0L && (node = iter.nextNode()).hasProperty("exo:tagId")) {
                t = 0;
                for (String string : Utils.valuesToList(node.getProperty("exo:tagId").getValues())) {
                    String[] temp = string.split(":");
                    if (temp.length != 2 || !temp[0].equals(userId)) continue;
                    if (t == 0) {
                        builder.append("@exo:id != '").append(temp[1]).append("'");
                    } else {
                        builder.append(" and @exo:id != '").append(temp[1]).append("'");
                    }
                    t = 1;
                }
            }
            queryString = new StringBuffer();
            queryString.append("/jcr:root").append(tagHome.getPath()).append("//element(*,exo:forumTag)[(jcr:contains(@exo:name, '").append(keyValue).append("*'))");
            if (builder.length() > 0) {
                queryString.append(" and (").append((CharSequence)builder).append(")");
            }
            queryString.append("]order by @exo:useCount descending, @exo:name ascending ");
            query = qm.createQuery(queryString.toString(), "xpath");
            result = query.execute();
            iter = result.getNodes();
            String str = "";
            while (iter.hasNext()) {
                try {
                    Node node2 = iter.nextNode();
                    str = node2.getProperty("exo:name").getString();
                    str = str + Utils.SPACE + "<font color=\"Salmon\">(" + node2.getProperty("exo:useCount").getString() + ")</font>";
                    tagNames.add(str);
                    if (tagNames.size() != 5) continue;
                    break;
                }
                catch (Exception e) {
                }
            }
            ArrayList<String> arrayList = tagNames;
            return arrayList;
        }
        catch (Exception e) {
            ArrayList<String> arrayList = tagNames;
            return arrayList;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Tag> getAllTags() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        try {
            Node tagHome = this.getTagHome(sProvider);
            QueryManager qm = tagHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root" + tagHome.getPath() + "//element(*,exo:forumTag)");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                try {
                    tags.add(this.getTagNode(iter.nextNode()));
                }
                catch (Exception e) {}
            }
            ArrayList<Tag> arrayList = tags;
            return arrayList;
        }
        catch (Exception e) {
            ArrayList<Tag> arrayList = tags;
            return arrayList;
        }
        finally {
            sProvider.close();
        }
    }

    private Tag getTagNode(Node tagNode) throws Exception {
        Tag newTag = new Tag();
        newTag.setId(tagNode.getName());
        newTag.setUserTag(Utils.valuesToArray(tagNode.getProperty("exo:userTag").getValues()));
        newTag.setName(tagNode.getProperty("exo:name").getString());
        newTag.setUseCount(tagNode.getProperty("exo:useCount").getLong());
        return newTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Tag> getMyTagInTopic(String[] tagIds) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        try {
            Node tagHome = this.getTagHome(sProvider);
            for (String id : tagIds) {
                try {
                    tags.add(this.getTagNode(tagHome.getNode(id)));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ArrayList<Tag> arrayList = tags;
            return arrayList;
        }
        catch (Exception e) {
            ArrayList<Tag> arrayList = tags;
            return arrayList;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JCRPageList getTopicByMyTag(String userIdAndtagId, String strOrderBy) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            ForumPageList pagelist;
            Node categoryHome = this.getCategoryHome(sProvider);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuilder builder = new StringBuilder();
            builder.append("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:topic)");
            if (userIdAndtagId.indexOf(":") > 0) {
                builder.append("[@exo:tagId='").append(userIdAndtagId).append("']");
            } else {
                builder.append("[jcr:contains(@exo:tagId,'").append(userIdAndtagId).append("')]");
            }
            builder.append(" order by @exo:isSticky descending");
            if (Utils.isEmpty(strOrderBy)) {
                builder.append(", @exo:lastPostDate descending");
            } else {
                builder.append(", @exo:").append(strOrderBy);
                if (strOrderBy.indexOf("lastPostDate") < 0) {
                    builder.append(", @exo:lastPostDate descending");
                }
            }
            String pathQuery = builder.toString();
            Query query = qm.createQuery(pathQuery, "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ForumPageList forumPageList = pagelist = new ForumPageList(iter, 10, pathQuery, true);
            return forumPageList;
        }
        catch (Exception e) {
            JCRPageList jCRPageList = null;
            return jCRPageList;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveTag(Tag newTag) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node newTagNode;
            Node tagHome = this.getTagHome(sProvider);
            boolean isNew = false;
            try {
                newTagNode = tagHome.getNode(newTag.getId());
            }
            catch (PathNotFoundException e) {
                isNew = true;
                String id = Utils.TAG + newTag.getName();
                newTagNode = tagHome.addNode(id, "exo:forumTag");
                newTagNode.setProperty("exo:id", id);
            }
            if (isNew) {
                newTagNode.setProperty("exo:userTag", newTag.getUserTag());
                newTagNode.setProperty("exo:name", newTag.getName());
                newTagNode.setProperty("exo:useCount", 1L);
            } else {
                List<String> userTags = Utils.valuesToList(newTagNode.getProperty("exo:userTag").getValues());
                if (!userTags.contains(newTag.getUserTag()[0])) {
                    userTags.add(newTag.getUserTag()[0]);
                    newTagNode.setProperty("exo:userTag", userTags.toArray(new String[userTags.size()]));
                }
                long count = newTagNode.getProperty("exo:useCount").getLong();
                newTagNode.setProperty("exo:useCount", count + 1L);
            }
            if (tagHome.isNew()) {
                tagHome.getSession().save();
            } else {
                tagHome.save();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to save tag.", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JCRPageList getPageListUserProfile() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            ForumPageList pageList;
            Node userProfileNode = this.getUserProfileHome(sProvider);
            NodeIterator iterator = userProfileNode.getNodes();
            ForumPageList forumPageList = pageList = new ForumPageList(iterator, 10, userProfileNode.getPath(), false);
            return forumPageList;
        }
        catch (Exception e) {
            JCRPageList jCRPageList = null;
            return jCRPageList;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JCRPageList searchUserProfile(String userSearch) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            ForumPageList pagelist;
            Node userProfileHome = this.getUserProfileHome(sProvider);
            QueryManager qm = userProfileHome.getSession().getWorkspace().getQueryManager();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(userProfileHome.getPath()).append("/element(*,").append(Utils.USER_PROFILES_TYPE).append(")").append("[(jcr:contains(., '").append(userSearch).append("'))]");
            Query query = qm.createQuery(stringBuffer.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ForumPageList forumPageList = pagelist = new ForumPageList(iter, 10, stringBuffer.toString(), true);
            return forumPageList;
        }
        catch (Exception e) {
            JCRPageList jCRPageList = null;
            return jCRPageList;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserProfile getDefaultUserProfile(String userName, String ip) throws Exception {
        UserProfile userProfile = new UserProfile();
        if (userName == null || userName.length() <= 0) {
            return userProfile;
        }
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            String[] array;
            String str;
            Value[] values;
            Node profileNode = this.getUserProfileHome(sProvider).getNode(userName);
            userProfile.setUserId(userName);
            if (this.isAdminRole(userName)) {
                userProfile.setUserRole(0L);
            } else {
                userProfile.setUserRole(profileNode.getProperty("exo:userRole").getLong());
            }
            userProfile.setModerateForums(Utils.valuesToArray(profileNode.getProperty("exo:moderateForums").getValues()));
            try {
                userProfile.setModerateCategory(Utils.valuesToArray(profileNode.getProperty("exo:moderateCategory").getValues()));
            }
            catch (Exception e) {
                userProfile.setModerateCategory(new String[0]);
            }
            userProfile.setNewMessage(profileNode.getProperty("exo:newMessage").getLong());
            userProfile.setTimeZone(profileNode.getProperty("exo:timeZone").getDouble());
            userProfile.setShortDateFormat(profileNode.getProperty("exo:shortDateformat").getString());
            userProfile.setLongDateFormat(profileNode.getProperty("exo:longDateformat").getString());
            userProfile.setTimeFormat(profileNode.getProperty("exo:timeFormat").getString());
            userProfile.setMaxPostInPage(profileNode.getProperty("exo:maxPost").getLong());
            userProfile.setMaxTopicInPage(profileNode.getProperty("exo:maxTopic").getLong());
            userProfile.setIsShowForumJump(profileNode.getProperty("exo:isShowForumJump").getBoolean());
            userProfile.setIsAutoWatchMyTopics(profileNode.getProperty("exo:isAutoWatchMyTopics").getBoolean());
            userProfile.setIsAutoWatchTopicIPost(profileNode.getProperty("exo:isAutoWatchTopicIPost").getBoolean());
            try {
                userProfile.setLastReadPostOfForum(Utils.valuesToArray(profileNode.getProperty("exo:lastReadPostOfForum").getValues()));
            }
            catch (Exception e) {
                userProfile.setLastReadPostOfForum(new String[0]);
            }
            try {
                userProfile.setLastReadPostOfTopic(Utils.valuesToArray(profileNode.getProperty("exo:lastReadPostOfTopic").getValues()));
            }
            catch (Exception e) {
                userProfile.setLastReadPostOfTopic(new String[0]);
            }
            userProfile.setIsBanned(profileNode.getProperty("exo:isBanned").getBoolean());
            if (profileNode.hasProperty("exo:collapCategories")) {
                userProfile.setCollapCategories(Utils.valuesToArray(profileNode.getProperty("exo:collapCategories").getValues()));
            }
            userProfile.setEmail(profileNode.getProperty("exo:email").getString());
            for (Value vl : values = profileNode.getProperty("exo:readTopic").getValues()) {
                str = vl.getString();
                if (str.indexOf(":") <= 0) continue;
                array = str.split(":");
                userProfile.setLastTimeAccessTopic(array[0], Long.parseLong(array[1]));
            }
            for (Value vl : values = profileNode.getProperty("exo:readForum").getValues()) {
                str = vl.getString();
                if (str.indexOf(":") <= 0) continue;
                array = str.split(":");
                userProfile.setLastTimeAccessForum(array[0], Long.parseLong(array[1]));
            }
            if (userProfile.getIsBanned()) {
                if (profileNode.hasProperty("exo:banUntil")) {
                    userProfile.setBanUntil(profileNode.getProperty("exo:banUntil").getLong());
                    if (userProfile.getBanUntil() <= this.getGreenwichMeanTime().getTimeInMillis()) {
                        profileNode.setProperty("exo:isBanned", false);
                        profileNode.save();
                        userProfile.setIsBanned(false);
                    }
                }
            } else if (ip != null) {
                userProfile.setIsBanned(this.isBanIp(ip));
            }
        }
        finally {
            sProvider.close();
        }
        return userProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserProfile updateUserProfileSetting(UserProfile userProfile) throws Exception {
        if (userProfile.getIsBanned()) {
            SessionProvider sProvider = SessionProvider.createSystemProvider();
            try {
                Node profileNode = this.getUserProfileHome(sProvider).getNode(userProfile.getUserId());
                if (profileNode.hasProperty("exo:banUntil")) {
                    userProfile.setBanUntil(profileNode.getProperty("exo:banUntil").getLong());
                    if (userProfile.getBanUntil() <= this.getGreenwichMeanTime().getTimeInMillis()) {
                        profileNode.setProperty("exo:isBanned", false);
                        profileNode.save();
                        userProfile.setIsBanned(false);
                    }
                }
            }
            finally {
                sProvider.close();
            }
        }
        return userProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getScreenName(String userName) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            String string = this.getScreenName(sProvider, userName);
            return string;
        }
        catch (Exception e) {
            String string = userName;
            return string;
        }
        finally {
            sProvider.close();
        }
    }

    private String getScreenName(SessionProvider sProvider, String userName) throws Exception {
        String userTemp = userName;
        try {
            Node userProfile = this.getUserProfileNode(this.getUserProfileHome(sProvider), userName);
            PropertyReader reader = new PropertyReader(userProfile);
            userName = reader.string("exo:screenName", reader.string("exo:fullName", userName));
        }
        catch (Exception e) {
            log.debug((Object)("Failed to get scrennName for user " + userName), (Throwable)e);
        }
        return userTemp.contains(Utils.DELETED) ? "<s>" + (userName.contains(Utils.DELETED) ? userName.substring(0, userName.indexOf(Utils.DELETED)) : userName) + "</s>" : userName;
    }

    private boolean isBanIp(String ip) throws Exception {
        return this.getBanList().contains(ip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserProfile getUserSettingProfile(String userName) throws Exception {
        UserProfile userProfile = new UserProfile();
        if (userName == null || userName.length() <= 0) {
            return userProfile;
        }
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node profileNode = this.getUserProfileHome(sProvider).getNode(userName);
            userProfile.setUserId(userName);
            userProfile.setUserTitle(profileNode.getProperty("exo:userTitle").getString());
            try {
                userProfile.setScreenName(profileNode.getProperty("exo:screenName").getString());
            }
            catch (Exception e) {
                userProfile.setScreenName(userName);
            }
            userProfile.setSignature(profileNode.getProperty("exo:signature").getString());
            userProfile.setIsDisplaySignature(profileNode.getProperty("exo:isDisplaySignature").getBoolean());
            userProfile.setIsDisplayAvatar(profileNode.getProperty("exo:isDisplayAvatar").getBoolean());
            userProfile.setIsAutoWatchMyTopics(profileNode.getProperty("exo:isAutoWatchMyTopics").getBoolean());
            userProfile.setIsAutoWatchTopicIPost(profileNode.getProperty("exo:isAutoWatchTopicIPost").getBoolean());
            userProfile.setUserRole(profileNode.getProperty("exo:userRole").getLong());
            userProfile.setTimeZone(profileNode.getProperty("exo:timeZone").getDouble());
            userProfile.setShortDateFormat(profileNode.getProperty("exo:shortDateformat").getString());
            userProfile.setLongDateFormat(profileNode.getProperty("exo:longDateformat").getString());
            userProfile.setTimeFormat(profileNode.getProperty("exo:timeFormat").getString());
            userProfile.setMaxPostInPage(profileNode.getProperty("exo:maxPost").getLong());
            userProfile.setMaxTopicInPage(profileNode.getProperty("exo:maxTopic").getLong());
            userProfile.setIsShowForumJump(profileNode.getProperty("exo:isShowForumJump").getBoolean());
        }
        catch (Exception e) {
            userProfile.setUserId(userName);
            userProfile.setUserTitle(Utils.USER);
            userProfile.setUserRole(2L);
            if (this.isAdminRole(userName)) {
                userProfile.setUserRole(0L);
                userProfile.setUserTitle(Utils.ADMIN);
                this.saveUserProfile(userProfile, false, false);
            }
        }
        finally {
            sProvider.close();
        }
        return userProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveUserSettingProfile(UserProfile userProfile) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node profileNode = this.getUserProfileHome(sProvider).getNode(userProfile.getUserId());
        try {
            profileNode.setProperty("exo:userTitle", userProfile.getUserTitle());
            profileNode.setProperty("exo:screenName", userProfile.getScreenName());
            profileNode.setProperty("exo:signature", userProfile.getSignature());
            profileNode.setProperty("exo:isDisplaySignature", userProfile.getIsDisplaySignature());
            profileNode.setProperty("exo:isDisplayAvatar", userProfile.getIsDisplayAvatar());
            profileNode.setProperty("exo:userRole", userProfile.getUserRole().longValue());
            profileNode.setProperty("exo:timeZone", userProfile.getTimeZone());
            profileNode.setProperty("exo:shortDateformat", userProfile.getShortDateFormat());
            profileNode.setProperty("exo:longDateformat", userProfile.getLongDateFormat());
            profileNode.setProperty("exo:timeFormat", userProfile.getTimeFormat());
            profileNode.setProperty("exo:maxPost", userProfile.getMaxPostInPage().longValue());
            profileNode.setProperty("exo:maxTopic", userProfile.getMaxTopicInPage().longValue());
            profileNode.setProperty("exo:isShowForumJump", userProfile.getIsShowForumJump());
            profileNode.setProperty("exo:isAutoWatchMyTopics", userProfile.getIsAutoWatchMyTopics());
            profileNode.setProperty("exo:isAutoWatchTopicIPost", userProfile.getIsAutoWatchTopicIPost());
            profileNode.save();
        }
        catch (Exception e) {
            log.error((Object)"Failed to save setting profile.", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserProfile getLastPostIdRead(UserProfile userProfile, String isOfForum) throws Exception {
        block15: {
            SessionProvider sProvider = SessionProvider.createSystemProvider();
            Node profileNode = this.getUserProfileHome(sProvider).getNode(userProfile.getUserId());
            try {
                if (isOfForum.equals("true")) {
                    try {
                        userProfile.setLastReadPostOfForum(Utils.valuesToArray(profileNode.getProperty("exo:lastReadPostOfForum").getValues()));
                    }
                    catch (Exception e) {
                        userProfile.setLastReadPostOfForum(new String[0]);
                    }
                    break block15;
                }
                if (isOfForum.equals("false")) {
                    try {
                        userProfile.setLastReadPostOfTopic(Utils.valuesToArray(profileNode.getProperty("exo:lastReadPostOfTopic").getValues()));
                    }
                    catch (Exception e) {
                        userProfile.setLastReadPostOfTopic(new String[0]);
                    }
                    break block15;
                }
                try {
                    userProfile.setLastReadPostOfForum(Utils.valuesToArray(profileNode.getProperty("exo:lastReadPostOfForum").getValues()));
                }
                catch (Exception e) {
                    userProfile.setLastReadPostOfForum(new String[0]);
                }
                try {
                    userProfile.setLastReadPostOfTopic(Utils.valuesToArray(profileNode.getProperty("exo:lastReadPostOfTopic").getValues()));
                }
                catch (Exception e) {
                    userProfile.setLastReadPostOfTopic(new String[0]);
                }
            }
            catch (Exception e) {
            }
            finally {
                sProvider.close();
            }
        }
        return userProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveLastPostIdRead(String userId, String[] lastReadPostOfForum, String[] lastReadPostOfTopic) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node profileHome = this.getUserProfileHome(sProvider);
        try {
            Node profileNode = profileHome.getNode(userId);
            profileNode.setProperty("exo:lastReadPostOfForum", lastReadPostOfForum);
            profileNode.setProperty("exo:lastReadPostOfTopic", lastReadPostOfTopic);
            profileHome.save();
        }
        catch (Exception e) {
            log.error((Object)"Failed to save last post id read.", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getUserModerator(String userName, boolean isModeCate) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node userProfileNode = this.getUserProfileHome(sProvider);
        ArrayList<String> list = new ArrayList<String>();
        try {
            Node profileNode = userProfileNode.getNode(userName);
            if (isModeCate) {
                try {
                    list.addAll(Utils.valuesToList(profileNode.getProperty("exo:moderateCategory").getValues()));
                }
                catch (Exception e) {}
            } else {
                list.addAll(Utils.valuesToList(profileNode.getProperty("exo:moderateForums").getValues()));
            }
        }
        catch (Exception e) {
        }
        finally {
            sProvider.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveUserModerator(String userName, List<String> ids, boolean isModeCate) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node userProfileNode = this.getUserProfileHome(sProvider);
        try {
            Node profileNode = userProfileNode.getNode(userName);
            if (isModeCate) {
                profileNode.setProperty("exo:moderateCategory", Utils.getStringsInList(ids));
            } else {
                profileNode.setProperty("exo:moderateForums", Utils.getStringsInList(ids));
            }
            profileNode.save();
        }
        catch (Exception e) {
        }
        finally {
            sProvider.close();
        }
    }

    private Node getUserProfileNode(Node profileHome, String userName) throws Exception {
        try {
            return profileHome.getNode(userName);
        }
        catch (PathNotFoundException e) {
            return profileHome.getNode(Utils.USER_PROFILE_DELETED).getNode(userName);
        }
        catch (Exception e) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserProfile getUserInfo(String userName) throws Exception {
        UserProfile userProfile = new UserProfile();
        if (userName == null || userName.length() <= 0) {
            return userProfile;
        }
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node userProfileNode = this.getUserProfileHome(sProvider);
        try {
            Node newProfileNode = this.getUserProfileNode(userProfileNode, userName);
            PropertyReader reader = new PropertyReader(newProfileNode);
            userProfile.setUserId(userName);
            userProfile.setScreenName(reader.string("exo:screenName", userName));
            userProfile.setFullName(reader.string("exo:fullName"));
            userProfile.setFirstName(reader.string("exo:firstName"));
            userProfile.setLastName(reader.string("exo:lastName"));
            userProfile.setEmail(reader.string("exo:email"));
            if (this.isAdminRole(userName)) {
                userProfile.setUserRole(0L);
            } else {
                userProfile.setUserRole(reader.l("exo:userRole"));
            }
            userProfile.setUserTitle(reader.string("exo:userTitle", ""));
            userProfile.setSignature(reader.string("exo:signature"));
            userProfile.setTotalPost(reader.l("exo:totalPost"));
            userProfile.setTotalTopic(reader.l("exo:totalTopic"));
            userProfile.setBookmark(reader.strings("exo:bookmark"));
            userProfile.setLastLoginDate(reader.date("exo:lastLoginDate"));
            userProfile.setJoinedDate(reader.date("exo:joinedDate"));
            userProfile.setLastPostDate(reader.date("exo:lastPostDate"));
            userProfile.setIsDisplaySignature(reader.bool("exo:isDisplaySignature"));
            userProfile.setIsDisplayAvatar(reader.bool("exo:isDisplayAvatar"));
        }
        catch (PathNotFoundException e) {
            userProfile.setUserId(userName);
            userProfile.setUserTitle(Utils.USER);
            userProfile.setUserRole(2L);
            if (this.isAdminRole(userName)) {
                userProfile.setUserRole(0L);
                userProfile.setUserTitle(Utils.ADMIN);
                this.saveUserProfile(userProfile, false, false);
            }
        }
        finally {
            sProvider.close();
        }
        return userProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UserProfile> getQuickProfiles(List<String> userList) throws Exception {
        ArrayList<UserProfile> profiles = new ArrayList<UserProfile>();
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node userProfileHome = this.getUserProfileHome(sProvider);
            for (String userName : userList) {
                UserProfile userProfile = new UserProfile();
                PropertyReader reader = new PropertyReader(this.getUserProfileNode(userProfileHome, userName));
                userProfile.setUserId(userName);
                userProfile.setUserRole(userName.contains(Utils.DELETED) ? 4L : reader.l("exo:userRole", 2L));
                userProfile.setUserTitle(reader.string("exo:userTitle", ""));
                userProfile.setScreenName(reader.string("exo:screenName", userName));
                userProfile.setJoinedDate(reader.date("exo:joinedDate", new Date()));
                userProfile.setIsDisplayAvatar(reader.bool("exo:isDisplayAvatar", false));
                userProfile.setTotalPost(reader.l("exo:totalPost"));
                if (userProfile.getTotalPost() > 0L) {
                    userProfile.setLastPostDate(reader.date("exo:lastPostDate"));
                }
                userProfile.setLastLoginDate(reader.date("exo:lastLoginDate"));
                userProfile.setIsDisplaySignature(reader.bool("exo:isDisplaySignature", false));
                if (userProfile.getIsDisplaySignature()) {
                    userProfile.setSignature(reader.string("exo:signature", ""));
                }
                profiles.add(userProfile);
            }
        }
        catch (Exception e) {
            log.trace((Object)("\nUser Name must exist: " + e.getMessage() + "\n" + e.getCause()));
        }
        finally {
            sProvider.close();
        }
        return profiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserProfile getQuickProfile(String userName) throws Exception {
        UserProfile userProfile;
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node userProfileHome = this.getUserProfileHome(sProvider);
            userProfile = new UserProfile();
            PropertyReader reader = new PropertyReader(this.getUserProfileNode(userProfileHome, userName));
            userProfile.setUserId(userName);
            userProfile.setUserRole(userName.contains(Utils.DELETED) ? 4L : reader.l("exo:userRole", 2L));
            userProfile.setUserTitle(reader.string("exo:userTitle", ""));
            userProfile.setScreenName(reader.string("exo:screenName", userName));
            userProfile.setJoinedDate(reader.date("exo:joinedDate", new Date()));
            userProfile.setIsDisplayAvatar(reader.bool("exo:isDisplayAvatar", false));
            userProfile.setTotalPost(reader.l("exo:totalPost"));
            if (userProfile.getTotalPost() > 0L) {
                userProfile.setLastPostDate(reader.date("exo:lastPostDate"));
            }
            userProfile.setLastLoginDate(reader.date("exo:lastLoginDate"));
            userProfile.setIsDisplaySignature(reader.bool("exo:isDisplaySignature", false));
            if (userProfile.getIsDisplaySignature()) {
                userProfile.setSignature(reader.string("exo:signature", ""));
            }
        }
        finally {
            sProvider.close();
        }
        return userProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserProfile getUserInformations(UserProfile userProfile) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node userProfileHome = this.getUserProfileHome(sProvider);
            Node profileNode = this.getUserProfileNode(userProfileHome, userProfile.getUserId());
            userProfile.setFirstName(profileNode.getProperty("exo:firstName").getString());
            userProfile.setLastName(profileNode.getProperty("exo:lastName").getString());
            userProfile.setFullName(profileNode.getProperty("exo:fullName").getString());
            userProfile.setEmail(profileNode.getProperty("exo:email").getString());
        }
        finally {
            sProvider.close();
        }
        return userProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveUserProfile(UserProfile newUserProfile, boolean isOption, boolean isBan) throws Exception {
        String userName = newUserProfile.getUserId();
        if (userName == null || userName.length() <= 0) {
            return;
        }
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node userProfileHome = this.getUserProfileHome(sProvider);
        try {
            Node newProfileNode;
            long role;
            block17: {
                role = 2L;
                try {
                    newProfileNode = userProfileHome.getNode(userName);
                    if (userProfileHome.hasProperty("exo:userRole")) {
                        role = userProfileHome.getProperty("exo:userRole").getLong();
                    }
                }
                catch (PathNotFoundException e) {
                    newProfileNode = userProfileHome.addNode(userName, Utils.USER_PROFILES_TYPE);
                    newProfileNode.setProperty("exo:userId", userName);
                    newProfileNode.setProperty("exo:totalPost", 0L);
                    newProfileNode.setProperty("exo:totalTopic", 0L);
                    newProfileNode.setProperty("exo:readTopic", new String[0]);
                    newProfileNode.setProperty("exo:readForum", new String[0]);
                    if (newUserProfile.getUserRole() >= 2L) {
                        newUserProfile.setUserRole(2L);
                    }
                    if (!this.isAdminRole(userName)) break block17;
                    newUserProfile.setUserTitle(Utils.ADMIN);
                }
            }
            newProfileNode.setProperty("exo:userRole", newUserProfile.getUserRole().longValue());
            newProfileNode.setProperty("exo:userTitle", newUserProfile.getUserTitle());
            newProfileNode.setProperty("exo:screenName", newUserProfile.getScreenName());
            newProfileNode.setProperty("exo:signature", newUserProfile.getSignature());
            newProfileNode.setProperty("exo:isAutoWatchMyTopics", newUserProfile.getIsAutoWatchMyTopics());
            newProfileNode.setProperty("exo:isAutoWatchTopicIPost", newUserProfile.getIsAutoWatchTopicIPost());
            newProfileNode.setProperty("exo:moderateCategory", newUserProfile.getModerateCategory());
            Calendar calendar = this.getGreenwichMeanTime();
            if (newUserProfile.getLastLoginDate() != null) {
                calendar.setTime(newUserProfile.getLastLoginDate());
            }
            newProfileNode.setProperty("exo:lastLoginDate", calendar);
            newProfileNode.setProperty("exo:isDisplaySignature", newUserProfile.getIsDisplaySignature());
            newProfileNode.setProperty("exo:isDisplayAvatar", newUserProfile.getIsDisplayAvatar());
            if (isOption) {
                newProfileNode.setProperty("exo:timeZone", newUserProfile.getTimeZone());
                newProfileNode.setProperty("exo:shortDateformat", newUserProfile.getShortDateFormat());
                newProfileNode.setProperty("exo:longDateformat", newUserProfile.getLongDateFormat());
                newProfileNode.setProperty("exo:timeFormat", newUserProfile.getTimeFormat());
                newProfileNode.setProperty("exo:maxPost", newUserProfile.getMaxPostInPage().longValue());
                newProfileNode.setProperty("exo:maxTopic", newUserProfile.getMaxTopicInPage().longValue());
                newProfileNode.setProperty("exo:isShowForumJump", newUserProfile.getIsShowForumJump());
            }
            if (isBan) {
                if (newProfileNode.hasProperty("exo:isBanned")) {
                    if (!newProfileNode.getProperty("exo:isBanned").getBoolean() && newUserProfile.getIsBanned()) {
                        newProfileNode.setProperty("exo:createdDateBan", this.getGreenwichMeanTime());
                    }
                } else {
                    newProfileNode.setProperty("exo:createdDateBan", this.getGreenwichMeanTime());
                }
                newProfileNode.setProperty("exo:isBanned", newUserProfile.getIsBanned());
                newProfileNode.setProperty("exo:banUntil", newUserProfile.getBanUntil().longValue());
                newProfileNode.setProperty("exo:banReason", newUserProfile.getBanReason());
                newProfileNode.setProperty("exo:banCounter", "" + newUserProfile.getBanCounter());
                newProfileNode.setProperty("exo:banReasonSummary", newUserProfile.getBanReasonSummary());
            }
            if (userProfileHome.isNew()) {
                userProfileHome.getSession().save();
            } else {
                userProfileHome.save();
            }
            if (role >= 2L && newUserProfile.getUserRole() < 2L && !this.isAdminRole(userName)) {
                this.getTotalJobWaitingForModerator(userProfileHome.getSession(), userName);
            }
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserProfile getUserProfileManagement(String userName) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node userProfileNode = this.getUserProfileNode(this.getUserProfileHome(sProvider), userName);
            UserProfile userProfile = this.getUserProfile(userProfileNode);
            return userProfile;
        }
        catch (Exception e) {
            UserProfile userProfile = null;
            return userProfile;
        }
        finally {
            sProvider.close();
        }
    }

    private UserProfile getUserProfile(Node userProfileNode) throws Exception {
        UserProfile userProfile = new UserProfile();
        userProfile.setUserId(userProfileNode.getName());
        userProfile.setUserTitle(userProfileNode.getProperty("exo:userTitle").getString());
        try {
            userProfile.setScreenName(userProfileNode.getProperty("exo:screenName").getString());
        }
        catch (Exception e) {
            userProfile.setScreenName(userProfileNode.getName());
        }
        userProfile.setFullName(userProfileNode.getProperty("exo:fullName").getString());
        userProfile.setFirstName(userProfileNode.getProperty("exo:firstName").getString());
        userProfile.setLastName(userProfileNode.getProperty("exo:lastName").getString());
        userProfile.setEmail(userProfileNode.getProperty("exo:email").getString());
        userProfile.setUserRole(userProfileNode.getProperty("exo:userRole").getLong());
        userProfile.setSignature(userProfileNode.getProperty("exo:signature").getString());
        userProfile.setTotalPost(userProfileNode.getProperty("exo:totalPost").getLong());
        userProfile.setTotalTopic(userProfileNode.getProperty("exo:totalTopic").getLong());
        userProfile.setModerateForums(Utils.valuesToArray(userProfileNode.getProperty("exo:moderateForums").getValues()));
        try {
            userProfile.setModerateCategory(Utils.valuesToArray(userProfileNode.getProperty("exo:moderateCategory").getValues()));
        }
        catch (Exception e) {
            userProfile.setModerateCategory(new String[0]);
        }
        if (userProfileNode.hasProperty("exo:lastLoginDate")) {
            userProfile.setLastLoginDate(userProfileNode.getProperty("exo:lastLoginDate").getDate().getTime());
        }
        if (userProfileNode.hasProperty("exo:joinedDate")) {
            userProfile.setJoinedDate(userProfileNode.getProperty("exo:joinedDate").getDate().getTime());
        }
        if (userProfileNode.hasProperty("exo:lastPostDate")) {
            userProfile.setLastPostDate(userProfileNode.getProperty("exo:lastPostDate").getDate().getTime());
        }
        userProfile.setIsDisplaySignature(userProfileNode.getProperty("exo:isDisplaySignature").getBoolean());
        userProfile.setIsDisplayAvatar(userProfileNode.getProperty("exo:isDisplayAvatar").getBoolean());
        userProfile.setNewMessage(userProfileNode.getProperty("exo:newMessage").getLong());
        userProfile.setTimeZone(userProfileNode.getProperty("exo:timeZone").getDouble());
        userProfile.setShortDateFormat(userProfileNode.getProperty("exo:shortDateformat").getString());
        userProfile.setLongDateFormat(userProfileNode.getProperty("exo:longDateformat").getString());
        userProfile.setTimeFormat(userProfileNode.getProperty("exo:timeFormat").getString());
        userProfile.setMaxPostInPage(userProfileNode.getProperty("exo:maxPost").getLong());
        userProfile.setMaxTopicInPage(userProfileNode.getProperty("exo:maxTopic").getLong());
        userProfile.setIsShowForumJump(userProfileNode.getProperty("exo:isShowForumJump").getBoolean());
        userProfile.setIsBanned(userProfileNode.getProperty("exo:isBanned").getBoolean());
        if (userProfile.getIsBanned() && userProfileNode.hasProperty("exo:banUntil")) {
            userProfile.setBanUntil(userProfileNode.getProperty("exo:banUntil").getLong());
            if (userProfile.getBanUntil() <= this.getGreenwichMeanTime().getTimeInMillis()) {
                userProfileNode.setProperty("exo:isBanned", false);
                userProfileNode.save();
                userProfile.setIsBanned(false);
            }
        }
        if (userProfileNode.hasProperty("exo:banReason")) {
            userProfile.setBanReason(userProfileNode.getProperty("exo:banReason").getString());
        }
        if (userProfileNode.hasProperty("exo:banCounter")) {
            userProfile.setBanCounter(Integer.parseInt(userProfileNode.getProperty("exo:banCounter").getString()));
        }
        if (userProfileNode.hasProperty("exo:banReasonSummary")) {
            userProfile.setBanReasonSummary(Utils.valuesToArray(userProfileNode.getProperty("exo:banReasonSummary").getValues()));
        }
        if (userProfileNode.hasProperty("exo:createdDateBan")) {
            userProfile.setCreatedDateBan(userProfileNode.getProperty("exo:createdDateBan").getDate().getTime());
        }
        return userProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveUserBookmark(String userName, String bookMark, boolean isNew) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node userProfileNode = this.getUserProfileHome(sProvider);
        try {
            Node newProfileNode = userProfileNode.getNode(userName);
            if (newProfileNode.hasProperty("exo:bookmark")) {
                List<String> listOld = Utils.valuesToList(newProfileNode.getProperty("exo:bookmark").getValues());
                ArrayList<String> listNew = new ArrayList<String>();
                String pathNew = bookMark.substring(bookMark.lastIndexOf("//") + 1);
                String pathOld = "";
                boolean isAdd = true;
                for (String string : listOld) {
                    pathOld = string.substring(string.lastIndexOf("//") + 1);
                    if (pathNew.equals(pathOld)) {
                        if (isNew) {
                            listNew.add(bookMark);
                        }
                        isAdd = false;
                        continue;
                    }
                    listNew.add(string);
                }
                if (isAdd) {
                    listNew.add(bookMark);
                }
                String[] bookMarks = listNew.toArray(new String[listNew.size()]);
                newProfileNode.setProperty("exo:bookmark", bookMarks);
                if (newProfileNode.isNew()) {
                    newProfileNode.getSession().save();
                } else {
                    newProfileNode.save();
                }
            } else {
                newProfileNode.setProperty("exo:bookmark", new String[]{bookMark});
                if (newProfileNode.isNew()) {
                    newProfileNode.getSession().save();
                } else {
                    newProfileNode.save();
                }
            }
        }
        catch (PathNotFoundException e) {
            Node newProfileNode = userProfileNode.addNode(userName, Utils.USER_PROFILES_TYPE);
            newProfileNode.setProperty("exo:userId", userName);
            newProfileNode.setProperty("exo:userTitle", Utils.USER);
            if (this.isAdminRole(userName)) {
                newProfileNode.setProperty("exo:userTitle", Utils.ADMIN);
            }
            newProfileNode.setProperty("exo:userRole", 2L);
            newProfileNode.setProperty("exo:bookmark", new String[]{bookMark});
            if (newProfileNode.isNew()) {
                newProfileNode.getSession().save();
            } else {
                newProfileNode.save();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to save UserBookmark.", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveCollapsedCategories(String userName, String categoryId, boolean isAdd) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node userProfileHome = this.getUserProfileHome(sProvider);
        try {
            Node newProfileNode = userProfileHome.getNode(userName);
            if (newProfileNode.hasProperty("exo:collapCategories")) {
                List<String> listCategoryId = Utils.valuesToList(newProfileNode.getProperty("exo:collapCategories").getValues());
                if (listCategoryId.contains(categoryId)) {
                    if (!isAdd) {
                        listCategoryId.remove(categoryId);
                        isAdd = true;
                    }
                } else if (isAdd) {
                    listCategoryId.add(categoryId);
                }
                if (isAdd) {
                    String[] categoryIds = listCategoryId.toArray(new String[listCategoryId.size()]);
                    newProfileNode.setProperty("exo:collapCategories", categoryIds);
                    if (newProfileNode.isNew()) {
                        newProfileNode.getSession().save();
                    } else {
                        newProfileNode.save();
                    }
                }
            } else {
                newProfileNode.setProperty("exo:collapCategories", new String[]{categoryId});
                if (newProfileNode.isNew()) {
                    newProfileNode.getSession().save();
                } else {
                    newProfileNode.save();
                }
            }
        }
        catch (PathNotFoundException e) {
            Node newProfileNode = userProfileHome.addNode(userName, Utils.USER_PROFILES_TYPE);
            newProfileNode.setProperty("exo:userId", userName);
            newProfileNode.setProperty("exo:userTitle", Utils.USER);
            if (this.isAdminRole(userName)) {
                newProfileNode.setProperty("exo:userTitle", Utils.ADMIN);
            }
            newProfileNode.setProperty("exo:userRole", 2L);
            newProfileNode.setProperty("exo:collapCategories", new String[]{categoryId});
            if (newProfileNode.isNew()) {
                newProfileNode.getSession().save();
            } else {
                newProfileNode.save();
            }
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveReadMessage(String messageId, String userName, String type) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node userProfileNode = this.getUserProfileHome(sProvider);
        try {
            Node profileNode = userProfileNode.getNode(userName);
            long totalNewMessage = 0L;
            boolean isNew = false;
            try {
                Node messageNode = profileNode.getNode(messageId);
                if (messageNode.hasProperty("exo:isUnread")) {
                    isNew = messageNode.getProperty("exo:isUnread").getBoolean();
                }
                if (isNew) {
                    messageNode.setProperty("exo:isUnread", false);
                }
            }
            catch (PathNotFoundException e) {
                log.error((Object)"Failed to save read massage", (Throwable)e);
            }
            if (type.equals(Utils.RECEIVE_MESSAGE) && isNew && profileNode.hasProperty("exo:newMessage") && (totalNewMessage = profileNode.getProperty("exo:newMessage").getLong()) > 0L) {
                profileNode.setProperty("exo:newMessage", totalNewMessage - 1L);
            }
            if (isNew) {
                if (userProfileNode.isNew()) {
                    userProfileNode.getSession().save();
                } else {
                    userProfileNode.save();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to save read message.");
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JCRPageList getPrivateMessage(String userName, String type) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node userProfileNode = this.getUserProfileHome(sProvider);
        try {
            ForumPageList pagelist;
            Node profileNode = userProfileNode.getNode(userName);
            QueryManager qm = profileNode.getSession().getWorkspace().getQueryManager();
            String pathQuery = "/jcr:root" + profileNode.getPath() + "//element(*,exo:privateMessage)[@exo:type='" + type + "'] order by @exo:receivedDate descending";
            Query query = qm.createQuery(pathQuery, "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ForumPageList forumPageList = pagelist = new ForumPageList(iter, 10, pathQuery, true);
            return forumPageList;
        }
        catch (Exception e) {
            JCRPageList jCRPageList = null;
            return jCRPageList;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNewPrivateMessage(String userName) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node userProfileNode = this.getUserProfileHome(sProvider);
        try {
            Node profileNode = userProfileNode.getNode(userName);
            if (!profileNode.getProperty("exo:isBanned").getBoolean()) {
                long l = profileNode.getProperty("exo:newMessage").getLong();
                return l;
            }
        }
        catch (PathNotFoundException e) {
            long l = -1L;
            return l;
        }
        finally {
            sProvider.close();
        }
        return -1L;
    }

    @Override
    public void savePrivateMessage(ForumPrivateMessage privateMessage) throws Exception {
        String id;
        List<String> userNames;
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node userProfileNode = this.getUserProfileHome(sProvider);
        Node profileNode = null;
        Node profileNodeFirst = null;
        Node messageNode = null;
        String sendTo = privateMessage.getSendTo();
        sendTo = sendTo.replaceAll(";", ",");
        String[] strUserNames = sendTo.split(",");
        try {
            userNames = ForumServiceUtils.getUserPermission(strUserNames);
        }
        catch (Exception e) {
            userNames = Arrays.asList(strUserNames);
        }
        String userNameFirst = privateMessage.getFrom();
        try {
            profileNodeFirst = userProfileNode.getNode(userNameFirst);
        }
        catch (PathNotFoundException e) {
            profileNodeFirst = this.addNodeUserProfile(sProvider, userNameFirst);
        }
        long totalMessage = 0L;
        if (profileNodeFirst != null) {
            id = userNameFirst + IdGenerator.generate();
            messageNode = profileNodeFirst.addNode(id, "exo:privateMessage");
            messageNode.setProperty("exo:from", privateMessage.getFrom());
            messageNode.setProperty("exo:sendTo", privateMessage.getSendTo());
            messageNode.setProperty("exo:name", privateMessage.getName());
            messageNode.setProperty("exo:message", privateMessage.getMessage());
            messageNode.setProperty("exo:receivedDate", this.getGreenwichMeanTime());
            messageNode.setProperty("exo:isUnread", true);
            messageNode.setProperty("exo:type", Utils.RECEIVE_MESSAGE);
        }
        for (String userName : userNames) {
            if (userName.equals(userNameFirst)) continue;
            try {
                profileNode = userProfileNode.getNode(userName);
                totalMessage = profileNode.getProperty("exo:newMessage").getLong() + 1L;
                id = profileNode.getPath() + "/" + userName + IdGenerator.generate();
                userProfileNode.getSession().getWorkspace().copy(messageNode.getPath(), id);
                profileNode.setProperty("exo:newMessage", totalMessage);
            }
            catch (Exception e) {
                profileNode = this.addNodeUserProfile(sProvider, userName);
                id = profileNode.getPath() + "/" + userName + IdGenerator.generate();
                userProfileNode.getSession().getWorkspace().copy(messageNode.getPath(), id);
                profileNode.setProperty("exo:newMessage", 1L);
            }
        }
        privateMessage.setType("PrivateMessage");
        this.sendNotificationMessage(privateMessage);
        if (messageNode != null) {
            messageNode.setProperty("exo:type", Utils.SEND_MESSAGE);
        }
        if (userProfileNode.isNew()) {
            userProfileNode.getSession().save();
        } else {
            userProfileNode.save();
        }
        sProvider.close();
    }

    private Node addNodeUserProfile(SessionProvider sProvider, String userName) throws Exception {
        Node userProfileHome = this.getUserProfileHome(sProvider);
        Node profileNode = userProfileHome.addNode(userName, Utils.USER_PROFILES_TYPE);
        profileNode.setProperty("exo:userId", userName);
        profileNode.setProperty("exo:userTitle", Utils.USER);
        if (this.isAdminRole(userName)) {
            profileNode.setProperty("exo:userRole", 0L);
            profileNode.setProperty("exo:userTitle", Utils.ADMIN);
        }
        profileNode.setProperty("exo:userRole", 2L);
        if (userProfileHome.isNew()) {
            userProfileHome.getSession().save();
        } else {
            userProfileHome.save();
        }
        return profileNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePrivateMessage(String messageId, String userName, String type) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node userProfileNode = this.getUserProfileHome(sProvider);
        try {
            long totalMessage;
            Node profileNode = userProfileNode.getNode(userName);
            Node messageNode = profileNode.getNode(messageId);
            if (type.equals(Utils.RECEIVE_MESSAGE) && messageNode.hasProperty("exo:isUnread") && messageNode.getProperty("exo:isUnread").getBoolean() && (totalMessage = profileNode.getProperty("exo:newMessage").getLong()) > 0L) {
                profileNode.setProperty("exo:newMessage", totalMessage - 1L);
            }
            messageNode.remove();
            profileNode.save();
        }
        catch (PathNotFoundException e) {
            log.error((Object)"Failed to remove private message", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ForumSubscription getForumSubscription(String userId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ForumSubscription forumSubscription = new ForumSubscription();
        try {
            Node subscriptionNode = this.getUserProfileHome(sProvider).getNode(userId + "/" + Utils.FORUM_SUBSCRIOTION + userId);
            if (subscriptionNode.hasProperty("exo:categoryIds")) {
                forumSubscription.setCategoryIds(Utils.valuesToArray(subscriptionNode.getProperty("exo:categoryIds").getValues()));
            }
            if (subscriptionNode.hasProperty("exo:forumIds")) {
                forumSubscription.setForumIds(Utils.valuesToArray(subscriptionNode.getProperty("exo:forumIds").getValues()));
            }
            if (subscriptionNode.hasProperty("exo:topicIds")) {
                forumSubscription.setTopicIds(Utils.valuesToArray(subscriptionNode.getProperty("exo:topicIds").getValues()));
            }
        }
        catch (Exception e) {
        }
        finally {
            sProvider.close();
        }
        return forumSubscription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveForumSubscription(ForumSubscription forumSubscription, String userId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node subscriptionNode;
            Node profileNode = this.getUserProfileHome(sProvider).getNode(userId);
            String id = Utils.FORUM_SUBSCRIOTION + userId;
            try {
                subscriptionNode = profileNode.getNode(id);
            }
            catch (PathNotFoundException e) {
                subscriptionNode = profileNode.addNode(id, "exo:forumSubscription");
            }
            subscriptionNode.setProperty("exo:categoryIds", forumSubscription.getCategoryIds());
            subscriptionNode.setProperty("exo:forumIds", forumSubscription.getForumIds());
            subscriptionNode.setProperty("exo:topicIds", forumSubscription.getTopicIds());
            if (profileNode.isNew()) {
                profileNode.getSession().save();
            } else {
                profileNode.save();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to save forum subscription.", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    private String[] getValueProperty(Node node, String property, String objectId) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (node.hasProperty(property)) {
            list.addAll(Utils.valuesToList(node.getProperty(property).getValues()));
            if (!list.contains(objectId)) {
                list.add(objectId);
            }
        } else {
            list.add(objectId);
        }
        return list.toArray(new String[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ForumStatistic getForumStatistic() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ForumStatistic forumStatistic = new ForumStatistic();
        try {
            Node forumStatisticNode = this.getForumStatisticsNode(sProvider);
            PropertyReader reader = new PropertyReader(forumStatisticNode);
            forumStatistic.setPostCount(reader.l("exo:postCount", 0L));
            forumStatistic.setTopicCount(reader.l("exo:topicCount", 0L));
            forumStatistic.setMembersCount(reader.l("exo:membersCount", 0L));
            forumStatistic.setActiveUsers(reader.l("exo:activeUsers", 0L));
            forumStatistic.setNewMembers(reader.string("exo:newMembers", ""));
            forumStatistic.setMostUsersOnline(reader.string("exo:mostUsersOnline", ""));
        }
        catch (Exception e) {
            log.error((Object)"Failed to load forum statistics", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return forumStatistic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveForumStatistic(ForumStatistic forumStatistic) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumStatisticNode = this.getForumStatisticsNode(sProvider);
            forumStatisticNode.setProperty("exo:postCount", forumStatistic.getPostCount());
            forumStatisticNode.setProperty("exo:topicCount", forumStatistic.getTopicCount());
            forumStatisticNode.setProperty("exo:membersCount", forumStatistic.getMembersCount());
            forumStatisticNode.setProperty("exo:activeUsers", forumStatistic.getActiveUsers());
            forumStatisticNode.setProperty("exo:mostUsersOnline", forumStatistic.getMostUsersOnline());
            if (!Utils.isEmpty(forumStatistic.getNewMembers())) {
                forumStatisticNode.setProperty("exo:newMembers", forumStatistic.getNewMembers());
            }
            if (forumStatisticNode.isNew()) {
                forumStatisticNode.getSession().save();
            } else {
                forumStatisticNode.save();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to save forum statistics", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    @Override
    public Calendar getGreenwichMeanTime() {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setLenient(false);
        int gmtoffset = calendar.get(16) + calendar.get(15);
        calendar.setTimeInMillis(System.currentTimeMillis() - (long)gmtoffset);
        return calendar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObjectNameByPath(String path) throws Exception {
        Post post;
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Object object;
            path = path.indexOf("CategoryHome") < 0 && path.indexOf(Utils.CATEGORY) >= 0 ? this.getCategoryHome(sProvider).getPath() + "/" + path : this.getTagHome(sProvider).getPath() + "/" + path;
            Node myNode = (Node)this.getForumHomeNode(sProvider).getSession().getItem(path);
            if (path.indexOf(Utils.POST) > 0) {
                Post post2 = new Post();
                post2.setId(myNode.getName());
                post2.setPath(path);
                post2.setName(myNode.getProperty("exo:name").getString());
                object = post2;
            } else if (path.indexOf(Utils.TOPIC) > 0) {
                Topic topic = new Topic();
                topic.setId(myNode.getName());
                topic.setPath(path);
                topic.setTopicName(myNode.getProperty("exo:name").getString());
                object = topic;
            } else if (path.indexOf(Utils.FORUM) > 0 && path.lastIndexOf(Utils.FORUM) > path.indexOf(Utils.CATEGORY)) {
                Forum forum = new Forum();
                forum.setId(myNode.getName());
                forum.setPath(path);
                forum.setForumName(myNode.getProperty("exo:name").getString());
                object = forum;
            } else if (path.indexOf(Utils.CATEGORY) > 0) {
                Category category = new Category();
                category.setId(myNode.getName());
                category.setPath(path);
                category.setCategoryName(myNode.getProperty("exo:name").getString());
                object = category;
            } else if (path.indexOf(Utils.TAG) > 0) {
                Tag tag = new Tag();
                tag.setId(myNode.getName());
                tag.setName(myNode.getProperty("exo:name").getString());
                object = tag;
            } else {
                Object var5_6 = null;
                return var5_6;
            }
            post = object;
            return post;
        }
        catch (RepositoryException e) {
            post = null;
            return post;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObjectNameById(String id, String type) throws Exception {
        Object object = null;
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node node = this.getNodeById(sProvider, id, type);
            if (type.equals(Utils.CATEGORY)) {
                Category category = this.getCategory(node);
                object = category;
            } else if (type.equals(Utils.FORUM)) {
                Forum forum = this.getForum(node);
                object = forum;
            } else if (type.equals(Utils.TOPIC)) {
                Topic topic = this.getTopicNode(node);
                object = topic;
            } else {
                Post post = this.getPost(node);
                object = post;
            }
        }
        catch (Exception e) {
            log.error((Object)("Can not get " + type + " by Id: " + id), (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return object;
    }

    private Node getNodeById(SessionProvider sProvider, String id, String type) {
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            if (type.equals(Utils.CATEGORY)) {
                return categoryHome.getNode(id);
            }
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:").append(type).append(")[exo:id='").append(id).append("']");
            Query query = qm.createQuery(stringBuffer.toString(), "xpath");
            QueryResult result = query.execute();
            return result.getNodes().nextNode();
        }
        catch (Exception e) {
            log.error((Object)("Can not get Node by Id: " + id), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ForumLinkData> getAllLink(String strQueryCate, String strQueryForum) throws Exception {
        ArrayList<ForumLinkData> forumLinks = new ArrayList<ForumLinkData>();
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer();
            queryString.append("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:forumCategory)").append(strQueryCate).append(" order by @exo:categoryOrder ascending, @exo:createdDate ascending");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                ForumLinkData linkData = new ForumLinkData();
                Node cateNode = iter.nextNode();
                linkData.setId(cateNode.getName());
                linkData.setName(cateNode.getProperty("exo:name").getString());
                linkData.setType(Utils.CATEGORY);
                linkData.setPath(cateNode.getName());
                forumLinks.add(linkData);
                queryString = new StringBuffer();
                queryString.append("/jcr:root").append(cateNode.getPath()).append("//element(*,exo:forum)").append(strQueryForum).append(" order by @exo:forumOrder ascending,@exo:createdDate ascending");
                query = qm.createQuery(queryString.toString(), "xpath");
                result = query.execute();
                NodeIterator iterForum = result.getNodes();
                while (iterForum.hasNext()) {
                    linkData = new ForumLinkData();
                    Node forumNode = iterForum.nextNode();
                    linkData.setId(forumNode.getName());
                    linkData.setName(forumNode.getProperty("exo:name").getString());
                    linkData.setType(Utils.FORUM);
                    linkData.setPath(cateNode.getName() + "/" + forumNode.getName());
                    if (forumNode.hasProperty("exo:isLock")) {
                        linkData.setIsLock(forumNode.getProperty("exo:isLock").getBoolean());
                    }
                    if (forumNode.hasProperty("exo:isClosed")) {
                        linkData.setIsClosed(forumNode.getProperty("exo:isClosed").getBoolean());
                    }
                    forumLinks.add(linkData);
                }
            }
        }
        finally {
            sProvider.close();
        }
        return forumLinks;
    }

    @Override
    public List<ForumSearch> getQuickSearch(String textQuery, String type_, String pathQuery, String userId, List<String> listCateIds, List<String> listForumIds, List<String> forumIdsOfModerator) throws Exception {
        List<ForumSearch> listSearchEvent = new ArrayList<ForumSearch>();
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            if (pathQuery == null || pathQuery.length() <= 0) {
                pathQuery = categoryHome.getPath();
            }
            textQuery = StringUtils.replace((String)textQuery, (String)"'", (String)"&apos;");
            String[] values = type_.split(",");
            boolean isAdmin = false;
            if (values[0].equals("true")) {
                isAdmin = true;
            }
            String[] types = new String[]{Utils.CATEGORY, Utils.FORUM, Utils.TOPIC, Utils.POST};
            if (!values[1].equals("all")) {
                types = values[1].split("/");
            }
            boolean isAnd = false;
            String searchBy = null;
            ArrayList<String> listOfUser = new ArrayList();
            if (!isAdmin) {
                listOfUser = ForumServiceUtils.getAllGroupAndMembershipOfUser(userId);
                Map<String, List<String>> mapList = this.getCategoryViewer(categoryHome, listOfUser, listCateIds, listForumIds, "@exo:userPrivate");
                listCateIds = mapList.get(Utils.CATEGORY);
                listForumIds = mapList.get(Utils.FORUM);
            }
            for (String type : types) {
                StringBuffer queryString = new StringBuffer();
                queryString.append("/jcr:root").append(pathQuery).append("//element(*,exo:").append(type).append(")");
                queryString.append("[");
                if (type.equals(Utils.CATEGORY)) {
                    if (listCateIds != null && listCateIds.size() > 0) {
                        queryString.append("(");
                        for (int i = 0; i < listCateIds.size(); ++i) {
                            queryString.append("fn:name() = '").append(listCateIds.get(i)).append("'");
                            if (i >= listCateIds.size() - 1) continue;
                            queryString.append(" or ");
                        }
                        queryString.append(") and ");
                    }
                } else if (listForumIds != null && listForumIds.size() > 0) {
                    searchBy = type.equals(Utils.FORUM) ? "fn:name()" : "@exo:path";
                    queryString.append("(");
                    for (int i = 0; i < listForumIds.size(); ++i) {
                        queryString.append(searchBy).append("='").append(listForumIds.get(i)).append("'");
                        if (i >= listForumIds.size() - 1) continue;
                        queryString.append(" or ");
                    }
                    queryString.append(") and ");
                }
                if (textQuery != null && textQuery.length() > 0 && !textQuery.equals("null")) {
                    queryString.append("(jcr:contains(., '").append(textQuery).append("'))");
                    isAnd = true;
                }
                if (!isAdmin) {
                    StringBuilder builder = new StringBuilder();
                    if (forumIdsOfModerator != null && !forumIdsOfModerator.isEmpty()) {
                        for (String string : forumIdsOfModerator) {
                            builder.append(" or (@exo:path='").append(string).append("')");
                        }
                    }
                    if (type.equals(Utils.FORUM)) {
                        if (isAnd) {
                            queryString.append(" and ");
                        }
                        queryString.append("(@exo:isClosed='false'");
                        for (String forumId : forumIdsOfModerator) {
                            queryString.append(" or fn:name()='").append(forumId).append("'");
                        }
                        queryString.append(")");
                    } else if (type.equals(Utils.TOPIC)) {
                        if (isAnd) {
                            queryString.append(" and ");
                        }
                        queryString.append("((@exo:isClosed='false' and @exo:isWaiting='false' and @exo:isApproved='true' and @exo:isActive='true' and @exo:isActiveByForum='true')");
                        if (builder.length() > 0) {
                            queryString.append((CharSequence)builder);
                        }
                        queryString.append(")");
                        String s = Utils.propertyMatchAny("@exo:canView", listOfUser);
                        if (s != null && s.length() > 0) {
                            if (isAnd) {
                                queryString.append(" and ");
                            }
                            queryString.append(s);
                        }
                    } else if (type.equals(Utils.POST)) {
                        if (isAnd) {
                            queryString.append(" and ");
                        }
                        queryString.append("((@exo:isApproved='true' and @exo:isHidden='false' and @exo:isActiveByTopic='true')");
                        if (builder.length() > 0) {
                            queryString.append((CharSequence)builder);
                        }
                        queryString.append(") and (@exo:userPrivate='exoUserPri'").append(" or @exo:userPrivate='").append(userId).append("') and @exo:isFirstPost='false'");
                    }
                } else if (type.equals(Utils.POST)) {
                    if (isAnd) {
                        queryString.append(" and ");
                    }
                    queryString.append("(@exo:userPrivate='exoUserPri'").append(" or @exo:userPrivate='").append(userId).append("') and @exo:isFirstPost='false'");
                }
                queryString.append("]");
                Query query = qm.createQuery(queryString.toString(), "xpath");
                QueryResult result = query.execute();
                NodeIterator iter = result.getNodes();
                while (iter.hasNext()) {
                    Node nodeObj = iter.nextNode();
                    listSearchEvent.add(this.setPropertyForForumSearch(nodeObj, type));
                }
                if (!type.equals(Utils.POST)) continue;
                listSearchEvent.addAll(this.getSearchByAttachment(categoryHome, pathQuery, textQuery, listForumIds, listOfUser, isAdmin, ""));
            }
            if (!isAdmin && listSearchEvent.size() > 0) {
                List<Object> categoryCanView = new ArrayList();
                ArrayList<String> forumCanView = new ArrayList<String>();
                Map<String, List<String>> mapList = this.getCategoryViewer(categoryHome, listOfUser, listCateIds, new ArrayList<String>(), "@exo:viewer");
                categoryCanView = mapList.get(Utils.CATEGORY);
                forumCanView.addAll(this.getForumUserCanView(categoryHome, listOfUser, listForumIds));
                if (categoryCanView.size() > 0 || forumCanView.size() > 0) {
                    listSearchEvent = this.removeItemInList(listSearchEvent, forumCanView, categoryCanView);
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            sProvider.close();
        }
        return listSearchEvent;
    }

    private List<ForumSearch> removeItemInList(List<ForumSearch> listSearchEvent, List<String> forumCanView, List<String> categoryCanView) {
        ArrayList<ForumSearch> tempListSearchEvent = new ArrayList<ForumSearch>();
        String path = null;
        for (ForumSearch forumSearch : listSearchEvent) {
            path = forumSearch.getPath();
            if (!path.contains(Utils.TOPIC)) {
                tempListSearchEvent.add(forumSearch);
                continue;
            }
            String[] strs = path.split("/");
            if (!categoryCanView.contains(strs[5]) && !forumCanView.contains(strs[6])) continue;
            tempListSearchEvent.add(forumSearch);
        }
        return tempListSearchEvent;
    }

    private List<String> getForumUserCanView(Node categoryHome, List<String> listOfUser, List<String> listForumIds) throws Exception {
        ArrayList<String> listForum = new ArrayList<String>();
        QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
        StringBuilder queryString = new StringBuilder();
        queryString.append("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:forum)");
        boolean i = false;
        for (String user : listOfUser) {
            if (!i) {
                queryString.append("[(not(@exo:viewer) or @exo:viewer='' or @exo:viewer='").append(user).append("')").append(" or (@exo:moderators='").append(user).append("')");
            } else {
                queryString.append(" or (@exo:viewer='").append(user).append("')").append(" or (@exo:moderators='").append(user).append("')");
            }
            i = true;
        }
        if (i) {
            queryString.append("]");
        }
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        Node forumNode = null;
        String forumId = null;
        while (iter.hasNext()) {
            forumNode = iter.nextNode();
            forumId = forumNode.getName();
            if (listForumIds != null && !listForumIds.isEmpty()) {
                if (!listForumIds.contains(forumId)) continue;
                listForum.add(forumId);
                continue;
            }
            listForum.add(forumId);
        }
        return listForum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ForumSearch> getAdvancedSearch(ForumEventQuery eventQuery, List<String> listCateIds, List<String> listForumIds) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        List<ForumSearch> listSearchEvent = new ArrayList<ForumSearch>();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            String path = eventQuery.getPath();
            if (path == null || path.length() <= 0) {
                path = categoryHome.getPath();
            }
            eventQuery.setPath(path);
            String type = eventQuery.getType();
            String queryString = null;
            List<String> listOfUser = eventQuery.getListOfUser();
            if (eventQuery.getUserPermission() > 0L) {
                Map<String, List<String>> mapList = this.getCategoryViewer(categoryHome, listOfUser, listCateIds, listForumIds, "@exo:userPrivate");
                listCateIds = mapList.get(Utils.CATEGORY);
                listForumIds = mapList.get(Utils.FORUM);
            }
            queryString = type.equals(Utils.CATEGORY) ? eventQuery.getPathQuery(listCateIds) : eventQuery.getPathQuery(listForumIds);
            Query query = qm.createQuery(queryString, "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                Node nodeObj = iter.nextNode();
                listSearchEvent.add(this.setPropertyForForumSearch(nodeObj, type));
            }
            if ((type.equals(Utils.POST) || type.equals(Utils.TOPIC)) && !Utils.isEmpty(eventQuery.getKeyValue())) {
                boolean isAdmin = false;
                if (eventQuery.getUserPermission() == 0L) {
                    isAdmin = true;
                }
                listSearchEvent.addAll(this.getSearchByAttachment(categoryHome, eventQuery.getPath(), eventQuery.getKeyValue(), listForumIds, eventQuery.getListOfUser(), isAdmin, type));
            }
            if (eventQuery.getUserPermission() > 0L) {
                List<Object> categoryCanView = new ArrayList();
                ArrayList<String> forumCanView = new ArrayList<String>();
                Map<String, List<String>> mapList = this.getCategoryViewer(categoryHome, listOfUser, listCateIds, listForumIds, "@exo:viewer");
                categoryCanView = mapList.get(Utils.CATEGORY);
                forumCanView.addAll((Collection)mapList.get(Utils.FORUM));
                forumCanView.addAll(this.getForumUserCanView(categoryHome, listOfUser, listForumIds));
                if (categoryCanView.size() > 0 || forumCanView.size() > 0) {
                    listSearchEvent = this.removeItemInList(listSearchEvent, forumCanView, categoryCanView);
                }
            }
        }
        catch (Exception e) {
        }
        finally {
            sProvider.close();
        }
        return listSearchEvent;
    }

    private List<ForumSearch> getSearchByAttachment(Node categoryHome, String path, String key, List<String> listForumIds, List<String> listOfUser, boolean isAdmin, String type) throws Exception {
        ArrayList<ForumSearch> listSearchEvent = new ArrayList<ForumSearch>();
        try {
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuilder strQuery = new StringBuilder();
            strQuery.append("/jcr:root").append(path).append("//element(*,nt:resource) [");
            strQuery.append("(jcr:contains(., '").append(key).append("*'))]");
            Query query = qm.createQuery(strQuery.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            boolean isAdd = true;
            String type_ = type;
            while (iter.hasNext()) {
                Node nodeObj = iter.nextNode().getParent().getParent();
                if (!nodeObj.isNodeType("exo:post")) continue;
                if (type == null || type.length() == 0) {
                    type_ = nodeObj.getProperty("exo:isFirstPost").getBoolean() ? Utils.TOPIC : Utils.POST;
                } else if (!nodeObj.getProperty("exo:isFirstPost").getBoolean() ? type.equals(Utils.TOPIC) : !type.equals(Utils.TOPIC)) continue;
                if (!isAdmin && !listForumIds.isEmpty()) {
                    String path_ = nodeObj.getPath();
                    isAdd = listForumIds.contains(path_ = path_.substring(path_.lastIndexOf(Utils.FORUM), path_.lastIndexOf("/" + Utils.TOPIC)));
                }
                if (isAdd) {
                    List<String> list = Utils.valuesToList(nodeObj.getProperty("exo:userPrivate").getValues());
                    if (!list.get(0).equals("exoUserPri") && !Utils.isListContentItemList(listOfUser, list)) {
                        isAdd = false;
                    }
                    if (isAdd && !isAdmin && !Utils.isListContentItemList(listOfUser, list = Utils.valuesToList(nodeObj.getParent().getParent().getProperty("exo:moderators").getValues()))) {
                        Post post;
                        list = Utils.valuesToList(nodeObj.getParent().getProperty("exo:canView").getValues());
                        if (list != null && list.size() > 0 && !Utils.isEmpty(list.get(0)) && !Utils.isListContentItemList(listOfUser, list)) {
                            isAdd = false;
                        }
                        if (isAdd && (!(post = this.getPost(nodeObj)).getIsActiveByTopic() || !post.getIsApproved() || post.getIsHidden())) {
                            isAdd = false;
                        }
                    }
                }
                if (!isAdd) continue;
                if (type_.equals(Utils.TOPIC)) {
                    nodeObj = nodeObj.getParent();
                }
                listSearchEvent.add(this.setPropertyForForumSearch(nodeObj, type_));
            }
        }
        catch (Exception e) {
            log.error((Object)"Search by attachment has failed", (Throwable)e);
        }
        return listSearchEvent;
    }

    private ForumSearch setPropertyForForumSearch(Node nodeObj, String type) throws Exception {
        ForumSearch forumSearch = new ForumSearch();
        forumSearch.setId(nodeObj.getName());
        forumSearch.setName(nodeObj.getProperty("exo:name").getString());
        forumSearch.setType(type);
        if (type.equals(Utils.FORUM)) {
            if (nodeObj.getProperty("exo:isClosed").getBoolean()) {
                forumSearch.setIcon("ForumCloseIcon");
            } else if (nodeObj.getProperty("exo:isLock").getBoolean()) {
                forumSearch.setIcon("ForumLockedIcon");
            } else {
                forumSearch.setIcon("ForumNormalIcon");
            }
        } else if (type.equals(Utils.TOPIC)) {
            if (nodeObj.getProperty("exo:isClosed").getBoolean()) {
                forumSearch.setIcon("HotThreadNoNewClosePost");
            } else if (nodeObj.getProperty("exo:isLock").getBoolean()) {
                forumSearch.setIcon("HotThreadNoNewLockPost");
            } else {
                forumSearch.setIcon("HotThreadNoNewPost");
            }
        } else if (type.equals(Utils.CATEGORY)) {
            forumSearch.setIcon("CategoryIcon");
        } else {
            forumSearch.setIcon(nodeObj.getProperty("exo:icon").getString());
        }
        forumSearch.setPath(nodeObj.getPath());
        return forumSearch;
    }

    private Map<String, List<String>> getCategoryViewer(Node categoryHome, List<String> listOfUser, List<String> listCateIds, List<String> listForumIds, String property) throws Exception {
        HashMap<String, List<String>> mapList = new HashMap<String, List<String>>();
        if (listOfUser == null || listOfUser.isEmpty()) {
            listOfUser = new ArrayList<String>();
            listOfUser.add("user_gest_uoom");
        }
        QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
        StringBuilder queryString = new StringBuilder();
        queryString.append("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:forumCategory)");
        boolean i = false;
        for (String string : listOfUser) {
            if (!i) {
                queryString.append("[(").append("not(").append(property).append(")) or (").append(property).append("='') or (").append(property).append("=' ') or (").append(property).append("='").append(string).append("')").append(" or (@exo:moderators='").append(string).append("')");
            } else {
                queryString.append(" or (").append(property).append("='").append(string).append("')").append(" or (@exo:moderators='").append(string).append("')");
            }
            i = true;
        }
        if (i) {
            queryString.append("]");
        }
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        NodeIterator iter1 = null;
        if (iter.getSize() > 0L && iter.getSize() != categoryHome.getNodes().getSize()) {
            ArrayList<String> listForumId = new ArrayList<String>();
            ArrayList<String> listCateId = new ArrayList<String>();
            while (iter.hasNext()) {
                Node catNode = iter.nextNode();
                String cateId = catNode.getName();
                if (listCateIds != null && !listCateIds.isEmpty()) {
                    if (listCateIds.contains(cateId)) {
                        listCateId.add(cateId);
                    }
                } else {
                    listCateId.add(cateId);
                }
                iter1 = catNode.getNodes();
                while (iter1.hasNext()) {
                    Node forumNode = iter1.nextNode();
                    if (!forumNode.isNodeType("exo:forum")) continue;
                    String forumId = forumNode.getName();
                    if (listForumIds != null && !listForumIds.isEmpty()) {
                        if (!listForumIds.contains(forumId)) continue;
                        listForumId.add(forumId);
                        continue;
                    }
                    listForumId.add(forumId);
                }
            }
            mapList.put(Utils.FORUM, listForumId);
            mapList.put(Utils.CATEGORY, listCateId);
        } else if (iter.getSize() == 0L) {
            if (!property.equals("@exo:viewer")) {
                listForumIds = new ArrayList<String>();
                listForumIds.add("forumId");
                mapList.put(Utils.FORUM, listForumIds);
                listCateIds = new ArrayList<String>();
                listCateIds.add("cateId");
                mapList.put(Utils.CATEGORY, listCateIds);
            } else {
                mapList.put(Utils.FORUM, new ArrayList());
                mapList.put(Utils.CATEGORY, new ArrayList());
            }
        } else {
            mapList.put(Utils.FORUM, listForumIds);
            mapList.put(Utils.CATEGORY, listCateIds);
        }
        return mapList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWatch(int watchType, String path, List<String> values, String currentUser) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            if (watchType == -1) {
                QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
                StringBuffer queryString = new StringBuffer();
                queryString.append("/jcr:root").append(categoryHome.getPath()).append("//*[@exo:id='").append(path).append("']");
                Query query = qm.createQuery(queryString.toString(), "xpath");
                QueryResult result = query.execute();
                NodeIterator iterator = result.getNodes();
                path = iterator.nextNode().getPath();
            }
            if (path.indexOf(categoryHome.getName()) < 0) {
                path = categoryHome.getPath() + "/" + path;
            }
            Node watchingNode = (Node)categoryHome.getSession().getItem(path);
            ArrayList<String> listUsers = new ArrayList<String>();
            if (watchingNode.isNodeType("exo:forumWatching")) {
                if (watchType == 1) {
                    ArrayList<String> listEmail = new ArrayList<String>();
                    if (watchingNode.hasProperty("exo:emailWatching")) {
                        listEmail.addAll(Utils.valuesToList(watchingNode.getProperty("exo:emailWatching").getValues()));
                    }
                    if (watchingNode.hasProperty("exo:userWatching")) {
                        listUsers.addAll(Utils.valuesToList(watchingNode.getProperty("exo:userWatching").getValues()));
                    }
                    for (String str : values) {
                        if (listEmail.contains(str)) continue;
                        listEmail.add(0, str);
                        listUsers.add(0, currentUser);
                    }
                    watchingNode.setProperty("exo:emailWatching", Utils.getStringsInList(listEmail));
                    watchingNode.setProperty("exo:userWatching", Utils.getStringsInList(listUsers));
                } else {
                    watchingNode.setProperty("exo:rssWatching", this.getValueProperty(watchingNode, "exo:rssWatching", currentUser));
                }
            } else {
                watchingNode.addMixin("exo:forumWatching");
                if (watchType == 1) {
                    for (int i = 0; i < values.size(); ++i) {
                        listUsers.add(currentUser);
                    }
                    watchingNode.setProperty("exo:emailWatching", Utils.getStringsInList(values));
                    watchingNode.setProperty("exo:userWatching", Utils.getStringsInList(listUsers));
                } else {
                    watchingNode.setProperty("exo:rssWatching", new String[]{currentUser});
                }
            }
            if (watchingNode.isNew()) {
                watchingNode.getSession().save();
            } else {
                watchingNode.save();
            }
        }
        catch (Exception e) {
            log.error((Object)("Can not add Watch for user: " + currentUser), (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWatch(int watchType, String path, String values) throws Exception {
        if (Utils.isEmpty(values)) {
            return;
        }
        Node watchingNode = null;
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node categoryHome = this.getCategoryHome(sProvider);
        String string = categoryHome.getPath();
        if (path.indexOf(categoryHome.getName()) < 0) {
            path = string + "/" + path;
        }
        try {
            watchingNode = (Node)categoryHome.getSession().getItem(path);
            ArrayList<String> newValues = new ArrayList<String>();
            ArrayList<String> listNewUsers = new ArrayList<String>();
            ArrayList<String> userRSS = new ArrayList<String>();
            if (watchingNode.isNodeType("exo:forumWatching") && watchType == 1) {
                String[] emails = new String[]{};
                String[] listOldUsers = new String[]{};
                String[] listRss = new String[]{};
                if (watchingNode.hasProperty("exo:emailWatching")) {
                    emails = Utils.valuesToArray(watchingNode.getProperty("exo:emailWatching").getValues());
                }
                if (watchingNode.hasProperty("exo:userWatching")) {
                    listOldUsers = Utils.valuesToArray(watchingNode.getProperty("exo:userWatching").getValues());
                }
                if (watchingNode.hasProperty("exo:rssWatching")) {
                    listRss = Utils.valuesToArray(watchingNode.getProperty("exo:rssWatching").getValues());
                }
                int n = listRss.length > listOldUsers.length ? listRss.length : listOldUsers.length;
                for (int i = 0; i < n; ++i) {
                    if (listOldUsers.length > i && !values.contains("/" + emails[i])) {
                        newValues.add(emails[i]);
                        listNewUsers.add(listOldUsers[i]);
                    }
                    if (listRss.length <= i || values.contains(listRss[i] + "/")) continue;
                    userRSS.add(listRss[i]);
                }
                watchingNode.setProperty("exo:emailWatching", Utils.getStringsInList(newValues));
                watchingNode.setProperty("exo:userWatching", Utils.getStringsInList(listNewUsers));
                watchingNode.setProperty("exo:rssWatching", Utils.getStringsInList(userRSS));
                if (watchingNode.isNew()) {
                    watchingNode.getSession().save();
                } else {
                    watchingNode.save();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to remove watch.", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateEmailWatch(List<String> listNodeId, String newEmailAdd, String userId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node parentNode = this.getForumHomeNode(sProvider);
            QueryManager qm = parentNode.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root").append(parentNode.getPath()).append("//element(*,exo:forumWatching)[(");
            for (int i = 0; i < listNodeId.size(); ++i) {
                if (i > 0) {
                    queryString.append(" or ");
                }
                queryString.append("@exo:id='").append(listNodeId.get(i)).append("'");
            }
            queryString.append(")]");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iterator = result.getNodes();
            Node watchingNode = null;
            ArrayList<String> listEmail = null;
            ArrayList<String> listUsers = null;
            while (iterator.hasNext()) {
                watchingNode = iterator.nextNode();
                listEmail = new ArrayList<String>();
                listUsers = new ArrayList<String>();
                if (watchingNode.hasProperty("exo:emailWatching")) {
                    listEmail.addAll(Arrays.asList(Utils.valuesToArray(watchingNode.getProperty("exo:emailWatching").getValues())));
                }
                if (watchingNode.hasProperty("exo:userWatching")) {
                    listUsers.addAll(Arrays.asList(Utils.valuesToArray(watchingNode.getProperty("exo:userWatching").getValues())));
                }
                if (listUsers.contains(userId)) {
                    for (int i = 0; i < listUsers.size(); ++i) {
                        if (!((String)listUsers.get(i)).equals(userId)) continue;
                        listEmail.set(i, newEmailAdd);
                    }
                } else {
                    listUsers.add(userId);
                    listEmail.add(newEmailAdd);
                }
                watchingNode.setProperty("exo:emailWatching", listEmail.toArray(new String[listEmail.size()]));
                watchingNode.setProperty("exo:userWatching", listUsers.toArray(new String[listUsers.size()]));
                watchingNode.save();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to update email watch.", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Watch> getWatchByUser(String userId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<Watch> listWatches = new ArrayList<Watch>();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            String rootPath = categoryHome.getPath();
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer();
            queryString.append("/jcr:root").append(rootPath).append("//element(*,").append("exo:forumWatching").append(")[(@").append("exo:userWatching").append("='").append(userId).append("') or (@").append("exo:rssWatching").append("='").append(userId).append("')]");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iterator = result.getNodes();
            String pathName = "";
            while (iterator.hasNext()) {
                ArrayList<String> users = new ArrayList<String>();
                ArrayList<String> RSSUsers = new ArrayList<String>();
                String[] emails = new String[]{};
                rootPath = categoryHome.getPath();
                pathName = "";
                Node node = iterator.nextNode();
                if (node.hasProperty("exo:userWatching")) {
                    users.addAll(Utils.valuesToList(node.getProperty("exo:userWatching").getValues()));
                }
                if (node.hasProperty("exo:emailWatching")) {
                    emails = Utils.valuesToArray(node.getProperty("exo:emailWatching").getValues());
                }
                if (node.hasProperty("exo:rssWatching")) {
                    RSSUsers.addAll(Utils.valuesToList(node.getProperty("exo:rssWatching").getValues()));
                }
                String path = node.getPath();
                String typeNode = node.isNodeType(Utils.TYPE_CATEGORY) ? Utils.TYPE_CATEGORY : (node.isNodeType(Utils.TYPE_FORUM) ? Utils.TYPE_FORUM : Utils.TYPE_TOPIC);
                for (String str : path.replace(rootPath + "/", "").split("/")) {
                    rootPath = rootPath + "/" + str;
                    if (!Utils.isEmpty(pathName)) {
                        pathName = pathName + " > ";
                    }
                    pathName = pathName + ((Node)categoryHome.getSession().getItem(rootPath)).getProperty("exo:name").getString();
                }
                Watch watch = new Watch();
                watch.setId(node.getName());
                watch.setNodePath(path);
                watch.setUserId(userId);
                watch.setPath(pathName);
                watch.setTypeNode(typeNode);
                if (users.contains(userId)) {
                    watch.setEmail(emails[users.indexOf(userId)]);
                    watch.setIsAddWatchByEmail(true);
                } else {
                    watch.setIsAddWatchByEmail(false);
                }
                watch.setIsAddWatchByRSS(RSSUsers.contains(userId));
                listWatches.add(watch);
            }
            ArrayList<Watch> arrayList = listWatches;
            return arrayList;
        }
        catch (Exception e) {
            ArrayList<Watch> arrayList = listWatches;
            return arrayList;
        }
        finally {
            sProvider.close();
        }
    }

    private void sendEmailNotification(List<String> addresses, Message message) throws Exception {
        this.pendingMessagesQueue.add(new SendMessageInfo(addresses, message));
    }

    @Override
    public Iterator<SendMessageInfo> getPendingMessages() throws Exception {
        Iterator<SendMessageInfo> pending = new ArrayList<SendMessageInfo>(this.pendingMessagesQueue).iterator();
        this.pendingMessagesQueue.clear();
        return pending;
    }

    @Override
    public void updateForum(String path) throws Exception {
        if (path == null || path.length() <= 0 || path.equals("/" + this.dataLocator.getForumHomeLocation())) {
            path = this.dataLocator.getForumHomeLocation();
            this.updateForum(path, true);
        } else {
            this.updateForum(path, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateForum(String path, boolean isReset) throws Exception {
        HashMap<String, Long> topicMap = new HashMap<String, Long>();
        HashMap<String, Long> postMap = new HashMap<String, Long>();
        if (path.indexOf("/") > 0) {
            path = "/" + path;
        }
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            String userId;
            long l;
            String owner;
            Node node;
            Node forumStatisticNode = this.getStatisticHome(sProvider).getNode("forumStatistic");
            QueryManager qm = forumStatisticNode.getSession().getWorkspace().getQueryManager();
            Query query = qm.createQuery("/jcr:root" + path + "//element(*,exo:topic)", "xpath");
            QueryResult result = query.execute();
            NodeIterator topicIter = result.getNodes();
            query = qm.createQuery("/jcr:root" + path + "//element(*,exo:post)", "xpath");
            result = query.execute();
            NodeIterator postIter = result.getNodes();
            if (isReset) {
                forumStatisticNode.setProperty("exo:postCount", postIter.getSize());
                forumStatisticNode.setProperty("exo:topicCount", topicIter.getSize());
            } else if (path.indexOf(Utils.FORUM) == path.lastIndexOf(Utils.FORUM)) {
                PropertyReader statisticReader = new PropertyReader(forumStatisticNode);
                forumStatisticNode.setProperty("exo:postCount", statisticReader.l("exo:postCount", 0L) + postIter.getSize());
                forumStatisticNode.setProperty("exo:topicCount", statisticReader.l("exo:topicCount", 0L) + topicIter.getSize());
            }
            forumStatisticNode.save();
            while (topicIter.hasNext()) {
                node = topicIter.nextNode();
                owner = node.getProperty("exo:owner").getString();
                if (topicMap.containsKey(owner)) {
                    l = (Long)topicMap.get(owner) + 1L;
                    topicMap.put(owner, l);
                    continue;
                }
                l = 1L;
                topicMap.put(owner, l);
            }
            while (postIter.hasNext()) {
                node = postIter.nextNode();
                owner = node.getProperty("exo:owner").getString();
                if (postMap.containsKey(owner)) {
                    l = (Long)postMap.get(owner) + 1L;
                    postMap.put(owner, l);
                    continue;
                }
                l = 1L;
                postMap.put(owner, l);
            }
            Node profileHome = this.getUserProfileHome(sProvider);
            Iterator it = topicMap.entrySet().iterator();
            Calendar cal = this.getGreenwichMeanTime();
            while (it.hasNext()) {
                Node profile;
                userId = (String)it.next().getKey();
                if (userId.indexOf(Utils.DELETED) >= 0) continue;
                if (profileHome.hasNode(userId)) {
                    profile = profileHome.getNode(userId);
                } else {
                    profile = profileHome.addNode(userId, Utils.USER_PROFILES_TYPE);
                    profile.setProperty("exo:userId", userId);
                    profile.setProperty("exo:lastLoginDate", cal);
                    profile.setProperty("exo:joinedDate", cal);
                    profile.setProperty("exo:lastPostDate", cal);
                }
                long l2 = isReset ? (Long)topicMap.get(userId) : profile.getProperty("exo:totalTopic").getLong() + (Long)topicMap.get(userId);
                profile.setProperty("exo:totalTopic", l2);
                if (!postMap.containsKey(userId)) continue;
                long t = isReset ? (Long)postMap.get(userId) : profile.getProperty("exo:totalPost").getLong() + (Long)postMap.get(userId);
                profile.setProperty("exo:totalPost", t);
                profile.setProperty("exo:lastPostDate", cal);
                postMap.remove(userId);
            }
            it = postMap.entrySet().iterator();
            while (it.hasNext()) {
                Node profile;
                userId = (String)it.next().getKey();
                if (userId.indexOf(Utils.DELETED) >= 0) continue;
                if (profileHome.hasNode(userId)) {
                    profile = profileHome.getNode(userId);
                } else {
                    profile = profileHome.addNode(userId, Utils.USER_PROFILES_TYPE);
                    profile.setProperty("exo:userId", userId);
                    profile.setProperty("exo:lastLoginDate", cal);
                    profile.setProperty("exo:joinedDate", cal);
                }
                long t = isReset ? (Long)postMap.get(userId) : profile.getProperty("exo:totalPost").getLong() + (Long)postMap.get(userId);
                profile.setProperty("exo:totalPost", t);
                profile.setProperty("exo:lastPostDate", cal);
            }
            if (profileHome.isNew()) {
                profileHome.getSession().save();
            } else {
                profileHome.save();
            }
            int t = profileHome.hasNode(Utils.USER_PROFILE_DELETED) ? 1 : 0;
            forumStatisticNode.setProperty("exo:membersCount", profileHome.getNodes().getSize() - (long)t);
            forumStatisticNode.save();
        }
        catch (Exception e) {
            log.error((Object)"Failed to update forum", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    @Override
    public SendMessageInfo getMessageInfo(String name) throws Exception {
        SendMessageInfo messageInfo = (SendMessageInfo)this.infoMap.get(name);
        this.infoMap.remove(name);
        return messageInfo;
    }

    private String getPath(String index, String path) throws Exception {
        int t = path.lastIndexOf(index);
        if (t > 0) {
            path = path.substring(t + 1);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ForumSearch> getJobWattingForModerator(String[] paths) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<ForumSearch> list = new ArrayList<ForumSearch>();
        try {
            Node node;
            ForumSearch forumSearch;
            Node categoryHome = this.getCategoryHome(sProvider);
            String string = categoryHome.getPath();
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            String pathQuery = "";
            StringBuffer buffer = new StringBuffer();
            int l = paths.length;
            if (l > 0) {
                buffer.append(" and (");
                for (int i = 0; i < l; ++i) {
                    if (i > 0) {
                        buffer.append(" or ");
                    }
                    String str = this.getPath("/" + Utils.FORUM, paths[i]);
                    buffer.append("@exo:path='").append(str).append("'");
                }
                buffer.append(")");
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(string).append("//element(*,exo:topic)").append("[(@exo:isApproved='false' or @exo:isWaiting='true')").append(buffer).append("] order by @exo:modifiedDate descending");
            pathQuery = stringBuffer.toString();
            Query query = qm.createQuery(pathQuery, "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                forumSearch = new ForumSearch();
                node = iter.nextNode();
                forumSearch.setId(node.getName());
                forumSearch.setPath(node.getPath());
                forumSearch.setType(Utils.TOPIC);
                forumSearch.setName(node.getProperty("exo:name").getString());
                forumSearch.setContent(node.getProperty("exo:description").getString());
                forumSearch.setCreatedDate(node.getProperty("exo:createdDate").getDate().getTime());
                list.add(forumSearch);
            }
            stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(string).append("//element(*,exo:post)").append("[(@exo:isApproved='false' or @exo:isHidden='true')").append(buffer).append("] order by @exo:modifiedDate descending");
            pathQuery = stringBuffer.toString();
            query = qm.createQuery(pathQuery, "xpath");
            result = query.execute();
            iter = result.getNodes();
            while (iter.hasNext()) {
                forumSearch = new ForumSearch();
                node = iter.nextNode();
                forumSearch.setId(node.getName());
                forumSearch.setPath(node.getPath());
                forumSearch.setType(Utils.POST);
                forumSearch.setName(node.getProperty("exo:name").getString());
                forumSearch.setContent(node.getProperty("exo:message").getString());
                forumSearch.setCreatedDate(node.getProperty("exo:createdDate").getDate().getTime());
                list.add(forumSearch);
            }
        }
        catch (Exception e) {
        }
        finally {
            sProvider.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getJobWattingForModeratorByUser(String userId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        int job = 0;
        try {
            Node newProfileNode = this.getUserProfileHome(sProvider).getNode(userId);
            long t = this.isAdminRole(userId) ? 0L : newProfileNode.getProperty("exo:userRole").getLong();
            if (t < 2L) {
                try {
                    job = (int)newProfileNode.getProperty("exo:jobWattingForModerator").getLong();
                }
                catch (Exception e) {
                    job = 0;
                }
            }
        }
        finally {
            sProvider.close();
        }
        return job;
    }

    private int getTotalJobWaitingForModerator(Session session, String userId) throws Exception {
        int totalJob = 0;
        try {
            Node newProfileNode = session.getRootNode().getNode(this.dataLocator.getUserProfilesLocation()).getNode(userId);
            long t = this.isAdminRole(userId) ? 0L : newProfileNode.getProperty("exo:userRole").getLong();
            if (t < 2L) {
                String[] paths;
                int l;
                Node categoryHome = session.getRootNode().getNode(this.dataLocator.getForumCategoriesLocation());
                String string = categoryHome.getPath();
                QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
                StringBuffer stringBuffer = new StringBuffer();
                String pathQuery = "";
                stringBuffer.append("/jcr:root").append(string).append("//element(*,exo:topic)");
                StringBuffer buffer = new StringBuffer();
                if (t > 0L && (l = (paths = Utils.valuesToArray(newProfileNode.getProperty("exo:moderateForums").getValues())).length) > 0) {
                    buffer.append(" and (");
                    for (int i = 0; i < l; ++i) {
                        if (i > 0) {
                            buffer.append(" or ");
                        }
                        String str = this.getPath("/" + Utils.FORUM, paths[i]);
                        buffer.append("@exo:path='").append(str).append("'");
                    }
                    buffer.append(")");
                }
                pathQuery = stringBuffer.append("[(@exo:isApproved='false' or @exo:isWaiting='true')").append(buffer).append("]").toString();
                Query query = qm.createQuery(pathQuery, "xpath");
                QueryResult result = query.execute();
                NodeIterator iter = result.getNodes();
                totalJob = (int)iter.getSize();
                stringBuffer = new StringBuffer();
                stringBuffer.append("/jcr:root").append(string).append("//element(*,exo:post)");
                pathQuery = stringBuffer.append("[(@exo:isApproved='false' or @exo:isHidden='true')").append(buffer).append("]").toString();
                query = qm.createQuery(pathQuery, "xpath");
                result = query.execute();
                iter = result.getNodes();
                newProfileNode.setProperty("exo:jobWattingForModerator", (long)(totalJob += (int)iter.getSize()));
                newProfileNode.save();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to get total job watting for moderator", (Throwable)e);
        }
        return totalJob;
    }

    private void getTotalJobWatting(SessionProvider sProvider, List<String> userIds) {
        try {
            JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
            Category cat = new Category();
            ArrayList<String> list = new ArrayList<String>();
            ContinuationService continuation = this.getContinuationService();
            for (String userId : userIds) {
                if (Utils.isEmpty(userId) || list.contains(userId)) continue;
                list.add(userId);
                int job = this.getTotalJobWaitingForModerator(this.getForumHomeNode(sProvider).getSession(), userId);
                if (job < 0) continue;
                cat.setCategoryName(String.valueOf(job));
                JsonValue json = generatorImpl.createJsonObject((Object)cat);
                continuation.sendMessage(userId, "/eXo/Application/Forum/messages", (Object)json, cat.toString());
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to get total job waiting for moderator", (Throwable)e);
        }
    }

    protected ContinuationService getContinuationService() {
        ContinuationService continuation = (ContinuationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ContinuationService.class);
        return continuation;
    }

    public void sendNotificationMessage(ForumPrivateMessage message) {
        try {
            if (message != null) {
                String[] sendTo = message.getSendTo().replaceAll(";", ",").split(",");
                JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                ContinuationService continuation = this.getContinuationService();
                JsonValue json = generatorImpl.createJsonObject((Object)message);
                for (int i = 0; i < sendTo.length; ++i) {
                    if (sendTo[i].equals(message.getFrom())) continue;
                    continuation.sendMessage(sendTo[i], "/eXo/Application/Forum/NotificationMessage", (Object)json, message.toString());
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to send notification message", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeIterator search(String queryString) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            QueryManager qm = this.getForumHomeNode(sProvider).getSession().getWorkspace().getQueryManager();
            Query query = qm.createQuery(queryString, "xpath");
            QueryResult result = query.execute();
            NodeIterator nodeIterator = result.getNodes();
            return nodeIterator;
        }
        catch (Exception e) {
            log.error((Object)"Failed to search", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluateActiveUsers(String strQuery) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            String path = this.getUserProfileHome(sProvider).getPath();
            StringBuilder stringBuilder = new StringBuilder();
            if (strQuery == null || strQuery.length() == 0) {
                Calendar calendar = GregorianCalendar.getInstance();
                calendar.setTimeInMillis(calendar.getTimeInMillis() - 864000000L);
                stringBuilder.append("/jcr:root").append(path).append("//element(*,").append(Utils.USER_PROFILES_TYPE).append(")[").append("@exo:lastPostDate >= xs:dateTime('").append(ISO8601.format((Calendar)calendar)).append("')]");
            } else {
                stringBuilder.append("/jcr:root").append(path).append(strQuery);
            }
            QueryManager qm = this.getForumHomeNode(sProvider).getSession().getWorkspace().getQueryManager();
            Query query = qm.createQuery(stringBuilder.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            Node statisticHome = this.getStatisticHome(sProvider);
            if (statisticHome.hasNode("forumStatistic")) {
                statisticHome.getNode("forumStatistic").setProperty("exo:activeUsers", iter.getSize());
                statisticHome.save();
            } else {
                ForumStatistic forumStatistic = new ForumStatistic();
                forumStatistic.setActiveUsers(iter.getSize());
                this.saveForumStatistic(forumStatistic);
            }
        }
        catch (Exception exception) {
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<File> createCategoryFiles(List<String> objectIds, SessionProvider sessionProvider) throws Exception {
        Node categoryHome = this.getCategoryHome(sessionProvider);
        ArrayList<File> listFiles = new ArrayList<File>();
        for (Category category : this.getCategories()) {
            if (objectIds != null && objectIds.size() > 0 && !objectIds.contains(category.getId())) continue;
            ByteArrayOutputStream outputStream = null;
            try {
                outputStream = new ByteArrayOutputStream();
                GregorianCalendar date = new GregorianCalendar();
                categoryHome.getSession().exportSystemView(category.getPath(), (OutputStream)outputStream, false, false);
                listFiles.add(org.exoplatform.ks.common.Utils.getXMLFile((ByteArrayOutputStream)outputStream, (String)"eXo Knowledge Suite - Forum", (String)"Category", (Date)date.getTime(), (String)category.getId()));
            }
            finally {
                outputStream.close();
            }
        }
        return listFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<File> createForumFiles(String categoryId, List<String> objectIds, SessionProvider sessionProvider) throws Exception {
        ArrayList<File> listFiles = new ArrayList<File>();
        for (Forum forum : this.getForums(categoryId, null)) {
            if (objectIds.size() > 0 && !objectIds.contains(forum.getId())) continue;
            ByteArrayOutputStream outputStream = null;
            try {
                outputStream = new ByteArrayOutputStream();
                Calendar calendar = GregorianCalendar.getInstance();
                this.getCategoryHome(sessionProvider).getSession().exportSystemView(forum.getPath(), (OutputStream)outputStream, false, false);
                listFiles.add(org.exoplatform.ks.common.Utils.getXMLFile((ByteArrayOutputStream)outputStream, (String)"eXo Knowledge Suite - Forum", (String)"Forum", (Date)calendar.getTime(), (String)forum.getId()));
            }
            finally {
                outputStream.close();
            }
        }
        return listFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<File> createFilesFromNode(Node node, String type) throws Exception {
        ArrayList<File> listFiles = new ArrayList<File>();
        if (node != null) {
            ByteArrayOutputStream outputStream = null;
            try {
                outputStream = new ByteArrayOutputStream();
                Calendar calendar = GregorianCalendar.getInstance();
                node.getSession().exportSystemView(node.getPath(), (OutputStream)outputStream, false, false);
                listFiles.add(org.exoplatform.ks.common.Utils.getXMLFile((ByteArrayOutputStream)outputStream, (String)"eXo Knowledge Suite - Forum", (String)type, (Date)calendar.getTime(), (String)node.getName()));
            }
            finally {
                outputStream.close();
            }
        }
        return listFiles;
    }

    protected List<File> createAllForumFiles(SessionProvider sessionProvider) throws Exception {
        ArrayList<File> listFiles = new ArrayList<File>();
        listFiles.addAll(this.createFilesFromNode(this.getAdminHome(sessionProvider), "AdministrationHome"));
        listFiles.addAll(this.createFilesFromNode(this.getUserProfileHome(sessionProvider), "UserProfileHome"));
        listFiles.addAll(this.createFilesFromNode(this.getTagHome(sessionProvider), "TagHome"));
        listFiles.addAll(this.createFilesFromNode(this.getBBCodesHome(sessionProvider), "forumBBCode"));
        listFiles.addAll(this.createFilesFromNode(this.getBanIPHome(sessionProvider), "BanIPHome"));
        listFiles.addAll(this.createFilesFromNode(this.getCategoryHome(sessionProvider), "CategoryHome"));
        return listFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object exportXML(String categoryId, String forumId, List<String> objectIds, String nodePath, ByteArrayOutputStream bos, boolean isExportAll) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            ArrayList<File> listFiles = new ArrayList<File>();
            if (!isExportAll) {
                if (categoryId != null) {
                    if (!Utils.isEmpty(forumId)) {
                        Node categoryHome = this.getCategoryHome(sProvider);
                        categoryHome.getSession().exportSystemView(nodePath, (OutputStream)bos, false, false);
                        categoryHome.getSession().logout();
                        Object var10_13 = null;
                        return var10_13;
                    }
                    listFiles.addAll(this.createForumFiles(categoryId, objectIds, sProvider));
                } else {
                    listFiles.addAll(this.createCategoryFiles(objectIds, sProvider));
                }
            } else {
                listFiles.addAll(this.createAllForumFiles(sProvider));
            }
            ZipOutputStream zipOutputStream = null;
            try {
                zipOutputStream = new ZipOutputStream(new FileOutputStream("exportCategory.zip"));
                byte[] buffer = new byte[4096];
                FileInputStream inputStream = null;
                ZipEntry zipEntry = null;
                for (File f : listFiles) {
                    inputStream = new FileInputStream(f);
                    try {
                        int byteReads;
                        zipEntry = new ZipEntry(f.getPath());
                        zipOutputStream.putNextEntry(zipEntry);
                        while ((byteReads = inputStream.read(buffer)) != -1) {
                            zipOutputStream.write(buffer, 0, byteReads);
                        }
                    }
                    finally {
                        inputStream.close();
                    }
                }
            }
            finally {
                zipOutputStream.close();
            }
            File file = new File("exportCategory.zip");
            for (File f : listFiles) {
                f.deleteOnExit();
            }
            File file2 = file;
            return file2;
        }
        catch (Exception e) {
            Object var9_12 = null;
            return var9_12;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void importXML(String nodePath, ByteArrayInputStream bis, int typeImport) throws Exception {
        String nodeName = "";
        byte[] bdata = new byte[bis.available()];
        bis.read(bdata);
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        ByteArrayInputStream is = new ByteArrayInputStream(bdata);
        Document doc = docBuilder.parse(is);
        doc.getDocumentElement().normalize();
        String typeNodeExport = doc.getFirstChild().getChildNodes().item(0).getChildNodes().item(0).getTextContent();
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<String> patchNodeImport = new ArrayList<String>();
        try {
            Node forumHome = this.getForumHomeNode(sProvider);
            is = new ByteArrayInputStream(bdata);
            if (!typeNodeExport.equals("exo:forumCategory") && !typeNodeExport.equals("exo:forum")) {
                Session session;
                Node node;
                if (typeNodeExport.equals("exo:categoryHome")) {
                    nodePath = this.getCategoryHome(sProvider).getPath();
                    Node categoryHome = this.getCategoryHome(sProvider);
                    nodeName = "CategoryHome";
                    this.addDataFromXML(categoryHome, nodePath, sProvider, is, nodeName);
                } else if (typeNodeExport.equals("exo:userProfileHome")) {
                    Node userProfile = this.getUserProfileHome(sProvider);
                    nodeName = "UserProfileHome";
                    nodePath = this.getUserProfileHome(sProvider).getPath();
                    this.addDataFromXML(userProfile, nodePath, sProvider, is, nodeName);
                } else if (typeNodeExport.equals("exo:tagHome")) {
                    Node tagHome = this.getTagHome(sProvider);
                    nodePath = this.getTagHome(sProvider).getPath();
                    nodeName = "TagHome";
                    this.addDataFromXML(tagHome, nodePath, sProvider, is, nodeName);
                } else if (typeNodeExport.equals("exo:forumBBCodeHome")) {
                    nodePath = this.dataLocator.getBBCodesLocation();
                    Node bbcodeNode = this.getBBCodesHome(sProvider);
                    nodeName = "forumBBCode";
                    this.addDataFromXML(bbcodeNode, nodePath, sProvider, is, nodeName);
                } else if (typeNodeExport.equals("exo:administrationHome")) {
                    nodePath = this.getForumSystemHome(sProvider).getPath();
                    node = this.getAdminHome(sProvider);
                    node.remove();
                    this.getForumSystemHome(sProvider).save();
                    typeImport = 2;
                    session = forumHome.getSession();
                    session.importXML(nodePath, (InputStream)is, typeImport);
                    session.save();
                } else {
                    if (!typeNodeExport.equals("exo:banIPHome")) throw new RuntimeException("unknown type of node to export :" + typeNodeExport);
                    nodePath = this.getForumSystemHome(sProvider).getPath();
                    node = this.getBanIPHome(sProvider);
                    node.remove();
                    this.getForumSystemHome(sProvider).save();
                    typeImport = 2;
                    session = forumHome.getSession();
                    session.importXML(nodePath, (InputStream)is, typeImport);
                    session.save();
                }
            } else {
                if (typeNodeExport.equals("exo:forumCategory")) {
                    if (nodePath.split("/").length == 6) {
                        System.out.println("\n\n langth can not == 6 \n");
                        throw new ConstraintViolationException();
                    }
                    nodePath = this.getCategoryHome(sProvider).getPath();
                }
                Session session = forumHome.getSession();
                NodeIterator iter = ((Node)session.getItem(nodePath)).getNodes();
                while (iter.hasNext()) {
                    patchNodeImport.add(iter.nextNode().getName());
                }
                session.importXML(nodePath, (InputStream)is, typeImport);
                session.save();
                NodeIterator newIter = ((Node)session.getItem(nodePath)).getNodes();
                while (newIter.hasNext()) {
                    Node node = newIter.nextNode();
                    if (patchNodeImport.contains(node.getName())) {
                        patchNodeImport.remove(node.getName());
                        continue;
                    }
                    patchNodeImport.add(node.getName());
                }
            }
            if (typeNodeExport.equals("exo:forumCategory") || typeNodeExport.equals("exo:forum")) {
                for (String string : patchNodeImport) {
                    this.updateForum(nodePath + "/" + string, false);
                }
                return;
            } else {
                if (!typeNodeExport.equals("exo:categoryHome")) return;
                this.updateForum(null);
            }
            return;
        }
        finally {
            sProvider.close();
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDataFromXML(Node sourceNode, String nodePath, SessionProvider sessionProvider, InputStream is, String nodeName) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sessionProvider);
        Session session = forumHomeNode.getSession();
        Node tempNode = forumHomeNode.getParent().addNode("DataTemp");
        session.importXML(tempNode.getPath(), is, 0);
        session.save();
        Node importNode = tempNode.getNode(nodeName);
        try {
            this.copyFullNodes(sourceNode, importNode, session);
        }
        finally {
            tempNode.remove();
            forumHomeNode.getParent().save();
        }
    }

    private void copyFullNodes(Node sourceNode, Node importNode, Session session) throws Exception {
        NodeIterator sourceIter = sourceNode.getNodes();
        NodeIterator importIter = importNode.getNodes();
        Node srcTemp = null;
        Node importTemp = null;
        boolean flag = false;
        while (importIter.hasNext()) {
            flag = true;
            importTemp = importIter.nextNode();
            while (sourceIter.hasNext()) {
                srcTemp = sourceIter.nextNode();
                if (!importTemp.getName().equals(srcTemp.getName())) continue;
                this.copyFullNodes(srcTemp, importTemp, session);
                flag = false;
                break;
            }
            if (!flag) continue;
            String path = sourceNode.getPath() + "/" + importTemp.getName();
            try {
                session.getWorkspace().copy(importTemp.getPath(), path);
            }
            catch (Exception e) {
                log.debug((Object)(path + " or " + importTemp.getPath() + " does not exist: " + e.getMessage() + "\n" + e.getCause()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTopicAccess(String userId, String topicId) throws Exception {
        SessionProvider sysSession = SessionProvider.createSystemProvider();
        try {
            Node profile = this.getUserProfileHome(sysSession).getNode(userId);
            List<Object> values = new ArrayList();
            if (profile.hasProperty("exo:readTopic")) {
                values = Utils.valuesToList(profile.getProperty("exo:readTopic").getValues());
            }
            int i = 0;
            boolean isUpdated = false;
            for (String string : values) {
                if (string.indexOf(topicId) == 0) {
                    values.set(i, topicId + ":" + this.getGreenwichMeanTime().getTimeInMillis());
                    isUpdated = true;
                    break;
                }
                ++i;
            }
            if (!isUpdated) {
                values.add(topicId + ":" + this.getGreenwichMeanTime().getTimeInMillis());
            }
            if (values.size() == 2 && Utils.isEmpty((String)values.get(0))) {
                values.remove(0);
            }
            profile.setProperty("exo:readTopic", values.toArray(new String[values.size()]));
            profile.save();
        }
        catch (Exception e) {
        }
        finally {
            sysSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateForumAccess(String userId, String forumId) throws Exception {
        SessionProvider sysSession = SessionProvider.createSystemProvider();
        try {
            Node profile = this.getUserProfileHome(sysSession).getNode(userId);
            List<Object> values = new ArrayList();
            if (profile.hasProperty("exo:readForum")) {
                values = Utils.valuesToList(profile.getProperty("exo:readForum").getValues());
            }
            int i = 0;
            boolean isUpdated = false;
            for (String string : values) {
                if (string.indexOf(forumId) == 0) {
                    values.set(i, forumId + ":" + this.getGreenwichMeanTime().getTimeInMillis());
                    isUpdated = true;
                    break;
                }
                ++i;
            }
            if (!isUpdated) {
                values.add(forumId + ":" + this.getGreenwichMeanTime().getTimeInMillis());
            }
            if (values.size() == 2 && Utils.isEmpty((String)values.get(0))) {
                values.remove(0);
            }
            profile.setProperty("exo:readForum", values.toArray(new String[values.size()]));
            profile.save();
        }
        catch (Exception e) {
        }
        finally {
            sysSession.close();
        }
    }

    @Override
    public List<String> getBookmarks(String userName) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node profile = this.getUserProfileHome(sProvider).getNode(userName);
        sProvider.close();
        if (profile.hasProperty("exo:bookmark")) {
            return Utils.valuesToList(profile.getProperty("exo:bookmark").getValues());
        }
        return new ArrayList<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getBanList() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node banNode = this.getForumBanNode(sProvider);
            if (banNode.hasProperty("exo:ips")) {
                List<String> list = Utils.valuesToList(banNode.getProperty("exo:ips").getValues());
                return list;
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to get ban list", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return new ArrayList<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addBanIP(String ip) throws Exception {
        List<String> ips = this.getBanList();
        if (ips.contains(ip)) {
            return false;
        }
        ips.add(ip);
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node banNode = this.getForumBanNode(sProvider);
            banNode.setProperty("exo:ips", ips.toArray(new String[ips.size()]));
            if (banNode.isNew()) {
                banNode.getSession().save();
            } else {
                banNode.save();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error((Object)("Failed to add ban ip: " + ip), (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBan(String ip) throws Exception {
        List<String> ips = this.getBanList();
        if (ips.contains(ip)) {
            ips.remove(ip);
            SessionProvider sProvider = SessionProvider.createSystemProvider();
            try {
                Node banNode = this.getForumBanNode(sProvider);
                banNode.setProperty("exo:ips", Utils.getStringsInList(ips));
                banNode.save();
            }
            catch (Exception e) {
                log.error((Object)("Failed to remove ban, ip: " + ip), (Throwable)e);
            }
            finally {
                sProvider.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getForumBanList(String forumId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<String> list = new ArrayList<String>();
        try {
            Node forumNode;
            if (forumId.indexOf(".") > 0) {
                forumId = StringUtils.replace((String)forumId, (String)".", (String)"/");
            }
            if ((forumNode = this.getCategoryHome(sProvider).getNode(forumId)).hasProperty("exo:banIPs")) {
                list.addAll(Utils.valuesToList(forumNode.getProperty("exo:banIPs").getValues()));
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to get forum ban list.", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addBanIPForum(String ip, String forumId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<String> ips = new ArrayList<String>();
        try {
            Node forumNode = this.getCategoryHome(sProvider).getNode(forumId);
            if (forumNode.hasProperty("exo:banIPs")) {
                ips.addAll(Utils.valuesToList(forumNode.getProperty("exo:banIPs").getValues()));
            }
            if (ips.contains(ip)) {
                boolean bl = false;
                return bl;
            }
            ips.add(ip);
            forumNode.setProperty("exo:banIPs", Utils.getStringsInList(ips));
            if (forumNode.isNew()) {
                forumNode.getSession().save();
            } else {
                forumNode.save();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error((Object)"Failed to add ban ip forum.", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBanIPForum(String ip, String forumId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<String> ips = new ArrayList<String>();
        try {
            Node forumNode = this.getCategoryHome(sProvider).getNode(forumId);
            if (forumNode.hasProperty("exo:banIPs")) {
                ips.addAll(Utils.valuesToList(forumNode.getProperty("exo:banIPs").getValues()));
            }
            if (ips.contains(ip)) {
                ips.remove(ip);
                forumNode.setProperty("exo:banIPs", Utils.getStringsInList(ips));
                if (forumNode.isNew()) {
                    forumNode.getSession().save();
                } else {
                    forumNode.save();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to remove ban IP from forum", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    private List<String> getAllAdministrator(SessionProvider sProvider) throws Exception {
        QueryManager qm = this.getForumHomeNode(sProvider).getSession().getWorkspace().getQueryManager();
        StringBuilder pathQuery = new StringBuilder();
        pathQuery.append("/jcr:root").append(this.getUserProfileHome(sProvider).getPath()).append("//element(*,").append(Utils.USER_PROFILES_TYPE).append(")[@exo:userRole=0]");
        Query query = qm.createQuery(pathQuery.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        ArrayList<String> list = new ArrayList<String>();
        while (iter.hasNext()) {
            Node userNode = iter.nextNode();
            list.add(userNode.getName());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateStatisticCounts(long topicCount, long postCount) throws Exception {
        try {
            JCRSessionManager manager = new JCRSessionManager(this.workspace);
            Session session = manager.createSession();
            try {
                long count;
                Node forumStatisticNode = session.getRootNode().getNode(this.dataLocator.getForumStatisticsLocation());
                PropertyReader reader = new PropertyReader(forumStatisticNode);
                if (topicCount != 0L) {
                    count = reader.l("exo:topicCount");
                    if (count < 0L) {
                        count = 0L;
                    }
                    forumStatisticNode.setProperty("exo:topicCount", count + topicCount);
                }
                if (postCount != 0L) {
                    count = reader.l("exo:postCount");
                    if (count < 0L) {
                        count = 0L;
                    }
                    forumStatisticNode.setProperty("exo:postCount", count + postCount);
                }
                forumStatisticNode.save();
            }
            finally {
                session.logout();
            }
        }
        catch (Exception e) {
            log.debug((Object)"Failed to update statistic counts", (Throwable)e);
        }
    }

    private PruneSetting getPruneSetting(Node prunNode) throws Exception {
        PruneSetting pruneSetting = new PruneSetting();
        pruneSetting.setId(prunNode.getName());
        pruneSetting.setForumPath(prunNode.getParent().getPath());
        pruneSetting.setActive(prunNode.getProperty("exo:isActive").getBoolean());
        pruneSetting.setCategoryName(prunNode.getParent().getParent().getProperty("exo:name").getString());
        pruneSetting.setForumName(prunNode.getParent().getProperty("exo:name").getString());
        pruneSetting.setInActiveDay(prunNode.getProperty("exo:inActiveDay").getLong());
        pruneSetting.setPeriodTime(prunNode.getProperty("exo:periodTime").getLong());
        if (prunNode.hasProperty("exo:lastRunDate")) {
            pruneSetting.setLastRunDate(prunNode.getProperty("exo:lastRunDate").getDate().getTime());
        }
        return pruneSetting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PruneSetting getPruneSetting(String forumPath) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        PruneSetting pruneSetting = new PruneSetting();
        try {
            Node forumNode = (Node)this.getCategoryHome(sProvider).getSession().getItem(forumPath);
            pruneSetting = this.getPruneSetting(forumNode.getNode(Utils.PRUNESETTING));
        }
        catch (Exception e) {
            log.debug((Object)("Failed to get Prune Settings: " + e.getMessage() + "\n" + e.getCause()));
        }
        finally {
            sProvider.close();
        }
        return pruneSetting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PruneSetting> getAllPruneSetting() throws Exception {
        ArrayList<PruneSetting> prunList = new ArrayList<PruneSetting>();
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node categoryHNode = this.getCategoryHome(sProvider);
            QueryManager qm = categoryHNode.getSession().getWorkspace().getQueryManager();
            StringBuilder pathQuery = new StringBuilder();
            pathQuery.append("/jcr:root").append(categoryHNode.getPath()).append("//element(*,exo:pruneSetting) order by @exo:id ascending");
            Query query = qm.createQuery(pathQuery.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                Node prunNode = iter.nextNode();
                prunList.add(this.getPruneSetting(prunNode));
            }
        }
        finally {
            sProvider.close();
        }
        return prunList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void savePruneSetting(PruneSetting pruneSetting) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node pruneNode;
            String path = pruneSetting.getForumPath();
            Node forumNode = (Node)this.getForumHomeNode(sProvider).getSession().getItem(path);
            try {
                pruneNode = forumNode.getNode(Utils.PRUNESETTING);
            }
            catch (Exception e) {
                pruneNode = forumNode.addNode(Utils.PRUNESETTING, "exo:pruneSetting");
                pruneNode.setProperty("exo:id", pruneSetting.getId());
            }
            pruneNode.setProperty("exo:inActiveDay", pruneSetting.getInActiveDay());
            pruneNode.setProperty("exo:periodTime", pruneSetting.getPeriodTime());
            pruneNode.setProperty("exo:isActive", pruneSetting.isActive());
            if (pruneSetting.getLastRunDate() != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(pruneSetting.getLastRunDate());
                pruneNode.setProperty("exo:lastRunDate", calendar);
            }
            if (pruneNode.isNew()) {
                forumNode.getSession().save();
            } else {
                forumNode.save();
            }
            try {
                this.addOrRemoveSchedule(pruneSetting);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to save prune setting.", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    private void addOrRemoveSchedule(PruneSetting pSetting) throws Exception {
        GregorianCalendar cal = new GregorianCalendar();
        PeriodInfo periodInfo = new PeriodInfo(cal.getTime(), null, -1, pSetting.getPeriodTime() * 86400000L);
        Class<?> clazz = Class.forName("org.exoplatform.forum.service.user.AutoPruneJob");
        JobInfo info = new JobInfo(pSetting.getId(), "KnowledgeSuite-forum", clazz);
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        JobSchedulerService schedulerService = (JobSchedulerService)container.getComponentInstanceOfType(JobSchedulerService.class);
        schedulerService.removeJob(info);
        if (pSetting.isActive()) {
            info = new JobInfo(pSetting.getId(), "KnowledgeSuite-forum", clazz);
            info.setDescription(pSetting.getForumPath());
            schedulerService.addPeriodJob(info, periodInfo);
            log.debug((Object)("\n\nActivated " + info.getJobName()));
        }
    }

    @Override
    public void runPrune(String forumPath) throws Exception {
        this.runPrune(this.getPruneSetting(forumPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runPrune(PruneSetting pSetting) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumHome = this.getForumHomeNode(sProvider);
            Node forumNode = (Node)forumHome.getSession().getItem(pSetting.getForumPath());
            Calendar newDate = this.getGreenwichMeanTime();
            newDate.setTimeInMillis(newDate.getTimeInMillis() - pSetting.getInActiveDay() * 86400000L);
            QueryManager qm = forumHome.getSession().getWorkspace().getQueryManager();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(forumNode.getPath()).append("//element(*,exo:topic)[ @exo:isActive='true' and @exo:lastPostDate <= xs:dateTime('").append(ISO8601.format((Calendar)newDate)).append("')]");
            Query query = qm.createQuery(stringBuffer.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                Node topic = iter.nextNode();
                topic.setProperty("exo:isActive", false);
                topic.save();
                try {
                    Node forumN = topic.getParent();
                    if (!forumN.hasProperty("exo:lastTopicPath") || !forumN.getProperty("exo:lastTopicPath").getString().equals(topic.getName())) continue;
                    this.queryLastTopic(sProvider, forumN.getPath());
                }
                catch (Exception e) {}
            }
            Node setting = forumNode.getNode(pSetting.getId());
            setting.setProperty("exo:lastRunDate", this.getGreenwichMeanTime());
            forumNode.save();
        }
        catch (Exception e) {
            log.error((Object)"Failed to run prune", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long checkPrune(PruneSetting pSetting) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumHome = this.getForumHomeNode(sProvider);
            Node forumNode = (Node)forumHome.getSession().getItem(pSetting.getForumPath());
            Calendar newDate = this.getGreenwichMeanTime();
            newDate.setTimeInMillis(newDate.getTimeInMillis() - pSetting.getInActiveDay() * 86400000L);
            QueryManager qm = forumHome.getSession().getWorkspace().getQueryManager();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(forumNode.getPath()).append("//element(*,exo:topic)[ @exo:isActive='true' and @exo:lastPostDate <= xs:dateTime('").append(ISO8601.format((Calendar)newDate)).append("')]");
            Query query = qm.createQuery(stringBuffer.toString(), "xpath");
            QueryResult result = query.execute();
            long l = result.getNodes().getSize();
            return l;
        }
        catch (Exception e) {
            log.error((Object)"Failed to check prune", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return 0L;
    }

    private TopicType getTopicType(Node node) throws Exception {
        TopicType topicType = new TopicType();
        topicType.setId(node.getName());
        topicType.setName(node.getProperty("exo:name").getString());
        topicType.setIcon(node.getProperty("exo:icon").getString());
        return topicType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TopicType> getTopicTypes() throws Exception {
        ArrayList<TopicType> listTT = new ArrayList<TopicType>();
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node nodeHome = this.getTopicTypeHome(sProvider);
            NodeIterator iter = nodeHome.getNodes();
            while (iter.hasNext()) {
                Node node = iter.nextNode();
                listTT.add(this.getTopicType(node));
            }
        }
        catch (Exception exception) {
        }
        finally {
            sProvider.close();
        }
        return listTT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TopicType getTopicType(String Id) throws Exception {
        TopicType topicType = new TopicType();
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node nodeHome = this.getTopicTypeHome(sProvider);
            topicType = this.getTopicType(nodeHome.getNode(Id));
        }
        catch (Exception e) {
            topicType.setId(TopicType.DEFAULT_ID);
            topicType.setName("Default");
        }
        finally {
            sProvider.close();
        }
        return topicType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveTopicType(TopicType topicType) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node node;
            Node nodeHome = this.getTopicTypeHome(sProvider);
            try {
                node = nodeHome.getNode(topicType.getId());
            }
            catch (Exception e) {
                node = nodeHome.addNode(topicType.getId(), "exo:topicType");
                node.setProperty("exo:id", topicType.getId());
            }
            node.setProperty("exo:name", topicType.getName());
            node.setProperty("exo:icon", topicType.getIcon());
            if (nodeHome.isNew()) {
                nodeHome.getSession().save();
            } else {
                nodeHome.save();
            }
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTopicType(String topicTypeId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node nodeHome = this.getTopicTypeHome(sProvider);
            try {
                Node node = nodeHome.getNode(topicTypeId);
                node.remove();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (nodeHome.isNew()) {
                nodeHome.getSession().save();
            } else {
                nodeHome.save();
            }
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JCRPageList getPageTopicByType(String type) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            ForumPageList pagelist;
            Node categoryNode = this.getCategoryHome(sProvider);
            QueryManager qm = categoryNode.getSession().getWorkspace().getQueryManager();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/jcr:root").append(categoryNode.getPath()).append("//element(*,exo:topic)").append("[@topicType='").append(type).append("']").append(" order by @exo:createdDate descending");
            String pathQuery = stringBuffer.toString();
            Query query = qm.createQuery(pathQuery, "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ForumPageList forumPageList = pagelist = new ForumPageList(iter, 10, pathQuery, true);
            return forumPageList;
        }
        catch (Exception e) {
            log.error((Object)("Failed to get page topic by type: " + type), (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream createForumRss(String objectId, String link) throws Exception {
        ArrayList<SyndEntry> entries = new ArrayList<SyndEntry>();
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node node_ = null;
            if (objectId.indexOf(Utils.CATEGORY) == 0) {
                node_ = this.getNodeById(sProvider, objectId, Utils.CATEGORY);
                entries.addAll(this.categoryUpdated(node_));
            } else if (objectId.indexOf(Utils.FORUM) == 0) {
                node_ = this.getNodeById(sProvider, objectId, Utils.FORUM);
                entries.addAll(this.forumUpdated(node_));
            } else {
                node_ = this.getNodeById(sProvider, objectId, Utils.TOPIC);
                String link_ = node_.getProperty("exo:link").getString();
                link = Utils.isEmpty(link_) ? link : link_;
                entries.addAll(this.topicUpdated(node_));
            }
            SyndFeed feed = this.createNewFeed(node_, link);
            feed.setEntries(entries);
            SyndFeedOutput output = new SyndFeedOutput();
            String s = output.outputString(feed);
            s = StringUtils.replace((String)s, (String)"&amp;", (String)"&");
            s = s.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
            s = StringUtils.replace((String)s, (String)"ST[CDATA[", (String)"<![CDATA[");
            s = StringUtils.replace((String)s, (String)"END]]", (String)"]]>");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(s.getBytes());
            return byteArrayInputStream;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    private List<SyndEntry> categoryUpdated(Node cateNode) throws Exception {
        ArrayList<SyndEntry> entries = new ArrayList<SyndEntry>();
        NodeIterator iterator = cateNode.getNodes();
        while (iterator.hasNext()) {
            Node node = iterator.nextNode();
            if (!node.isNodeType("exo:forum") || node.getProperty("exo:isClosed").getBoolean()) continue;
            entries.addAll(this.forumUpdated(node));
        }
        return entries;
    }

    private List<SyndEntry> forumUpdated(Node forumNode) throws Exception {
        ArrayList<SyndEntry> entries = new ArrayList<SyndEntry>();
        try {
            QueryManager qm = forumNode.getSession().getWorkspace().getQueryManager();
            StringBuilder queryString = new StringBuilder("/jcr:root").append(forumNode.getPath()).append("//element(*,exo:topic)[@exo:isWaiting='false' and @exo:isActive='true' and @exo:isClosed='false' and (not(@exo:canView) or @exo:canView='' or @exo:canView=' ')]").append(" order by @exo:isSticky descending, @exo:lastPostDate descending");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                entries.addAll(this.topicUpdated(iter.nextNode()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return entries;
    }

    private List<SyndEntry> topicUpdated(Node topicNode) {
        ArrayList<SyndEntry> entries = new ArrayList<SyndEntry>();
        try {
            Node forumNode = topicNode.getParent();
            Node categoryNode = forumNode.getParent();
            boolean categoryHasRestrictedAudience = this.hasProperty(categoryNode, "exo:viewer");
            boolean forumHasRestrictedAudience = this.hasProperty(forumNode, "exo:viewer");
            String topicName = topicNode.getName();
            if (categoryHasRestrictedAudience || forumHasRestrictedAudience) {
                log.debug((Object)("Post" + topicName + " was not added to feed because category or forum has restricted audience"));
                return null;
            }
            QueryManager qm = topicNode.getSession().getWorkspace().getQueryManager();
            StringBuffer stringBuffer = new StringBuffer().append("/jcr:root").append(topicNode.getPath()).append("//element(*,exo:post)").append((CharSequence)Utils.getPathQuery("true", "false", " ")).append(" order by @exo:createdDate ascending");
            Query query = qm.createQuery(stringBuffer.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            Node postNode = null;
            while (iter.hasNext()) {
                postNode = iter.nextNode();
                try {
                    entries.add(this.postUpdated(postNode));
                }
                catch (Exception e) {
                    log.debug((Object)("Failed to generate feed for post " + postNode.getPath()), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return entries;
    }

    private SyndEntry postUpdated(Node postNode) throws Exception {
        Node topicNode = postNode.getParent();
        String postName = postNode.getName();
        PropertyReader post = new PropertyReader(postNode);
        PropertyReader topic = new PropertyReader(topicNode);
        boolean notApproved = post.bool("exo:isApproved") == false;
        boolean isPrivatePost = this.hasProperty(topicNode, "exo:userPrivate") && !"exoUserPri".equals(topic.strings("exo:userPrivate")[0]);
        boolean topicHasLimitedViewers = this.hasProperty(topicNode, "exo:canView");
        if (notApproved || isPrivatePost || topicHasLimitedViewers) {
            log.debug((Object)("Post" + postName + " was not added to feed because it is private or topic has restricted audience or it is waiting for approval"));
            return null;
        }
        Node forumNode = topicNode.getParent();
        Node categoryNode = forumNode.getParent();
        boolean categoryHasRestrictedAudience = this.hasProperty(categoryNode, "exo:viewer");
        boolean forumHasRestrictedAudience = this.hasProperty(forumNode, "exo:viewer");
        if (categoryHasRestrictedAudience || forumHasRestrictedAudience) {
            log.debug((Object)("Post" + postName + " was not added to feed because category or forum has restricted audience"));
            return null;
        }
        ArrayList<String> listContent = new ArrayList<String>();
        String message = post.string("exo:message");
        listContent.add(message);
        SyndContentImpl description = new SyndContentImpl();
        description.setType("text/plain");
        description.setValue("ST[CDATA[" + message + "END]]");
        String title = post.string("exo:name");
        Date created = post.date("exo:createdDate");
        String owner = post.string("exo:owner");
        String linkItem = post.string("exo:link");
        SyndEntry entry = this.createNewEntry(postName, title, linkItem, listContent, (SyndContent)description, created, owner);
        return entry;
    }

    private SyndFeed createNewFeed(Node node, String link) throws Exception {
        PropertyReader reader = new PropertyReader(node);
        String desc = reader.string("exo:description", " ");
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType("rss_2.0");
        feed.setTitle(reader.string("exo:name"));
        feed.setPublishedDate(reader.date("exo:createdDate", new Date()));
        feed.setLink(link);
        feed.setDescription("ST[CDATA[" + desc + "END]]");
        feed.setEncoding("UTF-8");
        return feed;
    }

    private SyndEntry createNewEntry(String uri, String title, String link, List<String> listContent, SyndContent description, Date pubDate, String author) {
        SyndEntryImpl entry = new SyndEntryImpl();
        entry.setUri(uri);
        entry.setTitle(title);
        entry.setLink(link);
        entry.setContributors(listContent);
        entry.setDescription(description);
        entry.setPublishedDate(pubDate);
        entry.setAuthor(author);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream createUserRss(String userId, String link) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<SyndEntry> entries = new ArrayList<SyndEntry>();
        try {
            Node node;
            Node subscriptionNode = this.getUserProfileHome(sProvider).getNode(userId + "/" + Utils.FORUM_SUBSCRIOTION + userId);
            PropertyReader reader = new PropertyReader(subscriptionNode);
            List cateIds = reader.list("exo:categoryIds", new ArrayList());
            for (String id : cateIds) {
                node = this.getNodeById(sProvider, id, Utils.CATEGORY);
                entries.addAll(this.categoryUpdated(node));
            }
            List forumIds = reader.list("exo:forumIds", new ArrayList());
            for (String id : forumIds) {
                node = this.getNodeById(sProvider, id, Utils.FORUM);
                if (cateIds.contains(node.getParent().getName())) continue;
                entries.addAll(this.forumUpdated(node));
            }
            List topicIds = reader.list("exo:topicIds", new ArrayList());
            for (String id : topicIds) {
                node = this.getNodeById(sProvider, id, Utils.TOPIC);
                if (forumIds.contains(node.getParent().getName())) continue;
                entries.addAll(this.topicUpdated(node));
            }
        }
        catch (Exception e) {
            log.error((Object)("Can not create feed data for user: " + userId), (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        try {
            SyndFeedImpl feed = new SyndFeedImpl();
            feed.setFeedType("rss_2.0");
            feed.setTitle("Forum subscriptions for " + userId);
            feed.setPublishedDate(new Date());
            feed.setLink(link);
            feed.setDescription(" ");
            feed.setEncoding("UTF-8");
            feed.setEntries(entries);
            SyndFeedOutput output = new SyndFeedOutput();
            String s = output.outputString((SyndFeed)feed);
            s = StringUtils.replace((String)s, (String)"&amp;", (String)"&");
            s = s.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
            s = StringUtils.replace((String)s, (String)"ST[CDATA[", (String)"<![CDATA[");
            s = StringUtils.replace((String)s, (String)"END]]", (String)"]]>");
            return new ByteArrayInputStream(s.getBytes());
        }
        catch (Exception e) {
            log.error((Object)("Can not create RSS for user: " + userId), (Throwable)e);
            return new ByteArrayInputStream(("Can not create RSS for user: " + userId + "<br/>" + e).getBytes());
        }
    }

    @Override
    public boolean populateUserProfile(User user, UserProfile profileTemplate, boolean isNew) throws Exception {
        boolean added = false;
        this.sessionManager.openSession();
        try {
            Node profile = null;
            Node profileHome = this.getUserProfileHome();
            String userName = user.getUserName();
            if (profileHome.hasNode(userName)) {
                if (isNew) {
                    log.warn((Object)("Request to add user " + userName + " was ignored because it already exists."));
                }
                profile = profileHome.getNode(userName);
                added = false;
            } else {
                profile = profileHome.addNode(userName, Utils.USER_PROFILES_TYPE);
                added = true;
            }
            Calendar cal = this.getGreenwichMeanTime();
            profile.setProperty("exo:userId", userName);
            profile.setProperty("exo:lastLoginDate", cal);
            profile.setProperty("exo:email", user.getEmail());
            profile.setProperty("exo:fullName", user.getFullName());
            cal.setTime(user.getCreatedDate());
            profile.setProperty("exo:joinedDate", cal);
            if (this.isAdminRole(userName)) {
                profile.setProperty("exo:userTitle", "Administrator");
                profile.setProperty("exo:userRole", 0L);
            } else {
                profile.setProperty("exo:userRole", 2L);
            }
            if (profileTemplate != null) {
                profile.setProperty("exo:timeZone", profileTemplate.getTimeZone());
                profile.setProperty("exo:shortDateformat", profileTemplate.getShortDateFormat());
                profile.setProperty("exo:longDateformat", profileTemplate.getLongDateFormat());
                profile.setProperty("exo:timeFormat", profileTemplate.getTimeFormat());
                profile.setProperty("exo:maxTopic", profileTemplate.getMaxTopicInPage().longValue());
                profile.setProperty("exo:maxPost", profileTemplate.getMaxPostInPage().longValue());
                profile.setProperty("exo:isShowForumJump", profileTemplate.getIsShowForumJump());
            }
            if (profileHome.isNew()) {
                profileHome.getSession().save();
            } else {
                profileHome.save();
            }
            boolean bl = added;
            return bl;
        }
        catch (Exception e) {
            log.error((Object)("Error while populating user profile: " + e.getMessage()));
            throw e;
        }
        finally {
            this.sessionManager.closeSession(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLatestUser() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node profileHome = this.getUserProfileHome(sProvider);
            if (profileHome.hasNodes()) {
                QueryManager qm = profileHome.getSession().getWorkspace().getQueryManager();
                StringBuilder pathQuery = new StringBuilder();
                pathQuery.append("/jcr:root").append(profileHome.getPath()).append("/element(*,exo:forumUserProfile) order by @exo:joinedDate descending");
                Query query = qm.createQuery(pathQuery.toString(), "xpath");
                QueryResult result = query.execute();
                NodeIterator iter = result.getNodes();
                if (iter.getSize() > 0L) {
                    Node node = iter.nextNode();
                    String string = node.getName();
                    return string;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLastLoginDate(String userId) throws Exception {
        SessionProvider sysProvider = SessionProvider.createSystemProvider();
        try {
            Node userProfileHome = this.getUserProfileHome(sysProvider);
            userProfileHome.getNode(userId).setProperty("exo:lastLoginDate", this.getGreenwichMeanTime());
            userProfileHome.save();
        }
        finally {
            sysProvider.close();
        }
    }

    @Override
    public List<Post> getNewPosts(int number) throws Exception {
        ArrayList<Post> list = null;
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        QueryManager qm = forumHomeNode.getSession().getWorkspace().getQueryManager();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/jcr:root").append(forumHomeNode.getPath()).append("//element(*,exo:post) [((@exo:isApproved='true') and (@exo:isHidden='false') and (@exo:isActiveByTopic='true') and (@exo:userPrivate='exoUserPri'))] order by @exo:createdDate descending");
        Query query = qm.createQuery(stringBuffer.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        int count = 0;
        while (iter.hasNext() && count++ < number) {
            if (list == null) {
                list = new ArrayList<Post>();
            }
            list.add(this.getPost(iter.nextNode()));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteUserProfile(String userId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node profileDeleted;
            Node profileHome = this.getUserProfileHome(sProvider);
            Node profile = profileHome.getNode(userId);
            Session session = profileHome.getSession();
            profile.setProperty("exo:userRole", 4L);
            profile.setProperty("exo:userTitle", "User deleted");
            profile.setProperty("exo:moderateCategory", new String[0]);
            profile.setProperty("exo:moderateForums", new String[0]);
            profile.save();
            String id = userId + Utils.DELETED;
            try {
                profileDeleted = profileHome.getNode(Utils.USER_PROFILE_DELETED);
                long index = profileDeleted.getNodes().getSize();
                if (index > 0L) {
                    id = id + index;
                }
            }
            catch (Exception e) {
                profileDeleted = profileHome.addNode(Utils.USER_PROFILE_DELETED, "exo:userDeleted");
                session.save();
                this.deletedUserCalculateListener(profileDeleted);
            }
            session.getWorkspace().move(profile.getPath(), profileDeleted.getPath() + "/" + id);
            try {
                Node avatarHome = session.getRootNode().getNode(this.dataLocator.getAvatarsLocation());
                if (avatarHome.hasNode(userId)) {
                    avatarHome.getNode(userId).remove();
                }
            }
            catch (Exception e) {
                log.info((Object)"User deleted has not avatar !!!");
            }
            session.save();
        }
        catch (PathNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            sProvider.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void calculateDeletedUser(String userName) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        String tempUserName = userName;
        userName = tempUserName.substring(0, tempUserName.indexOf(Utils.DELETED));
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            String[] strs = new String[]{"exo:owner", "exo:modifiedBy", "exo:lastPostBy", "exo:userPrivate", "exo:moderators", "exo:poster", "exo:viewer", "exo:canPost", "exo:canView", "exo:userWatching", "exo:rssWatching"};
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < strs.length; ++i) {
                if (i > 0) {
                    builder.append(" or ");
                }
                builder.append("(@").append(strs[i]).append("='").append(userName).append("')");
            }
            StringBuilder pathQuery = new StringBuilder();
            pathQuery.append("/jcr:root").append(categoryHome.getPath()).append("//*[").append((CharSequence)builder).append("]");
            Query query = qm.createQuery(pathQuery.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                Node node = iter.nextNode();
                if (!node.isNodeType("exo:forumCategory") && !node.isNodeType("exo:forum") && !node.isNodeType("exo:topic") && !node.isNodeType("exo:post")) continue;
                for (int i = 0; i < strs.length; ++i) {
                    if (i < 3) {
                        if (!new PropertyReader(node).string(strs[i], "").equals(userName)) continue;
                        node.setProperty(strs[i], tempUserName);
                        continue;
                    }
                    PropertyReader reader = new PropertyReader(node);
                    List list = reader.list(strs[i], new ArrayList());
                    if (!list.contains(userName)) continue;
                    if (strs[i].equals("exo:userWatching")) {
                        try {
                            int t = list.indexOf(userName);
                            List list2 = reader.list("exo:emailWatching", new ArrayList());
                            list2.remove(t);
                            node.setProperty("exo:emailWatching", list2.toArray(new String[list2.size()]));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    list.remove(userName);
                    node.setProperty(strs[i], list.toArray(new String[list.size()]));
                }
            }
            if (categoryHome.isNew()) {
                categoryHome.getSession().save();
            } else {
                categoryHome.save();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to calculate deleting user.", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    @Override
    public List<InitializeForumPlugin> getDefaultPlugins() {
        return this.defaultPlugins;
    }

    @Override
    public List<RoleRulesPlugin> getRulesPlugins() {
        return this.rulesPlugins;
    }

    @Override
    public Map<String, String> getServerConfig() {
        return this.serverConfig;
    }

    @Override
    public KSDataLocation getDataLocation() {
        return this.dataLocator;
    }

    public void setDataLocator(KSDataLocation dataLocator) {
        this.dataLocator = dataLocator;
        this.sessionManager = dataLocator.getSessionManager();
        this.repository = dataLocator.getRepository();
        this.workspace = dataLocator.getWorkspace();
        log.info((Object)("JCR Data Storage for forum initialized to " + dataLocator));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SaveAvatarTask
    implements JCRTask<Boolean> {
        String userId;
        ForumAttachment fileAttachment;

        public SaveAvatarTask(String userId, ForumAttachment fileAttachment) {
            this.userId = userId;
            this.fileAttachment = fileAttachment;
        }

        public Boolean execute(Session session) throws Exception {
            Node ksAvatarHomnode = JCRDataStorage.this.getKSUserAvatarHomeNode();
            Node avatarNode = null;
            Boolean wasNew = false;
            if (ksAvatarHomnode.hasNode(this.userId)) {
                avatarNode = ksAvatarHomnode.getNode(this.userId);
            } else {
                avatarNode = ksAvatarHomnode.addNode(this.userId, "nt:file");
                wasNew = true;
            }
            ForumServiceUtils.reparePermissions(avatarNode, "any");
            Node nodeContent = null;
            nodeContent = avatarNode.hasNode("jcr:content") ? avatarNode.getNode("jcr:content") : avatarNode.addNode("jcr:content", "nt:resource");
            nodeContent.setProperty("jcr:mimeType", this.fileAttachment.getMimeType());
            nodeContent.setProperty("jcr:data", this.fileAttachment.getInputStream());
            nodeContent.setProperty("jcr:lastModified", Calendar.getInstance().getTimeInMillis());
            return wasNew;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LoadAvatarTask
    implements JCRTask<ForumAttachment> {
        String username;

        public LoadAvatarTask(String username) {
            this.username = username;
        }

        public ForumAttachment execute(Session session) throws Exception {
            Node ksAvatarHomnode = JCRDataStorage.this.getKSUserAvatarHomeNode();
            ArrayList<JCRForumAttachment> attachments = new ArrayList<JCRForumAttachment>();
            if (ksAvatarHomnode.hasNode(this.username)) {
                Node node = ksAvatarHomnode.getNode(this.username);
                Node nodeFile = null;
                String workspace = "";
                if (node.isNodeType("nt:file")) {
                    JCRForumAttachment attachment = new JCRForumAttachment();
                    nodeFile = node.getNode("jcr:content");
                    attachment.setId(node.getName());
                    attachment.setPathNode(node.getPath());
                    attachment.setMimeType(nodeFile.getProperty("jcr:mimeType").getString());
                    attachment.setName("avatar." + attachment.getMimeType());
                    workspace = node.getSession().getWorkspace().getName();
                    attachment.setWorkspace(workspace);
                    attachment.setPath("/" + workspace + node.getPath());
                    try {
                        if (nodeFile.hasProperty("jcr:data")) {
                            attachment.setSize(nodeFile.getProperty("jcr:data").getStream().available());
                        } else {
                            attachment.setSize(0L);
                        }
                        attachments.add(attachment);
                        return (ForumAttachment)attachments.get(0);
                    }
                    catch (Exception e) {
                        attachment.setSize(0L);
                        log.debug((Object)"Failed to execute avatar of user", (Throwable)e);
                    }
                }
                return null;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ResetAvatarTask
    implements JCRTask<Boolean> {
        String username;

        public ResetAvatarTask(String username) {
            this.username = username;
        }

        public Boolean execute(Session session) throws Exception {
            Node node;
            Boolean wasReset = false;
            Node ksAvatarHomnode = JCRDataStorage.this.getKSUserAvatarHomeNode();
            if (ksAvatarHomnode.hasNode(this.username) && (node = ksAvatarHomnode.getNode(this.username)).isNodeType("nt:file")) {
                node.remove();
                ksAvatarHomnode.save();
                wasReset = true;
            }
            return wasReset;
        }
    }
}

