/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.box;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.box.AbstractBoxMacro;
import org.xwiki.rendering.macro.box.BoxMacroParameters;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.util.ParserUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="box")
public class DefaultBoxMacro<P extends BoxMacroParameters>
extends AbstractBoxMacro<P> {
    private static final String DESCRIPTION = "Draw a box around provided content.";
    private static final String CONTENT_DESCRIPTION = "the content to put in the box";

    public DefaultBoxMacro() {
        super("Box", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION), BoxMacroParameters.class);
        this.setDefaultCategory("Formatting");
    }

    @Override
    protected List<Block> parseContent(P parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        return this.parseSourceSyntax(content, context);
    }

    protected List<Block> parseSourceSyntax(String content, MacroTransformationContext context) throws MacroExecutionException {
        Parser parser = this.getSyntaxParser(context);
        try {
            List blocks = parser.parse((Reader)new StringReader(content)).getChildren();
            if (context.isInline()) {
                ParserUtils parseUtils = new ParserUtils();
                parseUtils.removeTopLevelParagraph(blocks);
            }
            return blocks;
        }
        catch (ParseException e) {
            throw new MacroExecutionException("Failed to parse content [" + content + "] with Syntax parser [" + parser.getSyntax() + "]", (Throwable)e);
        }
    }
}

