/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.macro.box;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.ImageBlock;
import org.xwiki.rendering.block.NewLineBlock;
import org.xwiki.rendering.block.ParagraphBlock;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.Image;
import org.xwiki.rendering.listener.URLImage;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.box.BoxMacroParameters;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.transformation.MacroTransformationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBoxMacro<P extends BoxMacroParameters>
extends AbstractMacro<P> {
    @Requirement
    private ComponentManager componentManager;

    protected AbstractBoxMacro(String name, String description, ContentDescriptor contentDescriptor, Class<?> parametersBeanClass) {
        super(name, description, contentDescriptor, parametersBeanClass);
    }

    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public List<Block> execute(P parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        String imageParameter = ((BoxMacroParameters)parameters).getImage();
        String titleParameter = ((BoxMacroParameters)parameters).getTitle();
        List<? extends Block> titleBlockList = ((BoxMacroParameters)parameters).getBlockTitle();
        LinkedHashMap<String, String> boxParameters = new LinkedHashMap<String, String>();
        String classParameter = ((BoxMacroParameters)parameters).getCssClass();
        String cssClass = StringUtils.isEmpty((String)classParameter) ? this.getClassProperty() : this.getClassProperty() + " " + classParameter;
        boxParameters.put("class", cssClass);
        if (!StringUtils.isEmpty((String)((BoxMacroParameters)parameters).getWidth())) {
            boxParameters.put("style", "width:" + ((BoxMacroParameters)parameters).getWidth());
        }
        if (content != null) {
            GroupBlock boxBlock;
            if (context.isInline()) {
                List<Block> contentBlocks = this.parseContent(parameters, content, context);
                FormatBlock spanBlock = new FormatBlock(contentBlocks, Format.NONE);
                spanBlock.setParameters(boxParameters);
                boxBlock = spanBlock;
            } else {
                boxBlock = new GroupBlock(boxParameters);
                if (!StringUtils.isEmpty((String)imageParameter)) {
                    URLImage image = new URLImage(imageParameter);
                    ImageBlock imageBlock = new ImageBlock((Image)image, true);
                    boxBlock.addChild((Block)imageBlock);
                    boxBlock.addChild((Block)NewLineBlock.NEW_LINE_BLOCK);
                }
                if (!StringUtils.isEmpty((String)titleParameter)) {
                    Parser parser = this.getSyntaxParser(context);
                    List<Block> titleBlocks = this.parseTitle(parser, titleParameter);
                    boxBlock.addChildren(titleBlocks);
                }
                if (titleBlockList != null) {
                    boxBlock.addChildren(titleBlockList);
                }
                List<Block> contentBlocks = this.parseContent(parameters, content, context);
                boxBlock.addChildren(contentBlocks);
            }
            return Collections.singletonList(boxBlock);
        }
        return Collections.emptyList();
    }

    private List<Block> parseTitle(Parser parser, String titleParameter) throws MacroExecutionException {
        try {
            List children;
            List titleBlocks = parser.parse((Reader)new StringReader(titleParameter)).getChildren();
            if (titleBlocks.size() == 1 && titleBlocks.get(0) instanceof ParagraphBlock && (children = ((Block)titleBlocks.get(0)).getChildren()).size() > 0) {
                titleBlocks = children;
            }
            return titleBlocks;
        }
        catch (ParseException e) {
            throw new MacroExecutionException("Failed to parse the box's title [" + titleParameter + "]", (Throwable)e);
        }
    }

    protected abstract List<Block> parseContent(P var1, String var2, MacroTransformationContext var3) throws MacroExecutionException;

    protected Parser getSyntaxParser(MacroTransformationContext context) throws MacroExecutionException {
        try {
            return (Parser)this.getComponentManager().lookup(Parser.class, context.getSyntax().toIdString());
        }
        catch (ComponentLookupException e) {
            throw new MacroExecutionException("Failed to find source parser for syntax [" + context.getSyntax() + "]", (Throwable)e);
        }
    }

    protected String getClassProperty() {
        return "box";
    }
}

