/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link.ui;

import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.LinkWizard.LinkWizardStep;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * Specialized {@link AbstractExplorerWizardStep} to select an attachment to a wiki page.
 * 
 * @version $Id: AttachmentExplorerWizardStep.java 28844 2010-05-12 13:22:39Z mflorea $
 */
public class AttachmentExplorerWizardStep extends AbstractExplorerWizardStep
{
    /**
     * Creates a new attachment selection wizard step that allows the user to select an attachment from a tree.
     * 
     * @param wikiService the service to be used for getting information about the selected attachments
     */
    public AttachmentExplorerWizardStep(WikiServiceAsync wikiService)
    {
        // Reduce the size to fit the toggling bar of the attachment selector step which aggregates this step.
        // FIXME: This wizard step should be usable w/o the aggregating step. Also having size information added in more
        // than one single place is bad.
        super(wikiService, false, true, true, 455, 280);

        setStepTitle(Strings.INSTANCE.linkSelectAttachmentTitle());
        setHelpLabelText(Strings.INSTANCE.linkSelectAttachmentHelpLabel());
    }

    /**
     * {@inheritDoc}
     */
    public String getNextStep()
    {
        return getExplorer().isNewAttachment() ? LinkWizardStep.ATTACHMENT_UPLOAD.toString()
            : LinkWizardStep.WIKI_PAGE_CONFIG.toString();
    }

    /**
     * {@inheritDoc}
     */
    public void onSubmit(AsyncCallback<Boolean> async)
    {
        hideError();

        EntityReference attachmentReference = new EntityReference();
        attachmentReference.setType(getData().getDestination().getType());
        attachmentReference.setWikiName(getExplorer().getSelectedWiki());
        attachmentReference.setSpaceName(getExplorer().getSelectedSpace());
        attachmentReference.setPageName(getExplorer().getSelectedPage());
        attachmentReference.setFileName(getExplorer().getSelectedAttachment());

        if (getExplorer().isNewAttachment()) {
            getData().setDestination(attachmentReference);
            // Invalidate the explorer cache so that the new attachment shows up in the tree when the tree is reloaded.
            invalidateExplorerData();
            async.onSuccess(true);
        } else if (!StringUtils.isEmpty(attachmentReference.getFileName())) {
            if (getData().getDestination().equals(attachmentReference)) {
                async.onSuccess(true);
            } else {
                updateLinkConfig(attachmentReference, async);
            }
        } else {
            displayError(Strings.INSTANCE.linkNoAttachmentSelectedError());
            async.onSuccess(false);
        }
    }
}
