/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.mapping;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.chromattic.api.NameConflictResolution;
import org.chromattic.api.annotations.AutoCreated;
import org.chromattic.api.annotations.DefaultValue;
import org.chromattic.api.annotations.FormattedBy;
import org.chromattic.api.annotations.Id;
import org.chromattic.api.annotations.Mandatory;
import org.chromattic.api.annotations.ManyToOne;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.MixinType;
import org.chromattic.api.annotations.Name;
import org.chromattic.api.annotations.NamingPolicy;
import org.chromattic.api.annotations.NamingPrefix;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.Owner;
import org.chromattic.api.annotations.Path;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Properties;
import org.chromattic.api.annotations.Property;
import org.chromattic.api.annotations.WorkspaceName;
import org.chromattic.common.collection.Collections;
import org.chromattic.metamodel.bean.BeanFilter;
import org.chromattic.metamodel.bean.BeanInfo;
import org.chromattic.metamodel.bean.BeanInfoBuilder;
import org.chromattic.metamodel.bean.BeanValueInfo;
import org.chromattic.metamodel.bean.MultiValueKind;
import org.chromattic.metamodel.bean.MultiValuedPropertyInfo;
import org.chromattic.metamodel.bean.PropertyInfo;
import org.chromattic.metamodel.bean.SimpleValueInfo;
import org.chromattic.metamodel.bean.SingleValuedPropertyInfo;
import org.chromattic.metamodel.bean.ValueInfo;
import org.chromattic.metamodel.mapping.AttributeMapping;
import org.chromattic.metamodel.mapping.BeanMapping;
import org.chromattic.metamodel.mapping.Constants;
import org.chromattic.metamodel.mapping.CreateMapping;
import org.chromattic.metamodel.mapping.DestroyMapping;
import org.chromattic.metamodel.mapping.FindByIdMapping;
import org.chromattic.metamodel.mapping.InvalidMappingException;
import org.chromattic.metamodel.mapping.MethodMapping;
import org.chromattic.metamodel.mapping.NodeAttributeType;
import org.chromattic.metamodel.mapping.NodeTypeKind;
import org.chromattic.metamodel.mapping.PropertiesMapping;
import org.chromattic.metamodel.mapping.PropertyMapping;
import org.chromattic.metamodel.mapping.RelationshipMapping;
import org.chromattic.metamodel.mapping.ValueMapping;
import org.chromattic.metamodel.mapping.jcr.PropertyDefinitionMapping;
import org.chromattic.metamodel.mapping.jcr.PropertyMetaType;
import org.chromattic.metamodel.type.SimpleTypeMapping;
import org.chromattic.metamodel.type.SimpleTypeResolver;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.MethodInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.TypeResolver;
import org.reflext.api.VoidTypeInfo;
import org.reflext.api.annotation.AnnotationInfo;
import org.reflext.api.annotation.AnnotationParameterInfo;
import org.reflext.api.annotation.AnnotationType;
import org.reflext.api.introspection.AnnotationTarget;
import org.reflext.api.introspection.MethodIntrospector;
import org.reflext.api.visit.HierarchyScope;
import org.reflext.core.TypeResolverImpl;
import org.reflext.jlr.JavaLangReflectReflectionModel;
import org.reflext.spi.model.ReflectionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanMappingBuilder {
    private final TypeResolver<Type> domain = TypeResolverImpl.create((ReflectionModel)JavaLangReflectReflectionModel.getInstance());
    private final ClassTypeInfo FORMATTED_BY = (ClassTypeInfo)this.domain.resolve(FormattedBy.class);
    private final AnnotationType<AnnotationInfo, ?> FORMATTED_BY_ANNOTATION_TYPE = AnnotationType.get((ClassTypeInfo)this.FORMATTED_BY);
    private final SimpleTypeResolver simpleTypeResolver;

    public BeanMappingBuilder() {
        this(new SimpleTypeResolver());
    }

    public BeanMappingBuilder(SimpleTypeResolver simpleTypeResolver) {
        this.simpleTypeResolver = simpleTypeResolver;
    }

    public Map<ClassTypeInfo, BeanMapping> build(ClassTypeInfo ... classTypes) {
        return this.build(Collections.set((Object[])classTypes));
    }

    public Map<ClassTypeInfo, BeanMapping> build(Set<ClassTypeInfo> classTypes) {
        classTypes = new HashSet<ClassTypeInfo>(classTypes);
        final AtomicReference objectCTI = new AtomicReference();
        BeanFilter filter = new BeanFilter(){

            public boolean accept(ClassTypeInfo cti) {
                boolean accept = false;
                if (cti.getName().equals(Object.class.getName())) {
                    objectCTI.set(cti);
                    accept = true;
                } else {
                    accept |= cti.getDeclaredAnnotation(AnnotationType.get(PrimaryType.class)) != null;
                    accept |= cti.getDeclaredAnnotation(AnnotationType.get(MixinType.class)) != null;
                }
                return accept;
            }
        };
        Map<ClassTypeInfo, BeanInfo> beans = new BeanInfoBuilder(this.simpleTypeResolver, filter).build(classTypes);
        Context ctx = new Context(new SimpleTypeResolver(), new HashSet<BeanInfo>(beans.values()));
        if (objectCTI.get() != null) {
            BeanInfo objectBean = beans.remove(objectCTI.get());
            BeanMapping objectMapping = new BeanMapping(objectBean, NodeTypeKind.PRIMARY, "nt:base", NameConflictResolution.FAIL, null, false, true, null);
            ctx.beanMappings.put(objectBean, objectMapping);
            ctx.beans.remove(objectBean);
        }
        Map<BeanInfo, BeanMapping> beanMappings = ctx.build();
        new OneToOneHierarchicRelationshipResolver(beanMappings).resolve();
        new OneToManyHierarchicRelationshipResolver(beanMappings).resolve();
        new ManyToOneHierarchicRelationshipResolver(beanMappings).resolve();
        new OneToManyReferenceRelationshipResolver(beanMappings).resolve();
        new ManyToOneReferenceRelationshipResolver(beanMappings).resolve();
        HashMap<ClassTypeInfo, BeanMapping> classTypeMappings = new HashMap<ClassTypeInfo, BeanMapping>();
        for (Map.Entry<BeanInfo, BeanMapping> beanMapping : beanMappings.entrySet()) {
            classTypeMappings.put(beanMapping.getKey().getClassType(), beanMapping.getValue());
        }
        return classTypeMappings;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Context {
        final SimpleTypeResolver typeResolver;
        final Map<ClassTypeInfo, BeanInfo> beanClassTypeMap;
        final Set<BeanInfo> beans;
        final Map<BeanInfo, BeanMapping> beanMappings;

        private Context(SimpleTypeResolver typeResolver, Set<BeanInfo> beans) {
            HashMap<ClassTypeInfo, BeanInfo> beanClassTypeMap = new HashMap<ClassTypeInfo, BeanInfo>();
            for (BeanInfo bean : beans) {
                beanClassTypeMap.put(bean.getClassType(), bean);
            }
            this.typeResolver = typeResolver;
            this.beanClassTypeMap = beanClassTypeMap;
            this.beans = beans;
            this.beanMappings = new HashMap<BeanInfo, BeanMapping>();
        }

        public Map<BeanInfo, BeanMapping> build() {
            Iterator<BeanInfo> iterator;
            while ((iterator = this.beans.iterator()).hasNext()) {
                BeanInfo bean = iterator.next();
                this.resolve(bean);
            }
            return this.beanMappings;
        }

        private BeanMapping resolve(ClassTypeInfo classType) {
            BeanInfo bean = this.beanClassTypeMap.get(classType);
            if (bean != null) {
                return this.resolve(bean);
            }
            return null;
        }

        private BeanMapping resolve(BeanInfo bean) {
            BeanMapping mapping = this.beanMappings.get(bean);
            if (mapping == null && this.beans.remove(bean)) {
                mapping = this.create(bean);
                this.beanMappings.put(bean, mapping);
                this.build(mapping);
            }
            return mapping;
        }

        private BeanMapping create(BeanInfo bean) {
            boolean abstract_;
            boolean orderable;
            String nodeTypeName;
            NodeTypeKind nodeTypeKind;
            Collection<? extends Annotation> annotations = bean.getAnnotations(PrimaryType.class, MixinType.class);
            if (annotations.size() != 1) {
                throw new InvalidMappingException(bean.getClassType(), "Class is not annotated with a primary type of mixin type");
            }
            Annotation mappingAnnotation = annotations.iterator().next();
            NameConflictResolution onDuplicate = NameConflictResolution.FAIL;
            NamingPolicy namingPolicy = bean.getAnnotation(NamingPolicy.class);
            if (namingPolicy != null) {
                onDuplicate = namingPolicy.onDuplicate();
            }
            ClassTypeInfo formatter = null;
            AnnotationInfo formattedBy = (AnnotationInfo)bean.getAnnotation(BeanMappingBuilder.this.FORMATTED_BY_ANNOTATION_TYPE);
            if (formattedBy != null) {
                AnnotationParameterInfo valueParameter = formattedBy.getParameter("value");
                formatter = (ClassTypeInfo)valueParameter.getValue();
            }
            NamingPrefix namingPrefix = bean.getAnnotation(NamingPrefix.class);
            String prefix = null;
            if (namingPrefix != null) {
                prefix = namingPrefix.value();
            }
            if (mappingAnnotation instanceof PrimaryType) {
                PrimaryType typeAnnotation = (PrimaryType)mappingAnnotation;
                nodeTypeKind = NodeTypeKind.PRIMARY;
                nodeTypeName = typeAnnotation.name();
                orderable = typeAnnotation.orderable();
                abstract_ = typeAnnotation.abstract_();
            } else {
                MixinType typeAnnotation = (MixinType)mappingAnnotation;
                nodeTypeKind = NodeTypeKind.MIXIN;
                nodeTypeName = typeAnnotation.name();
                orderable = false;
                abstract_ = true;
            }
            return new BeanMapping(bean, nodeTypeKind, nodeTypeName, onDuplicate, formatter, orderable, abstract_, prefix);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void build(BeanMapping beanMapping) {
            ClassTypeInfo argCTI;
            TypeInfo argTI;
            List parameterTypes;
            MethodInfo method;
            BeanInfo bean = beanMapping.bean;
            if (bean.getParent() != null) {
                beanMapping.parent = this.resolve(bean.getParent());
            }
            HashMap<String, void> properties = new HashMap<String, void>();
            for (PropertyInfo<?> propertyInfo : bean.getProperties().values()) {
                void var7_10;
                Collection<Annotation> annotations = propertyInfo.getAnnotations(Property.class, Properties.class, OneToOne.class, OneToMany.class, ManyToOne.class, Id.class, Path.class, Name.class, WorkspaceName.class);
                if (annotations.size() > 1) {
                    throw new UnsupportedOperationException();
                }
                Object var7_11 = null;
                if (annotations.size() == 1) {
                    Property propertyAnnotation;
                    Annotation annotation = annotations.iterator().next();
                    Object value = propertyInfo.getValue();
                    if (propertyInfo instanceof SingleValuedPropertyInfo) {
                        if (value instanceof SimpleValueInfo) {
                            if (annotation instanceof Property) {
                                propertyAnnotation = (Property)annotation;
                                PropertyMapping<SingleValuedPropertyInfo, SimpleValueInfo> propertyMapping = this.createProperty(propertyAnnotation, (SingleValuedPropertyInfo)propertyInfo);
                            } else if (annotation instanceof Id) {
                                AttributeMapping attributeMapping = this.createAttribute((SingleValuedPropertyInfo)propertyInfo, NodeAttributeType.ID);
                            } else if (annotation instanceof Path) {
                                AttributeMapping attributeMapping = this.createAttribute((SingleValuedPropertyInfo)propertyInfo, NodeAttributeType.PATH);
                            } else if (annotation instanceof Name) {
                                AttributeMapping attributeMapping = this.createAttribute((SingleValuedPropertyInfo)propertyInfo, NodeAttributeType.NAME);
                            } else {
                                if (!(annotation instanceof WorkspaceName)) throw new InvalidMappingException(bean.getClassType(), "The property " + propertyInfo + " is not annotated");
                                AttributeMapping attributeMapping = this.createAttribute((SingleValuedPropertyInfo)propertyInfo, NodeAttributeType.WORKSPACE_NAME);
                            }
                        } else {
                            if (!(value instanceof BeanValueInfo)) throw new AssertionError();
                            if (annotation instanceof OneToOne) {
                                OneToOne oneToOne = (OneToOne)annotation;
                                switch (oneToOne.type()) {
                                    case HIERARCHIC: {
                                        RelationshipMapping.OneToOne.Hierarchic hierarchic = this.createHierarchicOneToOne(beanMapping, oneToOne, (SingleValuedPropertyInfo)propertyInfo);
                                        break;
                                    }
                                    case EMBEDDED: {
                                        RelationshipMapping.OneToOne.Embedded embedded = this.createEmbeddedOneToOne((SingleValuedPropertyInfo)propertyInfo);
                                        break;
                                    }
                                    default: {
                                        throw new UnsupportedOperationException();
                                    }
                                }
                            } else {
                                if (!(annotation instanceof ManyToOne)) throw new UnsupportedOperationException();
                                ManyToOne manyToOne = (ManyToOne)annotation;
                                switch (manyToOne.type()) {
                                    case HIERARCHIC: {
                                        RelationshipMapping.ManyToOne.Hierarchic hierarchic = this.createHierarchicManyToOne(beanMapping, manyToOne, (SingleValuedPropertyInfo)propertyInfo);
                                        break;
                                    }
                                    case PATH: 
                                    case REFERENCE: {
                                        RelationshipMapping.ManyToOne.Reference reference = this.createReferenceManyToOne(manyToOne, (SingleValuedPropertyInfo)propertyInfo);
                                        break;
                                    }
                                    default: {
                                        throw new UnsupportedOperationException();
                                    }
                                }
                            }
                        }
                    } else {
                        if (!(propertyInfo instanceof MultiValuedPropertyInfo)) throw new AssertionError();
                        if (value instanceof SimpleValueInfo) {
                            if (annotation instanceof Property) {
                                propertyAnnotation = (Property)annotation;
                                PropertyMapping<MultiValuedPropertyInfo, SimpleValueInfo> propertyMapping = this.createProperty(propertyAnnotation, (MultiValuedPropertyInfo)propertyInfo);
                            } else {
                                if (!(annotation instanceof Properties)) throw new InvalidMappingException(bean.getClassType(), "No annotation found on property " + propertyInfo);
                                PropertiesMapping propertiesMapping = this.createProperties((MultiValuedPropertyInfo)propertyInfo);
                            }
                        } else {
                            if (!(value instanceof BeanValueInfo)) throw new AssertionError();
                            if (annotation instanceof OneToMany) {
                                OneToMany oneToMany = (OneToMany)annotation;
                                switch (oneToMany.type()) {
                                    case HIERARCHIC: {
                                        RelationshipMapping.OneToMany.Hierarchic hierarchic = this.createHierarchicOneToMany(beanMapping, oneToMany, (MultiValuedPropertyInfo)propertyInfo);
                                        break;
                                    }
                                    case PATH: 
                                    case REFERENCE: {
                                        RelationshipMapping.OneToMany.Reference reference = this.createReferenceOneToMany(oneToMany, (MultiValuedPropertyInfo)propertyInfo);
                                        break;
                                    }
                                    default: {
                                        throw new UnsupportedOperationException();
                                    }
                                }
                            } else {
                                if (!(annotation instanceof Properties)) throw new InvalidMappingException(bean.getClassType(), "The property " + propertyInfo + " should be annotated with " + OneToMany.class.getName());
                                PropertiesMapping propertiesMapping = this.createProperties((MultiValuedPropertyInfo)propertyInfo);
                            }
                        }
                    }
                }
                if (var7_10 == null) continue;
                PropertyInfo parentProperty = propertyInfo.getParent();
                if (parentProperty != null) {
                    BeanInfo ancestor = parentProperty.getOwner();
                    BeanMapping ancestorMapping = this.resolve(ancestor);
                    var7_10.parent = ancestorMapping.properties.get(parentProperty.getName());
                }
                properties.put(((PropertyInfo)var7_10.property).getName(), var7_10);
            }
            beanMapping.properties.putAll(properties);
            for (PropertyMapping propertyMapping : beanMapping.properties.values()) {
                propertyMapping.owner = beanMapping;
            }
            MethodIntrospector introspector = new MethodIntrospector(HierarchyScope.ALL);
            HashSet<MethodMapping> hashSet = new HashSet<MethodMapping>();
            for (AnnotationTarget annotationTarget : introspector.resolveMethods(bean.getClassType(), Constants.CREATE)) {
                ClassTypeInfo returnTypeInfo;
                method = (MethodInfo)annotationTarget.getTarget();
                if (method.isStatic()) continue;
                parameterTypes = method.getParameterTypes();
                if (parameterTypes.size() >= 2) throw new IllegalStateException();
                if (parameterTypes.size() == 1) {
                    argTI = (TypeInfo)parameterTypes.get(0);
                    if (!(argTI instanceof ClassTypeInfo)) throw new IllegalStateException();
                    argCTI = (ClassTypeInfo)argTI;
                    if (!argCTI.getName().equals(String.class.getName())) {
                        throw new IllegalStateException();
                    }
                }
                if ((returnTypeInfo = bean.resolveToClass(method.getReturnType())) == null) throw new InvalidMappingException(bean.getClassType(), "Invalid " + method + " method return type " + returnTypeInfo);
                BeanMapping createBeanMapping = this.resolve(returnTypeInfo);
                if (createBeanMapping == null) {
                    throw new InvalidMappingException(bean.getClassType(), "Could not resolve the return type " + returnTypeInfo + " to a chromattic bean among beans " + this.beans + " and mappings " + this.beanMappings.values());
                }
                hashSet.add(new CreateMapping(method, createBeanMapping));
            }
            for (AnnotationTarget annotationTarget : introspector.resolveMethods(bean.getClassType(), Constants.DESTROY)) {
                method = (MethodInfo)annotationTarget.getTarget();
                if (method.isStatic()) continue;
                parameterTypes = method.getParameterTypes();
                if (parameterTypes.size() != 0) {
                    throw new IllegalStateException();
                }
                if (!(method.getReturnType() instanceof VoidTypeInfo)) {
                    throw new IllegalStateException();
                }
                hashSet.add(new DestroyMapping(method));
            }
            for (AnnotationTarget annotationTarget : introspector.resolveMethods(bean.getClassType(), Constants.FIND_BY_ID)) {
                method = (MethodInfo)annotationTarget.getTarget();
                if (method.isStatic() || (parameterTypes = method.getParameterTypes()).size() != 1) continue;
                argTI = (TypeInfo)parameterTypes.get(0);
                if (!(argTI instanceof ClassTypeInfo)) throw new IllegalStateException();
                argCTI = (ClassTypeInfo)argTI;
                if (!argCTI.getName().equals(String.class.getName())) throw new IllegalStateException();
                ClassTypeInfo cti = (ClassTypeInfo)bean.getClassType().resolve(method.getReturnType());
                hashSet.add(new FindByIdMapping(method, cti));
            }
            beanMapping.methods.addAll(hashSet);
        }

        private AttributeMapping createAttribute(SingleValuedPropertyInfo<SimpleValueInfo> property, NodeAttributeType type) {
            TypeInfo effectiveType = ((SimpleValueInfo)property.getValue()).getEffectiveType();
            if (!(effectiveType instanceof ClassTypeInfo)) {
                throw new UnsupportedOperationException();
            }
            ClassTypeInfo effectiveClassType = (ClassTypeInfo)effectiveType;
            if (!effectiveClassType.getName().equals(String.class.getName())) {
                throw new UnsupportedOperationException();
            }
            return new AttributeMapping(property, type);
        }

        private <V extends ValueInfo> PropertiesMapping<V> createProperties(MultiValuedPropertyInfo<V> property) {
            if (property.getKind() != MultiValueKind.MAP) {
                throw new UnsupportedOperationException();
            }
            TypeInfo type = ((ValueInfo)property.getValue()).getEffectiveType();
            PropertyMetaType<?> mt = null;
            if (type.getName().equals(Object.class.getName())) {
                mt = null;
            } else {
                SimpleTypeMapping stm = this.typeResolver.resolveType(type);
                if (stm == null) {
                    throw new InvalidMappingException(property.getOwner().getClassType(), "Cannot map type " + type + " as properties");
                }
                mt = stm.getPropertyMetaType();
            }
            return new PropertiesMapping<V>(property, mt);
        }

        private <P extends PropertyInfo<SimpleValueInfo>> PropertyMapping<P, SimpleValueInfo> createProperty(Property propertyAnnotation, P property) {
            PropertyMetaType<?> propertyMetaType = PropertyMetaType.get(propertyAnnotation.type());
            SimpleTypeMapping abc = this.typeResolver.resolveType(property.getValue().getDeclaredType(), propertyMetaType);
            if (abc == null) {
                throw new UnsupportedOperationException("No simple type mapping for " + property.getValue().getDeclaredType());
            }
            List<String> defaultValueList = null;
            DefaultValue defaultValueAnnotation = property.getAnnotation(DefaultValue.class);
            if (defaultValueAnnotation != null) {
                String[] defaultValues = defaultValueAnnotation.value();
                defaultValueList = new ArrayList<String>(defaultValues.length);
                defaultValueList.addAll(Arrays.asList(defaultValues));
                defaultValueList = java.util.Collections.unmodifiableList(defaultValueList);
            }
            PropertyDefinitionMapping propertyDefinition = new PropertyDefinitionMapping(propertyAnnotation.name(), abc.getPropertyMetaType(), defaultValueList, false);
            if (property instanceof SingleValuedPropertyInfo) {
                return new ValueMapping.Single((SingleValuedPropertyInfo)property, propertyDefinition);
            }
            if (property instanceof MultiValuedPropertyInfo) {
                return new ValueMapping.Multi((MultiValuedPropertyInfo)property, propertyDefinition);
            }
            throw new AssertionError();
        }

        private RelationshipMapping.OneToMany.Reference createReferenceOneToMany(OneToMany annotation, MultiValuedPropertyInfo<BeanValueInfo> property) {
            MappedBy mappedBy = property.getAnnotation(MappedBy.class);
            if (mappedBy == null) {
                throw new UnsupportedOperationException();
            }
            RelationshipMapping.OneToMany.Reference mapping = new RelationshipMapping.OneToMany.Reference(property, mappedBy.value(), annotation.type());
            mapping.relatedBeanMapping = this.resolve(((BeanValueInfo)property.getValue()).getBean());
            return mapping;
        }

        private RelationshipMapping.OneToMany.Hierarchic createHierarchicOneToMany(BeanMapping beanMapping, OneToMany annotation, MultiValuedPropertyInfo<BeanValueInfo> property) {
            NamingPrefix namingPrefix = property.getAnnotation(NamingPrefix.class);
            String declaredPrefix = namingPrefix != null ? namingPrefix.value() : null;
            String prefix = declaredPrefix == null ? beanMapping.getPrefix() : declaredPrefix;
            RelationshipMapping.OneToMany.Hierarchic mapping = new RelationshipMapping.OneToMany.Hierarchic(property, declaredPrefix, prefix);
            mapping.relatedBeanMapping = this.resolve(((BeanValueInfo)property.getValue()).getBean());
            return mapping;
        }

        private RelationshipMapping.ManyToOne.Reference createReferenceManyToOne(ManyToOne annotation, SingleValuedPropertyInfo<BeanValueInfo> property) {
            MappedBy mappedBy = property.getAnnotation(MappedBy.class);
            if (mappedBy == null) {
                throw new UnsupportedOperationException();
            }
            RelationshipMapping.ManyToOne.Reference mapping = new RelationshipMapping.ManyToOne.Reference(property, mappedBy.value(), annotation.type());
            mapping.relatedBeanMapping = this.resolve(((BeanValueInfo)property.getValue()).getBean());
            return mapping;
        }

        private RelationshipMapping.ManyToOne.Hierarchic createHierarchicManyToOne(BeanMapping beanMapping, ManyToOne annotation, SingleValuedPropertyInfo<BeanValueInfo> property) {
            NamingPrefix namingPrefix = property.getAnnotation(NamingPrefix.class);
            String declaredPrefix = namingPrefix != null ? namingPrefix.value() : null;
            String prefix = declaredPrefix == null ? beanMapping.getPrefix() : declaredPrefix;
            RelationshipMapping.ManyToOne.Hierarchic mapping = new RelationshipMapping.ManyToOne.Hierarchic(property, declaredPrefix, prefix);
            mapping.relatedBeanMapping = this.resolve(((BeanValueInfo)property.getValue()).getBean());
            return mapping;
        }

        private RelationshipMapping.OneToOne.Embedded createEmbeddedOneToOne(SingleValuedPropertyInfo<BeanValueInfo> property) {
            boolean owner = property.getAnnotation(Owner.class) != null;
            RelationshipMapping.OneToOne.Embedded mapping = new RelationshipMapping.OneToOne.Embedded(property, owner);
            mapping.relatedBeanMapping = this.resolve(((BeanValueInfo)property.getValue()).getBean());
            return mapping;
        }

        private RelationshipMapping.OneToOne.Hierarchic createHierarchicOneToOne(BeanMapping beanMapping, OneToOne annotation, SingleValuedPropertyInfo<BeanValueInfo> property) {
            String localName;
            String declaredPrefix;
            MappedBy mappedBy = property.getAnnotation(MappedBy.class);
            if (mappedBy == null) {
                throw new UnsupportedOperationException();
            }
            boolean owner = property.getAnnotation(Owner.class) != null;
            boolean autocreated = property.getAnnotation(AutoCreated.class) != null;
            boolean mandatory = property.getAnnotation(Mandatory.class) != null;
            int index = mappedBy.value().indexOf(58);
            if (index == -1) {
                declaredPrefix = null;
                localName = mappedBy.value();
            } else {
                declaredPrefix = mappedBy.value().substring(0, index);
                localName = mappedBy.value().substring(index + 1);
            }
            String prefix = declaredPrefix == null ? beanMapping.getPrefix() : declaredPrefix;
            RelationshipMapping.OneToOne.Hierarchic mapping = new RelationshipMapping.OneToOne.Hierarchic(property, owner, declaredPrefix, prefix, localName, mandatory, autocreated);
            mapping.relatedBeanMapping = this.resolve(((BeanValueInfo)property.getValue()).getBean());
            return mapping;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ManyToOneReferenceRelationshipResolver
    extends RelationshipResolver<RelationshipMapping.ManyToOne.Reference, RelationshipMapping.OneToMany.Reference> {
        private ManyToOneReferenceRelationshipResolver(Map<BeanInfo, BeanMapping> beanMappings) {
            super(RelationshipMapping.ManyToOne.Reference.class, RelationshipMapping.OneToMany.Reference.class, beanMappings);
        }

        @Override
        protected boolean resolves(RelationshipMapping.ManyToOne.Reference from, RelationshipMapping.OneToMany.Reference to) {
            return from.getMappedBy().equals(to.getMappedBy());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OneToManyReferenceRelationshipResolver
    extends RelationshipResolver<RelationshipMapping.OneToMany.Reference, RelationshipMapping.ManyToOne.Reference> {
        private OneToManyReferenceRelationshipResolver(Map<BeanInfo, BeanMapping> beanMappings) {
            super(RelationshipMapping.OneToMany.Reference.class, RelationshipMapping.ManyToOne.Reference.class, beanMappings);
        }

        @Override
        protected boolean resolves(RelationshipMapping.OneToMany.Reference from, RelationshipMapping.ManyToOne.Reference to) {
            return from.getMappedBy().equals(to.getMappedBy());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ManyToOneHierarchicRelationshipResolver
    extends RelationshipResolver<RelationshipMapping.ManyToOne.Hierarchic, RelationshipMapping.OneToMany.Hierarchic> {
        private ManyToOneHierarchicRelationshipResolver(Map<BeanInfo, BeanMapping> beanMappings) {
            super(RelationshipMapping.ManyToOne.Hierarchic.class, RelationshipMapping.OneToMany.Hierarchic.class, beanMappings);
        }

        @Override
        protected boolean resolves(RelationshipMapping.ManyToOne.Hierarchic from, RelationshipMapping.OneToMany.Hierarchic to) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OneToManyHierarchicRelationshipResolver
    extends RelationshipResolver<RelationshipMapping.OneToMany.Hierarchic, RelationshipMapping.ManyToOne.Hierarchic> {
        private OneToManyHierarchicRelationshipResolver(Map<BeanInfo, BeanMapping> beanMappings) {
            super(RelationshipMapping.OneToMany.Hierarchic.class, RelationshipMapping.ManyToOne.Hierarchic.class, beanMappings);
        }

        @Override
        protected boolean resolves(RelationshipMapping.OneToMany.Hierarchic from, RelationshipMapping.ManyToOne.Hierarchic to) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OneToOneHierarchicRelationshipResolver
    extends RelationshipResolver<RelationshipMapping.OneToOne.Hierarchic, RelationshipMapping.OneToOne.Hierarchic> {
        private OneToOneHierarchicRelationshipResolver(Map<BeanInfo, BeanMapping> beanMappings) {
            super(RelationshipMapping.OneToOne.Hierarchic.class, RelationshipMapping.OneToOne.Hierarchic.class, beanMappings);
        }

        @Override
        protected boolean resolves(RelationshipMapping.OneToOne.Hierarchic from, RelationshipMapping.OneToOne.Hierarchic to) {
            String fromPrefix = from.getPrefix() == null ? "" : from.getPrefix();
            String toPrefix = to.getPrefix() == null ? "" : to.getPrefix();
            return fromPrefix.equals(toPrefix) && from.getLocalName().equals(to.getLocalName()) && from.owner != to.owner;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class RelationshipResolver<F extends RelationshipMapping<?, T>, T extends RelationshipMapping<?, F>> {
        final Class<F> fromClass;
        final Class<T> toClass;
        Map<BeanInfo, BeanMapping> beanMappings;

        protected RelationshipResolver(Class<F> fromClass, Class<T> toClass, Map<BeanInfo, BeanMapping> beanMappings) {
            this.fromClass = fromClass;
            this.toClass = toClass;
            this.beanMappings = beanMappings;
        }

        void resolve() {
            for (BeanMapping beanMapping : this.beanMappings.values()) {
                block1: for (PropertyMapping<?, ?> propertyMapping : beanMapping.getProperties().values()) {
                    if (!(propertyMapping instanceof RelationshipMapping)) continue;
                    RelationshipMapping relationshipMapping = (RelationshipMapping)propertyMapping;
                    BeanInfo relatedBean = relationshipMapping.getRelatedBean();
                    BeanMapping relatedBeanMapping = this.beanMappings.get(relatedBean);
                    if (!this.fromClass.isInstance(relationshipMapping)) continue;
                    RelationshipMapping fromRelationship = (RelationshipMapping)this.fromClass.cast(relationshipMapping);
                    for (PropertyMapping<?, ?> relatedBeanPropertyMapping : relatedBeanMapping.getProperties().values()) {
                        RelationshipMapping toRelationship;
                        RelationshipMapping relatedBeanRelationshipMapping;
                        if (!(relatedBeanPropertyMapping instanceof RelationshipMapping) || !this.toClass.isInstance(relatedBeanRelationshipMapping = (RelationshipMapping)relatedBeanPropertyMapping) || fromRelationship == (toRelationship = (RelationshipMapping)this.toClass.cast(relatedBeanRelationshipMapping)) || !this.resolves(fromRelationship, toRelationship)) continue;
                        if (relationshipMapping.relatedRelationshipMapping != null) {
                            throw new UnsupportedOperationException();
                        }
                        fromRelationship.relatedRelationshipMapping = toRelationship;
                        continue block1;
                    }
                }
            }
        }

        protected abstract boolean resolves(F var1, T var2);
    }
}

