/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.mapping.jcr;

import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyMetaType<T> {
    public static final PropertyMetaType<String> STRING = new PropertyMetaType<String>(String.class, 1){

        @Override
        public Value getValue(ValueFactory factory, String s) throws ValueFormatException {
            return factory.createValue(s, 1);
        }

        @Override
        public String getValue(Value value) throws RepositoryException {
            return value.getString();
        }
    };
    public static final PropertyMetaType<String> PATH = new PropertyMetaType<String>(String.class, 8){

        @Override
        public Value getValue(ValueFactory factory, String s) throws ValueFormatException {
            return factory.createValue(s, 8);
        }

        @Override
        public String getValue(Value value) throws RepositoryException {
            return value.getString();
        }
    };
    public static final PropertyMetaType<String> NAME = new PropertyMetaType<String>(String.class, 7){

        @Override
        public Value getValue(ValueFactory factory, String s) throws ValueFormatException {
            return factory.createValue(s, 7);
        }

        @Override
        public String getValue(Value value) throws RepositoryException {
            return value.getString();
        }
    };
    public static final PropertyMetaType<Long> LONG = new PropertyMetaType<Long>(Long.class, 3){

        @Override
        public Value getValue(ValueFactory factory, Long aLong) throws ValueFormatException {
            return factory.createValue(aLong.longValue());
        }

        @Override
        public Long getValue(Value value) throws RepositoryException {
            return value.getLong();
        }
    };
    public static final PropertyMetaType<Double> DOUBLE = new PropertyMetaType<Double>(Double.class, 4){

        @Override
        public Value getValue(ValueFactory factory, Double aDouble) throws ValueFormatException {
            return factory.createValue(aDouble.doubleValue());
        }

        @Override
        public Double getValue(Value value) throws RepositoryException {
            return value.getDouble();
        }
    };
    public static final PropertyMetaType<Boolean> BOOLEAN = new PropertyMetaType<Boolean>(Boolean.class, 6){

        @Override
        public Value getValue(ValueFactory factory, Boolean aBoolean) throws ValueFormatException {
            return factory.createValue(aBoolean.booleanValue());
        }

        @Override
        public Boolean getValue(Value value) throws RepositoryException {
            return value.getBoolean();
        }
    };
    public static final PropertyMetaType<InputStream> BINARY = new PropertyMetaType<InputStream>(InputStream.class, 2){

        @Override
        public Value getValue(ValueFactory factory, InputStream inputStream) throws ValueFormatException {
            return factory.createValue(inputStream);
        }

        @Override
        public InputStream getValue(Value value) throws RepositoryException {
            return value.getStream();
        }
    };
    public static final PropertyMetaType<Calendar> DATE = new PropertyMetaType<Calendar>(Calendar.class, 5){

        @Override
        public Value getValue(ValueFactory factory, Calendar date) throws ValueFormatException {
            return factory.createValue(date);
        }

        @Override
        public Calendar getValue(Value value) throws RepositoryException {
            return value.getDate();
        }
    };
    private static final PropertyMetaType<?>[] ALL = new PropertyMetaType[]{STRING, PATH, NAME, LONG, DOUBLE, BOOLEAN, BINARY, DATE};
    private final Class<T> javaType;
    private final int code;

    public static PropertyMetaType<?> get(int code) {
        for (PropertyMetaType<?> pt : ALL) {
            if (pt.code != code) continue;
            return pt;
        }
        return null;
    }

    private PropertyMetaType(Class<T> javaType, int code) {
        this.javaType = javaType;
        this.code = code;
    }

    public abstract Value getValue(ValueFactory var1, T var2) throws ValueFormatException;

    public abstract T getValue(Value var1) throws RepositoryException;

    public Class<T> getJavaType() {
        return this.javaType;
    }

    public int getCode() {
        return this.code;
    }
}

