/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import org.exoplatform.container.BaseContainerLifecyclePlugin;
import org.exoplatform.container.ContainerLifecyclePlugin;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rpc.RPCException;
import org.exoplatform.services.rpc.RPCService;
import org.exoplatform.services.rpc.RemoteCommand;
import org.exoplatform.services.rpc.TopologyChangeEvent;
import org.exoplatform.services.rpc.TopologyChangeListener;

public class RepositoryCreationSynchronizer {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.RepositoryCreationSynchronizer");
    private final RPCService rpcService;
    private RemoteCommand needToInitWorkspaceCommand;
    private RemoteCommand shouldIWaitCommand;
    private boolean needToInitWorkspace;
    private final CountDownLatch lock = new CountDownLatch(1);
    private final boolean disabled;

    public RepositoryCreationSynchronizer(ExoContainerContext ctx) {
        this(null, ctx, null);
    }

    public RepositoryCreationSynchronizer(final RPCService rpcService, ExoContainerContext ctx, InitParams params) {
        this.rpcService = rpcService;
        boolean bl = this.disabled = rpcService == null || params != null && params.getValueParam("disabled") != null && Boolean.valueOf(params.getValueParam("disabled").getValue()) != false;
        if (this.disabled && LOG.isDebugEnabled()) {
            LOG.debug((Object)"The RepositoryCreationSynchronizer has been disabled");
        }
        if (rpcService != null) {
            this.shouldIWaitCommand = rpcService.registerCommand(new RemoteCommand(){

                public String getId() {
                    return "exo.jcr.component.core.RepositoryCreationSynchronizer-shouldIWaitCommand";
                }

                public Serializable execute(Serializable[] args) throws Throwable {
                    return Boolean.valueOf(RepositoryCreationSynchronizer.this.shouldIWait());
                }
            });
            this.needToInitWorkspaceCommand = rpcService.registerCommand(new RemoteCommand(){

                public String getId() {
                    return "exo.jcr.component.core.RepositoryCreationSynchronizer-needToInitWorkspaceCommand";
                }

                public Serializable execute(Serializable[] args) throws Throwable {
                    RepositoryCreationSynchronizer.this.needToInitWorkspace();
                    return null;
                }
            });
            final RemoteCommand releaseCommand = rpcService.registerCommand(new RemoteCommand(){

                public String getId() {
                    return "exo.jcr.component.core.RepositoryCreationSynchronizer-releaseCommand";
                }

                public Serializable execute(Serializable[] args) throws Throwable {
                    RepositoryCreationSynchronizer.this.release();
                    return null;
                }
            });
            ctx.getContainer().addContainerLifecylePlugin((ContainerLifecyclePlugin)new BaseContainerLifecyclePlugin(){

                public void startContainer(ExoContainer container) throws Exception {
                    if (RepositoryCreationSynchronizer.this.needToInitWorkspace) {
                        RepositoryCreationSynchronizer.this.needToInitWorkspace = false;
                        try {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"Release the other cluster nodes if needed.");
                            }
                            rpcService.executeCommandOnAllNodes(releaseCommand, false, new Serializable[0]);
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Could not release all the nodes", (Throwable)e);
                        }
                    }
                }
            });
            rpcService.registerTopologyChangeListener(new TopologyChangeListener(){

                public void onChange(TopologyChangeEvent event) {
                    if (event.isCoordinator()) {
                        RepositoryCreationSynchronizer.this.release();
                    }
                }
            });
        }
    }

    public void waitForApproval(boolean isWorkspaceInitialized) {
        if (this.disabled) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"The RepositoryCreationSynchronizer has been disabled so no need to make it wait.");
            }
            return;
        }
        if (this.rpcService == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"No RPCService has been defined so we assume that we are in a non cluster environment so no need to make it wait.");
            }
            return;
        }
        if (!isWorkspaceInitialized) {
            this.needToInitWorkspace();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Notify all the nodes that there is at least one workspace to initialize.");
            }
            try {
                this.rpcService.executeCommandOnAllNodes(this.needToInitWorkspaceCommand, false, new Serializable[0]);
            }
            catch (Exception e) {
                LOG.warn((Object)"Could not notify all the nodes that there is at least one workspace to initialize.", (Throwable)e);
            }
        }
        if (this.lock.getCount() <= 0L) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"We already have been released so no need to make it wait.");
            }
            return;
        }
        try {
            if (!this.needToInitWorkspace && isWorkspaceInitialized) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Ask the coordinator if the local node needs to wait.");
                }
                Object result = this.rpcService.executeCommandOnCoordinator(this.shouldIWaitCommand, 0L, new Serializable[0]);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("The response from the coordinator was " + result));
                }
                if (result instanceof Boolean && ((Boolean)result).booleanValue()) {
                    this.waitForCoordinator();
                }
            } else {
                this.waitForCoordinator();
            }
        }
        catch (RPCException e) {
            LOG.warn((Object)"An error occured while executing the method waitForApproval()", (Throwable)e);
        }
    }

    private void waitForCoordinator() {
        LOG.info((Object)"Waiting to be released by the coordinator");
        try {
            this.lock.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private boolean shouldIWait() {
        return this.needToInitWorkspace;
    }

    private void needToInitWorkspace() {
        this.needToInitWorkspace = true;
    }

    private void release() {
        if (this.lock.getCount() > 0L) {
            LOG.info((Object)"The local node has been released.");
            this.lock.countDown();
        }
    }
}

