/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.lock.infinispan;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.jcr.config.LockManagerEntry;
import org.exoplatform.services.jcr.config.MappedParametrizedObjectEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.SimpleParameterEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.core.lock.LockRemoverHolder;
import org.exoplatform.services.jcr.impl.core.lock.cacheable.AbstractCacheableLockManager;
import org.exoplatform.services.jcr.impl.core.lock.cacheable.CacheableSessionLockManager;
import org.exoplatform.services.jcr.impl.core.lock.cacheable.LockData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.jcr.impl.storage.jdbc.DBConstants;
import org.exoplatform.services.jcr.impl.storage.jdbc.DialectDetecter;
import org.exoplatform.services.jcr.impl.storage.jdbc.backup.Backupable;
import org.exoplatform.services.jcr.infinispan.ISPNCacheFactory;
import org.exoplatform.services.jcr.infinispan.PrivilegedISPNCacheHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.exoplatform.services.transaction.TransactionService;
import org.infinispan.Cache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Managed
@NameTemplate(value={@Property(key="service", value="lockmanager")})
public class ISPNCacheableLockManagerImpl
extends AbstractCacheableLockManager
implements Backupable {
    public static final String INFINISPAN_JDBC_CL_DATASOURCE = "infinispan-cl-cache.jdbc.datasource";
    public static final String INFINISPAN_JDBC_CL_DATA_COLUMN = "infinispan-cl-cache.jdbc.data.type";
    public static final String INFINISPAN_JDBC_CL_TIMESTAMP_COLUMN = "infinispan-cl-cache.jdbc.timestamp.type";
    public static final String INFINISPAN_JDBC_CL_ID_COLUMN = "infinispan-cl-cache.jdbc.id.type";
    public static final String INFINISPAN_JDBC_TABLE_NAME = "infinispan-cl-cache.jdbc.table.name";
    public static final String INFINISPAN_JDBC_CL_AUTO = "auto";
    private final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.InfinispanLockManagerImpl");
    private Cache<Serializable, Object> cache;

    public ISPNCacheableLockManagerImpl(WorkspacePersistentDataManager dataManager, WorkspaceEntry config, InitialContextInitializer context, TransactionService transactionService, ConfigurationManager cfm, LockRemoverHolder lockRemoverHolder) throws RepositoryConfigurationException, RepositoryException {
        this(dataManager, config, context, transactionService.getTransactionManager(), cfm, lockRemoverHolder);
    }

    public ISPNCacheableLockManagerImpl(WorkspacePersistentDataManager dataManager, WorkspaceEntry config, InitialContextInitializer context, ConfigurationManager cfm, LockRemoverHolder lockRemoverHolder) throws RepositoryConfigurationException, RepositoryException {
        this(dataManager, config, context, (TransactionManager)null, cfm, lockRemoverHolder);
    }

    public ISPNCacheableLockManagerImpl(WorkspacePersistentDataManager dataManager, WorkspaceEntry config, InitialContextInitializer context, TransactionManager transactionManager, ConfigurationManager cfm, LockRemoverHolder lockRemoverHolder) throws RepositoryConfigurationException, RepositoryException {
        super(dataManager, config, transactionManager, lockRemoverHolder);
        if (config.getLockManager() == null) {
            throw new RepositoryConfigurationException("Cache configuration not found");
        }
        ISPNCacheFactory factory = new ISPNCacheFactory(cfm);
        this.configureJDBCCacheLoader(config.getLockManager());
        this.cache = factory.createCache("Lock-" + config.getUniqueName(), config.getLockManager());
        context.recall();
        this.getNumLocks = new AbstractCacheableLockManager.LockActionNonTxAware<Integer, Object>(){

            @Override
            public Integer execute(Object arg) {
                return ISPNCacheableLockManagerImpl.this.cache.size();
            }
        };
        this.hasLocks = new AbstractCacheableLockManager.LockActionNonTxAware<Boolean, Object>(){

            @Override
            public Boolean execute(Object arg) {
                return !ISPNCacheableLockManagerImpl.this.cache.isEmpty();
            }
        };
        this.isLockLive = new AbstractCacheableLockManager.LockActionNonTxAware<Boolean, String>(){

            @Override
            public Boolean execute(String nodeId) {
                return ISPNCacheableLockManagerImpl.this.cache.containsKey((Object)nodeId);
            }
        };
        this.refresh = new AbstractCacheableLockManager.LockActionNonTxAware<Object, LockData>(){

            @Override
            public Object execute(LockData newLockData) throws LockException {
                Object oldValue = PrivilegedISPNCacheHelper.put((Cache<Serializable, Object>)ISPNCacheableLockManagerImpl.this.cache, (Serializable)((Object)newLockData.getNodeIdentifier()), newLockData);
                if (oldValue == null) {
                    throw new LockException("Can't refresh lock for node " + newLockData.getNodeIdentifier() + " since lock is not exist");
                }
                return null;
            }
        };
        this.lockExist = this.isLockLive;
        this.getLockDataById = new AbstractCacheableLockManager.LockActionNonTxAware<LockData, String>(){

            @Override
            public LockData execute(String nodeId) throws LockException {
                return (LockData)ISPNCacheableLockManagerImpl.this.cache.get((Object)nodeId);
            }
        };
        this.getLockList = new AbstractCacheableLockManager.LockActionNonTxAware<List<LockData>, Object>(){

            @Override
            public List<LockData> execute(Object arg) throws LockException {
                Collection datas = ISPNCacheableLockManagerImpl.this.cache.values();
                ArrayList<LockData> locksData = new ArrayList<LockData>();
                for (Object lockData : datas) {
                    if (lockData == null) continue;
                    locksData.add((LockData)lockData);
                }
                return locksData;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureJDBCCacheLoader(MappedParametrizedObjectEntry parameterEntry) throws RepositoryException {
        String dataSourceName = parameterEntry.getParameterValue(INFINISPAN_JDBC_CL_DATASOURCE, null);
        if (dataSourceName != null) {
            String dialect;
            block31: {
                try {
                    final DataSource dataSource = (DataSource)new InitialContext().lookup(dataSourceName);
                    if (dataSource == null) {
                        throw new RepositoryException("DataSource (" + dataSourceName + ") can't be null");
                    }
                    Connection jdbcConn = null;
                    try {
                        PrivilegedExceptionAction<Connection> action = new PrivilegedExceptionAction<Connection>(){

                            @Override
                            public Connection run() throws Exception {
                                return dataSource.getConnection();
                            }
                        };
                        try {
                            jdbcConn = AccessController.doPrivileged(action);
                        }
                        catch (PrivilegedActionException pae) {
                            Throwable cause = pae.getCause();
                            if (cause instanceof SQLException) {
                                throw (SQLException)cause;
                            }
                            if (cause instanceof RuntimeException) {
                                throw (RuntimeException)cause;
                            }
                            throw new RuntimeException(cause);
                        }
                        dialect = DialectDetecter.detect(jdbcConn.getMetaData());
                        Object var10_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_11 = null;
                        if (jdbcConn != null && !jdbcConn.isClosed()) {
                            try {
                                jdbcConn.close();
                            }
                            catch (SQLException e) {
                                throw new RepositoryException("Error of connection close", (Throwable)e);
                            }
                        }
                        throw throwable;
                    }
                    if (jdbcConn == null || jdbcConn.isClosed()) break block31;
                    try {
                        jdbcConn.close();
                    }
                    catch (SQLException e) {
                        throw new RepositoryException("Error of connection close", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    throw new RepositoryException("Error configuring JDBC cache loader", (Throwable)e);
                }
            }
            String blobType = "BLOB";
            String charType = "VARCHAR(512)";
            String timeStampType = "BIGINT";
            if (dialect.equals(DBConstants.DB_DIALECT_HSQLDB)) {
                blobType = "OBJECT";
            } else if (dialect.equals(DBConstants.DB_DIALECT_MYSQL) || dialect.equals(DBConstants.DB_DIALECT_MYSQL_UTF8)) {
                blobType = "LONGBLOB";
            } else if (dialect.equals(DBConstants.DB_DIALECT_ORACLE) || dialect.equals(DBConstants.DB_DIALECT_ORACLEOCI)) {
                charType = "VARCHAR2(512)";
                timeStampType = "NUMBER(19, 0)";
            } else if (dialect.equals(DBConstants.DB_DIALECT_PGSQL)) {
                blobType = "bytea";
            } else if (dialect.equals(DBConstants.DB_DIALECT_MSSQL)) {
                blobType = "VARBINARY(MAX)";
            } else if (dialect.equals(DBConstants.DB_DIALECT_SYBASE)) {
                blobType = "IMAGE";
            } else if (dialect.equals(DBConstants.DB_DIALECT_INGRES)) {
                blobType = "long byte";
            }
            if (parameterEntry.getParameterValue(INFINISPAN_JDBC_CL_DATA_COLUMN, INFINISPAN_JDBC_CL_AUTO).equalsIgnoreCase(INFINISPAN_JDBC_CL_AUTO)) {
                parameterEntry.putParameterValue(INFINISPAN_JDBC_CL_DATA_COLUMN, blobType);
            }
            if (parameterEntry.getParameterValue(INFINISPAN_JDBC_CL_ID_COLUMN, INFINISPAN_JDBC_CL_AUTO).equalsIgnoreCase(INFINISPAN_JDBC_CL_AUTO)) {
                parameterEntry.putParameterValue(INFINISPAN_JDBC_CL_ID_COLUMN, charType);
            }
            if (parameterEntry.getParameterValue(INFINISPAN_JDBC_CL_TIMESTAMP_COLUMN, INFINISPAN_JDBC_CL_AUTO).equalsIgnoreCase(INFINISPAN_JDBC_CL_AUTO)) {
                parameterEntry.putParameterValue(INFINISPAN_JDBC_CL_TIMESTAMP_COLUMN, timeStampType);
            }
        } else {
            this.LOG.warn((Object)"CacheLoader DataSource infinispan-cl-cache.jdbc.datasource is not configured.");
        }
    }

    @Override
    public void stop() {
        super.stop();
        PrivilegedISPNCacheHelper.stop(this.cache);
    }

    @Override
    protected synchronized void internalLock(String sessionId, String nodeIdentifier) throws LockException {
        CacheableSessionLockManager session = (CacheableSessionLockManager)this.sessionLockManagers.get(sessionId);
        if (session != null && session.containsPendingLock(nodeIdentifier)) {
            LockData lockData = session.getPendingLock(nodeIdentifier);
            LockData oldLockData = (LockData)PrivilegedISPNCacheHelper.putIfAbsent(this.cache, (Serializable)((Object)nodeIdentifier), lockData);
            if (oldLockData != null) {
                throw new LockException("Unable to write LockData. Node [" + lockData.getNodeIdentifier() + "] already has LockData!");
            }
        } else {
            throw new LockException("No lock in pending locks");
        }
        session.notifyLockPersisted(nodeIdentifier);
    }

    @Override
    protected synchronized void internalUnLock(String sessionId, String nodeIdentifier) throws LockException {
        LockData lData = this.getLockDataById(nodeIdentifier);
        if (lData != null) {
            this.cache.remove((Object)nodeIdentifier);
            CacheableSessionLockManager sessMgr = (CacheableSessionLockManager)this.sessionLockManagers.get(sessionId);
            if (sessMgr != null) {
                sessMgr.notifyLockRemoved(nodeIdentifier);
            }
        }
    }

    @Override
    protected List<String> getTableNames() {
        ArrayList<String> tableNames = new ArrayList<String>();
        LockManagerEntry lockManagerEntry = this.config.getLockManager();
        if (lockManagerEntry != null) {
            for (SimpleParameterEntry entry : lockManagerEntry.getParameters()) {
                if (!entry.getName().equals(INFINISPAN_JDBC_TABLE_NAME)) continue;
                tableNames.add(entry.getValue());
                return tableNames;
            }
        }
        return tableNames;
    }

    @Override
    protected String getDatasourceName() {
        LockManagerEntry lockManagerEntry = this.config.getLockManager();
        if (lockManagerEntry != null) {
            for (SimpleParameterEntry entry : lockManagerEntry.getParameters()) {
                if (!entry.getName().equals(INFINISPAN_JDBC_CL_DATASOURCE)) continue;
                return entry.getValue();
            }
        }
        return null;
    }
}

