/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype.registration;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeValuesList;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.NodeTypeConverter;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.NodeTypeDataPersister;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.UpdateNodeTypeObserver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlNodeTypeDataPersister
implements NodeTypeDataPersister {
    private final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.XmlNodeTypeDataPersister");
    private final NodeTypeConverter converter;
    private final InputStream is;
    private final OutputStream os;

    public XmlNodeTypeDataPersister(NodeTypeConverter converter, InputStream is) {
        this.converter = converter;
        this.is = is;
        this.os = null;
    }

    public XmlNodeTypeDataPersister(NodeTypeConverter converter, InputStream is, OutputStream os) {
        this.converter = converter;
        this.is = is;
        this.os = os;
    }

    public XmlNodeTypeDataPersister(NodeTypeConverter converter, OutputStream os) {
        this.converter = converter;
        this.os = os;
        this.is = null;
    }

    @Override
    public void addNodeType(NodeTypeData nodeType) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    @Override
    public boolean hasNodeType(InternalQName nodeTypeName) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    @Override
    public boolean isStorageFilled() {
        return true;
    }

    @Override
    public void addNodeTypes(List<NodeTypeData> nodeTypes) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    @Override
    public void removeNodeType(NodeTypeData nodeType) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void start() {
    }

    public void stop() {
    }

    @Override
    public List<NodeTypeData> getAllNodeTypes() throws RepositoryException {
        try {
            IBindingFactory factory = null;
            PrivilegedExceptionAction<IBindingFactory> action = new PrivilegedExceptionAction<IBindingFactory>(){

                @Override
                public IBindingFactory run() throws Exception {
                    return BindingDirectory.getFactory(NodeTypeValuesList.class);
                }
            };
            try {
                factory = AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof JiBXException) {
                    throw (JiBXException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
            IUnmarshallingContext uctx = factory.createUnmarshallingContext();
            NodeTypeValuesList nodeTypeValuesList = (NodeTypeValuesList)uctx.unmarshalDocument(this.is, null);
            ArrayList ntvList = nodeTypeValuesList.getNodeTypeValuesList();
            return this.converter.convertFromValueToData(ntvList);
        }
        catch (JiBXException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public void update(List<NodeTypeData> nodeTypes, UpdateNodeTypeObserver observer) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    @Override
    public NodeTypeData getNodeType(InternalQName nodeTypeName) throws RepositoryException {
        return null;
    }
}

