/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.impl.core.query.lucene.AbstractIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.DocNumberCache;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexListener;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexMigration;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexingQueue;
import org.exoplatform.services.jcr.impl.core.query.lucene.ReadOnlyIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.directory.DirectoryManager;

class PersistentIndex
extends AbstractIndex {
    private final String name;
    private IndexListener listener;

    PersistentIndex(String name, Analyzer analyzer, Similarity similarity, DocNumberCache cache, IndexingQueue indexingQueue, final DirectoryManager directoryManager) throws IOException {
        super(analyzer, similarity, directoryManager.getDirectory(name), cache, indexingQueue);
        this.name = name;
        if (this.isExisting()) {
            SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    IndexMigration.migrate(PersistentIndex.this, directoryManager);
                    return null;
                }
            });
        }
    }

    int removeDocument(Term idTerm) throws IOException {
        int num = super.removeDocument(idTerm);
        if (num > 0 && this.listener != null) {
            this.listener.documentDeleted(idTerm);
        }
        return num;
    }

    void addIndexes(final IndexReader[] readers) throws IOException {
        SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                PersistentIndex.this.getIndexWriter().addIndexes(readers);
                PersistentIndex.this.getIndexWriter().optimize();
                return null;
            }
        });
    }

    void copyIndex(final AbstractIndex index) throws IOException {
        SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                index.commit(true);
                byte[] buffer = new byte[1024];
                Directory dir = index.getDirectory();
                Directory dest = PersistentIndex.this.getDirectory();
                String[] files = dir.list();
                for (int i = 0; i < files.length; ++i) {
                    Object var14_11;
                    IndexInput in = dir.openInput(files[i]);
                    try {
                        Object var12_10;
                        IndexOutput out = dest.createOutput(files[i]);
                        try {
                            int num;
                            for (long remaining = in.length(); remaining > 0L; remaining -= (long)num) {
                                num = (int)Math.min(remaining, (long)buffer.length);
                                in.readBytes(buffer, 0, num);
                                out.writeBytes(buffer, num);
                            }
                            var12_10 = null;
                        }
                        catch (Throwable throwable) {
                            var12_10 = null;
                            out.close();
                            throw throwable;
                        }
                        out.close();
                        var14_11 = null;
                    }
                    catch (Throwable throwable) {
                        var14_11 = null;
                        in.close();
                        throw throwable;
                    }
                    in.close();
                }
                return null;
            }
        });
    }

    synchronized ReadOnlyIndexReader getReadOnlyIndexReader(IndexListener listener) throws IOException {
        ReadOnlyIndexReader reader = this.getReadOnlyIndexReader();
        this.listener = listener;
        return reader;
    }

    synchronized void resetListener() {
        this.listener = null;
    }

    int getNumDocuments() throws IOException {
        return this.getIndexReader().numDocs();
    }

    String getName() {
        return this.name;
    }
}

