/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.cleaner;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.exoplatform.services.jcr.impl.storage.jdbc.cleaner.DBCleaner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDBCleaner
extends DBCleaner {
    public OracleDBCleaner(Connection connection, List<String> cleanScripts) {
        super(connection, cleanScripts);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean isTableExists(Connection conn, String tableName) throws SQLException {
        boolean bl;
        Statement st = null;
        try {
            try {
                st = conn.createStatement();
                st.executeUpdate("SELECT 1 FROM " + tableName);
                bl = true;
                Object var7_6 = null;
                if (st == null) return bl;
            }
            catch (SQLException e) {
                if (e.getMessage().indexOf("ORA-00942") < 0) throw e;
                boolean bl2 = false;
                Object var7_7 = null;
                if (st == null) return bl2;
                try {
                    st.close();
                    return bl2;
                }
                catch (SQLException e2) {
                    LOG.error((Object)("Can't close the Statement: " + e2));
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (st == null) throw throwable;
            try {}
            catch (SQLException e2) {
                LOG.error((Object)("Can't close the Statement: " + e2));
                throw throwable;
            }
            st.close();
            throw throwable;
        }
        try {}
        catch (SQLException e2) {
            LOG.error((Object)("Can't close the Statement: " + e2));
            return bl;
        }
        st.close();
        return bl;
    }
}

