/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class TreeFile
extends File {
    private static Log fLog = ExoLogger.getLogger((String)"exo.jcr.component.core.TreeFile");
    private static final long serialVersionUID = 5125295927077006487L;
    private final FileCleaner cleaner;
    private final File rootDir;

    TreeFile(String fileName, FileCleaner cleaner, File rootDir) {
        super(fileName);
        this.cleaner = cleaner;
        this.rootDir = rootDir;
    }

    public boolean delete() {
        PrivilegedAction<Boolean> action = new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return TreeFile.super.delete();
            }
        };
        boolean res = AccessController.doPrivileged(action);
        if (res) {
            this.deleteParent(new File(this.getParent()));
        }
        return res;
    }

    protected boolean deleteParent(File fp) {
        String rootPath;
        boolean res = false;
        String fpPath = PrivilegedFileHelper.getAbsolutePath((File)fp);
        if (fpPath.startsWith(rootPath = PrivilegedFileHelper.getAbsolutePath((File)this.rootDir)) && fpPath.length() > rootPath.length()) {
            if (fp.isDirectory()) {
                String[] ls = PrivilegedFileHelper.list((File)fp);
                if (ls != null && ls.length <= 0) {
                    res = PrivilegedFileHelper.delete((File)fp);
                    if (res) {
                        res = this.deleteParent(new File(fp.getParent()));
                    } else {
                        fLog.warn((Object)("Parent directory can not be deleted now. " + PrivilegedFileHelper.getAbsolutePath((File)fp)));
                        this.cleaner.addFile(new TreeFile(PrivilegedFileHelper.getAbsolutePath((File)fp), this.cleaner, this.rootDir));
                    }
                }
            } else {
                fLog.warn((Object)("Parent can not be a file but found " + PrivilegedFileHelper.getAbsolutePath((File)fp)));
            }
        }
        return res;
    }
}

