/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.pygments;

import java.io.IOException;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyUnicode;
import org.python.util.PythonInterpreter;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.NewLineBlock;
import org.xwiki.rendering.block.VerbatimBlock;
import org.xwiki.rendering.internal.parser.pygments.BlocksGeneratorPygmentsListener;
import org.xwiki.rendering.parser.AbstractHighlightParser;
import org.xwiki.rendering.parser.HighlightParser;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(roles={HighlightParser.class})
public class PygmentsParser
extends AbstractHighlightParser
implements Initializable {
    private static final String PY_LEXER_VARNAME = "lexer";
    private static final String PY_FORMATTER_VARNAME = "formatter";
    private static final String PY_LISTENER_VARNAME = "listener";
    private static final String PY_CODE_VARNAME = "code";
    private static final String PY_LEXER_TRY = "lexer = None\ntry:\n  lexer";
    private static final String PY_LEXER_CATCH = "\nexcept ClassNotFound:\n  pass";
    private static final String PY_LEXER_CREATE = "lexer = None\ntry:\n  lexer = pygments.lexers.get_lexer_by_name(\"{0}\", stripnl=False)\nexcept ClassNotFound:\n  pass";
    private static final String PY_LEXER_FIND = "lexer = None\ntry:\n  lexer = guess_lexer(code, stripnl=False)\nexcept ClassNotFound:\n  pass";
    private Syntax syntax;
    private PythonInterpreter pythonInterpreter;
    @Requirement(value="plain/1.0")
    private Parser plainTextParser;

    public void initialize() throws InitializationException {
        String highlightSyntaxId = this.getSyntaxId() + "-highlight";
        this.syntax = new Syntax(new SyntaxType(highlightSyntaxId, highlightSyntaxId), "1.0");
        this.pythonInterpreter = new PythonInterpreter();
        this.pythonInterpreter.exec("import pygments\nfrom pygments.lexers import guess_lexer\nfrom pygments.util import ClassNotFound\nfrom pygments.formatters.xdom import XDOMFormatter");
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    @Override
    public List<Block> highlight(String syntaxId, Reader source) throws ParseException {
        String code;
        try {
            code = IOUtils.toString((Reader)source);
        }
        catch (IOException e) {
            throw new ParseException("Failed to read source", (Throwable)e);
        }
        if (code.length() == 0) {
            return Collections.emptyList();
        }
        List<Block> blocks = this.highlight(syntaxId, code);
        if (code.charAt(code.length() - 1) != '\n' && !blocks.isEmpty() && blocks.get(blocks.size() - 1) instanceof NewLineBlock) {
            blocks.remove(blocks.size() - 1);
        }
        return blocks;
    }

    private List<Block> highlight(String syntaxId, String code) throws ParseException {
        PythonInterpreter interpreter = this.getPythonInterpreter();
        BlocksGeneratorPygmentsListener listener = new BlocksGeneratorPygmentsListener(this.plainTextParser);
        interpreter.set(PY_LISTENER_VARNAME, (Object)listener);
        interpreter.set(PY_CODE_VARNAME, (PyObject)new PyUnicode(code));
        if (!StringUtils.isEmpty((String)syntaxId)) {
            interpreter.exec(MessageFormat.format(PY_LEXER_CREATE, syntaxId));
        } else {
            interpreter.exec(PY_LEXER_FIND);
        }
        PyObject lexer = interpreter.get(PY_LEXER_VARNAME);
        if (lexer == null || lexer == Py.None) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("no lexer found");
            }
            return Collections.singletonList(new VerbatimBlock(code, true));
        }
        interpreter.exec(MessageFormat.format("{0} = XDOMFormatter({1})", PY_FORMATTER_VARNAME, PY_LISTENER_VARNAME));
        interpreter.exec(MessageFormat.format("pygments.highlight({0}, {1}, {2})", PY_CODE_VARNAME, PY_LEXER_VARNAME, PY_FORMATTER_VARNAME));
        List<String> vars = Arrays.asList(PY_LISTENER_VARNAME, PY_CODE_VARNAME, PY_LEXER_VARNAME, PY_FORMATTER_VARNAME);
        for (String var : vars) {
            interpreter.exec("del " + var);
        }
        return listener.getBlocks();
    }

    protected PythonInterpreter getPythonInterpreter() {
        return this.pythonInterpreter;
    }
}

