/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Calendar;
import org.exoplatform.commons.utils.PrivilegedFileHelper;

public class FileNameProducer {
    private String backupSetName;
    private File backupSetDir;
    private boolean isFullBackup;
    private boolean isDirectoryForFullBackup;

    public FileNameProducer(String backupSetName, String backupDir, Calendar timeStamp, boolean isFullBackup, boolean isDirectory) {
        this.backupSetName = backupSetName;
        this.isFullBackup = isFullBackup;
        this.isDirectoryForFullBackup = isDirectory;
        this.backupSetDir = new File(backupDir);
        if (!PrivilegedFileHelper.exists(this.backupSetDir)) {
            PrivilegedFileHelper.mkdirs(this.backupSetDir);
        }
    }

    public static File generateBackupSetDir(String repositoryName, String workspaceName, String backupDir, Calendar timeStamp) {
        FileNameProducer fileNameProducer = new FileNameProducer();
        String sTime = "-" + fileNameProducer.getStrDate(timeStamp) + "_" + fileNameProducer.getStrTime(timeStamp);
        File fBackupSetDir = new File(backupDir + File.separator + repositoryName + "_" + workspaceName + sTime);
        if (!PrivilegedFileHelper.exists(fBackupSetDir)) {
            PrivilegedFileHelper.mkdirs(fBackupSetDir);
        }
        return fBackupSetDir;
    }

    public FileNameProducer(String repositoryName, String workspaceName, String backupDir, Calendar timeStamp, boolean isFullBackup, boolean isDirectory) {
        this(repositoryName + "_" + workspaceName, backupDir, timeStamp, isFullBackup, isDirectory);
    }

    public FileNameProducer(String repositoryName, String workspaceName, String backupDir, Calendar timeStamp, boolean isFullBackup) {
        this(repositoryName + "_" + workspaceName, backupDir, timeStamp, isFullBackup, false);
    }

    public FileNameProducer() {
    }

    public File getNextFile() {
        File nextFile = null;
        try {
            String sNextName = this.generateName();
            nextFile = new File(this.backupSetDir.getAbsoluteFile() + File.separator + sNextName);
            if (this.isFullBackup && this.isDirectoryForFullBackup) {
                if (!PrivilegedFileHelper.exists(nextFile)) {
                    PrivilegedFileHelper.mkdirs(nextFile);
                }
            } else {
                PrivilegedFileHelper.createNewFile(nextFile);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return nextFile;
    }

    private String generateName() {
        Calendar date = Calendar.getInstance();
        String sDate = this.getStrDate(date);
        String sTime = this.getStrTime(date);
        String fileName = this.backupSetName + "-" + sDate + "_" + sTime + ".";
        fileName = this.isFullBackup ? fileName + "0" : fileName + this.getNextSufix();
        return fileName;
    }

    private String getNextSufix() {
        String[] fileList = PrivilegedFileHelper.list(this.backupSetDir, new SkipBackupLogFilter());
        int sufix = 0;
        for (int i = 0; i < fileList.length; ++i) {
            String[] stringArray = fileList[i].split("[.]");
            int currentSufix = Integer.valueOf(stringArray[stringArray.length - 1]);
            if (currentSufix <= sufix) continue;
            sufix = currentSufix;
        }
        return String.valueOf(++sufix);
    }

    private String getStrDate(Calendar c) {
        int m = c.get(2) + 1;
        int d = c.get(5);
        return "" + c.get(1) + (m < 10 ? "0" + m : Integer.valueOf(m)) + (d < 10 ? "0" + d : Integer.valueOf(d));
    }

    private String getStrTime(Calendar c) {
        int h = c.get(10);
        int m = c.get(12);
        int s = c.get(13);
        return "" + (h < 10 ? "0" + h : Integer.valueOf(h)) + (m < 10 ? "0" + m : Integer.valueOf(m)) + (s < 10 ? "0" + s : Integer.valueOf(s));
    }

    public File getBackupSetDir() {
        return this.backupSetDir;
    }

    class SkipBackupLogFilter
    implements FilenameFilter {
        SkipBackupLogFilter() {
        }

        public boolean accept(File dir, String name) {
            return !name.endsWith(".xml");
        }
    }
}

