/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import java.util.ArrayList;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.application.UIGadget;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.portal.PageNodeEvent;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

public class UIPageActionListener {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveChildActionListener
    extends EventListener<UIPage> {
        public void execute(Event<UIPage> event) throws Exception {
            UIPage uiPage = (UIPage)((Object)event.getSource());
            String id = event.getRequestContext().getRequestParameter("objectId");
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            if (uiPage.isModifiable()) {
                uiPage.removeChildById(id);
                Page page = (Page)PortalDataMapper.buildModelObject((UIComponent)uiPage);
                if (page.getChildren() == null) {
                    page.setChildren(new ArrayList());
                }
                DataStorage dataService = (DataStorage)uiPage.getApplicationComponent(DataStorage.class);
                dataService.save(page);
                pcontext.setFullRender(false);
                pcontext.setResponseComplete(true);
                pcontext.getWriter().write("OK");
            } else {
                UIApplication uiApp = pcontext.getUIApplication();
                uiApp.addMessage(new ApplicationMessage("UIPage.msg.EditPermission.null", null));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteGadgetActionListener
    extends EventListener<UIPage> {
        public void execute(Event<UIPage> event) throws Exception {
            WebuiRequestContext pContext = event.getRequestContext();
            String id = pContext.getRequestParameter("objectId");
            UIPage uiPage = (UIPage)((Object)event.getSource());
            ArrayList uiWidgets = new ArrayList();
            uiPage.findComponentOfType(uiWidgets, UIGadget.class);
            for (UIGadget uiWidget : uiWidgets) {
                if (!uiWidget.getId().equals(id)) continue;
                uiPage.getChildren().remove((Object)uiWidget);
                String userName = pContext.getRemoteUser();
                if (userName == null || userName.trim().length() > 0) {
                    // empty if block
                }
                if (!uiPage.isModifiable()) break;
                Page page = (Page)PortalDataMapper.buildModelObject((UIComponent)uiPage);
                if (page.getChildren() == null) {
                    page.setChildren(new ArrayList());
                }
                DataStorage dataService = (DataStorage)uiPage.getApplicationComponent(DataStorage.class);
                dataService.save(page);
                break;
            }
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            pcontext.setFullRender(false);
            pcontext.setResponseComplete(true);
            pcontext.getWriter().write("OK");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangePageNodeActionListener
    extends EventListener<UIPortal> {
        public void execute(Event<UIPortal> event) throws Exception {
            UIPortal showedUIPortal = (UIPortal)((Object)event.getSource());
            UIPortalApplication uiPortalApp = (UIPortalApplication)showedUIPortal.getAncestorOfType(UIPortalApplication.class);
            UserPortal userPortal = uiPortalApp.getUserPortalConfig().getUserPortal();
            String uri = ((PageNodeEvent)event).getTargetNodeUri();
            UserNode naviPath = userPortal.resolvePath(null, uri);
            UserNavigation targetNav = naviPath.getNavigation();
            UserNode currentNavPath = showedUIPortal.getNavPath();
            if (currentNavPath != null && currentNavPath.getNavigation().getKey().equals((Object)targetNav.getKey())) {
                if (!currentNavPath.getURI().equals(naviPath.getURI())) {
                    showedUIPortal.setNavPath(naviPath);
                }
            } else {
                UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
                uiWorkingWS.setRenderedChild("UIViewWS");
                uiPortalApp.setModeState(0);
                showedUIPortal = uiPortalApp.getCachedUIPortal(targetNav.getKey());
                if (showedUIPortal != null) {
                    showedUIPortal.setNavPath(naviPath);
                    uiPortalApp.setShowedUIPortal(showedUIPortal);
                    DataStorage storageService = (DataStorage)uiPortalApp.getApplicationComponent(DataStorage.class);
                    PortalConfig associatedPortalConfig = storageService.getPortalConfig(targetNav.getKey().getTypeName(), targetNav.getKey().getName());
                    UserPortalConfig userPortalConfig = uiPortalApp.getUserPortalConfig();
                    userPortalConfig.setPortal(associatedPortalConfig);
                } else {
                    showedUIPortal = this.buildUIPortal(targetNav.getKey(), uiPortalApp, uiPortalApp.getUserPortalConfig());
                    if (showedUIPortal == null) {
                        return;
                    }
                    showedUIPortal.setNavPath(naviPath);
                    uiPortalApp.setShowedUIPortal(showedUIPortal);
                    uiPortalApp.putCachedUIPortal(showedUIPortal);
                }
            }
            showedUIPortal.refreshUIPage();
        }

        private UIPortal buildUIPortal(SiteKey newPageNav, UIPortalApplication uiPortalApp, UserPortalConfig userPortalConfig) throws Exception {
            DataStorage storage = (DataStorage)uiPortalApp.getApplicationComponent(DataStorage.class);
            if (storage == null) {
                return null;
            }
            PortalConfig portalConfig = storage.getPortalConfig(newPageNav.getTypeName(), newPageNav.getName());
            Container layout = portalConfig.getPortalLayout();
            if (layout != null) {
                userPortalConfig.setPortal(portalConfig);
            }
            UIPortal uiPortal = (UIPortal)uiPortalApp.createUIComponent(UIPortal.class, null, null);
            PortalDataMapper.toUIPortal(uiPortal, userPortalConfig);
            return uiPortal;
        }
    }
}

