/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.util;

import java.util.List;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageFactory;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.portal.UIPortalComponent;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.workspace.UIEditInlineWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIPortalToolPanel;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;
import org.exoplatform.webui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static PortalRequestContext getPortalRequestContext() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (context == null) {
            return null;
        }
        if (!(context instanceof PortalRequestContext)) {
            context = (WebuiRequestContext)context.getParentAppRequestContext();
        }
        return (PortalRequestContext)context;
    }

    public static UIPortalApplication getUIPortalApplication() {
        return (UIPortalApplication)Util.getPortalRequestContext().getUIApplication();
    }

    public static UIPortal getUIPortal() {
        return Util.getUIPortalApplication().getShowedUIPortal();
    }

    public static UIPortalToolPanel getUIPortalToolPanel() {
        return (UIPortalToolPanel)Util.getUIPortalApplication().findFirstComponentOfType(UIPortalToolPanel.class);
    }

    private static void setShowEditControl(UIComponent uiComponent, Class clazz) {
        if (uiComponent == null) {
            return;
        }
        if (uiComponent instanceof UIPortalComponent) {
            UIPortalComponent uiContainer = (UIPortalComponent)uiComponent;
            if (clazz.isInstance((Object)uiContainer)) {
                uiContainer.setShowEditControl(true);
            } else {
                uiContainer.setShowEditControl(false);
            }
        }
        if (uiComponent instanceof org.exoplatform.webui.core.UIContainer) {
            List children = ((org.exoplatform.webui.core.UIContainer)uiComponent).getChildren();
            for (UIComponent comp : children) {
                Util.setShowEditControl(comp, clazz);
            }
            return;
        }
        if (uiComponent instanceof UIComponentDecorator) {
            UIComponentDecorator uiDecorator = (UIComponentDecorator)uiComponent;
            if (uiDecorator.getUIComponent() == null) {
                return;
            }
            Util.setShowEditControl(uiDecorator.getUIComponent(), clazz);
        }
    }

    public static <T extends UIComponent> T showComponentOnWorking(UIComponent uicomp, Class<T> clazz) throws Exception {
        UIPortalApplication uiPortalApp = (UIPortalApplication)uicomp.getAncestorOfType(UIPortalApplication.class);
        UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
        UIPortalToolPanel uiToolPanel = (UIPortalToolPanel)((UIPortalToolPanel)uiWorkingWS.findFirstComponentOfType(UIPortalToolPanel.class)).setRendered(true);
        UIComponent uiWork = uiToolPanel.createUIComponent(clazz, null, null);
        uiToolPanel.setUIComponent(uiWork);
        return (T)uiWork;
    }

    public static void showPortalComponentLayoutMode(UIPortalApplication uiPortalApp) {
        UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
        uiWorkingWS.setRenderedChild(UIPortal.class);
        UIPortal uiPortal = (UIPortal)uiWorkingWS.findFirstComponentOfType(UIPortal.class);
        UIContainer uiContainer = Util.findUIComponent((UIComponent)uiPortal, UIContainer.class, UIPage.class);
        UIPage uiPage = (UIPage)uiPortal.findFirstComponentOfType(UIPage.class);
        UIPortlet uiPortlet = Util.findUIComponent((UIComponent)uiPortal, UIPortlet.class, UIPage.class);
        String name = "";
        if (uiContainer != null && uiContainer.isShowEditControl()) {
            name = "'UIContainer'";
        } else if (uiPage != null && uiPage.isShowEditControl()) {
            name = "'UIPage'";
        } else if (uiPortlet != null && uiPortlet.isShowEditControl()) {
            name = "'UIPortlet'";
        }
        Util.getPortalRequestContext().getJavascriptManager().addCustomizedOnLoadScript((CharSequence)("eXo.portal.UIPortal.showLayoutModeForPortal(" + name + ");"));
    }

    public static void showPageComponentLayoutMode(UIPortalApplication uiPortalApp) {
        UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
        uiWorkingWS.setRenderedChild(UIPortalToolPanel.class);
        UIPortalToolPanel uiPortalToolPanel = (UIPortalToolPanel)uiWorkingWS.findFirstComponentOfType(UIPortalToolPanel.class);
        UIPage uiPage = (UIPage)uiPortalToolPanel.findFirstComponentOfType(UIPage.class);
        UIContainer uiContainer = (UIContainer)uiPage.findFirstComponentOfType(UIContainer.class);
        UIPortlet uiPortlet = (UIPortlet)uiPage.findFirstComponentOfType(UIPortlet.class);
        String name = "";
        if (uiContainer != null && uiContainer.isShowEditControl()) {
            name = "UIContainer";
        } else if (uiPortlet != null && uiPortlet.isShowEditControl()) {
            name = "UIPortlet";
        }
        Util.getPortalRequestContext().getJavascriptManager().addCustomizedOnLoadScript((CharSequence)("eXo.portal.UIPortal.showLayoutModeForPage('" + name + "');"));
    }

    public static <T extends UIComponent> T findUIComponent(UIComponent uiComponent, Class<T> clazz, Class ignoreClazz) {
        if (clazz.isInstance(uiComponent)) {
            return (T)uiComponent;
        }
        if (!(uiComponent instanceof UIContainer)) {
            return null;
        }
        List children = ((UIContainer)uiComponent).getChildren();
        for (UIComponent child : children) {
            T value;
            if (clazz.isInstance(child)) {
                return (T)child;
            }
            if (ignoreClazz.isInstance(child) || (value = Util.findUIComponent(child, clazz, ignoreClazz)) == null) continue;
            return value;
        }
        return null;
    }

    public static void findUIComponents(UIComponent uiComponent, List<UIComponent> list, Class clazz, Class ignoreClazz) {
        if (clazz.isInstance(uiComponent)) {
            list.add(uiComponent);
        }
        if (!(uiComponent instanceof UIContainer)) {
            return;
        }
        List children = ((UIContainer)uiComponent).getChildren();
        for (UIComponent child : children) {
            if (clazz.isInstance(child)) {
                list.add(child);
                continue;
            }
            if (ignoreClazz.isInstance(child)) continue;
            Util.findUIComponents(child, list, clazz, ignoreClazz);
        }
    }

    @Deprecated
    public static UIPage toUIPage(PageNode node, UIComponent uiParent) throws Exception {
        return Util.toUIPage(node.getPageReference(), uiParent);
    }

    public static UIPage toUIPage(String pageRef, UIComponent uiParent) throws Exception {
        UserPortalConfigService configService = (UserPortalConfigService)uiParent.getApplicationComponent(UserPortalConfigService.class);
        Page page = configService.getPage(pageRef, Util.getPortalRequestContext().getRemoteUser());
        return Util.toUIPage(page, uiParent);
    }

    public static UIPage toUIPage(Page page, UIComponent uiParent) throws Exception {
        UIPage uiPage = (UIPage)Util.getUIPortal().findFirstComponentOfType(UIPage.class);
        if (uiPage != null && uiPage.getId().equals(page.getId())) {
            return uiPage;
        }
        PortalRequestContext context = Util.getPortalRequestContext();
        UIPageFactory clazz = UIPageFactory.getInstance(page.getFactoryId());
        uiPage = clazz.createUIPage(context);
        PortalDataMapper.toUIPage(uiPage, page);
        return uiPage;
    }

    public static void showComponentLayoutMode(Class clazz) throws Exception {
        if (clazz == null) {
            return;
        }
        UIPortalApplication portalApp = Util.getUIPortalApplication();
        UIEditInlineWorkspace uiEditWS = (UIEditInlineWorkspace)portalApp.findFirstComponentOfType(UIEditInlineWorkspace.class);
        UIContainer uiParent = null;
        UIComponent uiComponent = uiEditWS.getUIComponent();
        if (uiComponent instanceof UIPortal) {
            UIPortal uiPortal = (UIPortal)uiComponent;
            uiPortal.setMaximizedUIComponent(null);
            uiParent = uiPortal;
        } else {
            UIPortalToolPanel uiPortalToolPanel = Util.getUIPortalToolPanel();
            UIPage uiPage = (UIPage)uiPortalToolPanel.findFirstComponentOfType(UIPage.class);
            uiParent = uiPage;
        }
        if (uiParent == null) {
            return;
        }
        String layoutMode = clazz.getSimpleName();
        Util.setShowEditControl((UIComponent)uiParent, clazz);
        PortalRequestContext context = Util.getPortalRequestContext();
        if (uiParent instanceof UIPortal) {
            context.getJavascriptManager().addCustomizedOnLoadScript((CharSequence)("eXo.portal.UIPortal.showLayoutModeForPortal('" + layoutMode + "');"));
        } else {
            context.getJavascriptManager().addCustomizedOnLoadScript((CharSequence)("eXo.portal.UIPortal.showLayoutModeForPage('" + layoutMode + "');"));
        }
    }

    public static void showComponentEditInViewMode(Class clazz) throws Exception {
        if (clazz == null) {
            return;
        }
        UIPortalApplication portalApp = Util.getUIPortalApplication();
        UIEditInlineWorkspace uiEditWS = (UIEditInlineWorkspace)portalApp.findFirstComponentOfType(UIEditInlineWorkspace.class);
        UIContainer uiParent = null;
        UIComponent uiComponent = uiEditWS.getUIComponent();
        if (uiComponent instanceof UIPortal) {
            UIPortal uiPortal = (UIPortal)uiComponent;
            uiPortal.setMaximizedUIComponent(null);
            uiParent = uiPortal;
        } else {
            UIPortalToolPanel uiPortalToolPanel = Util.getUIPortalToolPanel();
            UIPage uiPage = (UIPage)uiPortalToolPanel.findFirstComponentOfType(UIPage.class);
            uiParent = uiPage;
        }
        if (uiParent == null) {
            return;
        }
        String layoutMode = clazz.getSimpleName();
        Util.setShowEditControl((UIComponent)uiParent, clazz);
        PortalRequestContext context = Util.getPortalRequestContext();
        context.getJavascriptManager().addCustomizedOnLoadScript((CharSequence)("eXo.portal.UIPortal.showViewMode('" + layoutMode + "');"));
    }

    public static UIWorkingWorkspace updateUIApplication(Event<? extends UIComponent> event) {
        PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
        UIPortalApplication uiPortalApp = (UIPortalApplication)((UIComponent)event.getSource()).getAncestorOfType(UIPortalApplication.class);
        UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
        pcontext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
        pcontext.setFullRender(true);
        return uiWorkingWS;
    }
}

