/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBoolean$PyExposer;
import org.python.core.PyInteger;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExposedType(name="bool", isBaseType=false, doc="bool(x) -> bool\n\nReturns True when the argument x is true, False otherwise.\nThe builtins True and False are the only two instances of the class bool.\nThe class bool is a subclass of the class int, and cannot be subclassed.")
public class PyBoolean
extends PyInteger {
    public static final PyType TYPE;
    private boolean value;

    public PyBoolean(boolean value) {
        super(TYPE, value ? 1 : 0);
        this.value = value;
    }

    @ExposedNew
    public static PyObject bool_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("bool", args, keywords, new String[]{"x"}, 0);
        PyObject obj = ap.getPyObject(0, null);
        if (obj == null) {
            return Py.False;
        }
        return obj.__nonzero__() ? Py.True : Py.False;
    }

    @Override
    public String toString() {
        return this.bool_toString();
    }

    final String bool_toString() {
        return this.value ? "True" : "False";
    }

    @Override
    public int hashCode() {
        return this.bool___hash__();
    }

    final int bool___hash__() {
        return this.value ? 1 : 0;
    }

    @Override
    public boolean __nonzero__() {
        return this.bool___nonzero__();
    }

    final boolean bool___nonzero__() {
        return this.value;
    }

    @Override
    public Object __tojava__(Class<?> c) {
        if (c == Boolean.TYPE || c == Boolean.class || c == Object.class) {
            return this.value;
        }
        if (c == Integer.TYPE || c == Number.class || c == Integer.class) {
            return this.value ? 1 : 0;
        }
        if (c == Byte.TYPE || c == Byte.class) {
            return (byte)(this.value ? 1 : 0);
        }
        if (c == Short.TYPE || c == Short.class) {
            return (short)(this.value ? 1 : 0);
        }
        if (c == Long.TYPE || c == Long.class) {
            return this.value ? 1L : 0L;
        }
        if (c == Float.TYPE || c == Float.class) {
            return Float.valueOf(this.value ? 1.0f : 0.0f);
        }
        if (c == Double.TYPE || c == Double.class) {
            return this.value ? 1.0 : 0.0;
        }
        return super.__tojava__(c);
    }

    @Override
    public PyObject __and__(PyObject right) {
        return this.bool___and__(right);
    }

    final PyObject bool___and__(PyObject right) {
        if (right instanceof PyBoolean) {
            return Py.newBoolean(this.value & ((PyBoolean)right).value);
        }
        if (right instanceof PyInteger) {
            return Py.newInteger(this.getValue() & ((PyInteger)right).getValue());
        }
        return null;
    }

    @Override
    public PyObject __xor__(PyObject right) {
        return this.bool___xor__(right);
    }

    final PyObject bool___xor__(PyObject right) {
        if (right instanceof PyBoolean) {
            return Py.newBoolean(this.value ^ ((PyBoolean)right).value);
        }
        if (right instanceof PyInteger) {
            return Py.newInteger(this.getValue() ^ ((PyInteger)right).getValue());
        }
        return null;
    }

    @Override
    public PyObject __or__(PyObject right) {
        return this.bool___or__(right);
    }

    final PyObject bool___or__(PyObject right) {
        if (right instanceof PyBoolean) {
            return Py.newBoolean(this.value | ((PyBoolean)right).value);
        }
        if (right instanceof PyInteger) {
            return Py.newInteger(this.getValue() | ((PyInteger)right).getValue());
        }
        return null;
    }

    @Override
    public PyObject __neg__() {
        return this.bool___neg__();
    }

    final PyObject bool___neg__() {
        return Py.newInteger(this.value ? -1 : 0);
    }

    @Override
    public PyObject __pos__() {
        return this.bool___pos__();
    }

    final PyObject bool___pos__() {
        return Py.newInteger(this.value ? 1 : 0);
    }

    @Override
    public PyObject __abs__() {
        return this.bool___abs__();
    }

    final PyObject bool___abs__() {
        return Py.newInteger(this.value ? 1 : 0);
    }

    static {
        PyType.addBuilder(PyBoolean.class, new PyBoolean$PyExposer());
        TYPE = PyType.fromClass(PyBoolean.class);
    }
}

