/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.backup.rdbms;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.backup.DataRestor;
import org.exoplatform.services.jcr.impl.util.io.DirectoryHelper;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryRestor
implements DataRestor {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.DirectoryRestorer");
    protected final List<File> dataDirs = new ArrayList<File>();
    protected final List<File> backupDirs = new ArrayList<File>();
    private final List<File> tmpDirs = new ArrayList<File>();
    protected final File tempDir = new File(PrivilegedSystemHelper.getProperty((String)"java.io.tmpdir"));
    private static final String PREFIX = "dr";

    public DirectoryRestor(List<File> dataDirs, List<File> backupDirs) {
        this.dataDirs.addAll(dataDirs);
        this.backupDirs.addAll(backupDirs);
    }

    public DirectoryRestor(File dataDir, File backupDir) {
        this.dataDirs.add(dataDir);
        this.backupDirs.add(backupDir);
    }

    @Override
    public void clean() throws BackupException {
        for (File dataDir : this.dataDirs) {
            try {
                File tmpDir = new File(this.tempDir, PREFIX + IdGenerator.generate());
                PrivilegedFileHelper.mkdirs((File)tmpDir);
                this.tmpDirs.add(tmpDir);
                if (!PrivilegedFileHelper.exists((File)dataDir)) continue;
                DirectoryHelper.copyDirectory(dataDir, tmpDir);
                DirectoryHelper.removeDirectory(dataDir);
            }
            catch (IOException e) {
                throw new BackupException(e);
            }
        }
    }

    @Override
    public void restore() throws BackupException {
        for (int i = 0; i < this.backupDirs.size(); ++i) {
            File backupDir = this.backupDirs.get(i);
            File dataDir = this.dataDirs.get(i);
            try {
                DirectoryHelper.uncompressDirectory(backupDir, dataDir);
                continue;
            }
            catch (IOException e) {
                throw new BackupException(e);
            }
        }
    }

    @Override
    public void commit() throws BackupException {
    }

    @Override
    public void rollback() throws BackupException {
        for (int i = 0; i < this.tmpDirs.size(); ++i) {
            try {
                File tmpDir = this.tmpDirs.get(i);
                File dataDir = this.dataDirs.get(i);
                if (PrivilegedFileHelper.exists((File)dataDir)) {
                    DirectoryHelper.removeDirectory(dataDir);
                }
                DirectoryHelper.copyDirectory(tmpDir, dataDir);
                continue;
            }
            catch (IOException e) {
                throw new BackupException(e);
            }
        }
    }

    @Override
    public void close() throws BackupException {
        for (File tmpDir : this.tmpDirs) {
            try {
                DirectoryHelper.removeDirectory(tmpDir);
            }
            catch (IOException e) {
                throw new BackupException(e);
            }
        }
        this.dataDirs.clear();
        this.backupDirs.clear();
        this.tmpDirs.clear();
    }
}

