/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.access.AuthenticationPolicy;
import org.exoplatform.services.jcr.access.DynamicIdentity;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.CredentialsImpl;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.core.security.JCRRuntimePermissions;
import org.exoplatform.services.jcr.dataflow.PersistentDataManager;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListener;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.RepositoryContainer;
import org.exoplatform.services.jcr.impl.WorkspaceContainer;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionFactory;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.SessionRegistry;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableDataManager;
import org.exoplatform.services.jcr.impl.xml.ExportImportFactory;
import org.exoplatform.services.jcr.impl.xml.importing.StreamImporter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.picocontainer.ComponentAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryImpl
implements ManageableRepository {
    private static HashMap<String, String> descriptors = new HashMap();
    private static final CredentialsImpl SYSTEM_CREDENTIALS = new CredentialsImpl(SystemIdentity.SYSTEM, "".toCharArray());
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.RepositoryImpl");
    private final RepositoryContainer repositoryContainer;
    private final String systemWorkspaceName;
    private final String name;
    private final RepositoryEntry config;
    private final AuthenticationPolicy authenticationPolicy;
    private boolean isOffline = true;

    public RepositoryImpl(RepositoryContainer container) throws RepositoryException, RepositoryConfigurationException {
        this.config = (RepositoryEntry)container.getComponentInstanceOfType(RepositoryEntry.class);
        this.authenticationPolicy = (AuthenticationPolicy)container.getComponentInstanceOfType(AuthenticationPolicy.class);
        this.name = this.config.getName();
        this.systemWorkspaceName = this.config.getSystemWorkspaceName();
        this.repositoryContainer = container;
    }

    @Override
    public void addItemPersistenceListener(String workspaceName, ItemsPersistenceListener listener) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
        }
        PersistentDataManager pmanager = (PersistentDataManager)this.repositoryContainer.getWorkspaceContainer(workspaceName).getComponentInstanceOfType(PersistentDataManager.class);
        pmanager.addItemPersistenceListener(listener);
    }

    @Override
    public boolean canRemoveWorkspace(String workspaceName) throws NoSuchWorkspaceException {
        if (this.repositoryContainer.getWorkspaceEntry(workspaceName) == null) {
            throw new NoSuchWorkspaceException("No such workspace " + workspaceName);
        }
        if (workspaceName.equals(this.config.getSystemWorkspaceName())) {
            return false;
        }
        SessionRegistry sessionRegistry = (SessionRegistry)this.repositoryContainer.getComponentInstance(SessionRegistry.class);
        return sessionRegistry != null && !sessionRegistry.isInUse(workspaceName);
    }

    @Override
    public void configWorkspace(final WorkspaceEntry wsConfig) throws RepositoryConfigurationException, RepositoryException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
        }
        if (this.isWorkspaceInitialized(wsConfig.getName())) {
            throw new RepositoryConfigurationException("Workspace '" + wsConfig.getName() + "' is presumably initialized. config canceled");
        }
        try {
            this.repositoryContainer.registerWorkspace(wsConfig);
        }
        catch (RepositoryConfigurationException e) {
            final WorkspaceContainer workspaceContainer = this.repositoryContainer.getWorkspaceContainer(wsConfig.getName());
            SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    RepositoryImpl.this.repositoryContainer.unregisterComponentByInstance((Object)workspaceContainer);
                    RepositoryImpl.this.repositoryContainer.unregisterComponent(wsConfig.getName());
                    return null;
                }
            });
            throw new RepositoryConfigurationException(e);
        }
        catch (RepositoryException e) {
            final WorkspaceContainer workspaceContainer = this.repositoryContainer.getWorkspaceContainer(wsConfig.getName());
            SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    RepositoryImpl.this.repositoryContainer.unregisterComponentByInstance((Object)workspaceContainer);
                    RepositoryImpl.this.repositoryContainer.unregisterComponent(wsConfig.getName());
                    return null;
                }
            });
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public synchronized void createWorkspace(String workspaceName) throws RepositoryException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
        }
        if (this.isWorkspaceInitialized(workspaceName)) {
            LOG.warn((Object)("Workspace '" + workspaceName + "' is presumably initialized. config canceled"));
            return;
        }
        final WorkspaceContainer wsContainer = this.repositoryContainer.getWorkspaceContainer(workspaceName);
        if (wsContainer == null) {
            throw new RepositoryException("Workspace " + workspaceName + " is not configured. Use RepositoryImpl.configWorkspace() method");
        }
        this.repositoryContainer.getWorkspaceContainer(workspaceName).getWorkspaceInitializer().initWorkspace();
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                wsContainer.start();
                return null;
            }
        });
        LOG.info((Object)("Workspace " + workspaceName + "@" + this.name + " is initialized"));
    }

    @Override
    public RepositoryEntry getConfiguration() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
        }
        return this.config;
    }

    public String getDescriptor(String key) {
        return descriptors.get(key);
    }

    public String[] getDescriptorKeys() {
        String[] keys = new String[descriptors.size()];
        Iterator<String> decriptorsList = descriptors.keySet().iterator();
        int i = 0;
        while (decriptorsList.hasNext()) {
            keys[i++] = decriptorsList.next();
        }
        return keys;
    }

    public LocationFactory getLocationFactory() {
        return this.repositoryContainer.getLocationFactory();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public NamespaceRegistry getNamespaceRegistry() {
        return this.repositoryContainer.getNamespaceRegistry();
    }

    @Override
    public ExtendedNodeTypeManager getNodeTypeManager() {
        return this.repositoryContainer.getNodeTypeManager();
    }

    public SessionImpl getSystemSession() throws RepositoryException {
        return this.getSystemSession(this.systemWorkspaceName);
    }

    @Override
    public SessionImpl getSystemSession(String workspaceName) throws RepositoryException {
        WorkspaceContainer workspaceContainer;
        if (this.getState() == 0) {
            LOG.warn((Object)("Repository " + this.getName() + " is OFFLINE."));
        }
        if ((workspaceContainer = this.repositoryContainer.getWorkspaceContainer(workspaceName)) == null || !workspaceContainer.getWorkspaceInitializer().isWorkspaceInitialized()) {
            throw new RepositoryException("Workspace " + workspaceName + " not found or workspace is not initialized");
        }
        SessionFactory sessionFactory = workspaceContainer.getSessionFactory();
        return sessionFactory.createSession(this.authenticationPolicy.authenticate(SYSTEM_CREDENTIALS));
    }

    @Override
    public SessionImpl getDynamicSession(String workspaceName, Collection<MembershipEntry> membershipEntries) throws RepositoryException {
        WorkspaceContainer workspaceContainer;
        if (this.getState() == 0) {
            LOG.warn((Object)("Repository " + this.getName() + " is OFFLINE."));
        }
        if ((workspaceContainer = this.repositoryContainer.getWorkspaceContainer(workspaceName)) == null || !workspaceContainer.getWorkspaceInitializer().isWorkspaceInitialized()) {
            throw new RepositoryException("Workspace " + workspaceName + " not found or workspace is not initialized");
        }
        SessionFactory sessionFactory = workspaceContainer.getSessionFactory();
        Identity id = new Identity(DynamicIdentity.DYNAMIC, membershipEntries);
        return sessionFactory.createSession(new ConversationState(id));
    }

    public String getSystemWorkspaceName() {
        return this.systemWorkspaceName;
    }

    @Override
    public String[] getWorkspaceNames() {
        List adapters = this.repositoryContainer.getComponentAdaptersOfType(WorkspaceContainer.class);
        ArrayList<String> workspaceNames = new ArrayList<String>();
        for (int i = 0; i < adapters.size(); ++i) {
            ComponentAdapter adapter = (ComponentAdapter)adapters.get(i);
            String workspaceName = new String((String)adapter.getComponentKey());
            try {
                if (!this.repositoryContainer.getWorkspaceContainer(workspaceName).getWorkspaceInitializer().isWorkspaceInitialized()) continue;
                workspaceNames.add(workspaceName);
                continue;
            }
            catch (RuntimeException e) {
                LOG.warn((Object)e.getLocalizedMessage());
            }
        }
        return workspaceNames.toArray(new String[workspaceNames.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importWorkspace(String wsName, InputStream xmlStream) throws RepositoryException, IOException {
        this.createWorkspace(wsName);
        SessionImpl sysSession = this.getSystemSession(wsName);
        try {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("respectPropertyDefinitionsConstraints", true);
            NodeData rootData = (NodeData)((NodeImpl)sysSession.getRootNode()).getData();
            TransactionableDataManager dataManager = sysSession.getTransientNodesManager().getTransactManager();
            ExportImportFactory eiFactory = new ExportImportFactory();
            StreamImporter importer = eiFactory.getWorkspaceImporter(rootData, 3, dataManager, dataManager, sysSession.getWorkspace().getNodeTypesHolder(), sysSession.getLocationFactory(), sysSession.getValueFactory(), this.getNamespaceRegistry(), sysSession.getAccessManager(), sysSession.getUserState(), context, this, wsName);
            importer.importStream(xmlStream);
            Object var10_9 = null;
            sysSession.logout();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            sysSession.logout();
            throw throwable;
        }
    }

    public void internalRemoveWorkspace(final String workspaceName) throws RepositoryException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
        }
        final WorkspaceContainer workspaceContainer = this.repositoryContainer.getWorkspaceContainer(workspaceName);
        try {
            SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    workspaceContainer.stop();
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                RepositoryImpl.this.repositoryContainer.unregisterComponentByInstance((Object)workspaceContainer);
                RepositoryImpl.this.repositoryContainer.unregisterComponent(workspaceName);
                return null;
            }
        });
    }

    @Override
    public boolean isWorkspaceInitialized(String workspaceName) {
        try {
            return this.repositoryContainer.getWorkspaceContainer(workspaceName).getWorkspaceInitializer().isWorkspaceInitialized();
        }
        catch (Exception e) {
            return false;
        }
    }

    public Session login() throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.login(null, null);
    }

    public Session login(Credentials credentials) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.login(credentials, null);
    }

    public Session login(String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.login(null, workspaceName);
    }

    public Session login(final Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        ConversationState state;
        if (this.getState() == 0) {
            LOG.warn((Object)("Repository " + this.getName() + " is OFFLINE."));
        }
        PrivilegedExceptionAction<ConversationState> action = new PrivilegedExceptionAction<ConversationState>(){

            @Override
            public ConversationState run() throws Exception {
                if (credentials != null) {
                    return RepositoryImpl.this.authenticationPolicy.authenticate(credentials);
                }
                return RepositoryImpl.this.authenticationPolicy.authenticate();
            }
        };
        try {
            state = AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof LoginException) {
                throw (LoginException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
        return this.internalLogin(state, workspaceName);
    }

    SessionImpl internalLogin(ConversationState state, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        if (workspaceName == null && (workspaceName = this.config.getDefaultWorkspaceName()) == null) {
            throw new NoSuchWorkspaceException("Both workspace and default-workspace name are null! ");
        }
        if (!this.isWorkspaceInitialized(workspaceName)) {
            throw new NoSuchWorkspaceException("Workspace '" + workspaceName + "' not found. " + "Probably is not initialized. If so either Initialize it manually or turn on the RepositoryInitializer");
        }
        SessionFactory sessionFactory = this.repositoryContainer.getWorkspaceContainer(workspaceName).getSessionFactory();
        return sessionFactory.createSession(state);
    }

    @Override
    public void removeWorkspace(String workspaceName) throws RepositoryException {
        if (!this.canRemoveWorkspace(workspaceName)) {
            throw new RepositoryException("Workspace " + workspaceName + " in use. If you want to " + " remove workspace close all open sessions");
        }
        this.internalRemoveWorkspace(workspaceName);
        this.config.getWorkspaceEntries().remove(this.repositoryContainer.getWorkspaceEntry(workspaceName));
    }

    @Override
    public WorkspaceContainerFacade getWorkspaceContainer(String workspaceName) {
        return new WorkspaceContainerFacade(workspaceName, this.repositoryContainer.getWorkspaceContainer(workspaceName));
    }

    @Override
    public int getState() {
        if (this.isOffline) {
            return 0;
        }
        Integer state = null;
        for (String workspaceName : this.getWorkspaceNames()) {
            int workspaceState = this.getWorkspaceContainer(workspaceName).getState();
            if (state == null) {
                state = workspaceState;
                continue;
            }
            if (state == workspaceState) continue;
            return 4;
        }
        return state == null ? 1 : state;
    }

    @Override
    public void setState(int state) throws RepositoryException {
        if (this.getState() != 1 && state != 1 && state != 0) {
            throw new RepositoryException("First switch repository to ONLINE and then to needed state.\n" + this.toString());
        }
        for (String workspaceName : this.getWorkspaceNames()) {
            this.getWorkspaceContainer(workspaceName).setState(state);
        }
        this.isOffline = state == 0;
    }

    @Override
    public String getStateTitle() {
        switch (this.getState()) {
            case 1: {
                return "online";
            }
            case 0: {
                return "offline";
            }
            case 2: {
                return "readonly";
            }
            case 3: {
                return "suspended";
            }
        }
        return "undefined";
    }

    public String toString() {
        String defaultWorkspaceName = this.config.getDefaultWorkspaceName();
        return String.format("Repository {\n name: %s;\n system workspace: %s;\n default workspace: %s;\n workspaces: %s;\n state: %s \n}", this.name, this.systemWorkspaceName, defaultWorkspaceName, Arrays.toString(this.getWorkspaceNames()), this.getStateTitle());
    }

    static {
        descriptors.put("jcr.specification.version", "1.0");
        descriptors.put("jcr.specification.name", "Content Repository Java Technology API");
        descriptors.put("jcr.repository.vendor", "eXo Platform SAS");
        descriptors.put("jcr.repository.vendor.url", "http://www.exoplatform.com");
        descriptors.put("jcr.repository.name", "eXo Java Content Repository");
        descriptors.put("jcr.repository.version", "1.7.1");
        descriptors.put("level.1.supported", "true");
        descriptors.put("level.2.supported", "true");
        descriptors.put("option.transactions.supported", "true");
        descriptors.put("option.versioning.supported", "true");
        descriptors.put("option.observation.supported", "true");
        descriptors.put("option.locking.supported", "true");
        descriptors.put("option.query.sql.supported", "true");
        descriptors.put("query.xpath.pos.index", "true");
        descriptors.put("query.xpath.doc.order", "true");
    }
}

