/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.jcr.config.QueryHandlerEntry;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListener;
import org.exoplatform.services.jcr.impl.core.query.IndexingTree;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IndexerChangesFilter
implements ItemsPersistenceListener {
    private static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.DefaultChangesFilter");
    protected final SearchManager searchManager;
    protected final QueryHandlerEntry config;
    protected final QueryHandler handler;
    protected final QueryHandler parentHandler;
    protected final IndexingTree indexingTree;
    protected final SearchManager parentSearchManager;
    protected final IndexingTree parentIndexingTree;

    public IndexerChangesFilter(SearchManager searchManager, SearchManager parentSearchManager, QueryHandlerEntry config, IndexingTree indexingTree, IndexingTree parentIndexingTree, QueryHandler handler, QueryHandler parentHandler, ConfigurationManager cfm) {
        this.searchManager = searchManager;
        this.parentSearchManager = parentSearchManager;
        this.config = config;
        this.parentIndexingTree = parentIndexingTree;
        this.indexingTree = indexingTree;
        this.handler = handler;
        this.parentHandler = parentHandler;
    }

    public QueryHandler getHandler() {
        return this.handler;
    }

    public IndexingTree getIndexingTree() {
        return this.indexingTree;
    }

    public SearchManager getSearchManager() {
        return this.searchManager;
    }

    @Override
    public void onSaveItems(ItemStateChangesLog itemStates) {
        HashSet<String> removedNodes = new HashSet<String>();
        HashSet<String> addedNodes = new HashSet<String>();
        HashMap<String, List<ItemState>> updatedNodes = new HashMap<String, List<ItemState>>();
        HashSet<String> parentRemovedNodes = new HashSet<String>();
        HashSet<String> parentAddedNodes = new HashSet<String>();
        HashMap<String, List<ItemState>> parentUpdatedNodes = new HashMap<String, List<ItemState>>();
        for (ItemState itemState : itemStates.getAllStates()) {
            if (!itemState.isPersisted()) continue;
            if (!this.indexingTree.isExcluded(itemState)) {
                this.acceptChanges(removedNodes, addedNodes, updatedNodes, itemState);
                continue;
            }
            if (this.parentIndexingTree == null || this.parentIndexingTree.isExcluded(itemState)) continue;
            this.acceptChanges(parentRemovedNodes, parentAddedNodes, parentUpdatedNodes, itemState);
        }
        for (String uuid : updatedNodes.keySet()) {
            removedNodes.add(uuid);
            addedNodes.add(uuid);
        }
        for (String uuid : parentUpdatedNodes.keySet()) {
            parentRemovedNodes.add(uuid);
            parentAddedNodes.add(uuid);
        }
        this.doUpdateIndex(removedNodes, addedNodes, parentRemovedNodes, parentAddedNodes);
    }

    private void acceptChanges(Set<String> removedNodes, Set<String> addedNodes, Map<String, List<ItemState>> updatedNodes, ItemState itemState) {
        String uuid;
        String string = uuid = itemState.isNode() ? itemState.getData().getIdentifier() : itemState.getData().getParentIdentifier();
        if (itemState.isNode()) {
            if (itemState.isAdded()) {
                addedNodes.add(uuid);
            } else if (itemState.isRenamed() || itemState.isUpdated() || itemState.isMixinChanged()) {
                this.createNewOrAdd(uuid, itemState, updatedNodes);
            } else if (itemState.isDeleted()) {
                addedNodes.remove(uuid);
                removedNodes.add(uuid);
                updatedNodes.remove(uuid);
            }
        } else if ((itemState.isAdded() || itemState.isUpdated() || itemState.isDeleted()) && !addedNodes.contains(uuid) && !removedNodes.contains(uuid) && !updatedNodes.containsKey(uuid)) {
            this.createNewOrAdd(uuid, itemState, updatedNodes);
        }
    }

    protected abstract void doUpdateIndex(Set<String> var1, Set<String> var2, Set<String> var3, Set<String> var4);

    private void createNewOrAdd(String key, ItemState state, Map<String, List<ItemState>> updatedNodes) {
        List<ItemState> list = updatedNodes.get(key);
        if (list == null) {
            list = new ArrayList<ItemState>();
            updatedNodes.put(key, list);
        }
        list.add(state);
    }

    @Override
    public boolean isTXAware() {
        return true;
    }

    public boolean isShared() {
        return false;
    }
}

