/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import javax.jcr.ValueFormatException;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.util.JCRDateFormat;

public class ValueDataConvertor {
    public static String readString(ValueData value) throws UnsupportedEncodingException, IllegalStateException, IOException {
        return new String(value.getAsByteArray(), "UTF-8");
    }

    public static Calendar readDate(ValueData value) throws UnsupportedEncodingException, IllegalStateException, IOException, ValueFormatException {
        return new JCRDateFormat().deserialize(new String(value.getAsByteArray(), "UTF-8"));
    }

    public static long readLong(ValueData value) throws NumberFormatException, UnsupportedEncodingException, IllegalStateException, IOException {
        return Long.valueOf(new String(value.getAsByteArray(), "UTF-8"));
    }

    public static double readDouble(ValueData value) throws NumberFormatException, UnsupportedEncodingException, IllegalStateException, IOException {
        return Double.valueOf(new String(value.getAsByteArray(), "UTF-8"));
    }

    public static boolean readBoolean(ValueData value) throws UnsupportedEncodingException, IllegalStateException, IOException {
        return Boolean.valueOf(new String(value.getAsByteArray(), "UTF-8"));
    }

    public static InternalQName readQName(ValueData value) throws UnsupportedEncodingException, IllegalNameException, IOException {
        return InternalQName.parse(ValueDataConvertor.readString(value));
    }
}

