/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent.jbosscache;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.WorkspaceStorageCache;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.NullItemData;
import org.exoplatform.services.jcr.datamodel.NullNodeData;
import org.exoplatform.services.jcr.datamodel.NullPropertyData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.backup.Backupable;
import org.exoplatform.services.jcr.impl.backup.DataRestor;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.jbosscache.BufferedJBossCache;
import org.exoplatform.services.jcr.jbosscache.ExoJBossCacheFactory;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.transaction.TransactionService;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.ExpirationAlgorithmConfig;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCacheWorkspaceStorageCache
implements WorkspaceStorageCache,
Startable,
Backupable {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.JBossCacheWorkspaceStorageCache");
    private final boolean enabled;
    public static final String JBOSSCACHE_CONFIG = "jbosscache-configuration";
    public static final String JBOSSCACHE_EXPIRATION = "jbosscache-expiration-time";
    public static final String JBOSSCACHE_SHAREABLE = "jbosscache-shareable";
    public static final Boolean JBOSSCACHE_SHAREABLE_DEFAULT = Boolean.FALSE;
    public static final long JBOSSCACHE_EXPIRATION_DEFAULT = 900000L;
    public static final String ITEMS = "$ITEMS".intern();
    public static final String NULL_ITEMS = "$NULL_ITEMS".intern();
    public static final String CHILD_NODES = "$CHILD_NODES".intern();
    public static final String CHILD_PROPS = "$CHILD_PROPS".intern();
    public static final String CHILD_NODES_LIST = "$CHILD_NODES_LIST".intern();
    public static final String CHILD_PROPS_LIST = "$CHILD_PROPS_LIST".intern();
    public static final String LOCKS = "$LOCKS".intern();
    public static final String REFERENCE = "$REFERENCE".intern();
    public static final String ITEM_DATA = "$data".intern();
    public static final String ITEM_ID = "$id".intern();
    public static final String ITEM_LIST = "$lists".intern();
    protected final BufferedJBossCache cache;
    protected final Fqn<String> itemsRoot;
    protected final Fqn<String> refRoot;
    protected final Fqn<String> childNodes;
    protected final Fqn<String> childProps;
    protected final Fqn<String> childNodesList;
    protected final Fqn<String> childPropsList;
    protected final Fqn<String> rootFqn;
    protected volatile boolean initialized;

    public JBossCacheWorkspaceStorageCache(WorkspaceEntry wsConfig, TransactionService transactionService, ConfigurationManager cfm) throws RepositoryException, RepositoryConfigurationException {
        if (wsConfig.getCache() == null) {
            throw new RepositoryConfigurationException("Cache configuration not found");
        }
        this.enabled = wsConfig.getCache().isEnabled();
        ExoJBossCacheFactory factory = transactionService != null ? new ExoJBossCacheFactory(cfm, transactionService.getTransactionManager()) : new ExoJBossCacheFactory(cfm);
        Cache parentCache = factory.createCache(wsConfig.getCache());
        List evictionConfigurations = parentCache.getConfiguration().getEvictionConfig().getEvictionRegionConfigs();
        evictionConfigurations.add(parentCache.getConfiguration().getEvictionConfig().getDefaultEvictionRegionConfig());
        boolean useExpiration = false;
        for (EvictionRegionConfig evictionRegionConfig : evictionConfigurations) {
            if (!(evictionRegionConfig.getEvictionAlgorithmConfig() instanceof ExpirationAlgorithmConfig)) continue;
            ((ExpirationAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).setExpirationKeyName("expiration");
            useExpiration = true;
        }
        if (useExpiration) {
            LOG.info((Object)"Using BufferedJBossCache compatible with Expiration algorithm.");
        }
        this.rootFqn = Fqn.fromElements((Object[])new String[]{wsConfig.getUniqueName()});
        parentCache = ExoJBossCacheFactory.getUniqueInstance(ExoJBossCacheFactory.CacheType.JCR_CACHE, this.rootFqn, parentCache, wsConfig.getCache().getParameterBoolean(JBOSSCACHE_SHAREABLE, JBOSSCACHE_SHAREABLE_DEFAULT));
        this.cache = new BufferedJBossCache(parentCache, useExpiration, wsConfig.getCache().getParameterTime(JBOSSCACHE_EXPIRATION, 900000L));
        this.itemsRoot = Fqn.fromRelativeElements(this.rootFqn, (Object[])new String[]{ITEMS});
        this.refRoot = Fqn.fromRelativeElements(this.rootFqn, (Object[])new String[]{REFERENCE});
        this.childNodes = Fqn.fromRelativeElements(this.rootFqn, (Object[])new String[]{CHILD_NODES});
        this.childProps = Fqn.fromRelativeElements(this.rootFqn, (Object[])new String[]{CHILD_PROPS});
        this.childNodesList = Fqn.fromRelativeElements(this.rootFqn, (Object[])new String[]{CHILD_NODES_LIST});
        this.childPropsList = Fqn.fromRelativeElements(this.rootFqn, (Object[])new String[]{CHILD_PROPS_LIST});
        if (this.cache.getConfiguration().getCacheMode() == Configuration.CacheMode.LOCAL) {
            this.init();
        }
    }

    public JBossCacheWorkspaceStorageCache(WorkspaceEntry wsConfig, ConfigurationManager cfm) throws RepositoryException, RepositoryConfigurationException {
        this(wsConfig, null, cfm);
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        this.cache.create();
        this.cache.start();
        this.createResidentNode(this.childNodes);
        this.createResidentNode(this.refRoot);
        this.createResidentNode(this.childNodesList);
        this.createResidentNode(this.childProps);
        this.createResidentNode(this.childPropsList);
        this.createResidentNode(this.itemsRoot);
        this.initialized = true;
    }

    public void start() {
        this.init();
    }

    public void stop() {
    }

    protected void createResidentNode(Fqn fqn) {
        Node<Serializable, Object> cacheRoot = this.cache.getRoot();
        if (!cacheRoot.hasChild(fqn)) {
            this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
            cacheRoot.addChild(fqn).setResident(true);
        } else {
            this.cache.getNode(fqn).setResident(true);
        }
    }

    protected static String readJBCConfig(WorkspaceEntry wsConfig) throws RepositoryConfigurationException {
        if (wsConfig.getCache() != null) {
            return wsConfig.getCache().getParameterValue(JBOSSCACHE_CONFIG);
        }
        throw new RepositoryConfigurationException("Cache configuration not found");
    }

    public TransactionManager getTransactionManager() {
        return this.cache.getTransactionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(ItemData item) {
        if (item instanceof NullItemData) {
            this.putNullItem((NullItemData)item);
            return;
        }
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            if (item.isNode()) {
                this.putNode((NodeData)item, ModifyChildOption.NOT_MODIFY);
            } else {
                this.putProperty((PropertyData)item, ModifyChildOption.NOT_MODIFY);
            }
            Object var4_3 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
            throw throwable;
        }
    }

    @Override
    public void remove(ItemData item) {
        this.removeItem(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSaveItems(ItemStateChangesLog itemStates) {
        boolean rollback = true;
        try {
            this.cache.beginTransaction();
            for (ItemState state : itemStates.getAllStates()) {
                if (state.isAdded()) {
                    if (!state.isPersisted()) continue;
                    this.putItem(state.getData());
                    continue;
                }
                if (state.isUpdated()) {
                    ItemData prevItem;
                    if (!state.isPersisted() || (prevItem = this.putItemInBufferedCache(state.getData())) == null || !state.isNode()) continue;
                    this.updateInBuffer((NodeData)state.getData(), (NodeData)prevItem);
                    continue;
                }
                if (state.isDeleted()) {
                    this.removeItem(state.getData());
                    continue;
                }
                if (state.isRenamed()) {
                    this.putItem(state.getData());
                    continue;
                }
                if (state.isPathChanged()) {
                    this.updateTreePath(state.getOldPath(), state.getData().getQPath(), null);
                    continue;
                }
                if (!state.isMixinChanged() || !state.isPersisted()) continue;
                this.updateMixin((NodeData)state.getData());
            }
            this.cache.commitTransaction();
            rollback = false;
            Object var7_6 = null;
            if (rollback) {
                this.cache.rollbackTransaction();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (rollback) {
                this.cache.rollbackTransaction();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildNodes(NodeData parent, List<NodeData> childs) {
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            if (childs.size() > 0) {
                HashSet<String> set = new HashSet<String>();
                for (NodeData child : childs) {
                    this.putNode(child, ModifyChildOption.NOT_MODIFY);
                    set.add(child.getIdentifier());
                }
                this.cache.putIfAbsent(this.makeChildListFqn(this.childNodesList, parent.getIdentifier()), (Serializable)((Object)ITEM_LIST), set);
            } else {
                this.cache.putIfAbsent(this.makeChildListFqn(this.childNodesList, parent.getIdentifier()), (Serializable)((Object)ITEM_LIST), new HashSet());
            }
            Object var8_7 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildProperties(NodeData parent, List<PropertyData> childs) {
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            if (childs.size() > 0) {
                HashSet<String> set = new HashSet<String>();
                for (PropertyData child : childs) {
                    this.putProperty(child, ModifyChildOption.NOT_MODIFY);
                    set.add(child.getIdentifier());
                }
                this.cache.putIfAbsent(this.makeChildListFqn(this.childPropsList, parent.getIdentifier()), (Serializable)((Object)ITEM_LIST), set);
            } else {
                LOG.warn((Object)("Empty properties list cached " + (parent != null ? parent.getQPath().getAsString() : parent)));
            }
            Object var8_7 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
            throw throwable;
        }
    }

    @Override
    public void addChildPropertiesList(NodeData parent, List<PropertyData> childProperties) {
    }

    @Override
    public ItemData get(String parentId, QPathEntry name) {
        return this.get(parentId, name, ItemType.UNKNOWN);
    }

    @Override
    public ItemData get(String parentId, QPathEntry name, ItemType itemType) {
        String itemId = null;
        if (itemType == ItemType.UNKNOWN) {
            String propId;
            itemId = (String)this.cache.get(this.makeChildFqn(this.childNodes, parentId, name), (Serializable)((Object)ITEM_ID));
            if ((itemId == null || itemId.equals("_null_id")) && (propId = (String)this.cache.get(this.makeChildFqn(this.childProps, parentId, name), (Serializable)((Object)ITEM_ID))) != null) {
                itemId = propId;
            }
        } else {
            itemId = itemType == ItemType.NODE ? (String)this.cache.get(this.makeChildFqn(this.childNodes, parentId, name), (Serializable)((Object)ITEM_ID)) : (String)this.cache.get(this.makeChildFqn(this.childProps, parentId, name), (Serializable)((Object)ITEM_ID));
        }
        if (itemId != null) {
            if (itemId.equals("_null_id")) {
                if (itemType == ItemType.UNKNOWN || itemType == ItemType.NODE) {
                    return new NullNodeData();
                }
                return new NullPropertyData();
            }
            return this.get(itemId);
        }
        return null;
    }

    @Override
    public ItemData get(String id) {
        return this.getFromCacheById(id);
    }

    @Override
    public List<NodeData> getChildNodes(NodeData parent) {
        Set set = (Set)this.cache.get(this.makeChildListFqn(this.childNodesList, parent.getIdentifier()), (Serializable)((Object)ITEM_LIST));
        if (set != null) {
            ArrayList<NodeData> childs = new ArrayList<NodeData>();
            for (Object child : set) {
                NodeData node = (NodeData)this.cache.get(this.makeItemFqn((String)child), (Serializable)((Object)ITEM_DATA));
                if (node == null || node instanceof NullItemData) {
                    return null;
                }
                childs.add(node);
            }
            Collections.sort(childs, new NodesOrderComparator());
            return childs;
        }
        return null;
    }

    @Override
    public int getChildNodesCount(NodeData parent) {
        Set set = (Set)this.cache.get(this.makeChildListFqn(this.childNodesList, parent.getIdentifier()), (Serializable)((Object)ITEM_LIST));
        return set != null ? set.size() : -1;
    }

    @Override
    public List<PropertyData> getChildProperties(NodeData parent) {
        return this.getChildProps(parent.getIdentifier(), true);
    }

    @Override
    public List<PropertyData> listChildProperties(NodeData parent) {
        return this.getChildProps(parent.getIdentifier(), false);
    }

    @Override
    public List<PropertyData> getReferencedProperties(String identifier) {
        Set set = (Set)this.cache.get(this.makeRefFqn(identifier), (Serializable)((Object)ITEM_LIST));
        if (set != null) {
            ArrayList<PropertyData> props = new ArrayList<PropertyData>();
            for (String propId : set) {
                PropertyData prop = (PropertyData)this.cache.get(this.makeItemFqn(propId), (Serializable)((Object)ITEM_DATA));
                if (prop == null || prop instanceof NullItemData) {
                    return null;
                }
                List<ValueData> lData = prop.getValues();
                int length = lData.size();
                for (int i = 0; i < length; ++i) {
                    ValueData vdata = lData.get(i);
                    try {
                        if (!new String(vdata.getAsByteArray(), "UTF-8").equals(identifier)) continue;
                        props.add(prop);
                        continue;
                    }
                    catch (IllegalStateException e) {
                        continue;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
            return props;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReferencedProperties(String identifier, List<PropertyData> refProperties) {
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            HashSet<String> set = new HashSet<String>();
            for (PropertyData prop : refProperties) {
                this.putProperty(prop, ModifyChildOption.NOT_MODIFY);
                set.add(prop.getIdentifier());
            }
            this.cache.putIfAbsent(this.makeRefFqn(identifier), (Serializable)((Object)ITEM_LIST), set);
            Object var8_7 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
            throw throwable;
        }
    }

    protected List<PropertyData> getChildProps(String parentId, boolean withValue) {
        Set set = (Set)this.cache.get(this.makeChildListFqn(this.childPropsList, parentId), (Serializable)((Object)ITEM_LIST));
        if (set != null) {
            ArrayList<PropertyData> childs = new ArrayList<PropertyData>();
            for (Object child : set) {
                PropertyData prop = (PropertyData)this.cache.get(this.makeItemFqn((String)child), (Serializable)((Object)ITEM_DATA));
                if (prop == null || prop instanceof NullItemData) {
                    return null;
                }
                if (withValue && prop.getValues().size() <= 0) {
                    return null;
                }
                childs.add(prop);
            }
            return childs;
        }
        return null;
    }

    @Override
    public long getSize() {
        return JBossCacheWorkspaceStorageCache.numNodes(this.cache.getNode(this.rootFqn)) - 7L;
    }

    private static long numNodes(Node<Serializable, Object> n) {
        long count = 1L;
        if (n != null) {
            for (Node child : n.getChildren()) {
                count += JBossCacheWorkspaceStorageCache.numNodes((Node<Serializable, Object>)child);
            }
        }
        return count;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && this.initialized;
    }

    protected Fqn<String> makeItemFqn(String itemId) {
        return Fqn.fromRelativeElements(this.itemsRoot, (Object[])new String[]{itemId});
    }

    protected Fqn<String> makeRefFqn(String itemId) {
        return Fqn.fromRelativeElements(this.refRoot, (Object[])new String[]{itemId});
    }

    protected Fqn<String> makeChildFqn(Fqn<String> root, String parentId, QPathEntry childName) {
        return Fqn.fromRelativeElements(root, (Object[])new String[]{parentId, childName.getAsString(true)});
    }

    protected Fqn<String> makeChildFqn(Fqn<String> root, String parentId, String childName) {
        return Fqn.fromRelativeElements(root, (Object[])new String[]{parentId, childName});
    }

    protected Fqn<String> makeChildListFqn(Fqn<String> root, String parentId) {
        return Fqn.fromRelativeElements(root, (Object[])new String[]{parentId});
    }

    protected ItemData getFromCacheById(String id) {
        return (ItemData)this.cache.get(this.makeItemFqn(id), (Serializable)((Object)ITEM_DATA));
    }

    protected ItemData putItem(ItemData item) {
        if (item.isNode()) {
            return this.putNode((NodeData)item, ModifyChildOption.MODIFY);
        }
        return this.putProperty((PropertyData)item, ModifyChildOption.MODIFY);
    }

    protected ItemData putItemInBufferedCache(ItemData item) {
        if (item.isNode()) {
            return this.putNodeInBufferedCache((NodeData)item, ModifyChildOption.MODIFY);
        }
        return this.putProperty((PropertyData)item, ModifyChildOption.MODIFY);
    }

    protected ItemData putNode(NodeData node, ModifyChildOption modifyListsOfChild) {
        if (node.getParentIdentifier() != null) {
            this.cache.put(this.makeChildFqn(this.childNodes, node.getParentIdentifier(), node.getQPath().getEntries()[node.getQPath().getEntries().length - 1]), (Serializable)((Object)ITEM_ID), node.getIdentifier(), modifyListsOfChild == ModifyChildOption.NOT_MODIFY);
            if (modifyListsOfChild != ModifyChildOption.NOT_MODIFY) {
                this.cache.addToList(this.makeChildListFqn(this.childNodesList, node.getParentIdentifier()), ITEM_LIST, node.getIdentifier(), modifyListsOfChild == ModifyChildOption.FORCE_MODIFY);
            }
        }
        return (ItemData)this.cache.put(this.makeItemFqn(node.getIdentifier()), (Serializable)((Object)ITEM_DATA), node, modifyListsOfChild == ModifyChildOption.NOT_MODIFY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putNullItem(NullItemData item) {
        boolean inTransaction = this.cache.isTransactionActive();
        try {
            if (!inTransaction) {
                this.cache.beginTransaction();
            }
            this.cache.setLocal(true);
            if (!item.getIdentifier().equals("_null_id")) {
                this.cache.putIfAbsent(this.makeItemFqn(item.getIdentifier()), (Serializable)((Object)ITEM_DATA), item);
            } else if (item.getName() != null && item.getParentIdentifier() != null) {
                if (item.isNode()) {
                    this.cache.putIfAbsent(this.makeChildFqn(this.childNodes, item.getParentIdentifier(), item.getName()), (Serializable)((Object)ITEM_ID), "_null_id");
                } else {
                    this.cache.putIfAbsent(this.makeChildFqn(this.childProps, item.getParentIdentifier(), item.getName()), (Serializable)((Object)ITEM_ID), "_null_id");
                }
            }
            Object var4_3 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.cache.setLocal(false);
            if (!inTransaction) {
                this.dedicatedTxCommit();
            }
            throw throwable;
        }
    }

    protected ItemData putNodeInBufferedCache(NodeData node, ModifyChildOption modifyListsOfChild) {
        ItemData returnedData;
        if (node.getParentIdentifier() != null) {
            this.cache.put(this.makeChildFqn(this.childNodes, node.getParentIdentifier(), node.getQPath().getEntries()[node.getQPath().getEntries().length - 1]), (Serializable)((Object)ITEM_ID), (Object)node.getIdentifier());
            if (modifyListsOfChild != ModifyChildOption.NOT_MODIFY) {
                this.cache.addToList(this.makeChildListFqn(this.childNodesList, node.getParentIdentifier()), ITEM_LIST, node.getIdentifier(), modifyListsOfChild == ModifyChildOption.FORCE_MODIFY);
            }
        }
        return (returnedData = (ItemData)this.cache.putInBuffer(this.makeItemFqn(node.getIdentifier()), (Serializable)((Object)ITEM_DATA), node)) instanceof NullItemData ? null : returnedData;
    }

    protected PropertyData putProperty(PropertyData prop, ModifyChildOption modifyListsOfChild) {
        this.cache.put(this.makeChildFqn(this.childProps, prop.getParentIdentifier(), prop.getQPath().getEntries()[prop.getQPath().getEntries().length - 1]), (Serializable)((Object)ITEM_ID), prop.getIdentifier(), modifyListsOfChild == ModifyChildOption.NOT_MODIFY);
        if (modifyListsOfChild != ModifyChildOption.NOT_MODIFY) {
            this.cache.addToList(this.makeChildListFqn(this.childPropsList, prop.getParentIdentifier()), ITEM_LIST, prop.getIdentifier(), modifyListsOfChild == ModifyChildOption.FORCE_MODIFY);
        }
        if (modifyListsOfChild != ModifyChildOption.NOT_MODIFY && prop.getType() == 9) {
            List<ValueData> lData = prop.getValues();
            int length = lData.size();
            for (int i = 0; i < length; ++i) {
                ValueData vdata = lData.get(i);
                String nodeIdentifier = null;
                try {
                    nodeIdentifier = new String(vdata.getAsByteArray(), "UTF-8");
                }
                catch (IllegalStateException e) {
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.cache.addToList(this.makeRefFqn(nodeIdentifier), ITEM_LIST, prop.getIdentifier(), modifyListsOfChild == ModifyChildOption.FORCE_MODIFY);
            }
        }
        ItemData returnedData = (ItemData)this.cache.put(this.makeItemFqn(prop.getIdentifier()), (Serializable)((Object)ITEM_DATA), prop, modifyListsOfChild == ModifyChildOption.NOT_MODIFY);
        return returnedData instanceof NullItemData ? null : (PropertyData)returnedData;
    }

    protected void removeItem(ItemData item) {
        if (item.isNode()) {
            if (item.getParentIdentifier() != null) {
                this.cache.removeNode(this.makeChildFqn(this.childNodes, item.getParentIdentifier(), item.getQPath().getEntries()[item.getQPath().getEntries().length - 1]));
                this.cache.removeFromList(this.makeChildListFqn(this.childNodesList, item.getParentIdentifier()), ITEM_LIST, item.getIdentifier());
                this.cache.removeNode(this.makeChildListFqn(this.childNodes, item.getIdentifier()));
                this.cache.removeNode(this.makeChildListFqn(this.childNodesList, item.getIdentifier()));
                this.cache.removeNode(this.makeChildListFqn(this.childProps, item.getIdentifier()));
                this.cache.removeNode(this.makeChildListFqn(this.childPropsList, item.getIdentifier()));
            }
            this.cache.removeNode(this.makeRefFqn(item.getIdentifier()));
        } else {
            this.cache.removeNode(this.makeChildFqn(this.childProps, item.getParentIdentifier(), item.getQPath().getEntries()[item.getQPath().getEntries().length - 1]));
            this.cache.removeFromList(this.makeChildListFqn(this.childPropsList, item.getParentIdentifier()), ITEM_LIST, item.getIdentifier());
        }
        this.cache.removeNode(this.makeItemFqn(item.getIdentifier()));
    }

    protected void updateMixin(NodeData node) {
        NodeData prevData = (NodeData)this.cache.put(this.makeItemFqn(node.getIdentifier()), (Serializable)((Object)ITEM_DATA), (Object)node);
        if (prevData != null && !(prevData instanceof NullItemData)) {
            if (prevData.getACL() == null || !prevData.getACL().equals(node.getACL())) {
                this.updateChildsACL(node.getIdentifier(), node.getACL());
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Previous NodeData not found for mixin update " + node.getQPath().getAsString()));
        }
    }

    protected void update(NodeData node, NodeData prevNode) {
        int prevNodeIndex;
        int nodeIndex;
        Fqn<String> prevFqn = this.makeChildFqn(this.childNodes, node.getParentIdentifier(), prevNode.getQPath().getEntries()[prevNode.getQPath().getEntries().length - 1]);
        if (node.getIdentifier().equals(this.cache.get(prevFqn, (Serializable)((Object)ITEM_ID))) && !this.cache.removeNode(prevFqn) && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Node not extists as a child but update asked " + node.getQPath().getAsString()));
        }
        if ((nodeIndex = node.getQPath().getEntries()[node.getQPath().getEntries().length - 1].getIndex()) != (prevNodeIndex = prevNode.getQPath().getEntries()[prevNode.getQPath().getEntries().length - 1].getIndex())) {
            this.updateTreePath(node.getIdentifier(), node.getQPath(), null);
        }
    }

    protected void updateInBuffer(NodeData node, NodeData prevNode) {
        int prevNodeIndex;
        int nodeIndex;
        Fqn<String> prevFqn = this.makeChildFqn(this.childNodes, node.getParentIdentifier(), prevNode.getQPath().getEntries()[prevNode.getQPath().getEntries().length - 1]);
        if (node.getIdentifier().equals(this.cache.getFromBuffer(prevFqn, (Serializable)((Object)ITEM_ID))) && !this.cache.removeNode(prevFqn) && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Node not extists as a child but update asked " + node.getQPath().getAsString()));
        }
        if ((nodeIndex = node.getQPath().getEntries()[node.getQPath().getEntries().length - 1].getIndex()) != (prevNodeIndex = prevNode.getQPath().getEntries()[prevNode.getQPath().getEntries().length - 1].getIndex())) {
            this.updateTreePath(prevNode.getQPath(), node.getQPath(), null);
        }
    }

    protected void updateTreePath(QPath prevRootPath, QPath newRootPath, AccessControlList acl) {
        boolean inheritACL = acl != null;
        Node<Serializable, Object> items = this.cache.getNode(this.itemsRoot);
        Set childrenNames = items.getChildrenNames();
        for (String id : childrenNames) {
            ItemData data = (ItemData)this.cache.get(this.makeItemFqn(id), (Serializable)((Object)ITEM_DATA));
            QPath nodeQPath = data.getQPath();
            if (nodeQPath == null || !nodeQPath.isDescendantOf(prevRootPath)) continue;
            QPathEntry[] relativePath = null;
            try {
                relativePath = nodeQPath.getRelPath(nodeQPath.getDepth() - prevRootPath.getDepth());
            }
            catch (IllegalPathException e) {
                // empty catch block
            }
            QPath newPath = QPath.makeChildPath(newRootPath, relativePath);
            if (data.isNode()) {
                NodeData prevNode = (NodeData)data;
                TransientNodeData newNode = new TransientNodeData(newPath, prevNode.getIdentifier(), prevNode.getPersistedVersion(), prevNode.getPrimaryTypeName(), prevNode.getMixinTypeNames(), prevNode.getOrderNumber(), prevNode.getParentIdentifier(), inheritACL ? acl : prevNode.getACL());
                this.cache.put(this.makeItemFqn(newNode.getIdentifier()), (Serializable)((Object)ITEM_DATA), (Object)newNode);
                continue;
            }
            PropertyData prevProp = (PropertyData)data;
            if (inheritACL && (prevProp.getQPath().getName().equals((Object)Constants.EXO_PERMISSIONS) || prevProp.getQPath().getName().equals((Object)Constants.EXO_OWNER))) {
                inheritACL = false;
            }
            TransientPropertyData newProp = new TransientPropertyData(newPath, prevProp.getIdentifier(), prevProp.getPersistedVersion(), prevProp.getType(), prevProp.getParentIdentifier(), prevProp.isMultiValued(), prevProp.getValues());
            this.cache.put(this.makeItemFqn(newProp.getIdentifier()), (Serializable)((Object)ITEM_DATA), (Object)newProp);
        }
    }

    protected void updateTreePath(String parentId, QPath rootPath, AccessControlList acl) {
        QPath newPath;
        boolean inheritACL = acl != null;
        ChildItemsIterator iter = new ChildPropertiesIterator(parentId);
        while (iter.hasNext()) {
            PropertyData prevProp = (PropertyData)iter.next();
            if (inheritACL && (prevProp.getQPath().getName().equals((Object)Constants.EXO_PERMISSIONS) || prevProp.getQPath().getName().equals((Object)Constants.EXO_OWNER))) {
                inheritACL = false;
            }
            newPath = QPath.makeChildPath(rootPath, prevProp.getQPath().getEntries()[prevProp.getQPath().getEntries().length - 1]);
            TransientPropertyData newProp = new TransientPropertyData(newPath, prevProp.getIdentifier(), prevProp.getPersistedVersion(), prevProp.getType(), prevProp.getParentIdentifier(), prevProp.isMultiValued(), prevProp.getValues());
            this.cache.put(this.makeItemFqn(newProp.getIdentifier()), (Serializable)((Object)ITEM_DATA), (Object)newProp);
        }
        iter = new ChildNodesIterator(parentId);
        while (iter.hasNext()) {
            NodeData prevNode = (NodeData)iter.next();
            newPath = QPath.makeChildPath(rootPath, prevNode.getQPath().getEntries()[prevNode.getQPath().getEntries().length - 1]);
            TransientNodeData newNode = new TransientNodeData(newPath, prevNode.getIdentifier(), prevNode.getPersistedVersion(), prevNode.getPrimaryTypeName(), prevNode.getMixinTypeNames(), prevNode.getOrderNumber(), prevNode.getParentIdentifier(), inheritACL ? acl : prevNode.getACL());
            this.cache.put(this.makeItemFqn(newNode.getIdentifier()), (Serializable)((Object)ITEM_DATA), (Object)newNode);
            this.updateTreePath(newNode.getIdentifier(), newNode.getQPath(), inheritACL ? acl : null);
        }
    }

    protected void updateChildsACL(String parentId, AccessControlList acl) {
        ChildNodesIterator iter = new ChildNodesIterator(parentId);
        block0: while (iter.hasNext()) {
            NodeData prevNode = (NodeData)iter.next();
            for (InternalQName mixin : prevNode.getMixinTypeNames()) {
                if (mixin.equals((Object)Constants.EXO_PRIVILEGEABLE) || mixin.equals((Object)Constants.EXO_OWNEABLE)) continue block0;
            }
            TransientNodeData newNode = new TransientNodeData(prevNode.getQPath(), prevNode.getIdentifier(), prevNode.getPersistedVersion(), prevNode.getPrimaryTypeName(), prevNode.getMixinTypeNames(), prevNode.getOrderNumber(), prevNode.getParentIdentifier(), acl);
            this.cache.put(this.makeItemFqn(newNode.getIdentifier()), (Serializable)((Object)ITEM_DATA), (Object)newNode);
            this.updateChildsACL(newNode.getIdentifier(), acl);
        }
    }

    @Override
    public void beginTransaction() {
        this.cache.beginTransaction();
    }

    @Override
    public void commitTransaction() {
        this.cache.commitTransaction();
    }

    @Override
    public void rollbackTransaction() {
        this.cache.rollbackTransaction();
    }

    @Override
    public boolean isTXAware() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dedicatedTxCommit() {
        TransactionManager tm = this.getTransactionManager();
        Transaction tx = null;
        try {
            if (tm != null) {
                try {
                    tx = tm.suspend();
                }
                catch (Exception e) {
                    LOG.warn((Object)"Cannot suspend the current transaction", (Throwable)e);
                }
            }
            this.cache.commitTransaction();
            Object var5_4 = null;
            if (tx == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (tx == null) throw throwable;
            try {
                tm.resume(tx);
                throw throwable;
            }
            catch (Exception e) {
                LOG.warn((Object)"Cannot resume the current transaction", (Throwable)e);
            }
            throw throwable;
        }
        try {
            tm.resume(tx);
            return;
        }
        catch (Exception e) {
            LOG.warn((Object)"Cannot resume the current transaction", (Throwable)e);
        }
    }

    @Override
    public void backup(File storageDir) throws BackupException {
    }

    @Override
    public void clean() throws BackupException {
        this.cleanCache();
    }

    @Override
    public DataRestor getDataRestorer(File storageDir) throws BackupException {
        return new DataRestor(){

            public void clean() throws BackupException {
                JBossCacheWorkspaceStorageCache.this.cleanCache();
            }

            public void restore() throws BackupException {
            }

            public void commit() throws BackupException {
            }

            public void rollback() throws BackupException {
            }

            public void close() throws BackupException {
            }
        };
    }

    private void cleanCache() {
        if (this.cache.getCacheStatus() == CacheStatus.STARTED) {
            this.cache.beginTransaction();
            this.cache.removeNode(this.itemsRoot);
            this.cache.removeNode(this.refRoot);
            this.cache.removeNode(this.childNodes);
            this.cache.removeNode(this.childProps);
            this.cache.removeNode(this.childNodesList);
            this.cache.removeNode(this.childPropsList);
            this.cache.commitTransaction();
            this.createResidentNode(this.childNodes);
            this.createResidentNode(this.refRoot);
            this.createResidentNode(this.childNodesList);
            this.createResidentNode(this.childProps);
            this.createResidentNode(this.childPropsList);
            this.createResidentNode(this.itemsRoot);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ModifyChildOption {
        NOT_MODIFY,
        MODIFY,
        FORCE_MODIFY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ChildPropertiesIterator<P extends PropertyData>
    extends ChildItemsIterator<P> {
        ChildPropertiesIterator(String parentId) {
            super(JBossCacheWorkspaceStorageCache.this.childProps, parentId);
        }

        @Override
        public P next() {
            return (P)((PropertyData)super.next());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ChildNodesIterator<N extends NodeData>
    extends ChildItemsIterator<N> {
        ChildNodesIterator(String parentId) {
            super(JBossCacheWorkspaceStorageCache.this.childNodes, parentId);
        }

        @Override
        public N next() {
            return (N)((NodeData)super.next());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ChildItemsIterator<T extends ItemData>
    implements Iterator<T> {
        final Iterator<Object> childs;
        final String parentId;
        final Fqn<String> root;
        T next;

        ChildItemsIterator(Fqn<String> root, String parentId) {
            this.parentId = parentId;
            this.root = root;
            Fqn<String> parentFqn = JBossCacheWorkspaceStorageCache.this.makeChildListFqn(root, parentId);
            Node<Serializable, Object> parent = JBossCacheWorkspaceStorageCache.this.cache.getNode(parentFqn);
            if (parent != null) {
                this.childs = JBossCacheWorkspaceStorageCache.this.cache.getChildrenNames(parentFqn).iterator();
                this.fetchNext();
            } else {
                this.childs = null;
                this.next = null;
            }
        }

        protected void fetchNext() {
            if (this.childs.hasNext()) {
                ItemData n = null;
                do {
                    String itemId;
                    if ((itemId = (String)JBossCacheWorkspaceStorageCache.this.cache.get(JBossCacheWorkspaceStorageCache.this.makeChildFqn(this.root, this.parentId, (String)this.childs.next()), (Serializable)((Object)ITEM_ID))) == null) continue;
                    n = (ItemData)JBossCacheWorkspaceStorageCache.this.cache.get(JBossCacheWorkspaceStorageCache.this.makeItemFqn(itemId), (Serializable)((Object)ITEM_DATA));
                } while (n == null && this.childs.hasNext());
                this.next = n;
            } else {
                this.next = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            T current = this.next;
            this.fetchNext();
            return current;
        }

        @Override
        public void remove() {
            throw new IllegalArgumentException("Not implemented");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NodesOrderComparator<N extends NodeData>
    implements Comparator<NodeData> {
        NodesOrderComparator() {
        }

        @Override
        public int compare(NodeData n1, NodeData n2) {
            return n1.getOrderNumber() - n2.getOrderNumber();
        }
    }
}

