/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.exoplatform.commons.utils.PrivilegedFileHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryHelper {
    public static List<File> listFiles(File srcPath) throws IOException {
        ArrayList<File> result = new ArrayList<File>();
        if (!PrivilegedFileHelper.isDirectory((File)srcPath)) {
            throw new IOException(PrivilegedFileHelper.getAbsolutePath((File)srcPath) + " is a directory");
        }
        for (File subFile : PrivilegedFileHelper.listFiles((File)srcPath)) {
            result.add(subFile);
            if (!subFile.isDirectory()) continue;
            result.addAll(DirectoryHelper.listFiles(subFile));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyDirectory(File srcPath, File dstPath) throws IOException {
        FileOutputStream out;
        block7: {
            if (PrivilegedFileHelper.isDirectory((File)srcPath)) {
                if (!PrivilegedFileHelper.exists((File)dstPath)) {
                    PrivilegedFileHelper.mkdirs((File)dstPath);
                }
                String[] files = PrivilegedFileHelper.list((File)srcPath);
                for (int i = 0; i < files.length; ++i) {
                    DirectoryHelper.copyDirectory(new File(srcPath, files[i]), new File(dstPath, files[i]));
                }
                return;
            }
            FileInputStream in = null;
            out = null;
            try {
                int len;
                in = PrivilegedFileHelper.fileInputStream((File)srcPath);
                out = PrivilegedFileHelper.fileOutputStream((File)dstPath);
                byte[] buf = new byte[2048];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                Object var7_8 = null;
                if (in == null) break block7;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (out == null) throw throwable;
                out.flush();
                ((OutputStream)out).close();
                throw throwable;
            }
            ((InputStream)in).close();
        }
        if (out == null) return;
        out.flush();
        ((OutputStream)out).close();
    }

    public static void removeDirectory(File dir) throws IOException {
        if (PrivilegedFileHelper.isDirectory((File)dir)) {
            for (File subFile : PrivilegedFileHelper.listFiles((File)dir)) {
                DirectoryHelper.removeDirectory(subFile);
            }
            if (!PrivilegedFileHelper.delete((File)dir)) {
                throw new IOException("Can't remove folder : " + PrivilegedFileHelper.getCanonicalPath((File)dir));
            }
        } else if (!PrivilegedFileHelper.delete((File)dir)) {
            throw new IOException("Can't remove file : " + PrivilegedFileHelper.getCanonicalPath((File)dir));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void compressDirectory(File srcPath, File dstPath) throws IOException {
        ZipOutputStream out;
        block7: {
            if (PrivilegedFileHelper.isDirectory((File)srcPath)) {
                if (!PrivilegedFileHelper.exists((File)dstPath)) {
                    PrivilegedFileHelper.mkdirs((File)dstPath);
                }
                String[] files = PrivilegedFileHelper.list((File)srcPath);
                for (int i = 0; i < files.length; ++i) {
                    DirectoryHelper.compressDirectory(new File(srcPath, files[i]), new File(dstPath, files[i]));
                }
                return;
            }
            FileInputStream in = null;
            out = null;
            try {
                int len;
                in = PrivilegedFileHelper.fileInputStream((File)srcPath);
                out = PrivilegedFileHelper.zipOutputStream((File)dstPath);
                out.putNextEntry(new ZipEntry(srcPath.getName()));
                byte[] buf = new byte[2048];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                Object var7_8 = null;
                if (in == null) break block7;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (out == null) throw throwable;
                out.flush();
                out.closeEntry();
                out.close();
                throw throwable;
            }
            ((InputStream)in).close();
        }
        if (out == null) return;
        out.flush();
        out.closeEntry();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void uncompressDirectory(File srcPath, File dstPath) throws IOException {
        FileOutputStream out;
        block7: {
            if (PrivilegedFileHelper.isDirectory((File)srcPath)) {
                if (!PrivilegedFileHelper.exists((File)dstPath)) {
                    PrivilegedFileHelper.mkdirs((File)dstPath);
                }
                String[] files = PrivilegedFileHelper.list((File)srcPath);
                for (int i = 0; i < files.length; ++i) {
                    DirectoryHelper.uncompressDirectory(new File(srcPath, files[i]), new File(dstPath, files[i]));
                }
                return;
            }
            ZipInputStream in = null;
            out = null;
            try {
                int len;
                in = PrivilegedFileHelper.zipInputStream((File)srcPath);
                in.getNextEntry();
                out = PrivilegedFileHelper.fileOutputStream((File)dstPath);
                byte[] buf = new byte[2048];
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                Object var7_8 = null;
                if (in == null) break block7;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (in != null) {
                    in.close();
                }
                if (out == null) throw throwable;
                ((OutputStream)out).close();
                throw throwable;
            }
            in.close();
        }
        if (out == null) return;
        ((OutputStream)out).close();
    }
}

