/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.jbosscache;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrivilegedJBossCacheHelper {
    public static void start(final Cache<Serializable, Object> cache) {
        PrivilegedAction<Object> action = new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                cache.start();
                return null;
            }
        };
        AccessController.doPrivileged(action);
    }

    public static void stop(final Cache<Serializable, Object> cache) {
        PrivilegedAction<Object> action = new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                cache.stop();
                return null;
            }
        };
        AccessController.doPrivileged(action);
    }

    public static void create(final Cache<Serializable, Object> cache) {
        PrivilegedAction<Object> action = new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                cache.create();
                return null;
            }
        };
        AccessController.doPrivileged(action);
    }

    public static Object put(final Cache<Serializable, Object> cache, final String fqn, final Serializable key, final Object value) throws CacheException {
        PrivilegedExceptionAction<Object> action = new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                return cache.put(fqn, (Object)key, value);
            }
        };
        try {
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof CacheException) {
                throw (CacheException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static Object put(final Cache<Serializable, Object> cache, final Fqn fqn, final Serializable key, final Object value) throws CacheException {
        PrivilegedExceptionAction<Object> action = new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                return cache.put(fqn, (Object)key, value);
            }
        };
        try {
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof CacheException) {
                throw (CacheException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static Object removeNode(final Cache<Serializable, Object> cache, final Fqn fqn) throws CacheException {
        PrivilegedExceptionAction<Object> action = new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                return cache.removeNode(fqn);
            }
        };
        try {
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof CacheException) {
                throw (CacheException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

