/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.macro.descriptor;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.xwiki.properties.BeanDescriptor;
import org.xwiki.properties.PropertyDescriptor;
import org.xwiki.rendering.macro.MacroId;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultParameterDescriptor;
import org.xwiki.rendering.macro.descriptor.MacroDescriptor;
import org.xwiki.rendering.macro.descriptor.ParameterDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMacroDescriptor
implements MacroDescriptor {
    private MacroId id;
    private String name;
    private String description;
    private ContentDescriptor contentDescriptor;
    private BeanDescriptor parametersBeanDescriptor;
    private String defaultCategory;
    private Map<String, ParameterDescriptor> parameterDescriptorMap = new LinkedHashMap<String, ParameterDescriptor>();

    public AbstractMacroDescriptor(MacroId id, String name, String description, ContentDescriptor contentDescriptor, BeanDescriptor parametersBeanDescriptor) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.contentDescriptor = contentDescriptor;
        this.parametersBeanDescriptor = parametersBeanDescriptor;
    }

    @Deprecated
    public AbstractMacroDescriptor(String name, String description, ContentDescriptor contentDescriptor, BeanDescriptor parametersBeanDescriptor) {
        this.name = name;
        this.description = description;
        this.contentDescriptor = contentDescriptor;
        this.parametersBeanDescriptor = parametersBeanDescriptor;
    }

    protected void extractParameterDescriptorMap() {
        for (PropertyDescriptor propertyDescriptor : this.parametersBeanDescriptor.getProperties()) {
            DefaultParameterDescriptor desc = new DefaultParameterDescriptor(propertyDescriptor);
            this.parameterDescriptorMap.put(desc.getId().toLowerCase(), desc);
        }
    }

    @Override
    public MacroId getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ContentDescriptor getContentDescriptor() {
        return this.contentDescriptor;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Class<?> getParametersBeanClass() {
        return null != this.parametersBeanDescriptor ? this.parametersBeanDescriptor.getBeanClass() : Object.class;
    }

    @Override
    public Map<String, ParameterDescriptor> getParameterDescriptorMap() {
        return null != this.parametersBeanDescriptor ? Collections.unmodifiableMap(this.parameterDescriptorMap) : Collections.emptyMap();
    }

    @Override
    public String getDefaultCategory() {
        return this.defaultCategory;
    }

    public void setDefaultCategory(String defaultCategory) {
        this.defaultCategory = defaultCategory;
    }
}

