/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.w3c.dom.Node;
import org.xwiki.xml.ExtractHandler;

public final class XMLUtils {
    private XMLUtils() {
    }

    public static String extractXML(Node node, int start, int length) {
        ExtractHandler handler = null;
        try {
            handler = new ExtractHandler(start, length);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(new DOMSource(node), new SAXResult(handler));
            return handler.getResult();
        }
        catch (Throwable t) {
            if (handler != null && handler.isFinished()) {
                return handler.getResult();
            }
            throw new RuntimeException("Failed to extract XML", t);
        }
    }

    public static String escapeXMLComment(String content) {
        StringBuffer str = new StringBuffer(content.length());
        char[] buff = content.toCharArray();
        int lastChar = 0;
        for (int n : buff) {
            if (n == 92) {
                str.append('\\');
            } else if (n == 45 && lastChar == 45) {
                str.append('\\');
            }
            str.append((char)n);
            lastChar = n;
        }
        if (lastChar == 45) {
            str.append('\\');
        }
        return str.toString();
    }

    public static String unescapeXMLComment(String content) {
        StringBuffer str = new StringBuffer(content.length());
        char[] buff = content.toCharArray();
        boolean escaped = false;
        for (char c : buff) {
            if (!escaped && c == '\\') {
                escaped = true;
                continue;
            }
            str.append(c);
            escaped = false;
        }
        return str.toString();
    }
}

