/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.util.Random;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.demos.CausalMessage;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;

public class CausalDemo
implements Runnable {
    private Channel channel;
    private final Vector alphabet = new Vector();
    private boolean starter = false;
    private int doneCount = 0;
    private Log log = LogFactory.getLog(this.getClass());
    private final String props = "causal.xml";

    public CausalDemo(boolean start) {
        this.starter = start;
    }

    public String getNext(String c) {
        char letter = c.charAt(0);
        return new String(new char[]{letter = (char)(letter + '\u0001')});
    }

    public void listAlphabet() {
        System.out.println(this.alphabet);
    }

    @Override
    public void run() {
        Random r = new Random();
        try {
            this.channel = new JChannel("causal.xml");
            this.channel.connect("CausalGroup");
            System.out.println("View:" + this.channel.getView());
            if (this.starter) {
                this.channel.send(new Message(null, null, new CausalMessage("A", this.channel.getView().getMembers().get(0))));
            }
        }
        catch (Exception e) {
            System.out.println("Could not conec to channel");
        }
        try {
            Runtime.getRuntime().addShutdownHook(new Thread("Shutdown cleanup thread"){

                @Override
                public void run() {
                    CausalDemo.this.listAlphabet();
                    CausalDemo.this.channel.disconnect();
                    CausalDemo.this.channel.close();
                }
            });
        }
        catch (Exception e) {
            System.out.println("Exception while shutting down" + e);
        }
        while (true) {
            try {
                while (true) {
                    CausalMessage cm = null;
                    Object obj = this.channel.receive(0L);
                    if (!(obj instanceof Message)) continue;
                    Message msg = (Message)obj;
                    cm = (CausalMessage)msg.getObject();
                    Vector<Address> members = this.channel.getView().getMembers();
                    String receivedLetter = cm.message;
                    if ("Z".equals(receivedLetter)) {
                        this.channel.send(new Message(null, null, new CausalMessage("done", null)));
                    }
                    if ("done".equals(receivedLetter)) {
                        if (++this.doneCount < members.size()) continue;
                        System.exit(0);
                        continue;
                    }
                    this.alphabet.add(receivedLetter);
                    this.listAlphabet();
                    if (!cm.member.equals(this.channel.getAddress())) continue;
                    int nextTarget = r.nextInt(members.size());
                    while (nextTarget == members.indexOf(this.channel.getAddress())) {
                        nextTarget = r.nextInt(members.size());
                    }
                    Address next = members.get(nextTarget);
                    String nextChar = this.getNext(receivedLetter);
                    if (nextChar.compareTo("Z") >= 1) continue;
                    System.out.println("Sending " + nextChar);
                    this.channel.send(new Message(null, null, new CausalMessage(nextChar, next)));
                }
            }
            catch (ChannelNotConnectedException conn) {
            }
            catch (Exception e) {
                this.log.error(e.toString());
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        CausalDemo test = null;
        boolean start = false;
        for (int i = 0; i < args.length; ++i) {
            if ("-help".equals(args[i])) {
                System.out.println("CausalDemo [-help] [-start]");
                return;
            }
            if (!"-start".equals(args[i])) continue;
            start = true;
        }
        test = new CausalDemo(start);
        try {
            new Thread(test).start();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }
}

