/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Membership;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.TimeoutException;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.annotations.DeprecatedProperty;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.logging.Log;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.pbcast.ClientGmsImpl;
import org.jgroups.protocols.pbcast.CoordGmsImpl;
import org.jgroups.protocols.pbcast.GmsImpl;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.protocols.pbcast.MergeData;
import org.jgroups.protocols.pbcast.Merger;
import org.jgroups.protocols.pbcast.ParticipantGmsImpl;
import org.jgroups.stack.Protocol;
import org.jgroups.util.AckCollector;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Digest;
import org.jgroups.util.MergeId;
import org.jgroups.util.Queue;
import org.jgroups.util.QueueClosedException;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

@MBean(description="Group membership protocol")
@DeprecatedProperty(names={"join_retry_timeout", "digest_timeout", "use_flush", "flush_timeout", "merge_leader", "reject_join_from_existing_member", "shun"})
public class GMS
extends Protocol
implements TP.ProbeHandler {
    private static final String CLIENT = "Client";
    private static final String COORD = "Coordinator";
    private static final String PART = "Participant";
    @Property(description="Join timeout")
    long join_timeout = 5000L;
    @Property(description="Leave timeout")
    long leave_timeout = 5000L;
    @Property(description="Timeout to complete merge")
    long merge_timeout = 5000L;
    @Property(description="Print local address of this member after connect. Default is true")
    private boolean print_local_addr = true;
    @Property(description="Print physical address(es) on startup")
    private boolean print_physical_addrs = true;
    @Property(description="If true this member can never become coordinator. Default is false", deprecatedMessage="This method will be deprecated in 3.0")
    boolean disable_initial_coord = false;
    @Property(description="Temporary switch. Default is true and should not be changed")
    boolean handle_concurrent_startup = true;
    @Property(description="View bundling toggle")
    private boolean view_bundling = true;
    @Property(description="Max view bundling timeout if view bundling is turned on. Default is 50 msec")
    private long max_bundling_time = 50L;
    @Property(description="Max number of old members to keep in history. Default is 50")
    protected int num_prev_mbrs = 50;
    @Property(description="Time in ms to wait for all VIEW acks (0 == wait forever. Default is 2000 msec")
    long view_ack_collection_timeout = 2000L;
    @Property(description="Timeout to resume ViewHandler. Default is 10000 msec")
    long resume_task_timeout = 10000L;
    @Property(description="Use flush for view changes. Default is true")
    boolean use_flush_if_present = true;
    @Property(description="Logs failures for collecting all view acks if true")
    boolean log_collect_msgs = true;
    private int num_views = 0;
    private final BoundedList<View> prev_views = new BoundedList(20);
    @Property(converter=PropertyConverters.FlushInvoker.class, name="flush_invoker_class")
    protected Class<Callable<Boolean>> flushInvokerClass;
    private GmsImpl impl = null;
    private final Object impl_mutex = new Object();
    private final Hashtable<String, GmsImpl> impls = new Hashtable(3);
    final Merger merger = new Merger(this, this.log);
    protected Address local_addr = null;
    protected final Membership members = new Membership();
    private final Membership tmp_members = new Membership();
    private final Vector<Address> joining = new Vector(7);
    private final Vector<Address> leaving = new Vector(7);
    private BoundedList<Address> prev_members = null;
    protected View view = null;
    protected ViewId view_id = null;
    protected long ltime = 0L;
    protected TimeScheduler timer = null;
    private final ViewHandler view_handler = new ViewHandler();
    protected final AckCollector ack_collector = new AckCollector();
    protected final AckCollector merge_ack_collector = new AckCollector();
    boolean flushProtocolInStack = false;

    public GMS() {
        this.initState();
    }

    @ManagedAttribute
    public String getView() {
        return this.view_id != null ? this.view_id.toString() : "null";
    }

    @ManagedAttribute
    public int getNumberOfViews() {
        return this.num_views;
    }

    @ManagedAttribute
    public String getLocalAddress() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    @ManagedAttribute
    public String getMembers() {
        return this.members.toString();
    }

    @ManagedAttribute
    public int getNumMembers() {
        return this.members.size();
    }

    public long getJoinTimeout() {
        return this.join_timeout;
    }

    public void setJoinTimeout(long t) {
        this.join_timeout = t;
    }

    public long getMergeTimeout() {
        return this.merge_timeout;
    }

    public void setMergeTimeout(long timeout) {
        this.merge_timeout = timeout;
    }

    public static long getJoinRetryTimeout() {
        return -1L;
    }

    public void setJoinRetryTimeout(long t) {
    }

    @Deprecated
    public static boolean isShun() {
        return false;
    }

    @Deprecated
    public void setShun(boolean s) {
    }

    @ManagedOperation
    public String printPreviousMembers() {
        StringBuilder sb = new StringBuilder();
        if (this.prev_members != null) {
            for (Address addr : this.prev_members) {
                sb.append(addr).append("\n");
            }
        }
        return sb.toString();
    }

    public void setPrintLocalAddress(boolean flag) {
        this.print_local_addr = flag;
    }

    public void setPrintLocalAddr(boolean flag) {
        this.setPrintLocalAddress(flag);
    }

    public long getViewAckCollectionTimeout() {
        return this.view_ack_collection_timeout;
    }

    public void setViewAckCollectionTimeout(long view_ack_collection_timeout) {
        this.view_ack_collection_timeout = view_ack_collection_timeout;
    }

    public boolean isViewBundling() {
        return this.view_bundling;
    }

    public void setViewBundling(boolean view_bundling) {
        this.view_bundling = view_bundling;
    }

    public long getMaxBundlingTime() {
        return this.max_bundling_time;
    }

    public void setMaxBundlingTime(long max_bundling_time) {
        this.max_bundling_time = max_bundling_time;
    }

    @ManagedAttribute
    public int getViewHandlerSize() {
        return this.view_handler.size();
    }

    @ManagedAttribute
    public boolean isViewHandlerSuspended() {
        return this.view_handler.suspended();
    }

    @ManagedOperation
    public String dumpViewHandlerQueue() {
        return this.view_handler.dumpQueue();
    }

    @ManagedOperation
    public String dumpViewHandlerHistory() {
        return this.view_handler.dumpHistory();
    }

    @ManagedOperation
    public void suspendViewHandler() {
        this.view_handler.suspend(null);
    }

    @ManagedOperation
    public void resumeViewHandler() {
        this.view_handler.resumeForce();
    }

    Log getLog() {
        return this.log;
    }

    ViewHandler getViewHandler() {
        return this.view_handler;
    }

    @ManagedOperation
    public String printPreviousViews() {
        StringBuilder sb = new StringBuilder();
        for (View view : this.prev_views) {
            sb.append(view).append("\n");
        }
        return sb.toString();
    }

    public boolean isCoordinator() {
        Address coord = this.determineCoordinator();
        return coord != null && this.local_addr != null && this.local_addr.equals(coord);
    }

    public MergeId getMergeId() {
        return this.impl instanceof CoordGmsImpl ? ((CoordGmsImpl)this.impl).getMergeId() : null;
    }

    public void setLogCollectMessages(boolean flag) {
        this.log_collect_msgs = flag;
    }

    public boolean getLogCollectMessages() {
        return this.log_collect_msgs;
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_views = 0;
        this.prev_views.clear();
    }

    @Override
    public Vector<Integer> requiredDownServices() {
        Vector<Integer> retval = new Vector<Integer>(3);
        retval.addElement(new Integer(39));
        retval.addElement(new Integer(41));
        retval.addElement(new Integer(12));
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImpl(GmsImpl new_impl) {
        Object object = this.impl_mutex;
        synchronized (object) {
            if (this.impl == new_impl) {
                return;
            }
            this.impl = new_impl;
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.local_addr != null ? this.local_addr + ": " : "changed role to " + new_impl.getClass().getName());
            }
        }
    }

    public GmsImpl getImpl() {
        return this.impl;
    }

    @Override
    public void init() throws Exception {
        this.prev_members = new BoundedList(this.num_prev_mbrs);
        TP transport = this.getTransport();
        this.timer = transport.getTimer();
        if (this.timer == null) {
            throw new Exception("timer is null");
        }
        if (this.impl != null) {
            this.impl.init();
        }
        transport.registerProbeHandler(this);
    }

    @Override
    public void start() throws Exception {
        if (this.impl != null) {
            this.impl.start();
        }
    }

    @Override
    public void stop() {
        this.view_handler.stop(true);
        if (this.impl != null) {
            this.impl.stop();
        }
        if (this.prev_members != null) {
            this.prev_members.clear();
        }
    }

    public void becomeCoordinator() {
        CoordGmsImpl tmp = (CoordGmsImpl)this.impls.get(COORD);
        if (tmp == null) {
            tmp = new CoordGmsImpl(this);
            this.impls.put(COORD, tmp);
        }
        try {
            tmp.init();
        }
        catch (Exception e) {
            this.log.error("exception switching to coordinator role", e);
        }
        this.setImpl(tmp);
    }

    public void becomeParticipant() {
        ParticipantGmsImpl tmp = (ParticipantGmsImpl)this.impls.get(PART);
        if (tmp == null) {
            tmp = new ParticipantGmsImpl(this);
            this.impls.put(PART, tmp);
        }
        try {
            tmp.init();
        }
        catch (Exception e) {
            this.log.error("exception switching to participant", e);
        }
        this.setImpl(tmp);
    }

    public void becomeClient() {
        ClientGmsImpl tmp = (ClientGmsImpl)this.impls.get(CLIENT);
        if (tmp == null) {
            tmp = new ClientGmsImpl(this);
            this.impls.put(CLIENT, tmp);
        }
        try {
            tmp.init();
        }
        catch (Exception e) {
            this.log.error("exception switching to client role", e);
        }
        this.setImpl(tmp);
    }

    boolean haveCoordinatorRole() {
        return this.impl != null && this.impl instanceof CoordGmsImpl;
    }

    @ManagedOperation(description="Fetches digests from all members and installs them, unblocking blocked members")
    public void fixDigests() {
        if (this.impl instanceof CoordGmsImpl) {
            ((CoordGmsImpl)this.impl).fixDigests();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View getNextView(Collection<Address> new_mbrs, Collection<Address> old_mbrs, Collection<Address> suspected_mbrs) {
        Membership membership = this.members;
        synchronized (membership) {
            long vid;
            if (this.view_id == null) {
                this.log.error("view_id is null");
                return null;
            }
            this.ltime = vid = Math.max(this.view_id.getId(), this.ltime) + 1L;
            Membership tmp_mbrs = this.tmp_members.copy();
            tmp_mbrs.remove(suspected_mbrs);
            tmp_mbrs.remove(old_mbrs);
            tmp_mbrs.add(new_mbrs);
            Vector<Address> mbrs = tmp_mbrs.getMembers();
            Address new_coord = this.local_addr;
            if (!mbrs.isEmpty()) {
                new_coord = mbrs.firstElement();
            }
            View v = new View(new_coord, vid, mbrs);
            this.tmp_members.set(mbrs);
            if (new_mbrs != null) {
                for (Address tmp_mbr : new_mbrs) {
                    if (this.joining.contains(tmp_mbr)) continue;
                    this.joining.addElement(tmp_mbr);
                }
            }
            if (old_mbrs != null) {
                for (Address addr : old_mbrs) {
                    if (this.leaving.contains(addr)) continue;
                    this.leaving.add(addr);
                }
            }
            if (suspected_mbrs != null) {
                for (Address addr : suspected_mbrs) {
                    if (this.leaving.contains(addr)) continue;
                    this.leaving.add(addr);
                }
            }
            return v;
        }
    }

    public void castViewChangeWithDest(View new_view, Digest digest, JoinRsp jr, Collection<Address> newMembers) {
        block14: {
            block13: {
                if (this.log.isTraceEnabled()) {
                    this.log.trace(this.local_addr + ": mcasting view {" + new_view + "} (" + new_view.size() + " mbrs)\n");
                }
                Message view_change_msg = new Message();
                GmsHeader hdr = new GmsHeader(5, new_view);
                hdr.my_digest = digest;
                view_change_msg.putHeader(this.id, hdr);
                ArrayList<Address> ackMembers = new ArrayList<Address>(new_view.getMembers());
                if (newMembers != null && !newMembers.isEmpty()) {
                    ackMembers.removeAll(newMembers);
                }
                if (!ackMembers.isEmpty()) {
                    this.ack_collector.reset(ackMembers);
                } else {
                    this.ack_collector.reset(null);
                }
                this.down_prot.up(new Event(15, new_view));
                this.down_prot.down(new Event(15, new_view));
                this.down_prot.down(new Event(1, view_change_msg));
                try {
                    if (!ackMembers.isEmpty()) {
                        this.ack_collector.waitForAllAcks(this.view_ack_collection_timeout);
                        if (this.log.isTraceEnabled()) {
                            this.log.trace(this.local_addr + ": received all ACKs (" + this.ack_collector.expectedAcks() + ") from existing members for view " + new_view.getVid());
                        }
                    }
                }
                catch (TimeoutException e) {
                    if (!this.log_collect_msgs || !this.log.isWarnEnabled()) break block13;
                    this.log.warn(this.local_addr + ": failed to collect all ACKs (expected=" + this.ack_collector.expectedAcks() + ") for view " + new_view + " after " + this.view_ack_collection_timeout + "ms, missing ACKs from " + this.ack_collector.printMissing());
                }
            }
            if (jr != null && newMembers != null && !newMembers.isEmpty()) {
                this.ack_collector.reset(new ArrayList<Address>(newMembers));
                for (Address joiner : newMembers) {
                    this.sendJoinResponse(jr, joiner);
                }
                try {
                    this.ack_collector.waitForAllAcks(this.view_ack_collection_timeout);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace(this.local_addr + ": received all ACKs (" + this.ack_collector.expectedAcks() + ") from joiners for view " + new_view.getVid());
                    }
                }
                catch (TimeoutException e) {
                    if (!this.log_collect_msgs || !this.log.isWarnEnabled()) break block14;
                    this.log.warn(this.local_addr + ": failed to collect all ACKs (expected=" + this.ack_collector.expectedAcks() + ") for unicast view " + new_view + " after " + this.view_ack_collection_timeout + "ms, missing ACKs from " + this.ack_collector.printMissing());
                }
            }
        }
    }

    public void sendJoinResponse(JoinRsp rsp, Address dest) {
        Message m = new Message(dest, null, null);
        GmsHeader hdr = new GmsHeader(2, rsp);
        m.putHeader(this.id, hdr);
        this.getDownProtocol().down(new Event(1, m));
    }

    public void installView(View new_view) {
        this.installView(new_view, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installView(View new_view, Digest digest) {
        int rc;
        ViewId vid = new_view.getVid();
        Vector<Address> mbrs = new_view.getMembers();
        if (this.view_id != null && (rc = vid.compareTo(this.view_id)) <= 0) {
            if (this.log.isWarnEnabled() && rc < 0) {
                this.log.warn(this.local_addr + ": received view < current view;" + " discarding it (current vid: " + this.view_id + ", new vid: " + vid + ')');
            }
            return;
        }
        if (digest != null) {
            if (new_view instanceof MergeView) {
                this.mergeDigest(digest);
            } else {
                this.setDigest(digest);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.local_addr + ": view is " + new_view);
        }
        if (this.stats) {
            ++this.num_views;
            this.prev_views.add(new_view);
        }
        this.ack_collector.handleView(new_view);
        this.merge_ack_collector.handleView(new_view);
        this.ltime = Math.max(vid.getId(), this.ltime);
        if (!this.checkSelfInclusion(mbrs)) {
            if (this.log.isWarnEnabled()) {
                this.log.warn(this.local_addr + ": not member of view " + new_view + "; discarding it");
            }
            return;
        }
        Membership membership = this.members;
        synchronized (membership) {
            this.view = new_view instanceof MergeView ? new View(new_view.getVid(), new_view.getMembers()) : new_view;
            this.view_id = vid.copy();
            if (mbrs != null && !mbrs.isEmpty()) {
                this.members.set(mbrs);
                this.tmp_members.set(this.members);
                this.joining.removeAll(mbrs);
                this.leaving.retainAll(mbrs);
                this.tmp_members.add(this.joining);
                this.tmp_members.remove(this.leaving);
                for (Address addr : mbrs) {
                    if (this.prev_members.contains(addr)) continue;
                    this.prev_members.add(addr);
                }
            }
            Event view_event = new Event(6, new_view);
            this.down_prot.down(view_event);
            this.up_prot.up(view_event);
            Address coord = this.determineCoordinator();
            if (coord != null && coord.equals(this.local_addr) && !this.haveCoordinatorRole()) {
                this.becomeCoordinator();
            } else if (this.haveCoordinatorRole() && !this.local_addr.equals(coord)) {
                this.becomeParticipant();
                this.merge_ack_collector.reset(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Address determineCoordinator() {
        Membership membership = this.members;
        synchronized (membership) {
            return this.members.size() > 0 ? this.members.elementAt(0) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean wouldBeNewCoordinator(Address potential_new_coord) {
        if (potential_new_coord == null) {
            return false;
        }
        Membership membership = this.members;
        synchronized (membership) {
            if (this.members.size() < 2) {
                return false;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : var3_2
            Address new_coord = this.members.elementAt(1);
            return new_coord != null && new_coord.equals(potential_new_coord);
        }
    }

    protected boolean checkSelfInclusion(Vector<Address> mbrs) {
        if (mbrs == null) {
            return false;
        }
        for (int i = 0; i < mbrs.size(); ++i) {
            Address mbr = mbrs.elementAt(i);
            if (mbr == null || !this.local_addr.equals(mbr)) continue;
            return true;
        }
        return false;
    }

    public View makeView(Vector<Address> mbrs) {
        Address coord = null;
        long id = 0L;
        if (this.view_id != null) {
            coord = this.view_id.getCoordAddress();
            id = this.view_id.getId();
        }
        return new View(coord, id, mbrs);
    }

    public static View makeView(Vector<Address> mbrs, ViewId vid) {
        Address coord = null;
        long id = 0L;
        if (vid != null) {
            coord = vid.getCoordAddress();
            id = vid.getId();
        }
        return new View(coord, id, mbrs);
    }

    public void setDigest(Digest d) {
        this.down_prot.down(new Event(41, d));
    }

    public void mergeDigest(Digest d) {
        this.down_prot.down(new Event(53, d));
    }

    public Digest getDigest() {
        return (Digest)this.down_prot.down(Event.GET_DIGEST_EVT);
    }

    boolean startFlush(View view) {
        return this._startFlush(view, 4, 1000L, 5000L);
    }

    boolean startFlush(View view, int maxAttempts, long floor, long ceiling) {
        return this._startFlush(view, maxAttempts, floor, ceiling);
    }

    protected boolean _startFlush(View new_view, int maxAttempts, long randomFloor, long randomCeiling) {
        if (this.flushInvokerClass != null) {
            try {
                Callable<Boolean> invoker = this.flushInvokerClass.getDeclaredConstructor(View.class).newInstance(new_view);
                return invoker.call();
            }
            catch (Throwable e) {
                return false;
            }
        }
        try {
            boolean validView;
            boolean successfulFlush = true;
            boolean bl = validView = new_view != null && new_view.size() > 0;
            if (validView && this.flushProtocolInStack) {
                for (int attemptCount = 0; attemptCount < maxAttempts && !(successfulFlush = ((Boolean)this.up_prot.up(new Event(68, new ArrayList<Address>(new_view.getMembers())))).booleanValue()); ++attemptCount) {
                    Util.sleepRandom(randomFloor, randomCeiling);
                }
                if (successfulFlush) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace(this.local_addr + ": successful GMS flush by coordinator");
                    }
                } else if (this.log.isWarnEnabled()) {
                    this.log.warn(this.local_addr + ": GMS flush by coordinator failed");
                }
            }
            return successfulFlush;
        }
        catch (Exception e) {
            return false;
        }
    }

    void stopFlush() {
        if (this.flushProtocolInStack) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.local_addr + ": sending RESUME event");
            }
            this.up_prot.up(new Event(70));
        }
    }

    void stopFlush(List<Address> members) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.local_addr + ": sending RESUME event");
        }
        this.up_prot.up(new Event(70, members));
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                GmsHeader hdr = (GmsHeader)msg.getHeader(this.id);
                if (hdr == null) break;
                switch (hdr.type) {
                    case 1: {
                        this.view_handler.add(new GmsImpl.Request(1, hdr.mbr, false, null, hdr.useFlushIfPresent));
                        break;
                    }
                    case 11: {
                        this.view_handler.add(new GmsImpl.Request(6, hdr.mbr, false, null, hdr.useFlushIfPresent));
                        break;
                    }
                    case 2: {
                        this.impl.handleJoinResponse(hdr.join_rsp);
                        break;
                    }
                    case 3: {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("received LEAVE_REQ for " + hdr.mbr + " from " + msg.getSrc());
                        }
                        if (hdr.mbr == null) {
                            return null;
                        }
                        this.view_handler.add(new GmsImpl.Request(2, hdr.mbr, false));
                        break;
                    }
                    case 4: {
                        this.impl.handleLeaveResponse();
                        break;
                    }
                    case 5: {
                        View new_view = hdr.view;
                        if (new_view == null) {
                            return null;
                        }
                        Address coord = msg.getSrc();
                        if (!new_view.containsMember(coord)) {
                            this.sendViewAck(coord);
                            this.impl.handleViewChange(new_view, hdr.my_digest);
                            break;
                        }
                        this.impl.handleViewChange(new_view, hdr.my_digest);
                        this.sendViewAck(coord);
                        break;
                    }
                    case 10: {
                        Address sender = msg.getSrc();
                        this.ack_collector.ack(sender);
                        return null;
                    }
                    case 6: {
                        this.down_prot.down(new Event(65, 20000));
                        this.impl.handleMergeRequest(msg.getSrc(), hdr.merge_id, hdr.mbrs);
                        break;
                    }
                    case 7: {
                        MergeData merge_data = new MergeData(msg.getSrc(), hdr.view, hdr.my_digest);
                        merge_data.merge_rejected = hdr.merge_rejected;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug(this.local_addr + ": got merge response from " + msg.getSrc() + ", merge_id=" + hdr.merge_id + ", merge data is " + merge_data);
                        }
                        this.impl.handleMergeResponse(merge_data, hdr.merge_id);
                        break;
                    }
                    case 8: {
                        this.impl.handleMergeView(new MergeData(msg.getSrc(), hdr.view, hdr.my_digest), hdr.merge_id);
                        this.down_prot.down(new Event(66));
                        break;
                    }
                    case 15: {
                        Digest tmp = hdr.my_digest;
                        this.down_prot.down(new Event(53, tmp));
                        break;
                    }
                    case 12: {
                        this.merge_ack_collector.ack(msg.getSrc());
                        break;
                    }
                    case 9: {
                        this.impl.handleMergeCancelled(hdr.merge_id);
                        this.down_prot.down(new Event(66));
                        break;
                    }
                    case 13: {
                        Digest.Entry entry;
                        Digest digest = (Digest)this.down_prot.down(Event.GET_DIGEST_EVT);
                        if (digest == null || (entry = digest.get(this.local_addr)) == null) break;
                        Digest retval = new Digest(this.local_addr, entry.getLow(), entry.getHighestDeliveredSeqno(), entry.getHighestReceivedSeqno());
                        GmsHeader rsp_hdr = new GmsHeader(14);
                        rsp_hdr.my_digest = retval;
                        Message get_digest_rsp = new Message(msg.getSrc(), null, null);
                        get_digest_rsp.setFlag((byte)1);
                        get_digest_rsp.putHeader(this.id, rsp_hdr);
                        this.down_prot.down(new Event(1, get_digest_rsp));
                        break;
                    }
                    case 14: {
                        Digest digest_rsp = hdr.my_digest;
                        this.impl.handleDigestResponse(msg.getSrc(), digest_rsp);
                        break;
                    }
                    default: {
                        if (!this.log.isErrorEnabled()) break;
                        this.log.error("GmsHeader with type=" + hdr.type + " not known");
                    }
                }
                return null;
            }
            case 9: {
                Object retval = this.up_prot.up(evt);
                Address suspected = (Address)evt.getArg();
                this.view_handler.add(new GmsImpl.Request(3, suspected, true));
                this.ack_collector.suspect(suspected);
                this.merge_ack_collector.suspect(suspected);
                return retval;
            }
            case 51: {
                this.impl.unsuspect((Address)evt.getArg());
                return null;
            }
            case 14: {
                this.view_handler.add(new GmsImpl.Request(4, null, false, (Map)evt.getArg()));
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object down(Event evt) {
        int type = evt.getType();
        switch (type) {
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                boolean state_transfer;
                boolean use_flush = type == 92 || type == 93;
                boolean bl = state_transfer = type == 80 || type == 93;
                if (this.print_local_addr) {
                    PhysicalAddress physical_addr = this.print_physical_addrs ? (PhysicalAddress)this.down(new Event(87, this.local_addr)) : null;
                    System.out.println("\n-------------------------------------------------------------------\nGMS: address=" + this.local_addr + ", cluster=" + evt.getArg() + (physical_addr != null ? ", physical address=" + physical_addr : "") + "\n-------------------------------------------------------------------");
                }
                this.down_prot.down(evt);
                if (this.local_addr == null && this.log.isFatalEnabled()) {
                    this.log.fatal("[CONNECT] local_addr is null");
                }
                try {
                    if (state_transfer) {
                        this.impl.joinWithStateTransfer(this.local_addr, use_flush);
                    } else {
                        this.impl.join(this.local_addr, use_flush);
                    }
                }
                catch (Throwable e) {
                    return e;
                }
                return null;
            }
            case 4: {
                this.impl.leave((Address)evt.getArg());
                if (!(this.impl instanceof CoordGmsImpl)) {
                    this.initState();
                }
                this.down_prot.down(evt);
                return null;
            }
            case 56: {
                Map config = (Map)evt.getArg();
                if (config == null || !config.containsKey("flush_supported")) break;
                this.flushProtocolInStack = true;
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Map<String, String> handleProbe(String ... keys) {
        for (String key : keys) {
            if (!key.equals("fix-digests")) continue;
            this.fixDigests();
        }
        return null;
    }

    @Override
    public String[] supportedKeys() {
        return new String[]{"fix-digests"};
    }

    final void initState() {
        this.becomeClient();
        this.view_id = null;
        this.view = null;
    }

    private void sendViewAck(Address dest) {
        Message view_ack = new Message(dest, null, null);
        view_ack.setFlag((byte)1);
        GmsHeader tmphdr = new GmsHeader(10);
        view_ack.putHeader(this.id, tmphdr);
        this.down_prot.down(new Event(1, view_ack));
    }

    static class Resumer
    implements Runnable {
        final MergeId token;
        final Map<MergeId, Future> tasks;
        final ViewHandler handler;

        public Resumer(MergeId token, Map<MergeId, Future> t, ViewHandler handler) {
            this.token = token;
            this.tasks = t;
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean executed = true;
            Map<MergeId, Future> map = this.tasks;
            synchronized (map) {
                Future future = this.tasks.get(this.token);
                if (future != null) {
                    future.cancel(false);
                    executed = true;
                } else {
                    executed = false;
                }
                this.tasks.remove(this.token);
            }
            if (executed) {
                this.handler.resume(this.token);
            }
        }
    }

    class ViewHandler
    implements Runnable {
        volatile Thread thread;
        final Queue queue = new Queue();
        volatile boolean suspended = false;
        static final long INTERVAL = 5000L;
        private static final long MAX_COMPLETION_TIME = 10000L;
        private final BoundedList<String> history = new BoundedList(20);
        private final Map<MergeId, Future> resume_tasks = new HashMap<MergeId, Future>();

        ViewHandler() {
        }

        synchronized void add(GmsImpl.Request req) {
            block4: {
                if (this.suspended) {
                    if (GMS.this.log.isTraceEnabled()) {
                        GMS.this.log.trace("queue is suspended; request " + req + " is discarded");
                    }
                    return;
                }
                this.start();
                try {
                    this.queue.add(req);
                    this.history.add(new Date() + ": " + req.toString());
                }
                catch (QueueClosedException e) {
                    if (!GMS.this.log.isTraceEnabled()) break block4;
                    GMS.this.log.trace("queue is closed; request " + req + " is discarded");
                }
            }
        }

        void waitUntilCompleted(long timeout) {
            this.waitUntilCompleted(timeout, false);
        }

        synchronized void waitUntilCompleted(long timeout, boolean resume) {
            if (this.thread != null) {
                try {
                    this.thread.join(timeout);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.thread = null;
            }
            if (resume) {
                this.resumeForce();
            }
        }

        synchronized void start() {
            if (this.queue.closed()) {
                this.queue.reset();
            }
            if (this.thread == null || !this.thread.isAlive()) {
                this.thread = GMS.this.getThreadFactory().newThread(this, "ViewHandler");
                this.thread.setDaemon(false);
                this.thread.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void stop(boolean flush) {
            this.queue.close(flush);
            Map<MergeId, Future> map = this.resume_tasks;
            synchronized (map) {
                for (Future future : this.resume_tasks.values()) {
                    future.cancel(true);
                }
                this.resume_tasks.clear();
            }
        }

        public synchronized void suspend(MergeId merge_id) {
            if (!this.suspended) {
                this.suspended = true;
                this.queue.clear();
                this.waitUntilCompleted(10000L);
                this.queue.close(true);
                Resumer resumer = new Resumer(merge_id, this.resume_tasks, this);
                Future<?> future = GMS.this.timer.schedule(resumer, GMS.this.resume_task_timeout, TimeUnit.MILLISECONDS);
                Future<?> old_future = this.resume_tasks.put(merge_id, future);
                if (old_future != null) {
                    old_future.cancel(true);
                }
                if (GMS.this.log.isTraceEnabled()) {
                    GMS.this.log.trace(GMS.this.local_addr + ": view handler for merge_id " + merge_id + " was suspended");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void resume(MergeId merge_id) {
            Future future;
            if (!this.suspended) {
                return;
            }
            Map<MergeId, Future> map = this.resume_tasks;
            synchronized (map) {
                future = this.resume_tasks.remove(merge_id);
            }
            if (future != null) {
                future.cancel(true);
            }
            this.resumeForce();
        }

        public synchronized void resumeForce() {
            if (this.queue.closed()) {
                this.queue.reset();
            }
            this.suspended = false;
            if (GMS.this.log.isTraceEnabled()) {
                GMS.this.log.trace("view handler was resumed");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkedList<GmsImpl.Request> requests = new LinkedList<GmsImpl.Request>();
            while (Thread.currentThread().equals(this.thread) && !this.suspended) {
                try {
                    boolean keepGoing = false;
                    long end_time = System.currentTimeMillis() + GMS.this.max_bundling_time;
                    do {
                        GmsImpl.Request firstRequest = (GmsImpl.Request)this.queue.remove(5000L);
                        requests.add(firstRequest);
                        if (!GMS.this.view_bundling) break;
                        if (this.queue.size() > 0) {
                            GmsImpl.Request nextReq = (GmsImpl.Request)this.queue.peek();
                            keepGoing = GMS.this.view_bundling && firstRequest.canBeProcessedTogether(nextReq);
                            continue;
                        }
                        long wait_time = end_time - System.currentTimeMillis();
                        if (wait_time > 0L) {
                            this.queue.waitUntilClosed(wait_time);
                        }
                        boolean bl = keepGoing = this.queue.size() > 0 && firstRequest.canBeProcessedTogether((GmsImpl.Request)this.queue.peek());
                    } while (keepGoing && System.currentTimeMillis() < end_time);
                    try {
                        this.process(requests);
                    }
                    finally {
                        requests.clear();
                    }
                }
                catch (QueueClosedException e) {
                    break;
                }
                catch (TimeoutException e) {
                    break;
                }
                catch (Throwable catchall) {
                    Util.sleep(50L);
                }
            }
        }

        public int size() {
            return this.queue.size();
        }

        public boolean suspended() {
            return this.suspended;
        }

        public String dumpQueue() {
            StringBuilder sb = new StringBuilder();
            LinkedList v = this.queue.values();
            Iterator it = v.iterator();
            while (it.hasNext()) {
                sb.append(it.next() + "\n");
            }
            return sb.toString();
        }

        public String dumpHistory() {
            StringBuilder sb = new StringBuilder();
            for (String line : this.history) {
                sb.append(line + "\n");
            }
            return sb.toString();
        }

        private void process(List<GmsImpl.Request> requests) {
            if (requests.isEmpty()) {
                return;
            }
            GmsImpl.Request firstReq = requests.get(0);
            switch (firstReq.type) {
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    GMS.this.impl.handleMembershipChange(requests);
                    break;
                }
                case 4: {
                    GMS.this.impl.merge(firstReq.views);
                    break;
                }
                default: {
                    GMS.this.log.error("request " + firstReq.type + " is unknown; discarded");
                }
            }
        }
    }

    public static class GmsHeader
    extends Header {
        public static final byte JOIN_REQ = 1;
        public static final byte JOIN_RSP = 2;
        public static final byte LEAVE_REQ = 3;
        public static final byte LEAVE_RSP = 4;
        public static final byte VIEW = 5;
        public static final byte MERGE_REQ = 6;
        public static final byte MERGE_RSP = 7;
        public static final byte INSTALL_MERGE_VIEW = 8;
        public static final byte CANCEL_MERGE = 9;
        public static final byte VIEW_ACK = 10;
        public static final byte JOIN_REQ_WITH_STATE_TRANSFER = 11;
        public static final byte INSTALL_MERGE_VIEW_OK = 12;
        public static final byte GET_DIGEST_REQ = 13;
        public static final byte GET_DIGEST_RSP = 14;
        public static final byte INSTALL_DIGEST = 15;
        byte type = 0;
        View view = null;
        Address mbr = null;
        Collection<? extends Address> mbrs = null;
        boolean useFlushIfPresent;
        JoinRsp join_rsp = null;
        Digest my_digest = null;
        MergeId merge_id = null;
        boolean merge_rejected = false;

        public GmsHeader() {
        }

        public GmsHeader(byte type) {
            this.type = type;
        }

        public GmsHeader(byte type, View view) {
            this.type = type;
            this.view = view;
        }

        public GmsHeader(byte type, Address mbr, boolean useFlushIfPresent) {
            this.type = type;
            this.mbr = mbr;
            this.useFlushIfPresent = useFlushIfPresent;
        }

        public GmsHeader(byte type, Address mbr) {
            this(type, mbr, true);
        }

        public GmsHeader(byte type, Collection<Address> mbrs) {
            this(type);
            this.mbrs = mbrs;
        }

        public GmsHeader(byte type, JoinRsp join_rsp) {
            this.type = type;
            this.join_rsp = join_rsp;
        }

        public byte getType() {
            return this.type;
        }

        public Address getMember() {
            return this.mbr;
        }

        public MergeId getMergeId() {
            return this.merge_id;
        }

        public void setMergeId(MergeId merge_id) {
            this.merge_id = merge_id;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("GmsHeader");
            sb.append('[' + GmsHeader.type2String(this.type) + ']');
            switch (this.type) {
                case 1: 
                case 3: 
                case 13: {
                    sb.append(": mbr=" + this.mbr);
                    break;
                }
                case 2: {
                    sb.append(": join_rsp=" + this.join_rsp);
                    break;
                }
                case 5: 
                case 10: {
                    sb.append(": view=" + this.view);
                    break;
                }
                case 6: {
                    sb.append(": merge_id=" + this.merge_id).append(", mbrs=" + this.mbrs);
                    break;
                }
                case 7: {
                    sb.append(": view=" + this.view + ", digest=" + this.my_digest + ", merge_id=" + this.merge_id);
                    if (!this.merge_rejected) break;
                    sb.append(", merge_rejected=" + this.merge_rejected);
                    break;
                }
                case 8: 
                case 14: 
                case 15: {
                    sb.append(": view=" + this.view + ", digest=" + this.my_digest);
                    break;
                }
                case 9: {
                    sb.append(", <merge cancelled>, merge_id=" + this.merge_id);
                }
            }
            return sb.toString();
        }

        public static String type2String(int type) {
            switch (type) {
                case 1: {
                    return "JOIN_REQ";
                }
                case 2: {
                    return "JOIN_RSP";
                }
                case 3: {
                    return "LEAVE_REQ";
                }
                case 4: {
                    return "LEAVE_RSP";
                }
                case 5: {
                    return "VIEW";
                }
                case 6: {
                    return "MERGE_REQ";
                }
                case 7: {
                    return "MERGE_RSP";
                }
                case 8: {
                    return "INSTALL_MERGE_VIEW";
                }
                case 9: {
                    return "CANCEL_MERGE";
                }
                case 10: {
                    return "VIEW_ACK";
                }
                case 11: {
                    return "JOIN_REQ_WITH_STATE_TRANSFER";
                }
                case 12: {
                    return "INSTALL_MERGE_VIEW_OK";
                }
                case 13: {
                    return "GET_DIGEST_REQ";
                }
                case 14: {
                    return "GET_DIGEST_RSP";
                }
                case 15: {
                    return "INSTALL_DIGEST";
                }
            }
            return "<unknown>";
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            boolean isMergeView = this.view != null && this.view instanceof MergeView;
            out.writeBoolean(isMergeView);
            Util.writeStreamable(this.view, out);
            Util.writeAddress(this.mbr, out);
            Util.writeAddresses(this.mbrs, out);
            Util.writeStreamable(this.join_rsp, out);
            Util.writeStreamable(this.my_digest, out);
            Util.writeStreamable(this.merge_id, out);
            out.writeBoolean(this.merge_rejected);
            out.writeBoolean(this.useFlushIfPresent);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            boolean isMergeView = in.readBoolean();
            this.view = isMergeView ? (View)Util.readStreamable(MergeView.class, in) : (View)Util.readStreamable(View.class, in);
            this.mbr = Util.readAddress(in);
            this.mbrs = Util.readAddresses(in, ArrayList.class);
            this.join_rsp = (JoinRsp)Util.readStreamable(JoinRsp.class, in);
            this.my_digest = (Digest)Util.readStreamable(Digest.class, in);
            this.merge_id = (MergeId)Util.readStreamable(MergeId.class, in);
            this.merge_rejected = in.readBoolean();
            this.useFlushIfPresent = in.readBoolean();
        }

        @Override
        public int size() {
            int retval = 2;
            ++retval;
            ++retval;
            if (this.view != null) {
                retval += this.view.serializedSize();
            }
            retval += Util.size(this.mbr);
            retval = (int)((long)retval + Util.size(this.mbrs));
            ++retval;
            if (this.join_rsp != null) {
                retval += this.join_rsp.serializedSize();
            }
            ++retval;
            if (this.my_digest != null) {
                retval = (int)((long)retval + this.my_digest.serializedSize());
            }
            ++retval;
            if (this.merge_id != null) {
                retval += this.merge_id.size();
            }
            return ++retval;
        }
    }
}

