/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.PhysicalAddress;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.TUNNEL;
import org.jgroups.stack.GossipData;
import org.jgroups.util.Util;

public class RouterStub {
    private final String router_host;
    private final int router_port;
    private Socket sock = null;
    private DataOutputStream output = null;
    private DataInputStream input = null;
    private volatile ConnectionStatus connectionState = ConnectionStatus.INITIAL;
    private static final Log log = LogFactory.getLog(RouterStub.class);
    private final ConnectionListener conn_listener;
    private final InetAddress bind_addr;
    private int sock_conn_timeout = 3000;
    private int sock_read_timeout = 3000;
    private boolean tcp_nodelay = true;
    private TUNNEL.StubReceiver receiver;

    public RouterStub(String routerHost, int routerPort, InetAddress bindAddress, ConnectionListener l) {
        this.router_host = routerHost != null ? routerHost : "localhost";
        this.router_port = routerPort;
        this.bind_addr = bindAddress;
        this.conn_listener = l;
    }

    public synchronized void setReceiver(TUNNEL.StubReceiver receiver) {
        this.receiver = receiver;
    }

    public synchronized TUNNEL.StubReceiver getReceiver() {
        return this.receiver;
    }

    public boolean isTcpNoDelay() {
        return this.tcp_nodelay;
    }

    public void setTcpNoDelay(boolean tcp_nodelay) {
        this.tcp_nodelay = tcp_nodelay;
    }

    public synchronized void interrupt() {
        Thread thread;
        if (this.receiver != null && (thread = this.receiver.getThread()) != null) {
            thread.interrupt();
        }
    }

    public synchronized void join(long wait) throws InterruptedException {
        Thread thread;
        if (this.receiver != null && (thread = this.receiver.getThread()) != null) {
            thread.join(wait);
        }
    }

    public int getSocketConnectionTimeout() {
        return this.sock_conn_timeout;
    }

    public void setSocketConnectionTimeout(int sock_conn_timeout) {
        this.sock_conn_timeout = sock_conn_timeout;
    }

    public int getSocketReadTimeout() {
        return this.sock_read_timeout;
    }

    public void setSocketReadTimeout(int sock_read_timeout) {
        this.sock_read_timeout = sock_read_timeout;
    }

    public boolean isConnected() {
        return this.connectionState != ConnectionStatus.CONNECTION_BROKEN && this.connectionState != ConnectionStatus.INITIAL;
    }

    public ConnectionStatus getConnectionStatus() {
        return this.connectionState;
    }

    public synchronized void connect(String group, Address addr, String logical_name, List<PhysicalAddress> phys_addrs) throws Exception {
        this.doConnect();
        GossipData request = new GossipData(1, group, addr, logical_name, phys_addrs);
        request.writeTo(this.output);
        this.output.flush();
        byte result = this.input.readByte();
        if (result != 14) {
            this.connectionStateChanged(ConnectionStatus.DISCONNECTED);
            throw new Exception("Connect failed received from GR " + this.getGossipRouterAddress());
        }
        this.connectionStateChanged(ConnectionStatus.CONNECTED);
    }

    public synchronized void doConnect() throws Exception {
        if (!this.isConnected()) {
            try {
                this.sock = new Socket();
                this.sock.bind(new InetSocketAddress(this.bind_addr, 0));
                this.sock.setSoTimeout(this.sock_read_timeout);
                this.sock.setSoLinger(true, 2);
                this.sock.setTcpNoDelay(this.tcp_nodelay);
                this.sock.setKeepAlive(true);
                Util.connect(this.sock, new InetSocketAddress(this.router_host, this.router_port), this.sock_conn_timeout);
                this.output = new DataOutputStream(this.sock.getOutputStream());
                this.input = new DataInputStream(this.sock.getInputStream());
                this.connectionStateChanged(ConnectionStatus.CONNECTION_ESTABLISHED);
            }
            catch (Exception e) {
                Util.close(this.sock);
                Util.close(this.input);
                Util.close(this.output);
                this.connectionStateChanged(ConnectionStatus.CONNECTION_BROKEN);
                throw new Exception("Could not connect to " + this.getGossipRouterAddress(), e);
            }
        }
    }

    public synchronized void checkConnection() {
        GossipData request = new GossipData(12);
        try {
            request.writeTo(this.output);
            this.output.flush();
        }
        catch (IOException e) {
            this.connectionStateChanged(ConnectionStatus.CONNECTION_BROKEN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect(String group, Address addr) {
        try {
            GossipData request = new GossipData(2, group, addr);
            request.writeTo(this.output);
            this.output.flush();
        }
        catch (Exception exception) {
        }
        finally {
            this.connectionStateChanged(ConnectionStatus.DISCONNECTED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() {
        try {
            GossipData request = new GossipData(13);
            request.writeTo(this.output);
            this.output.flush();
        }
        catch (Exception exception) {
        }
        finally {
            Util.close(this.output);
            Util.close(this.input);
            Util.close(this.sock);
        }
    }

    public Socket getSocket() {
        return this.sock;
    }

    public synchronized List<PingData> getMembers(String group) throws Exception {
        ArrayList<PingData> retval = new ArrayList<PingData>();
        try {
            if (!this.isConnected() || this.input == null) {
                throw new Exception("not connected");
            }
            if (this.input.available() > 0) {
                this.input.skipBytes(this.input.available());
            }
            GossipData request = new GossipData(4, group, null);
            request.writeTo(this.output);
            this.output.flush();
            int num_rsps = this.input.readShort();
            for (int i = 0; i < num_rsps; ++i) {
                PingData rsp = new PingData();
                rsp.readFrom(this.input);
                retval.add(rsp);
            }
        }
        catch (Exception e) {
            this.connectionStateChanged(ConnectionStatus.CONNECTION_BROKEN);
            throw new Exception("Connection to " + this.getGossipRouterAddress() + " broken. Could not send GOSSIP_GET request", e);
        }
        return retval;
    }

    public InetSocketAddress getGossipRouterAddress() {
        return new InetSocketAddress(this.router_host, this.router_port);
    }

    public String toString() {
        return "RouterStub[localsocket=" + (this.sock != null ? this.sock.getLocalSocketAddress().toString() : "null") + ",router_host=" + this.router_host + "::" + this.router_port + ",connected=" + this.isConnected() + "]";
    }

    public void sendToAllMembers(String group, byte[] data, int offset, int length) throws Exception {
        this.sendToMember(group, null, data, offset, length);
    }

    public synchronized void sendToMember(String group, Address dest, byte[] data, int offset, int length) throws Exception {
        try {
            GossipData request = new GossipData(10, group, dest, data, offset, length);
            request.writeTo(this.output);
            this.output.flush();
        }
        catch (Exception e) {
            this.connectionStateChanged(ConnectionStatus.CONNECTION_BROKEN);
            throw new Exception("Connection to " + this.getGossipRouterAddress() + " broken. Could not send message to " + dest, e);
        }
    }

    public DataInputStream getInputStream() {
        return this.input;
    }

    private void connectionStateChanged(ConnectionStatus newState) {
        boolean notify = this.connectionState != newState;
        this.connectionState = newState;
        if (notify && this.conn_listener != null) {
            try {
                this.conn_listener.connectionStatusChange(this, newState);
            }
            catch (Throwable t) {
                log.error("failed notifying ConnectionListener " + this.conn_listener, t);
            }
        }
    }

    public static interface ConnectionListener {
        public void connectionStatusChange(RouterStub var1, ConnectionStatus var2);
    }

    public static enum ConnectionStatus {
        INITIAL,
        CONNECTION_BROKEN,
        CONNECTION_ESTABLISHED,
        CONNECTED,
        DISCONNECTED;

    }
}

