/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ExtendedReceiverAdapter;
import org.jgroups.JChannel;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.tests.ViewHandler;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Util;

public class GroupCommunication {
    private static final String control_groupname = "ControlChannel";
    private JChannel control_channel = null;
    private ControlReceiver control_receiver = null;
    String control_props = null;

    public void init(String name) {
        try {
            this.control_props = "/home/bela/tmp.xml";
            this.control_receiver = new ControlReceiver();
            System.out.println("Creating control channel");
            this.control_channel = new JChannel(this.control_props);
            this.control_channel.setName(name);
            this.control_channel.setReceiver(this.control_receiver);
            System.out.println("Connecting control channel");
            this.control_channel.setOpt(3, Boolean.TRUE);
            this.control_channel.connect(control_groupname);
            JmxConfigurator.registerChannel(this.control_channel, Util.getMBeanServer(), "jgroups.demo");
            System.out.println("jgroups started");
            block2: while (true) {
                String line;
                if ((line = Util.readStringFromStdin(": ")).startsWith("state")) {
                    BoundedList<String> state = this.control_receiver.getMessages();
                    Iterator i$ = state.iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block2;
                        String s = (String)i$.next();
                        System.out.println(s);
                    }
                }
                this.control_channel.send(null, null, (Serializable)((Object)line));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("error while starting jgroups");
            System.exit(-1);
            return;
        }
    }

    public Channel getControlChannel() {
        return this.control_channel;
    }

    public static void main(String[] args) {
        new GroupCommunication().init(args[0]);
    }

    public class ControlReceiver
    extends ExtendedReceiverAdapter {
        final Vector members = new Vector();
        Vector<String> groupMembers = new Vector();
        final BoundedList<String> messages = new BoundedList(100);

        public BoundedList<String> getMessages() {
            return this.messages;
        }

        @Override
        public void receive(Message msg) {
            System.out.println("<< " + msg.getObject() + " from " + msg.getSrc());
            this.messages.add((String)msg.getObject());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void viewAccepted(View new_view) {
            Vector<Address> left_mbrs;
            Vector<Address> joined_mbrs;
            System.out.println("** View=" + new_view);
            if (new_view == null) {
                return;
            }
            Vector<Address> tmp = new_view.getMembers();
            Address local_address = GroupCommunication.this.control_channel.getAddress();
            Vector vector = this.members;
            synchronized (vector) {
                Address tmp_mbr;
                int i;
                joined_mbrs = new Vector<Address>();
                for (i = 0; i < tmp.size(); ++i) {
                    tmp_mbr = tmp.elementAt(i);
                    if (this.members.contains(tmp_mbr)) continue;
                    joined_mbrs.addElement(tmp_mbr);
                }
                left_mbrs = new Vector<Address>();
                for (i = 0; i < this.members.size(); ++i) {
                    tmp_mbr = this.members.elementAt(i);
                    if (tmp.contains(tmp_mbr)) continue;
                    left_mbrs.addElement(tmp_mbr);
                }
                this.members.removeAllElements();
                this.members.addAll(tmp);
            }
            if (!joined_mbrs.isEmpty()) {
                for (int i = 0; i < joined_mbrs.size(); ++i) {
                    if (local_address.compareTo((Address)joined_mbrs.elementAt(i)) == 0 || local_address.compareTo((Address)joined_mbrs.elementAt(joined_mbrs.size() - 1)) == 0) continue;
                    System.out.println("Members joined " + (Address)joined_mbrs.elementAt(i));
                }
            }
            if (!left_mbrs.isEmpty()) {
                for (int i = 0; i < left_mbrs.size(); ++i) {
                    System.out.println("Members left " + (Address)left_mbrs.elementAt(i));
                    String leftMember = left_mbrs.elementAt(i).toString().split("-")[0];
                    if (this.groupMembers.contains(leftMember)) continue;
                    this.groupMembers.add(leftMember);
                }
            }
            this.handleView(GroupCommunication.this.control_channel, new_view);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getState() {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(output);
            try {
                BoundedList<String> boundedList = this.messages;
                synchronized (boundedList) {
                    try {
                        out.writeInt(this.messages.size());
                        for (String msg : this.messages) {
                            out.writeUTF(msg);
                        }
                        out.flush();
                        Object i$ = output.toByteArray();
                        return i$;
                    }
                    catch (IOException e) {
                        byte[] byArray = null;
                        // MONITOREXIT @DISABLED, blocks:[0, 2, 4, 5] lbl20 : MonitorExitStatement: MONITOREXIT : var3_3
                        Util.close(out);
                        return byArray;
                    }
                }
            }
            finally {
                Util.close(out);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setState(byte[] state) {
            LinkedList<String> tmp = new LinkedList<String>();
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(state));
            try {
                int num = in.readInt();
                for (int i = 0; i < num; ++i) {
                    tmp.add(in.readUTF());
                }
                System.out.println("new state: " + tmp.size() + " elements");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            BoundedList<String> boundedList = this.messages;
            synchronized (boundedList) {
                this.messages.clear();
                this.messages.addAll(tmp);
            }
        }

        private void handleView(Channel ch, View new_view) {
            if (new_view instanceof MergeView) {
                ViewHandler handler = new ViewHandler(ch, (MergeView)new_view);
                handler.start();
            }
        }
    }
}

