/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicStampedReference;
import java.util.concurrent.locks.LockSupport;

public class RingBuffer<T> {
    private final AtomicStampedReference<T>[] queue;
    private final int capacity;
    private final AtomicLong next_to_add = new AtomicLong(0L);
    private final AtomicLong next_to_remove = new AtomicLong(0L);

    public RingBuffer(int capacity) {
        this.queue = new AtomicStampedReference[capacity];
        this.capacity = capacity;
        for (int i = 0; i < capacity; ++i) {
            this.queue[i] = new AtomicStampedReference<Object>(null, -1);
        }
    }

    public void add(T el) {
        if (el == null) {
            throw new IllegalArgumentException("null element");
        }
        int counter = 0;
        long next = this.next_to_add.getAndIncrement();
        int stamp = (int)(next / (long)this.capacity);
        int index;
        AtomicStampedReference<T> ref;
        while (next - this.next_to_remove.get() >= (long)this.capacity || !(ref = this.queue[index = (int)(next % (long)this.capacity)]).compareAndSet(null, el, -1, stamp)) {
            if (counter >= 5) {
                LockSupport.parkNanos(10L);
                continue;
            }
            ++counter;
        }
        return;
    }

    public T remove() {
        long next = this.next_to_remove.get();
        if (next >= this.next_to_add.get()) {
            return null;
        }
        int stamp = (int)(next / (long)this.capacity);
        int index = (int)(next % (long)this.capacity);
        AtomicStampedReference<T> ref = this.queue[index];
        T retval = ref.getReference();
        if (retval != null && ref.compareAndSet(retval, null, stamp, -1)) {
            this.next_to_remove.incrementAndGet();
            return retval;
        }
        return null;
    }

    public String dumpNonNullElements() {
        StringBuilder sb = new StringBuilder();
        for (AtomicStampedReference<T> ref : this.queue) {
            if (ref.getReference() == null) continue;
            sb.append(ref.getReference() + " ");
        }
        return sb.toString();
    }

    public int size() {
        int index;
        int size = 0;
        for (int i = index = (int)(this.next_to_remove.get() % (long)this.capacity); i < index + this.capacity; ++i) {
            if (this.queue[i % this.capacity].getReference() == null) continue;
            ++size;
        }
        return size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.size() + " elements");
        if (this.size() < 100) {
            sb.append(": ").append(this.dumpNonNullElements());
        }
        return sb.toString();
    }
}

