/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.servlet;

import java.net.MalformedURLException;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.exoplatform.container.StandaloneContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.naming.InitialContextInitializer;

public class StandaloneContainerInitializedListener
implements ServletContextListener {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.ws.frameworks.servlet.StandaloneContainerInitializedListener");
    private static final String CONF_URL_PARAMETER = "org.exoplatform.container.standalone.config";
    private static final String PREFIX_WAR = "war:";
    private StandaloneContainer container;

    public void contextInitialized(ServletContextEvent event) {
        String configurationURL = event.getServletContext().getInitParameter(CONF_URL_PARAMETER);
        try {
            if (configurationURL != null && configurationURL.startsWith(PREFIX_WAR)) {
                configurationURL = event.getServletContext().getResource(configurationURL.substring(PREFIX_WAR.length())).toExternalForm();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error of configurationURL read", (Throwable)e);
        }
        try {
            StandaloneContainer.addConfigurationURL((String)configurationURL);
        }
        catch (MalformedURLException e) {
            LOG.error((Object)"Error of addConfigurationURL", (Throwable)e);
        }
        try {
            this.container = StandaloneContainer.getInstance((ClassLoader)Thread.currentThread().getContextClassLoader());
            InitialContextInitializer ic = (InitialContextInitializer)this.container.getComponentInstanceOfType(InitialContextInitializer.class);
            if (ic != null) {
                ic.recall();
            }
            event.getServletContext().setAttribute("org.exoplatform.frameworks.web.eXoContainer", (Object)this.container);
        }
        catch (Exception e) {
            LOG.error((Object)"Error of StandaloneContainer initialization", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.container.stop();
    }
}

