/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.bench;

import java.util.HashMap;
import org.exoplatform.faq.service.Category;
import org.exoplatform.ks.bench.AnswerDataInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectInfo {
    public static final String ARRAY_SPLIT = ",".intern();
    private int categories = 3;
    private int depth = 3;
    private int questions = 4;
    private int answers = 10;
    private int comments = 10;
    private int maxAtt = 0;
    private int attCp = 100;
    private int txtCp = 0;
    private String type = "";
    private String preCategories = "";
    private String preQuestions = "";
    private String preAnswers = "";
    private String preComments = "";
    private String[] perCanView = new String[]{""};
    private String[] perCanEdit = new String[]{"root"};
    private Category rootCategory;
    HashMap<String, String> queryParams;

    public InjectInfo() {
    }

    public InjectInfo(HashMap<String, String> queryParams, Category category) throws Exception {
        this.queryParams = queryParams;
        this.rootCategory = category;
        this.setQueryParams(queryParams);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getCategories() {
        return this.categories;
    }

    public void setCategories(int categories) {
        this.categories = categories;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getQuestions() {
        return this.questions;
    }

    public void setQuestions(int questions) {
        this.questions = questions;
    }

    public int getAnswers() {
        return this.answers;
    }

    public void setAnswers(int answers) {
        this.answers = answers;
    }

    public int getComments() {
        return this.comments;
    }

    public void setComments(int comments) {
        this.comments = comments;
    }

    public int getMaxAtt() {
        return this.maxAtt;
    }

    public void setMaxAtt(int maxAtt) {
        this.maxAtt = maxAtt;
    }

    public int getAttCp() {
        return this.attCp;
    }

    public void setAttCp(int attCp) {
        this.attCp = attCp;
    }

    public int getTxtCp() {
        return this.txtCp;
    }

    public void setTxtCp(int txtCp) {
        this.txtCp = txtCp;
    }

    public String getPreCategories() {
        return this.preCategories;
    }

    public void setPreCategories(String preCategories) {
        this.preCategories = preCategories;
    }

    public String getPreQuestions() {
        return this.preQuestions;
    }

    public void setPreQuestions(String preQuestions) {
        this.preQuestions = preQuestions;
    }

    public String getPreAnswers() {
        return this.preAnswers;
    }

    public void setPreAnswers(String preAnswers) {
        this.preAnswers = preAnswers;
    }

    public String getPreComments() {
        return this.preComments;
    }

    public void setPreComments(String preComments) {
        this.preComments = preComments;
    }

    public String[] getPerCanView() {
        return this.perCanView;
    }

    public void setPerCanView(String[] perCanView) {
        this.perCanView = perCanView;
    }

    public String[] getPerCanEdit() {
        return this.perCanEdit;
    }

    public void setPerCanEdit(String[] perCanEdit) {
        this.perCanEdit = perCanEdit;
    }

    private void readPermissions(HashMap<String, String> queryParams) throws Exception {
        String[] perCanEdit = this.getValues(queryParams, AnswerDataInjector.CONSTANTS.EDIT.getName());
        String[] perCanView = this.getValues(queryParams, AnswerDataInjector.CONSTANTS.VIEW.getName());
        String[] mods = this.rootCategory.getModerators();
        if (mods == null || mods.length <= 0 || mods[0].trim().length() == 0) {
            mods = new String[]{"root"};
        }
        if (AnswerDataInjector.CONSTANTS.PERM.getName().equalsIgnoreCase(this.type) && perCanEdit.length > 0 && !perCanEdit[0].equals(AnswerDataInjector.CONSTANTS.ANY.getName())) {
            this.perCanEdit = new String[perCanEdit.length + 1];
            this.perCanEdit[0] = mods[0];
            System.arraycopy(perCanEdit, 0, this.perCanEdit, 1, perCanEdit.length);
        } else {
            this.perCanEdit = mods;
        }
        if (AnswerDataInjector.CONSTANTS.PERM.getName().equalsIgnoreCase(this.type) && perCanView.length > 0 && !perCanView[0].equals(AnswerDataInjector.CONSTANTS.ANY.getName())) {
            this.perCanView = new String[perCanView.length + 1];
            this.perCanView[0] = mods[0];
            System.arraycopy(perCanView, 0, this.perCanView, 1, perCanView.length);
        } else {
            this.perCanView = new String[]{""};
        }
    }

    public void setQueryParams(HashMap<String, String> queryParams) throws Exception {
        String[] quantities = this.getValues(queryParams, AnswerDataInjector.CONSTANTS.Q.getName());
        this.categories = this.getParam(quantities, 0, this.categories);
        this.depth = this.getParam(quantities, 1, this.depth);
        this.questions = this.getParam(quantities, 2, this.questions);
        this.answers = this.getParam(quantities, 3, this.answers);
        this.comments = this.getParam(quantities, 4, this.comments);
        String[] prefixes = this.getValues(queryParams, AnswerDataInjector.CONSTANTS.PRE.getName());
        this.preCategories = this.getParam(prefixes, 0);
        this.preQuestions = this.getParam(prefixes, 1);
        this.preAnswers = this.getParam(prefixes, 2);
        this.preComments = this.getParam(prefixes, 3);
        this.type = queryParams.get(AnswerDataInjector.CONSTANTS.TYPE.getName());
        this.maxAtt = this.getParam(queryParams, AnswerDataInjector.CONSTANTS.ATT.getName(), 0);
        if (this.maxAtt > 0) {
            this.attCp = this.getParam(queryParams, AnswerDataInjector.CONSTANTS.ATTCP.getName(), 100);
        }
        this.txtCp = this.getParam(queryParams, AnswerDataInjector.CONSTANTS.TXTCP.getName(), 0);
        this.readPermissions(queryParams);
    }

    private int getParam(String[] param, int index, int df) throws Exception {
        try {
            return Integer.parseInt(param[index].trim());
        }
        catch (Exception e) {
            return df;
        }
    }

    private int getParam(HashMap<String, String> queryParams, String key, int df) throws Exception {
        try {
            return Integer.parseInt(queryParams.get(key));
        }
        catch (Exception e) {
            return df;
        }
    }

    private String getParam(String[] param, int index) throws Exception {
        try {
            return param[index].trim();
        }
        catch (Exception e) {
            return "";
        }
    }

    private String[] getValues(HashMap<String, String> queryParams, String key) throws Exception {
        try {
            return queryParams.get(key).split(ARRAY_SPLIT);
        }
        catch (Exception e) {
            return new String[0];
        }
    }
}

