/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.html;

final class AttributeNameFixup {
    static final String PREFIX = "f:";
    static final String XMLNS_PREFIX = AttributeNameFixup.fixupNameFromQname("xmlns:");

    AttributeNameFixup() {
    }

    static String fixupNameFromQname(String qname) {
        int n = qname.length();
        StringBuilder adjName = new StringBuilder(n + 16);
        adjName.append(PREFIX);
        int pos = 0;
        block4: for (int i = 0; i < n; ++i) {
            char ch = qname.charAt(i);
            switch (ch) {
                case '9': {
                    adjName.append(qname, pos, i).append("99");
                    pos = i + 1;
                    continue block4;
                }
                case ':': {
                    adjName.append(qname, pos, i).append("90");
                    pos = i + 1;
                }
            }
        }
        return adjName.append(qname, pos, n).toString();
    }

    static String qnameFromFixupName(String fixupName) {
        int pos = PREFIX.length();
        StringBuilder adjName = null;
        int n = fixupName.length();
        for (int i = pos; i < n; ++i) {
            char ch = fixupName.charAt(i);
            if (ch != '9') continue;
            if (adjName == null) {
                adjName = new StringBuilder(n);
            }
            adjName.append(fixupName, pos, i);
            adjName.append(fixupName.charAt(++i) == '9' ? (char)'9' : ':');
            pos = i + 1;
        }
        if (adjName == null) {
            return fixupName.substring(pos);
        }
        return adjName.append(fixupName, pos, n).toString();
    }
}

