/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lang.css.CssPropertyPatterns;
import com.google.caja.lang.css.CssSchema;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.MutableParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.Visitor;
import com.google.caja.parser.css.CssTree;
import com.google.caja.parser.html.ElKey;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.plugin.CssPropertyPartType;
import com.google.caja.plugin.CssValidator;
import com.google.caja.plugin.PluginMessageType;
import com.google.caja.plugin.UriPolicy;
import com.google.caja.plugin.UriPolicyHintKey;
import com.google.caja.render.Concatenator;
import com.google.caja.render.CssPrettyPrinter;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import com.google.caja.util.Name;
import com.google.caja.util.Pair;
import com.google.caja.util.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CssRewriter {
    private final UriPolicy uriPolicy;
    private final CssSchema schema;
    private final MessageQueue mq;
    private MessageLevel invalidNodeMessageLevel = MessageLevel.ERROR;
    private static final Set<Name> LINK_PSEUDO_CLASSES = Sets.immutableSet(Name.css("link"), Name.css("visited"));
    private static final ElKey HTML_ANCHOR = ElKey.forHtmlElement("a");
    private static final Set<Name> ALLOWED_PSEUDO_CLASSES = Sets.immutableSet(Name.css("active"), Name.css("after"), Name.css("before"), Name.css("first-child"), Name.css("first-letter"), Name.css("focus"), Name.css("link"), Name.css("hover"));
    private static final Set<Name> PROPERTIES_ALLOWED_IN_LINK_CLASSES;
    private static final Pattern SAFE_SELECTOR_PART;
    private static final Map<String, Integer> CSS3_COLORS;

    public CssRewriter(UriPolicy uriPolicy, CssSchema schema, MessageQueue mq) {
        assert (null != mq);
        assert (null != uriPolicy);
        this.uriPolicy = uriPolicy;
        this.schema = schema;
        this.mq = mq;
    }

    public CssRewriter withInvalidNodeMessageLevel(MessageLevel messageLevel) {
        this.invalidNodeMessageLevel = messageLevel;
        return this;
    }

    public void rewrite(AncestorChain<? extends CssTree> t) {
        this.rewriteHistorySensitiveRulesets(t);
        this.quoteLooseWords(t);
        this.fixTerms(t);
        this.removeUnsafeConstructs(t);
        this.removeEmptyDeclarationsAndSelectors(t);
        this.removeEmptyRuleSets(t);
        this.removeForbiddenIdents(t);
        this.removeUnsafeConstructs(t);
        this.translateUrls(t);
    }

    private void rewriteHistorySensitiveRulesets(final AncestorChain<? extends CssTree> t) {
        ((CssTree)t.node).acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ancestors) {
                if (!(ancestors.node instanceof CssTree.RuleSet)) {
                    return true;
                }
                Pair rewritten = CssRewriter.this.rewriteHistorySensitiveRuleset((CssTree.RuleSet)ancestors.node);
                if (rewritten != null) {
                    ((CssTree)t.node).insertBefore((ParseTreeNode)rewritten.a, (ParseTreeNode)ancestors.node);
                    ((CssTree)t.node).insertBefore((ParseTreeNode)rewritten.b, (ParseTreeNode)ancestors.node);
                    ((CssTree)t.node).removeChild((ParseTreeNode)ancestors.node);
                }
                return false;
            }
        }, t.parent);
    }

    private Pair<CssTree.RuleSet, CssTree.RuleSet> rewriteHistorySensitiveRuleset(CssTree.RuleSet ruleSet) {
        List<CssTree> linkeyChildren = Lists.newArrayList();
        List<CssTree> nonLinkeyChildren = Lists.newArrayList();
        for (CssTree cssTree : ruleSet.children()) {
            if (cssTree instanceof CssTree.Selector) {
                CssTree.Selector selector = (CssTree.Selector)cssTree;
                if (this.vetLinkToHistorySensitiveSelector(selector)) {
                    linkeyChildren.add(selector);
                    continue;
                }
                nonLinkeyChildren.add(selector);
                continue;
            }
            if (linkeyChildren.isEmpty() || nonLinkeyChildren.isEmpty()) {
                return null;
            }
            linkeyChildren.add(cssTree);
            nonLinkeyChildren.add((CssTree)cssTree.clone());
        }
        return Pair.pair(new CssTree.RuleSet(ruleSet.getFilePosition(), linkeyChildren), new CssTree.RuleSet(ruleSet.getFilePosition(), nonLinkeyChildren));
    }

    private boolean vetLinkToHistorySensitiveSelector(CssTree.Selector selector) {
        boolean modified = false;
        for (CssTree cssTree : selector.children()) {
            if (!(cssTree instanceof CssTree.SimpleSelector)) continue;
            modified |= this.vetLinkToHistorySensitiveSimpleSelector((CssTree.SimpleSelector)cssTree);
        }
        return modified;
    }

    private boolean vetLinkToHistorySensitiveSimpleSelector(CssTree.SimpleSelector selector) {
        if (selector.children().isEmpty()) {
            return false;
        }
        if (!this.containsLinkPseudoClass(selector)) {
            return false;
        }
        CssTree firstChild = selector.children().get(0);
        if (firstChild instanceof CssTree.WildcardElement) {
            selector.replaceChild(new CssTree.IdentLiteral(firstChild.getFilePosition(), HTML_ANCHOR.toString()), firstChild);
            return true;
        }
        if (firstChild instanceof CssTree.IdentLiteral) {
            String value = ((CssTree.IdentLiteral)firstChild).getValue();
            if (!HTML_ANCHOR.equals(ElKey.forElement(Namespaces.HTML_DEFAULT, value))) {
                this.mq.addMessage((MessageTypeInt)PluginMessageType.CSS_LINK_PSEUDO_SELECTOR_NOT_ALLOWED_ON_NONANCHOR, firstChild.getFilePosition());
            }
            return false;
        }
        selector.insertBefore(new CssTree.IdentLiteral(firstChild.getFilePosition(), HTML_ANCHOR.toString()), firstChild);
        return true;
    }

    private boolean containsLinkPseudoClass(CssTree.SimpleSelector selector) {
        final boolean[] result = new boolean[1];
        selector.acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> chain) {
                CssTree firstChild;
                if (chain.node instanceof CssTree.Pseudo && (firstChild = (CssTree)chain.node.children().get(0)) instanceof CssTree.IdentLiteral) {
                    CssTree.IdentLiteral ident = (CssTree.IdentLiteral)firstChild;
                    if (LINK_PSEUDO_CLASSES.contains(Name.css(ident.getValue()))) {
                        result[0] = true;
                        return false;
                    }
                }
                return true;
            }
        }, null);
        return result[0];
    }

    private void quoteLooseWords(AncestorChain<? extends CssTree> t) {
        if (t.node instanceof CssTree.Expr) {
            this.combineLooseWords((CssTree.Expr)t.cast(CssTree.Expr.class).node);
        }
        for (CssTree cssTree : ((CssTree)t.node).children()) {
            this.quoteLooseWords(AncestorChain.instance(t, cssTree));
        }
    }

    private void combineLooseWords(CssTree.Expr e) {
        int n = e.getNTerms();
        for (int i = 0; i < n; ++i) {
            int end;
            CssTree.Term t = e.getNthTerm(i);
            if (!CssRewriter.isLooseWord(t)) continue;
            Name propertyPart = CssRewriter.propertyPart(t);
            StringBuilder sb = new StringBuilder();
            sb.append(t.getExprAtom().getValue());
            MutableParseTreeNode.Mutation mut = e.createMutation();
            int start = i;
            for (end = i + 1; end < n; ++end) {
                CssTree.Operation op = e.getNthOperation(end - 1);
                CssTree.Term t2 = e.getNthTerm(end);
                if (CssTree.Operator.NONE != op.getOperator() || !CssRewriter.isLooseWord(t2) || !propertyPart.equals(CssRewriter.propertyPart(t2))) break;
                mut.removeChild(op);
                mut.removeChild(t2);
                sb.append(' ').append(e.getNthTerm(end).getExprAtom().getValue());
            }
            String text = sb.toString();
            FilePosition pos = FilePosition.span(t.getFilePosition(), e.getNthTerm(end - 1).getFilePosition());
            CssTree.StringLiteral quotedWords = new CssTree.StringLiteral(pos, text);
            CssTree.Term quotedTerm = new CssTree.Term(pos, null, quotedWords);
            quotedTerm.getAttributes().putAll(t.getAttributes());
            quotedTerm.getAttributes().set(CssValidator.CSS_PROPERTY_PART_TYPE, CssPropertyPartType.STRING);
            mut.replaceChild(quotedTerm, t);
            mut.execute();
            if (end - start > 1) {
                this.mq.addMessage((MessageTypeInt)PluginMessageType.QUOTED_CSS_VALUE, pos, MessagePart.Factory.valueOf(text));
            }
            n = e.getNTerms();
        }
    }

    private static boolean isLooseWord(CssTree.Term t) {
        return t.getOperator() == null && t.getExprAtom() instanceof CssTree.IdentLiteral && CssRewriter.propertyPartType(t) == CssPropertyPartType.LOOSE_WORD;
    }

    private void fixTerms(AncestorChain<? extends CssTree> t) {
        CssSchema.SymbolInfo stdColors = this.schema.getSymbol(Name.css("color-standard"));
        final Pattern stdColorMatcher = stdColors != null ? new CssPropertyPatterns(this.schema).cssPropertyToJavaRegex(stdColors.sig) : null;
        ((CssTree)t.node).acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ancestors) {
                if (!(ancestors.node instanceof CssTree.Term)) {
                    return true;
                }
                CssTree.Term term = (CssTree.Term)ancestors.node;
                CssPropertyPartType partType = CssRewriter.propertyPartType(term);
                if (CssPropertyPartType.LENGTH == partType && term.getExprAtom() instanceof CssTree.QuantityLiteral) {
                    CssTree.QuantityLiteral quantity = (CssTree.QuantityLiteral)term.getExprAtom();
                    String value = quantity.getValue();
                    if (!CssRewriter.isZeroOrHasUnits(value)) {
                        CssTree.QuantityLiteral withUnits = new CssTree.QuantityLiteral(quantity.getFilePosition(), value + "px");
                        withUnits.getAttributes().putAll(quantity.getAttributes());
                        term.replaceChild(withUnits, quantity);
                        CssRewriter.this.mq.addMessage((MessageTypeInt)PluginMessageType.ASSUMING_PIXELS_FOR_LENGTH, quantity.getFilePosition(), MessagePart.Factory.valueOf(value));
                    }
                    return false;
                }
                if (stdColorMatcher != null && CssPropertyPartType.IDENT == partType && CssRewriter.propertyPart(term).getCanonicalForm().endsWith("::color")) {
                    Name colorName = Name.css(((CssTree.IdentLiteral)term.getExprAtom()).getValue());
                    if (!stdColorMatcher.matcher(colorName.getCanonicalForm() + " ").matches()) {
                        FilePosition pos = term.getExprAtom().getFilePosition();
                        CssTree.HashLiteral replacement = CssRewriter.colorHash(pos, colorName);
                        MessageLevel lvl = MessageLevel.LINT;
                        if (replacement == null) {
                            lvl = MessageLevel.ERROR;
                            replacement = CssTree.HashLiteral.hex(pos, 0, 3);
                        }
                        term.replaceChild(replacement, term.getExprAtom());
                        CssRewriter.this.mq.addMessage((MessageTypeInt)PluginMessageType.NON_STANDARD_COLOR, lvl, pos, colorName, MessagePart.Factory.valueOf(replacement.getValue()));
                    }
                    return false;
                }
                return true;
            }
        }, t.parent);
    }

    private static boolean isZeroOrHasUnits(String value) {
        int len = value.length();
        char ch = value.charAt(len - 1);
        if (ch == '.' || '0' <= ch && ch <= '9') {
            int i = len;
            while (--i >= 0) {
                ch = value.charAt(i);
                if ('1' > ch || ch > '9') continue;
                return false;
            }
        }
        return true;
    }

    private void removeEmptyDeclarationsAndSelectors(AncestorChain<? extends CssTree> t) {
        ((CssTree)t.node).acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ancestors) {
                Object node = ancestors.node;
                if (node instanceof CssTree.EmptyDeclaration) {
                    ParseTreeNode parent = ancestors.getParentNode();
                    if (parent instanceof MutableParseTreeNode) {
                        ((MutableParseTreeNode)parent).removeChild((ParseTreeNode)node);
                    }
                    return false;
                }
                if (node instanceof CssTree.Selector) {
                    ParseTreeNode parent;
                    CssTree.Selector sel = (CssTree.Selector)node;
                    if ((sel.children().isEmpty() || !(sel.children().get(0) instanceof CssTree.SimpleSelector)) && (parent = ancestors.getParentNode()) instanceof MutableParseTreeNode) {
                        ((MutableParseTreeNode)parent).removeChild(sel);
                    }
                    return false;
                }
                return true;
            }
        }, t.parent);
    }

    private void removeEmptyRuleSets(AncestorChain<? extends CssTree> t) {
        ((CssTree)t.node).acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ancestors) {
                ParseTreeNode parent;
                Object node = ancestors.node;
                if (!(node instanceof CssTree.RuleSet)) {
                    return true;
                }
                CssTree.RuleSet rset = (CssTree.RuleSet)node;
                List<? extends CssTree> children = rset.children();
                if ((children.isEmpty() || children.get(children.size() - 1) instanceof CssTree.Selector || !(children.get(0) instanceof CssTree.Selector)) && (parent = ancestors.getParentNode()) instanceof MutableParseTreeNode) {
                    ((MutableParseTreeNode)parent).removeChild(rset);
                }
                return false;
            }
        }, t.parent);
    }

    private void removeForbiddenIdents(AncestorChain<? extends CssTree> t) {
        ((CssTree)t.node).acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ac) {
                if (!(ac.node instanceof CssTree.SimpleSelector)) {
                    return true;
                }
                CssTree.SimpleSelector ss = (CssTree.SimpleSelector)ac.node;
                boolean ok = false;
                for (CssTree cssTree : ss.children()) {
                    String literal;
                    if (!(cssTree instanceof CssTree.ClassLiteral) && !(cssTree instanceof CssTree.IdLiteral) || !(literal = (String)cssTree.getValue()).endsWith("__")) continue;
                    CssRewriter.this.mq.addMessage((MessageTypeInt)PluginMessageType.UNSAFE_CSS_IDENTIFIER, cssTree.getFilePosition(), MessagePart.Factory.valueOf(literal));
                    ac.parent.node.getAttributes().set(CssValidator.INVALID, true);
                    ok = false;
                }
                return ok;
            }
        }, t.parent);
    }

    void removeUnsafeConstructs(AncestorChain<? extends CssTree> t) {
        ((CssTree)t.node).acceptPreOrder(new Visitor(){

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean visit(AncestorChain<?> ancestors) {
                Object node = ancestors.node;
                if (node instanceof CssTree.SimpleSelector) {
                    for (CssTree cssTree : ((CssTree.SimpleSelector)node).children()) {
                        void var4_4;
                        Object value;
                        if (cssTree instanceof CssTree.Pseudo) {
                            CssTree cssTree2 = cssTree.children().get(0);
                        }
                        if ((value = var4_4.getValue()) == null || CssRewriter.isSafeSelectorPart(value.toString())) continue;
                        CssRewriter.this.mq.addMessage((MessageTypeInt)PluginMessageType.UNSAFE_CSS_IDENTIFIER, var4_4.getFilePosition(), MessagePart.Factory.valueOf(value.toString()));
                        node.getAttributes().set(CssValidator.INVALID, Boolean.TRUE);
                        return false;
                    }
                }
                return true;
            }
        }, t.parent);
        ((CssTree)t.node).acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ancestors) {
                Object node = ancestors.node;
                if (node instanceof CssTree.Pseudo) {
                    boolean remove = false;
                    CssTree child = ((CssTree.Pseudo)node).children().get(0);
                    if (child instanceof CssTree.IdentLiteral) {
                        Name pseudoName = Name.css(((CssTree.IdentLiteral)child).getValue());
                        if (!(ALLOWED_PSEUDO_CLASSES.contains(pseudoName) || LINK_PSEUDO_CLASSES.contains(pseudoName) && CssRewriter.this.strippedPropertiesBannedInLinkClasses(ancestors.parent.parent.cast(CssTree.Selector.class)))) {
                            CssRewriter.this.mq.addMessage((MessageTypeInt)PluginMessageType.UNSAFE_CSS_PSEUDO_SELECTOR, CssRewriter.this.invalidNodeMessageLevel, new MessagePart[]{node.getFilePosition(), node});
                            remove = true;
                        }
                    } else {
                        StringBuilder rendered = new StringBuilder();
                        CssPrettyPrinter tc = new CssPrettyPrinter(new Concatenator(rendered));
                        node.render(new RenderContext(tc));
                        tc.noMoreTokens();
                        CssRewriter.this.mq.addMessage((MessageTypeInt)PluginMessageType.UNSAFE_CSS_PSEUDO_SELECTOR, CssRewriter.this.invalidNodeMessageLevel, node.getFilePosition(), MessagePart.Factory.valueOf(rendered.toString()));
                        remove = true;
                    }
                    if (remove) {
                        CssRewriter.selectorFor(ancestors).getAttributes().set(CssValidator.INVALID, Boolean.TRUE);
                    }
                }
                return true;
            }
        }, t.parent);
        ((CssTree)t.node).acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ancestors) {
                Object node = ancestors.node;
                if (node instanceof CssTree.Property) {
                    if (node.getAttributes().is(CssValidator.INVALID)) {
                        CssRewriter.declarationFor(ancestors).getAttributes().set(CssValidator.INVALID, Boolean.TRUE);
                    }
                } else if (node instanceof CssTree.Attrib) {
                    if (node.getAttributes().is(CssValidator.INVALID)) {
                        CssRewriter.simpleSelectorFor(ancestors).getAttributes().set(CssValidator.INVALID, Boolean.TRUE);
                    }
                } else if (node instanceof CssTree.Term && CssPropertyPartType.URI == CssRewriter.propertyPartType(node)) {
                    CssTree.Declaration decl;
                    boolean remove = false;
                    Message removeMsg = null;
                    CssTree.Term term = (CssTree.Term)node;
                    CssTree.CssLiteral content = (CssTree.CssLiteral)term.children().get(0);
                    if (content instanceof CssTree.Substitution) {
                        return true;
                    }
                    String uriStr = content.getValue();
                    try {
                        URI baseUri = content.getFilePosition().source().getUri();
                        URI uri = baseUri.resolve(new URI(uriStr));
                        ExternalReference ref = new ExternalReference(uri, content.getFilePosition());
                        Name propertyPart = CssRewriter.propertyPart(node);
                        if (CssRewriter.this.uriPolicy.rewriteUri(ref, UriPolicy.UriEffect.SAME_DOCUMENT, UriPolicy.LoaderType.SANDBOXED, Collections.singletonMap(UriPolicyHintKey.CSS_PROP.key, propertyPart)) == null) {
                            removeMsg = new Message((MessageTypeInt)PluginMessageType.DISALLOWED_URI, node.getFilePosition(), MessagePart.Factory.valueOf(uriStr));
                            remove = true;
                        }
                    }
                    catch (URISyntaxException ex) {
                        removeMsg = new Message((MessageTypeInt)PluginMessageType.DISALLOWED_URI, node.getFilePosition(), MessagePart.Factory.valueOf(uriStr));
                        remove = true;
                    }
                    if (remove && null != (decl = CssRewriter.declarationFor(ancestors)) && !decl.getAttributes().is(CssValidator.INVALID)) {
                        if (null != removeMsg) {
                            CssRewriter.this.mq.getMessages().add(removeMsg);
                        }
                        decl.getAttributes().set(CssValidator.INVALID, Boolean.TRUE);
                    }
                }
                return true;
            }
        }, t.parent);
        this.removeInvalidNodes(t);
        ((CssTree)t.node).acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ancestors) {
                Object node = ancestors.node;
                if (node instanceof CssTree.Selector && node.children().isEmpty() || node instanceof CssTree.RuleSet && (node.children().isEmpty() || node.children().get(0) instanceof CssTree.Declaration)) {
                    ((MutableParseTreeNode)ancestors.parent.node).removeChild((ParseTreeNode)node);
                    return false;
                }
                return true;
            }
        }, t.parent);
    }

    private void removeInvalidNodes(AncestorChain<? extends CssTree> t) {
        if (((CssTree)t.node).getAttributes().is(CssValidator.INVALID)) {
            ((MutableParseTreeNode)t.parent.node).removeChild((ParseTreeNode)t.node);
            return;
        }
        MutableParseTreeNode.Mutation mut = null;
        for (CssTree cssTree : ((CssTree)t.node).children()) {
            if (cssTree.getAttributes().is(CssValidator.INVALID)) {
                if (mut == null) {
                    mut = ((CssTree)t.node).createMutation();
                }
                mut.removeChild(cssTree);
                continue;
            }
            this.removeInvalidNodes(AncestorChain.instance(t, cssTree));
        }
        if (mut != null) {
            mut.execute();
        }
    }

    private void translateUrls(AncestorChain<? extends CssTree> t) {
        ((CssTree)t.node).acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ancestors) {
                Object node = ancestors.node;
                if (node instanceof CssTree.Term && CssPropertyPartType.URI == CssRewriter.propertyPartType(node)) {
                    CssTree.Term term = (CssTree.Term)node;
                    CssTree.CssLiteral content = (CssTree.CssLiteral)term.children().get(0);
                    if (content instanceof CssTree.Substitution) {
                        return true;
                    }
                    Name propertyPart = CssRewriter.propertyPart(node);
                    String uriStr = content.getValue();
                    try {
                        URI baseUri = content.getFilePosition().source().getUri();
                        URI uri = baseUri.resolve(new URI(uriStr));
                        ExternalReference ref = new ExternalReference(uri, content.getFilePosition());
                        String rewrittenUri = CssRewriter.this.uriPolicy.rewriteUri(ref, UriPolicy.UriEffect.SAME_DOCUMENT, UriPolicy.LoaderType.SANDBOXED, Collections.singletonMap(UriPolicyHintKey.CSS_PROP.key, propertyPart));
                        CssTree.UriLiteral replacement = new CssTree.UriLiteral(content.getFilePosition(), URI.create(rewrittenUri));
                        replacement.getAttributes().putAll(content.getAttributes());
                        term.replaceChild(replacement, content);
                    }
                    catch (URISyntaxException ex) {
                        throw new SomethingWidgyHappenedError(ex);
                    }
                }
                return true;
            }
        }, t.parent);
    }

    private static CssTree.Declaration declarationFor(AncestorChain<?> chain) {
        AncestorChain<Object> c = chain;
        while (null != c) {
            if (c.node instanceof CssTree.Declaration) {
                return (CssTree.Declaration)c.node;
            }
            c = c.parent;
        }
        return null;
    }

    private static CssTree.SimpleSelector simpleSelectorFor(AncestorChain<?> chain) {
        AncestorChain<Object> c = chain;
        while (null != c) {
            if (c.node instanceof CssTree.SimpleSelector) {
                return (CssTree.SimpleSelector)c.node;
            }
            c = c.parent;
        }
        return null;
    }

    private static CssTree.Selector selectorFor(AncestorChain<?> chain) {
        AncestorChain<Object> c = chain;
        while (null != c) {
            if (c.node instanceof CssTree.Selector) {
                return (CssTree.Selector)c.node;
            }
            c = c.parent;
        }
        return null;
    }

    private boolean strippedPropertiesBannedInLinkClasses(AncestorChain<CssTree.Selector> sel) {
        if (!(sel.parent.node instanceof CssTree.RuleSet)) {
            return false;
        }
        Set<Name> propertyNames = PROPERTIES_ALLOWED_IN_LINK_CLASSES;
        CssTree.RuleSet rs = (CssTree.RuleSet)sel.parent.cast(CssTree.RuleSet.class).node;
        MutableParseTreeNode.Mutation mut = rs.createMutation();
        for (CssTree cssTree : rs.children()) {
            if (cssTree instanceof CssTree.Selector || cssTree instanceof CssTree.EmptyDeclaration) continue;
            CssTree.PropertyDeclaration pd = cssTree instanceof CssTree.PropertyDeclaration ? (CssTree.PropertyDeclaration)cssTree : ((CssTree.UserAgentHack)cssTree).getDeclaration();
            CssTree.Property p = pd.getProperty();
            Name propName = p.getPropertyName();
            boolean allowedInLinkClass = propertyNames.contains(propName);
            if (!allowedInLinkClass && propName.getCanonicalForm().startsWith("_")) {
                allowedInLinkClass = propertyNames.contains(Name.css(propName.getCanonicalForm().substring(1)));
            }
            if (allowedInLinkClass && !this.mightContainUrl(pd.getExpr())) continue;
            this.mq.getMessages().add(new Message((MessageTypeInt)PluginMessageType.DISALLOWED_CSS_PROPERTY_IN_SELECTOR, this.invalidNodeMessageLevel, p.getFilePosition(), p.getPropertyName(), ((CssTree.Selector)sel.node).getFilePosition()));
            mut.removeChild(cssTree);
        }
        mut.execute();
        return true;
    }

    private boolean mightContainUrl(CssTree.Expr expr) {
        int n = expr.getNTerms();
        for (int i = 0; i < n; ++i) {
            CssTree.CssExprAtom atom = expr.getNthTerm(i).getExprAtom();
            if (atom instanceof CssTree.IdentLiteral || atom instanceof CssTree.QuantityLiteral || atom instanceof CssTree.HashLiteral) continue;
            return true;
        }
        return false;
    }

    private static boolean isSafeSelectorPart(String s) {
        return SAFE_SELECTOR_PART.matcher(s).matches();
    }

    private static Name propertyPart(ParseTreeNode node) {
        return node.getAttributes().get(CssValidator.CSS_PROPERTY_PART);
    }

    private static CssPropertyPartType propertyPartType(ParseTreeNode node) {
        return node.getAttributes().get(CssValidator.CSS_PROPERTY_PART_TYPE);
    }

    public static CssTree.HashLiteral colorHash(FilePosition pos, Name color) {
        Integer hexI = CSS3_COLORS.get(color.getCanonicalForm());
        return hexI != null ? CssRewriter.colorHash(pos, hexI) : null;
    }

    public static CssTree.HashLiteral colorHash(FilePosition pos, int hex) {
        if ((hex & 0xF0F0F) == (hex >>> 4 & 0xF0F0F)) {
            return CssTree.HashLiteral.hex(pos, hex >>> 8 & 0xF00 | hex >>> 4 & 0xF0 | hex & 0xF, 3);
        }
        return CssTree.HashLiteral.hex(pos, hex, 6);
    }

    static {
        Set<Name> propNames = Sets.newHashSet(Name.css("background-color"), Name.css("color"), Name.css("cursor"));
        Set<Name> computedStyleNames = CssPropertyPatterns.HISTORY_INSENSITIVE_STYLE_WHITELIST;
        propNames.removeAll(computedStyleNames);
        PROPERTIES_ALLOWED_IN_LINK_CLASSES = Sets.immutableSet(propNames);
        SAFE_SELECTOR_PART = Pattern.compile("^[#!\\.]?[a-zA-Z][_a-zA-Z0-9\\-]*$");
        CSS3_COLORS = Maps.immutableMap().put("aliceblue", 0xF0F8FF).put("antiquewhite", 16444375).put("aqua", 65535).put("aquamarine", 8388564).put("azure", 0xF0FFFF).put("beige", 16119260).put("bisque", 16770244).put("black", 0).put("blanchedalmond", 16772045).put("blue", 255).put("blueviolet", 9055202).put("brown", 0xA52A2A).put("burlywood", 14596231).put("cadetblue", 6266528).put("chartreuse", 0x7FFF00).put("chocolate", 13789470).put("coral", 16744272).put("cornflowerblue", 6591981).put("cornsilk", 16775388).put("crimson", 14423100).put("cyan", 65535).put("darkblue", 139).put("darkcyan", 35723).put("darkgoldenrod", 12092939).put("darkgray", 0xA9A9A9).put("darkgreen", 25600).put("darkkhaki", 12433259).put("darkmagenta", 0x8B008B).put("darkolivegreen", 5597999).put("darkorange", 16747520).put("darkorchid", 10040012).put("darkred", 0x8B0000).put("darksalmon", 15308410).put("darkseagreen", 9419919).put("darkslateblue", 4734347).put("darkslategray", 0x2F4F4F).put("darkturquoise", 52945).put("darkviolet", 9699539).put("deeppink", 16716947).put("deepskyblue", 49151).put("dimgray", 0x696969).put("dodgerblue", 2003199).put("firebrick", 0xB22222).put("floralwhite", 0xFFFAF0).put("forestgreen", 0x228B22).put("fuchsia", 0xFF00FF).put("gainsboro", 0xDCDCDC).put("ghostwhite", 0xF8F8FF).put("gold", 16766720).put("goldenrod", 14329120).put("gray", 0x808080).put("green", 32768).put("greenyellow", 11403055).put("honeydew", 0xF0FFF0).put("hotpink", 16738740).put("indianred", 0xCD5C5C).put("indigo", 4915330).put("ivory", 0xFFFFF0).put("khaki", 15787660).put("lavender", 15132410).put("lavenderblush", 0xFFF0F5).put("lawngreen", 8190976).put("lemonchiffon", 16775885).put("lightblue", 11393254).put("lightcoral", 0xF08080).put("lightcyan", 0xE0FFFF).put("lightgoldenrodyellow", 16448210).put("lightgreen", 0x90EE90).put("lightgrey", 0xD3D3D3).put("lightpink", 16758465).put("lightsalmon", 16752762).put("lightseagreen", 2142890).put("lightskyblue", 8900346).put("lightslategray", 0x778899).put("lightsteelblue", 11584734).put("lightyellow", 0xFFFFE0).put("lime", 65280).put("limegreen", 3329330).put("linen", 16445670).put("magenta", 0xFF00FF).put("maroon", 0x800000).put("mediumaquamarine", 6737322).put("mediumblue", 205).put("mediumorchid", 12211667).put("mediumpurple", 9662683).put("mediumseagreen", 3978097).put("mediumslateblue", 8087790).put("mediumspringgreen", 64154).put("mediumturquoise", 4772300).put("mediumvioletred", 13047173).put("midnightblue", 1644912).put("mintcream", 0xF5FFFA).put("mistyrose", 16770273).put("moccasin", 16770229).put("navajowhite", 16768685).put("navy", 128).put("oldlace", 16643558).put("olive", 0x808000).put("olivedrab", 7048739).put("orange", 16753920).put("orangered", 16729344).put("orchid", 14315734).put("palegoldenrod", 0xEEE8AA).put("palegreen", 10025880).put("paleturquoise", 0xAFEEEE).put("palevioletred", 14381203).put("papayawhip", 16773077).put("peachpuff", 16767673).put("peru", 13468991).put("pink", 16761035).put("plum", 0xDDA0DD).put("powderblue", 11591910).put("purple", 0x800080).put("red", 0xFF0000).put("rosybrown", 12357519).put("royalblue", 4286945).put("saddlebrown", 9127187).put("salmon", 16416882).put("sandybrown", 16032864).put("seagreen", 3050327).put("seashell", 0xFFF5EE).put("sienna", 10506797).put("silver", 0xC0C0C0).put("skyblue", 8900331).put("slateblue", 6970061).put("slategray", 7372944).put("snow", 0xFFFAFA).put("springgreen", 65407).put("steelblue", 4620980).put("tan", 13808780).put("teal", 32896).put("thistle", 14204888).put("tomato", 16737095).put("turquoise", 4251856).put("violet", 0xEE82EE).put("wheat", 16113331).put("white", 0xFFFFFF).put("whitesmoke", 0xF5F5F5).put("yellow", 0xFFFF00).put("yellowgreen", 10145074).create();
    }
}

