/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jdbc;

import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.jdbc.ConnectionControl;
import com.arjuna.ats.internal.jdbc.ConnectionImple;
import com.arjuna.ats.internal.jdbc.DynamicClass;
import com.arjuna.ats.internal.jdbc.drivers.modifiers.ConnectionModifier;
import com.arjuna.ats.jdbc.logging.jdbcLogger;
import com.arjuna.ats.jta.xa.RecoverableXAConnection;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;

public class DirectRecoverableConnection
implements RecoverableXAConnection,
ConnectionControl {
    private String _dbName;
    private String _user;
    private String _passwd;
    private String _dynamic;
    private XAConnection _theConnection;
    private XADataSource _theDataSource;
    private DynamicClass _dynamicConnection;
    private XAResource _theXAResource;
    private Transaction _theTransaction;
    private ConnectionImple _theArjunaConnection;
    private ConnectionModifier _theModifier;

    public DirectRecoverableConnection() throws SQLException {
        if (jdbcLogger.logger.isDebugEnabled()) {
            jdbcLogger.logger.debug(1L, 4L, 1L, "DirectRecoverableConnection.DirectRecoverableConnection()");
        }
        this._dbName = null;
        this._user = null;
        this._passwd = null;
        this._dynamic = null;
        this._theConnection = null;
        this._theDataSource = null;
        this._dynamicConnection = null;
        this._theXAResource = null;
        this._theTransaction = null;
        this._theArjunaConnection = null;
        this._theModifier = null;
    }

    public DirectRecoverableConnection(String dbName, String user, String passwd, String dynamic, ConnectionImple conn) throws SQLException {
        if (jdbcLogger.logger.isDebugEnabled()) {
            jdbcLogger.logger.debug(1L, 4L, 1L, "DirectRecoverableConnection.DirectRecoverableConnection( " + dbName + ", " + user + ", " + passwd + ", " + dynamic + " )");
        }
        this._dbName = dbName;
        this._user = user;
        this._passwd = passwd;
        this._dynamic = dynamic;
        this._theConnection = null;
        this._theDataSource = null;
        this._dynamicConnection = null;
        this._theXAResource = null;
        this._theTransaction = null;
        this._theArjunaConnection = conn;
        this._theModifier = null;
    }

    public void finalize() {
        block3: {
            try {
                if (this._theConnection != null) {
                    this._theConnection.close();
                    this._theConnection = null;
                }
            }
            catch (SQLException e) {
                if (!jdbcLogger.loggerI18N.isWarnEnabled()) break block3;
                jdbcLogger.loggerI18N.warn("com.arjuna.ats.internal.jdbc.drcdest", new Object[]{e});
            }
        }
    }

    public boolean packInto(OutputObjectState os) {
        if (jdbcLogger.logger.isDebugEnabled()) {
            jdbcLogger.logger.debug(16L, 4L, 1L, "DirectRecoverableConnection.packInto ()");
        }
        try {
            os.packString(this._dbName);
            os.packString(this._user);
            os.packString(this._passwd);
            os.packString(this._dynamic);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean unpackFrom(InputObjectState os) {
        if (jdbcLogger.logger.isDebugEnabled()) {
            jdbcLogger.logger.debug(16L, 4L, 1L, "DirectRecoverableConnection.unpackFrom ()");
        }
        try {
            this._dbName = os.unpackString();
            this._user = os.unpackString();
            this._passwd = os.unpackString();
            this._dynamic = os.unpackString();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setTransaction(Transaction tx2) {
        DirectRecoverableConnection directRecoverableConnection = this;
        synchronized (directRecoverableConnection) {
            if (this._theTransaction == null) {
                this._theTransaction = tx2;
                return true;
            }
        }
        return this.validTransaction(tx2);
    }

    public boolean validTransaction(Transaction tx2) {
        boolean valid = true;
        if (this._theTransaction != null) {
            valid = this._theTransaction.equals(tx2);
        }
        return valid;
    }

    public XAResource getResource() throws SQLException {
        if (jdbcLogger.logger.isDebugEnabled()) {
            jdbcLogger.logger.debug(16L, 4L, 1L, "DirectRecoverableConnection.getResource ()");
        }
        try {
            if (this._theXAResource == null) {
                this._theXAResource = this.getConnection().getXAResource();
            }
            return this._theXAResource;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException(e.toString());
        }
    }

    public final void close() {
        this.reset();
    }

    public final void reset() {
        this._theXAResource = null;
        this._theTransaction = null;
    }

    public XAConnection getCurrentConnection() throws SQLException {
        return this._theConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCloseCurrentConnection() throws SQLException {
        DirectRecoverableConnection directRecoverableConnection = this;
        synchronized (directRecoverableConnection) {
            if (this._theConnection != null) {
                this._theConnection.close();
                this._theConnection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAConnection getConnection() throws SQLException {
        if (jdbcLogger.logger.isDebugEnabled()) {
            jdbcLogger.logger.debug(16L, 4L, 1L, "DirectRecoverableConnection.getConnection ()");
        }
        try {
            DirectRecoverableConnection directRecoverableConnection = this;
            synchronized (directRecoverableConnection) {
                if (this._theConnection == null) {
                    this.createConnection();
                }
            }
            return this._theConnection;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException(e.toString());
        }
    }

    public XADataSource getDataSource() throws SQLException {
        if (jdbcLogger.logger.isDebugEnabled()) {
            jdbcLogger.logger.debug(16L, 4L, 1L, "DirectRecoverableConnection.getDataSource ()");
        }
        return this._theDataSource;
    }

    public boolean inuse() {
        return this._theXAResource != null;
    }

    public String user() {
        return this._user;
    }

    public String password() {
        return this._passwd;
    }

    public String url() {
        return this._dbName;
    }

    public String dynamicClass() {
        return this._dynamic;
    }

    public String dataSourceName() {
        return this._dbName;
    }

    public Transaction transaction() {
        return this._theTransaction;
    }

    public void setModifier(ConnectionModifier cm) {
        this._theModifier = cm;
        if (this._theModifier != null) {
            this._dbName = this._theModifier.initialise(this._dbName);
        }
    }

    private final void createConnection() throws SQLException {
        if (jdbcLogger.logger.isDebugEnabled()) {
            jdbcLogger.logger.debug(16L, 1L, 1L, "DirectRecoverableConnection.createConnection");
        }
        if (this._dynamic == null || this._dynamic.equals("")) {
            throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.dynamicerror"));
        }
        try {
            if (this._theDataSource == null) {
                Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(this._dynamic);
                this._dynamicConnection = (DynamicClass)c.newInstance();
                this._theDataSource = this._dynamicConnection.getDataSource(this._dbName);
            }
            if (this._user == null && this._passwd == null) {
                if (jdbcLogger.logger.isDebugEnabled()) {
                    jdbcLogger.logger.debug(16L, 1L, 1L, "DirectRecoverableConnection - getting connection with no user");
                }
                this._theConnection = this._theDataSource.getXAConnection();
            } else {
                if (jdbcLogger.logger.isDebugEnabled()) {
                    jdbcLogger.logger.debug(16L, 1L, 1L, "DirectRecoverableConnection - getting connection for user " + this._user);
                }
                this._theConnection = this._theDataSource.getXAConnection(this._user, this._passwd);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException(e.toString());
        }
    }
}

