/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.common.Pair;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.ResourceMutateVisitor;
import org.apache.shindig.gadgets.uri.ProxyUriManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyingVisitor
extends ResourceMutateVisitor {
    private static final Logger logger = Logger.getLogger(ProxyUriManager.class.getName());
    private final ProxyUriManager uriManager;

    public ProxyingVisitor(ContentRewriterFeature.Config featureConfig, ProxyUriManager uriManager, ResourceMutateVisitor.Tags ... resourceTags) {
        super(featureConfig, resourceTags);
        this.uriManager = uriManager;
    }

    @Override
    protected Collection<Pair<Node, Uri>> mutateUris(Gadget gadget, Collection<Node> nodes) {
        ArrayList reservedUris = Lists.newArrayListWithCapacity((int)nodes.size());
        ArrayList reservedNodes = Lists.newArrayListWithCapacity((int)nodes.size());
        for (Node node : nodes) {
            Element element = (Element)node;
            String nodeName = node.getNodeName().toLowerCase();
            String uriStr = element.getAttribute((String)this.resourceTags.get(nodeName)).trim();
            try {
                ProxyUriManager.ProxyUri proxiedUri = new ProxyUriManager.ProxyUri(gadget, Uri.parse((String)uriStr));
                proxiedUri.setHtmlTagContext(nodeName);
                reservedUris.add(proxiedUri);
                reservedNodes.add(node);
            }
            catch (Uri.UriException e) {
                logger.log(Level.WARNING, "Uri exception when parsing: " + uriStr, e);
            }
        }
        List<Uri> resourceUris = this.uriManager.make(reservedUris, this.featureConfig.getExpires());
        ArrayList proxiedUris = Lists.newArrayListWithCapacity((int)nodes.size());
        Iterator<Uri> uriIt = resourceUris.iterator();
        for (Node node : reservedNodes) {
            proxiedUris.add(Pair.of((Object)node, (Object)uriIt.next()));
        }
        return proxiedUris;
    }
}

