/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.impl.model;

import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.forum.service.DataStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListAccess<E>
implements ListAccess<E> {
    protected DataStorage storage = null;
    private int currentPage = 1;
    private int totalPage = 1;
    private int pageSize = 0;
    protected int size = -1;

    public abstract E[] load(int var1) throws Exception, IllegalArgumentException;

    public void reCalculate(int offset, int limit) {
        if (offset >= 0) {
            this.currentPage = (offset + 1) / limit;
            if ((offset + 1) % limit > 0) {
                ++this.currentPage;
            }
        }
    }

    public void initialize(int pageSize, int pageSelect) throws Exception {
        this.setPageSize(pageSize);
        this.getTotalPages();
        this.setCurrentPage(pageSelect);
    }

    public int getTotalPages() throws Exception {
        this.totalPage = this.getSize() / this.pageSize;
        if (this.getSize() % this.pageSize > 0) {
            ++this.totalPage;
        }
        return this.totalPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getCurrentPage() throws Exception {
        return this.currentPage;
    }

    public void setCurrentPage(int page) throws Exception {
        this.currentPage = page > this.totalPage && this.totalPage > 0 ? this.totalPage : (page <= 0 ? 1 : page);
    }

    public int getOffset(int currentPage) {
        return (currentPage - 1) * this.pageSize;
    }

    public int getOffset(int currentPage, int pageSize) {
        return (this.currentPage - 1) * this.pageSize;
    }

    public int getOffset() {
        return (this.currentPage - 1) * this.pageSize;
    }
}

