/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.common.job;

import java.lang.reflect.Constructor;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiTenancyJob
implements Job {
    private static Log log_ = ExoLogger.getLogger((String)"cs.ks.job.multitenancy");
    public static final String COLON = ":".intern();

    public abstract Class<? extends MultiTenancyTask> getTask();

    public void execute(JobExecutionContext context) throws JobExecutionException {
        RepositoryService repoService = (RepositoryService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class);
        List entries = repoService.getConfig().getRepositoryConfigurations();
        ExecutorService executor = Executors.newFixedThreadPool(entries.size());
        for (RepositoryEntry repositoryEntry : entries) {
            try {
                Constructor<? extends MultiTenancyTask> constructor = this.getTask().getConstructor(this.getClass(), JobExecutionContext.class, String.class);
                executor.execute(constructor.newInstance(this, context, repositoryEntry.getName()));
            }
            catch (Exception e) {
                log_.error((Object)"Exception when looking for multi-tenancy task", (Throwable)e);
            }
        }
        executor.shutdown();
    }

    public static PortalContainer getPortalContainer(JobExecutionContext context) {
        if (context == null) {
            return null;
        }
        String portalName = context.getJobDetail().getGroup();
        if (portalName == null) {
            return null;
        }
        if (portalName.indexOf(COLON) > 0) {
            portalName = portalName.substring(0, portalName.indexOf(":"));
        }
        return RootContainer.getInstance().getPortalContainer(portalName);
    }

    public class MultiTenancyTask
    implements Runnable {
        protected JobExecutionContext context;
        protected PortalContainer container;
        protected String repoName;

        public MultiTenancyTask(JobExecutionContext context, String repoName) {
            this.context = context;
            this.repoName = repoName;
        }

        public void run() {
            this.container = MultiTenancyJob.getPortalContainer(this.context);
            if (this.container == null) {
                throw new IllegalStateException("Container is empty");
            }
            ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
            RepositoryService repoService = (RepositoryService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class);
            try {
                repoService.setCurrentRepositoryName(this.repoName);
            }
            catch (RepositoryConfigurationException e) {
                log_.error((Object)"Repository is error", (Throwable)e);
            }
        }
    }
}

