/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.swing;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import org.exoplatform.server.tomcat.TomcatPlugin;
import org.exoplatform.swing.ApplicationMenuBar;
import org.exoplatform.swing.ControlSpace;
import org.exoplatform.swing.Plugin;
import org.exoplatform.swing.ViewPlugin;
import org.exoplatform.swing.Workspaces;
import org.exoplatform.swing.explorer.FileExplorerPlugin;
import org.exoplatform.swing.log.LogPlugin;
import org.exoplatform.wsqa.swing.WSQAPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application
extends JFrame {
    private static Application instance_;
    private Map<String, ViewPlugin> workspacesMap_ = new HashMap<String, ViewPlugin>();
    private Map<String, Plugin> plugins_ = new LinkedHashMap<String, Plugin>();
    private ApplicationMenuBar menuBar_;
    private ControlSpace controlSpace_;
    private Workspaces workspaces_;

    public Application() throws Exception {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                System.out.println("Window Exit");
                System.exit(0);
            }
        });
        this.setLocation(20, 20);
        this.setSize(1200, 700);
        this.menuBar_ = new ApplicationMenuBar();
        this.setJMenuBar(this.menuBar_);
        this.plugins_.put("ExplorerWorkspacePlugin", new FileExplorerPlugin());
        this.plugins_.put("LogPlugin", new LogPlugin());
        this.plugins_.put("WSQAPlugin", new WSQAPlugin());
        this.plugins_.put("TomcatPlugin", new TomcatPlugin());
        this.getContentPane().setLayout(new CardLayout());
        JSplitPane splitPane = new JSplitPane();
        splitPane.setContinuousLayout(true);
        splitPane.updateUI();
        splitPane.setDividerSize(5);
        splitPane.setDividerLocation(300);
        this.add((Component)splitPane, "SplitPane");
        this.controlSpace_ = new ControlSpace();
        splitPane.setLeftComponent(this.controlSpace_);
        this.workspaces_ = new Workspaces();
        splitPane.setRightComponent(this.workspaces_);
        this.getContentPane().add((Component)splitPane, "SplitPane");
        for (Plugin plugin : this.plugins_.values()) {
            plugin.onInitApplication(this);
        }
        this.setVisible(true);
    }

    public Plugin getPlugin(String name) {
        return this.plugins_.get(name);
    }

    public Map<String, ViewPlugin> getWorkspacesMap() {
        return this.workspacesMap_;
    }

    public void changeWorkspace(String name) {
        ViewPlugin oldWS = (ViewPlugin)((Object)this.getContentPane().getComponent(0));
        this.getContentPane().remove(0);
        ViewPlugin newWS = this.workspacesMap_.get(name);
        this.getContentPane().add((Component)((JComponent)((Object)newWS)), "Workspace");
        this.setVisible(true);
    }

    public ControlSpace getControlSpace() {
        return this.controlSpace_;
    }

    public Workspaces getWorkspaces() {
        return this.workspaces_;
    }

    public ApplicationMenuBar getApplicationMenuBar() {
        return this.menuBar_;
    }

    public static Application getInstance() {
        return instance_;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    instance_ = new Application();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }
}

