/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.metadata;

import java.io.InputStream;
import java.io.Reader;
import javax.xml.stream.XMLStreamReader;
import org.exoplatform.web.controller.metadata.ControllerDescriptor;
import org.exoplatform.web.controller.metadata.Element;
import org.exoplatform.web.controller.metadata.PathParamDescriptor;
import org.exoplatform.web.controller.metadata.RequestParamDescriptor;
import org.exoplatform.web.controller.metadata.RouteDescriptor;
import org.exoplatform.web.controller.metadata.RouteParamDescriptor;
import org.exoplatform.web.controller.router.ControlMode;
import org.exoplatform.web.controller.router.EncodingMode;
import org.exoplatform.web.controller.router.ValueMapping;
import org.exoplatform.web.controller.router.ValueType;
import org.staxnav.Naming;
import org.staxnav.StaxNavException;
import org.staxnav.StaxNavigator;
import org.staxnav.StaxNavigatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptorBuilder {
    public static PathParamDescriptor pathParam(String qualifiedName) {
        return new PathParamDescriptor(qualifiedName);
    }

    public static RequestParamDescriptor requestParam(String qualifiedName) {
        return new RequestParamDescriptor(qualifiedName);
    }

    public static RouteParamDescriptor routeParam(String qualifiedName) {
        return new RouteParamDescriptor(qualifiedName);
    }

    public static RouteDescriptor route(String path) {
        return new RouteDescriptor(path);
    }

    public static ControllerDescriptor router() {
        return new ControllerDescriptor();
    }

    public ControllerDescriptor build(InputStream in) throws StaxNavException {
        return this.build((StaxNavigator<Element>)StaxNavigatorFactory.create((Naming)new Naming.Enumerated.Simple(Element.class, (Enum)Element.UNKNOWN), (InputStream)in));
    }

    public ControllerDescriptor build(Reader reader) throws StaxNavException {
        return this.build((StaxNavigator<Element>)StaxNavigatorFactory.create((Naming)new Naming.Enumerated.Simple(Element.class, (Enum)Element.UNKNOWN), (Reader)reader));
    }

    public ControllerDescriptor build(XMLStreamReader reader) throws StaxNavException {
        return this.build((StaxNavigator<Element>)StaxNavigatorFactory.create((Naming)new Naming.Enumerated.Simple(Element.class, (Enum)Element.UNKNOWN), (XMLStreamReader)reader));
    }

    public ControllerDescriptor build(StaxNavigator<Element> root) throws StaxNavException {
        ControllerDescriptor router = DescriptorBuilder.router();
        String s = root.getAttribute("separator-escape");
        if (s != null) {
            char c = s.charAt(0);
            router.setSeparatorEscape(c);
        }
        if (root.child() != null) {
            for (StaxNavigator routeNav : root.fork((Object)Element.ROUTE)) {
                RouteDescriptor route = this.buildRoute((StaxNavigator<Element>)routeNav);
                router.add(route);
            }
        }
        return router;
    }

    private RouteDescriptor buildRoute(StaxNavigator<Element> root) throws StaxNavException {
        String path = root.getAttribute("path");
        RouteDescriptor route = new RouteDescriptor(path);
        Element elt = (Element)((Object)root.child());
        while (elt != null) {
            StaxNavigator fork = root.fork();
            switch (elt) {
                case PATH_PARAM: {
                    String qualifiedName = fork.getAttribute("qname");
                    String encoded = fork.getAttribute("encoding");
                    boolean captureGroup = "true".equals(fork.getAttribute("capture-group"));
                    String pattern = null;
                    if (fork.child((Object)Element.PATTERN)) {
                        pattern = fork.getContent();
                    }
                    EncodingMode encodingMode = "preserve-path".equals(encoded) ? EncodingMode.PRESERVE_PATH : EncodingMode.FORM;
                    route.with(new PathParamDescriptor(qualifiedName).captureGroup(captureGroup).encodedBy(encodingMode).matchedBy(pattern));
                    break;
                }
                case ROUTE_PARAM: {
                    String qualifiedName = fork.getAttribute("qname");
                    String value = null;
                    if (fork.child((Object)Element.VALUE)) {
                        value = fork.getContent();
                    }
                    route.with(new RouteParamDescriptor(qualifiedName).withValue(value));
                    break;
                }
                case REQUEST_PARAM: {
                    String qualifiedName = fork.getAttribute("qname");
                    String name = fork.getAttribute("name");
                    String controlModeAtt = fork.getAttribute("control-mode");
                    String valueMappingAtt = fork.getAttribute("value-mapping");
                    RequestParamDescriptor param = new RequestParamDescriptor(qualifiedName);
                    param.setName(name);
                    param.setControlMode(DescriptorBuilder.parseControlMode(controlModeAtt));
                    param.setValueMapping(DescriptorBuilder.parseValueMapping(valueMappingAtt));
                    if (fork.child((Object)Element.VALUE)) {
                        param.setValue(fork.getContent());
                        param.setValueType(ValueType.LITERAL);
                    }
                    if (fork.child((Object)Element.PATTERN)) {
                        param.setValue(fork.getContent());
                        param.setValueType(ValueType.PATTERN);
                    }
                    route.with(param);
                    break;
                }
                case ROUTE: {
                    RouteDescriptor sub = this.buildRoute((StaxNavigator<Element>)fork);
                    route.sub(sub);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            elt = (Element)((Object)root.sibling());
        }
        return route;
    }

    static ControlMode parseControlMode(String s) {
        if (s == null || "optional".equals(s)) {
            return ControlMode.OPTIONAL;
        }
        if ("required".equals(s)) {
            return ControlMode.REQUIRED;
        }
        throw new UnsupportedOperationException("Handle me gracefully");
    }

    static ValueMapping parseValueMapping(String s) {
        if (s == null || "canonical".equals(s)) {
            return ValueMapping.CANONICAL;
        }
        if ("never-empty".equals(s)) {
            return ValueMapping.NEVER_EMPTY;
        }
        if ("never-null".equals(s)) {
            return ValueMapping.NEVER_NULL;
        }
        throw new UnsupportedOperationException("Handle me gracefully");
    }
}

