/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.html;

import com.google.caja.parser.html.ElKey;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessagePart;
import com.google.caja.util.Strings;
import java.io.IOException;
import org.w3c.dom.Attr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttribKey
implements MessagePart,
Comparable<AttribKey> {
    public final ElKey el;
    public final Namespaces ns;
    public final String localName;
    private static final Namespaces HTML_NS = Namespaces.HTML_DEFAULT.forUri("http://www.w3.org/1999/xhtml");

    private AttribKey(ElKey el, Namespaces ns, String localName) {
        if (el == null || ns == null || localName == null) {
            throw new NullPointerException();
        }
        this.el = el;
        this.ns = ns;
        this.localName = this.ns.uri == "http://www.w3.org/1999/xhtml" ? Strings.toLowerCase(localName) : localName;
    }

    public boolean is(Attr a) {
        return this.ns.uri.equals(a.getNamespaceURI()) && this.localName.equals(a.getLocalName()) && this.el.is(a.getOwnerElement());
    }

    public static AttribKey forHtmlAttrib(ElKey el, String localName) {
        return new AttribKey(el, HTML_NS, localName);
    }

    public static AttribKey forAttribute(Namespaces inScope, ElKey el, String qname) {
        String localName;
        Namespaces ns;
        int colon = qname.indexOf(58);
        if (colon < 0) {
            ns = el.ns;
            localName = qname;
        } else {
            ns = inScope.forAttrName(el.ns, qname);
            if (ns == null) {
                return null;
            }
            ns = inScope.forUri(ns.uri);
            localName = qname.substring(colon + 1);
        }
        return new AttribKey(el, ns, localName);
    }

    public static AttribKey forAttribute(ElKey el, Attr attr) {
        Namespaces ns;
        String uri = attr.getNamespaceURI();
        String localName = attr.getLocalName();
        Namespaces namespaces = ns = uri != null ? Namespaces.HTML_DEFAULT.forUri(uri) : el.ns;
        if (ns == null) {
            ns = new Namespaces(Namespaces.XML_SPECIAL, "", uri);
        }
        return new AttribKey(el, ns, localName);
    }

    public AttribKey onAnyElement() {
        return this.onElement(ElKey.wildcard(this.ns));
    }

    public AttribKey onElement(ElKey el) {
        if (el.equals(this.el)) {
            return this;
        }
        return new AttribKey(el, this.ns, this.localName);
    }

    @Override
    public void format(MessageContext mc, Appendable out) throws IOException {
        if (this.el.ns.uri == this.ns.uri) {
            out.append(this.localName);
        } else {
            AttribKey.appendQName(this.ns, this.localName, out);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof AttribKey)) {
            return false;
        }
        AttribKey that = (AttribKey)o;
        return this.ns.uri == that.ns.uri && this.el.equals(that.el) && this.localName.equals(that.localName);
    }

    public int hashCode() {
        return this.ns.uri.hashCode() + 31 * (this.localName.hashCode() + 31 * this.el.hashCode());
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        try {
            AttribKey.appendQName(this.el.ns, this.el.localName, out);
            out.append("::");
            AttribKey.appendQName(this.ns, this.localName, out);
        }
        catch (IOException ex) {
            throw new RuntimeException("Appending to StringBuilder", ex);
        }
        return out.toString();
    }

    private static void appendQName(Namespaces ns, String localName, Appendable out) throws IOException {
        if (!"".equals(ns.prefix)) {
            out.append(ns.prefix).append(":");
        }
        out.append(localName);
    }

    @Override
    public int compareTo(AttribKey that) {
        int delta = this.el.compareTo(that.el);
        if (delta == 0 && (delta = this.ns.uri.compareTo(that.ns.uri)) == 0) {
            delta = this.localName.compareTo(that.localName);
        }
        return delta;
    }
}

