/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.shindig.gadgets.http.HttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FetchResponseUtils {
    private FetchResponseUtils() {
    }

    public static Map<String, Object> getResponseAsJson(HttpResponse response, String id, String body, boolean getFullHeaders) {
        HashMap resp = Maps.newHashMap();
        if (id != null) {
            resp.put("id", id);
        }
        resp.put("rc", response.getHttpStatusCode());
        resp.put("body", body);
        HashMap headers = Maps.newHashMap();
        if (getFullHeaders) {
            FetchResponseUtils.addAllHeaders(headers, response);
        } else {
            FetchResponseUtils.addHeaders(headers, response, "set-cookie");
            FetchResponseUtils.addHeaders(headers, response, "location");
        }
        if (!headers.isEmpty()) {
            resp.put("headers", headers);
        }
        for (Map.Entry<String, String> entry : response.getMetadata().entrySet()) {
            resp.put(entry.getKey(), entry.getValue());
        }
        return resp;
    }

    private static void addAllHeaders(Map<String, Collection<String>> headers, HttpResponse response) {
        Multimap<String, String> responseHeaders = response.getHeaders();
        for (String name : responseHeaders.keySet()) {
            headers.put(name.toLowerCase(), responseHeaders.get((Object)name));
        }
    }

    private static void addHeaders(Map<String, Collection<String>> headers, HttpResponse response, String name) {
        Collection<String> values = response.getHeaders(name);
        if (!values.isEmpty()) {
            headers.put(name.toLowerCase(), values);
        }
    }
}

