/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization;

import java.io.Serializable;
import java.util.HashMap;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.ExtendedCloneable;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;

public class CacheHandler {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.organization.api.CacheHandler");
    public static final String MEMBERSHIPTYPE_PREFIX = "mt=";
    public static final String GROUP_PREFIX = "g=";
    public static final String USER_PREFIX = "u=";
    protected final ExoCache<Serializable, User> userCache;
    protected final ExoCache<Serializable, UserProfile> userProfileCache;
    protected final ExoCache<Serializable, MembershipType> membershipTypeCache;
    protected final ExoCache<Serializable, Membership> membershipCache;
    protected final ExoCache<Serializable, Group> groupCache;

    public CacheHandler(CacheService cservice) {
        this.userCache = cservice.getCacheInstance(this.getClass().getName() + "userCache");
        this.userProfileCache = cservice.getCacheInstance(this.getClass().getName() + "userProfileCache");
        this.membershipTypeCache = cservice.getCacheInstance(this.getClass().getName() + "membershipTypeCache");
        this.groupCache = cservice.getCacheInstance(this.getClass().getName() + "groupCache");
        this.membershipCache = cservice.getCacheInstance(this.getClass().getName() + "membershipCache");
    }

    public void put(Serializable key, Object value, CacheType cacheType) {
        key = this.createCacheKey(key);
        if (cacheType == CacheType.USER) {
            this.userCache.put(key, (Object)((User)value));
        } else if (cacheType == CacheType.GROUP) {
            this.groupCache.put(key, (Object)((Group)value));
        } else if (cacheType == CacheType.MEMBERSHIP) {
            this.membershipCache.put(key, (Object)((Membership)value));
        } else if (cacheType == CacheType.MEMBERSHIPTYPE) {
            this.membershipTypeCache.put(key, (Object)((MembershipType)value));
        } else if (cacheType == CacheType.USER_PROFILE) {
            this.userProfileCache.put(key, (Object)((UserProfile)value));
        }
    }

    public Object get(Serializable key, CacheType cacheType) {
        Object obj = null;
        key = this.createCacheKey(key);
        if (cacheType == CacheType.USER) {
            obj = this.userCache.get(key);
        } else if (cacheType == CacheType.GROUP) {
            obj = this.groupCache.get(key);
        } else if (cacheType == CacheType.MEMBERSHIP) {
            obj = this.membershipCache.get(key);
        } else if (cacheType == CacheType.MEMBERSHIPTYPE) {
            obj = this.membershipTypeCache.get(key);
        } else if (cacheType == CacheType.USER_PROFILE) {
            obj = this.userProfileCache.get(key);
        }
        if (obj instanceof ExtendedCloneable) {
            return ((ExtendedCloneable)obj).clone();
        }
        return obj;
    }

    public void remove(Serializable key, CacheType cacheType) {
        if (cacheType == CacheType.MEMBERSHIP) {
            try {
                this.membershipCache.select((CachedObjectSelector)new CachedObjectSelector<Serializable, Membership>(){

                    public boolean select(Serializable cacheKey, ObjectCacheInfo<? extends Membership> ocinfo) {
                        return CacheHandler.this.matchKey(cacheKey);
                    }

                    public void onSelect(ExoCache<? extends Serializable, ? extends Membership> cache, Serializable cacheKey, ObjectCacheInfo<? extends Membership> ocinfo) throws Exception {
                        String key;
                        String mkey = CacheHandler.this.getMembershipKey((Membership)ocinfo.get());
                        if (mkey.indexOf(key = (String)((Object)CacheHandler.this.createOrgServiceKey(cacheKey))) >= 0) {
                            cache.remove(cacheKey);
                        }
                    }
                });
            }
            catch (Exception e) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                }
            }
        } else {
            key = this.createCacheKey(key);
            if (cacheType == CacheType.USER) {
                this.userCache.remove(key);
            } else if (cacheType == CacheType.GROUP) {
                this.groupCache.remove(key);
            } else if (cacheType == CacheType.MEMBERSHIPTYPE) {
                this.membershipTypeCache.remove(key);
            } else if (cacheType == CacheType.USER_PROFILE) {
                this.userProfileCache.remove(key);
            }
        }
    }

    public void move(Serializable oldKey, Serializable newKey, CacheType cacheType) {
        if (cacheType == CacheType.MEMBERSHIP) {
            try {
                final HashMap wait4Adding = new HashMap();
                final Serializable finalNewKey = newKey;
                this.membershipCache.select((CachedObjectSelector)new CachedObjectSelector<Serializable, Membership>(){

                    public boolean select(Serializable cacheKey, ObjectCacheInfo<? extends Membership> ocinfo) {
                        return CacheHandler.this.matchKey(cacheKey);
                    }

                    public void onSelect(ExoCache<? extends Serializable, ? extends Membership> cache, Serializable cacheKey, ObjectCacheInfo<? extends Membership> ocinfo) throws Exception {
                        String key;
                        String mkey = CacheHandler.this.getMembershipKey((Membership)ocinfo.get());
                        if (mkey.indexOf(key = (String)((Object)CacheHandler.this.createOrgServiceKey(cacheKey))) >= 0) {
                            wait4Adding.put(CacheHandler.this.createCacheKey((Serializable)((Object)mkey.replace(key, (String)((Object)finalNewKey)))), cache.remove(CacheHandler.this.createCacheKey((Serializable)((Object)mkey))));
                        }
                    }
                });
                this.membershipCache.putMap(wait4Adding);
            }
            catch (Exception e) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                }
            }
        } else {
            oldKey = this.createCacheKey(oldKey);
            newKey = this.createCacheKey(newKey);
            if (cacheType == CacheType.USER) {
                this.userCache.put(newKey, this.userCache.remove(oldKey));
            } else if (cacheType == CacheType.GROUP) {
                this.groupCache.put(newKey, this.groupCache.remove(oldKey));
            } else if (cacheType == CacheType.MEMBERSHIPTYPE) {
                this.membershipTypeCache.put(newKey, this.membershipTypeCache.remove(oldKey));
            } else if (cacheType == CacheType.USER_PROFILE) {
                this.userProfileCache.put(newKey, this.userProfileCache.remove(oldKey));
            }
        }
    }

    public String getMembershipKey(Membership m) {
        StringBuilder key = new StringBuilder();
        key.append(GROUP_PREFIX + m.getGroupId());
        key.append(MEMBERSHIPTYPE_PREFIX + m.getMembershipType());
        key.append(USER_PREFIX + m.getUserName());
        return key.toString();
    }

    public String getMembershipKey(String username, String groupId, String type) {
        StringBuilder key = new StringBuilder();
        key.append(GROUP_PREFIX + groupId);
        key.append(MEMBERSHIPTYPE_PREFIX + type);
        key.append(USER_PREFIX + username);
        return key.toString();
    }

    protected Serializable createCacheKey(Serializable orgServiceKey) {
        return orgServiceKey;
    }

    protected boolean matchKey(Serializable cacheKey) {
        return true;
    }

    protected Serializable createOrgServiceKey(Serializable cacheKey) {
        return cacheKey;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CacheType {
        USER,
        GROUP,
        MEMBERSHIP,
        MEMBERSHIPTYPE,
        USER_PROFILE;

    }
}

