/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.hierarchy.impl;

import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionManager;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionMode;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionType;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.ext.hierarchy.impl.HierarchyConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewGroupListener
extends GroupEventListener {
    private static final Log LOG = ExoLogger.getLogger("exo.jcr.component.ext.NewGroupListener");
    private static final String GROUPS_PATH = "groupsPath";
    private final HierarchyConfig config_;
    private final RepositoryService jcrService_;
    private final DataDistributionType dataDistributionType_;
    private final String groupsPath_;

    public NewGroupListener(RepositoryService jcrService, NodeHierarchyCreator nodeHierarchyCreatorService, DataDistributionManager dataDistributionManager, InitParams params) throws Exception {
        this.jcrService_ = jcrService;
        this.config_ = (HierarchyConfig)params.getObjectParamValues(HierarchyConfig.class).get(0);
        this.dataDistributionType_ = dataDistributionManager.getDataDistributionType(DataDistributionMode.NONE);
        this.groupsPath_ = nodeHierarchyCreatorService.getJcrPath(GROUPS_PATH);
    }

    public void preSave(Group group, boolean isNew) throws Exception {
        String parentId;
        String groupId = null;
        groupId = group.getId() != null ? group.getId() : ((parentId = group.getParentId()) == null || parentId.length() == 0 ? "/" + group.getGroupName() : parentId + "/" + group.getGroupName());
        if (isNew) {
            this.buildGroupStructure(this.jcrService_.getCurrentRepository(), groupId);
        }
    }

    public void preDelete(Group group) throws Exception {
        String parentId;
        String groupId = null;
        groupId = group.getId() != null ? group.getId() : ((parentId = group.getParentId()) == null || parentId.length() == 0 ? "/" + group.getGroupName() : parentId + "/" + group.getGroupName());
        this.removeGroup(this.jcrService_.getCurrentRepository(), groupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeGroup(ManageableRepository manageableRepository, String groupId) throws Exception {
        Session session = null;
        try {
            String systemWorkspace = manageableRepository.getConfiguration().getDefaultWorkspaceName();
            session = manageableRepository.getSystemSession(systemWorkspace);
            Node groupsHome = (Node)session.getItem(this.groupsPath_);
            this.dataDistributionType_.removeDataNode(groupsHome, groupId);
        }
        catch (RepositoryException e) {
            LOG.error((Object)("An error occurs while removing the group directory of '" + groupId + "'"), e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildGroupStructure(ManageableRepository manageableRepository, String groupId) throws Exception {
        Session session = null;
        try {
            String systemWorkspace = manageableRepository.getConfiguration().getDefaultWorkspaceName();
            session = manageableRepository.getSystemSession(systemWorkspace);
            Node groupsHome = (Node)session.getItem(this.groupsPath_);
            Node groupNode = this.dataDistributionType_.getOrCreateDataNode(groupsHome, groupId);
            List<HierarchyConfig.JcrPath> jcrPaths = this.config_.getJcrPaths();
            for (HierarchyConfig.JcrPath jcrPath : jcrPaths) {
                this.createNode(groupNode, jcrPath.getPath(), jcrPath.getNodeType(), jcrPath.getMixinTypes(), jcrPath.getPermissions("*:".concat(groupId)));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("An error occurs while initializing the group directory of '" + groupId + "'"), e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private void createNode(Node groupNode, String path, String nodeType, List<String> mixinTypes, Map<String, String[]> permissions) throws Exception {
        this.dataDistributionType_.getOrCreateDataNode(groupNode, path, nodeType, mixinTypes, permissions);
    }
}

