/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.css;

import com.google.caja.lexer.ParseException;
import com.google.caja.parser.css.CssTree;
import com.google.caja.render.Concatenator;
import com.google.caja.render.CssPrettyPrinter;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.TestUtil;

public class CssTreeTest
extends CajaTestCase {
    public final void testRender1() throws Exception {
        this.runRenderTest("cssrendergolden1.txt", "cssparserinput1.css", false);
    }

    public final void testRender2() throws Exception {
        this.runRenderTest("cssrendergolden2.txt", "cssparserinput2.css", false);
    }

    public final void testRender4() throws Exception {
        this.runRenderTest("cssrendergolden4.txt", "cssparserinput4.css", true);
    }

    public final void testRenderFilters() throws Exception {
        this.runRenderTest("cssrendergolden-filters.css", "cssparserinput-filters.css", false);
    }

    public final void testRenderUserAgentHacks() throws Exception {
        this.runRenderTest("cssrendergolden-uahacks.css", "cssparserinput-uahacks.css", false);
        this.runRenderTest("cssrendergolden-uahacks.css", "cssparserinput-uahacks.css", true);
    }

    public final void testClone1() throws Exception {
        CssTree.StyleSheet t = this.css(this.fromResource("cssparserinput1.css"));
        CssTreeTest.assertEquals((String)CssTreeTest.render(t), (String)CssTreeTest.render(t.clone()));
    }

    public final void testClone2() throws Exception {
        CssTree.StyleSheet t = this.css(this.fromString("span { background-image:url('//www.example.org/image.gif'); }"));
        CssTreeTest.assertEquals((String)CssTreeTest.render(t), (String)CssTreeTest.render(t.clone()));
    }

    public final void testStringRendering() throws Exception {
        this.assertRenderedForm("a {\n  background: ''\n}", "a { background: '' }");
        this.assertRenderedForm("a {\n  background: 'foo\\5C bar\\27 Baz\\22zoicks\\A '\n}", "a { background: 'foo\\\\bar\\'Baz\\\"zoicks\\0A ' }");
        this.assertRenderedForm("a {\n  background: '\\3C/script\\3E\\3C b\\3E '\n}", "a { background: \"</script><b>\" }");
        this.assertRenderedForm("a {\n  background: '\\5D\\5D\\3E '\n}", "a { background: ']]>' }");
        this.assertRenderedForm("a {\n  background: '\\5D\\5D\\3E '\n}", "a { background: ']]\\3E ' }");
    }

    public final void testUrlRendering() throws Exception {
        this.assertRenderedForm("a {\n  background: url('')\n}", "a { background: url('') }");
        this.assertRenderedForm("a {\n  background: url('foo')\n}", "a { background: url(foo) }");
        this.assertRenderedForm("a {\n  background: url('foo')\n}", "a { background: url('foo') }");
        this.assertRenderedForm("a {\n  background: url('url%28%27hi%27%29')\n}", "a { background: url(\"url('hi')\") }");
    }

    public final void testParanoidUrlRendering() throws Exception {
        try {
            this.assertRenderedForm("a {\n  background: url('\\3C/script')\n}", "a { background: url('</script') }");
        }
        catch (ParseException ex) {
            // empty catch block
        }
        try {
            this.assertRenderedForm("a {\n  background: url('\\3C/script')\n}", "a { background: url(</script) }");
        }
        catch (ParseException ex) {
            // empty catch block
        }
        try {
            this.assertRenderedForm("a {\n  background: url('\\5D\\5D\\3E ')\n}", "a { background: url(]]>) }");
        }
        catch (ParseException ex) {
            // empty catch block
        }
        try {
            this.assertRenderedForm("a {\n  background: url('\\5D\\5D\\3E ')\n}", "a { background: url(']]>') }");
        }
        catch (ParseException ex) {
            // empty catch block
        }
        try {
            this.assertRenderedForm("a {\n  background: url('\\3C\\21DOCTYPE')\n}", "a { background: url(/<!DOCTYPE) }");
        }
        catch (ParseException ex) {
            // empty catch block
        }
        try {
            this.assertRenderedForm("a {\n  background: url('\\3C\\21DOCTYPE')\n}", "a { background: url('/<!DOCTYPE') }");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public final void testIdentifierEscaping() throws Exception {
        this.assertRenderedForm("Le caja .no es #un rect\\E1ngulo {\n}", "Le caja .no es #un rect\u00e1ngulo {}");
        this.assertRenderedForm("\\34is a number and an identifier {\n}", "\\34is a number and an identifier {}");
        this.assertRenderedForm("\\34 0 is a number and an identifier too {\n}", "\\34 0 is a number and an identifier too {}");
    }

    public final void testPrio() throws Exception {
        this.assertRenderedForm("sky {\n  color: #0000ff !important\n}", "sky { color: #0000ff !important }");
    }

    public final void testOperators() throws Exception {
        this.assertRenderedForm("hi {\n  x: f(-3);\n  y: +g(2)\n}", "hi { x: f(-3); y: +g( 2 ) }");
    }

    public final void testCombinatorRules() throws Exception {
        this.assertRenderedForm("hello > world {\n  color: blue\n}", "hello>world { color: blue }");
        this.assertRenderedForm("hello + world {\n  color: blue\n}", "hello+world { color: blue }");
    }

    private void runRenderTest(String goldenFile, String inputFile, boolean paranoid) throws Exception {
        String golden = TestUtil.readResource(((Object)((Object)this)).getClass(), goldenFile);
        CssTree.StyleSheet stylesheet = this.css(this.fromResource(inputFile));
        StringBuilder sb = new StringBuilder();
        CssPrettyPrinter csspp = new CssPrettyPrinter(new Concatenator(sb));
        RenderContext rc = new RenderContext(csspp).withAsciiOnly(true).withEmbeddable(paranoid);
        stylesheet.render(rc);
        CssTreeTest.assertEquals((String)golden.trim(), (String)sb.toString().trim());
    }

    private void assertRenderedForm(String golden, String cssInput) throws Exception {
        CssTree.StyleSheet stylesheet = this.css(this.fromString(cssInput));
        StringBuilder sb = new StringBuilder();
        CssPrettyPrinter csspp = new CssPrettyPrinter(new Concatenator(sb));
        RenderContext rc = new RenderContext(csspp).withAsciiOnly(true);
        stylesheet.render(rc);
        csspp.noMoreTokens();
        String actual = sb.toString();
        CssTreeTest.assertEquals((String)actual, (String)golden, (String)actual);
    }
}

