/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.bench;

import java.io.ByteArrayInputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.NodeIterator;
import org.apache.commons.collections.ListUtils;
import org.exoplatform.forum.bench.ForumDataRandom;
import org.exoplatform.forum.service.BufferAttachment;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumAttachment;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.MessageBuilder;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.ks.common.jcr.KSDataLocation;
import org.exoplatform.services.bench.DataInjector;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForumDataInjector
extends DataInjector {
    private static Log log = ExoLogger.getLogger(ForumDataInjector.class);
    private static final String ARRAY_SPLIT = ",";
    private static final String UNDER_SCORE = "_";
    private static final String SIXTEEN_CHARACTERS = "asdfghjklzxcvbnm";
    private ForumService forumService;
    private KSDataLocation dataLocation;

    public ForumDataInjector(ForumService forumService, KSDataLocation dataLocation) {
        this.forumService = forumService;
        this.dataLocation = dataLocation;
    }

    public Log getLog() {
        return log;
    }

    public void inject(HashMap<String, String> queryParams) throws Exception {
        String type = queryParams.get("type");
        if ("data".equals(type)) {
            log.info((Object)"Injecting data ...");
            this.injectData(queryParams);
        } else if ("perm".equals(type)) {
            log.info((Object)"Injecting permissions ...");
            this.injectPermission(queryParams);
        } else {
            log.info((Object)String.format("Do not support type %s for injector...", type));
        }
    }

    public void injectData(HashMap<String, String> queryParams) throws Exception {
        long categoriesCount = 0L;
        long forumsCount = 0L;
        long topicsCount = 0L;
        long postCount = 0L;
        long categoriesWeight = 0L;
        List<Integer> itemsQu = this.readQuantities(queryParams);
        List<String> itemsPre = this.readPrefixes(queryParams);
        if (itemsPre.size() == 0 || itemsQu.size() == 0) {
            throw new RuntimeException("The size of parametes is zero");
        }
        List<Category> categories = this.generatesCategories(itemsPre.get(0), itemsQu.get(0));
        for (Category category : categories) {
            if (this.forumService.getCategory(category.getId()) == null) {
                this.forumService.saveCategory(category, true);
                ++categoriesCount;
            }
            String categoryId = category.getId();
            long forumsWeight = 0L;
            int forumNum = 0;
            if (itemsQu.size() <= 1) continue;
            List<Forum> forums = this.generateForums(itemsPre.get(1), itemsQu.get(1));
            log.info((Object)("Category " + categoriesCount + "/" + categories.size() + " with " + forums.size() + " forums"));
            for (Forum forum : forums) {
                if (this.forumService.getForum(categoryId, forum.getId()) == null) {
                    this.forumService.saveForum(categoryId, forum, true);
                    ++forumsCount;
                }
                String forumId = forum.getId();
                long topicsWeight = 0L;
                int topicNum = 0;
                if (itemsQu.size() <= 2) continue;
                List<Topic> topics = this.generateTopics(itemsPre.get(2), itemsQu.get(2));
                log.info((Object)("\tForum " + ++forumNum + "/" + forums.size() + " with " + topics.size() + " topics"));
                for (Topic topic : topics) {
                    if (this.forumService.getTopic(categoryId, forumId, topic.getId(), "root") == null) {
                        this.forumService.saveTopic(categoryId, forumId, topic, true, false, new MessageBuilder());
                        ++topicsCount;
                    }
                    String topicId = topic.getId();
                    long postsWeight = 0L;
                    long t1 = System.currentTimeMillis();
                    if (itemsQu.size() <= 3) continue;
                    List<Post> posts = this.generatePosts(itemsPre.get(3), itemsQu.get(3));
                    for (Post post : posts) {
                        if (this.forumService.getPost(categoryId, forumId, topicId, post.getId()) == null) {
                            this.forumService.savePost(categoryId, forumId, topicId, post, true, new MessageBuilder());
                            long messageWeight = post.getMessage().length() * 2;
                            ++postCount;
                            postsWeight += messageWeight;
                        }
                        if (itemsQu.size() <= 4) continue;
                        int attSize = Integer.parseInt(queryParams.get("attSize"));
                        List<ForumAttachment> atts = this.generateAttachments(itemsPre.get(4), itemsQu.get(4), attSize);
                        post.setAttachments(atts);
                        this.forumService.savePost(categoryId, forumId, topicId, post, false, new MessageBuilder());
                    }
                    double elapsed = System.currentTimeMillis() - t1;
                    double rate = (double)(postsWeight / 1024L) / (elapsed / 1000.0);
                    String srate = MessageFormat.format("({0,number,#.#} KB/s)", rate);
                    log.info((Object)("\t\tTopic " + ++topicNum + "/" + topics.size() + "\t" + posts.size() + " posts in " + elapsed + "ms " + srate));
                    topicsWeight += postsWeight;
                }
                log.info((Object)("\t\t " + topics.size() + " topics " + MessageFormat.format("({0,number,#.#} KB)", topicsWeight / 1024L) + " total posts=" + postCount));
                forumsWeight += topicsWeight;
            }
            log.info((Object)("\t" + forums.size() + " forums " + MessageFormat.format("({0,number,#.#} K)", forumsWeight / 1024L) + " total posts=" + postCount));
            categoriesWeight += forumsWeight;
        }
        log.info((Object)("INITIALIZED : categories=" + categories.size() + " / forums=" + forumsCount + " / topics=" + topicsCount + " / posts=" + postCount + MessageFormat.format(" ({0,number,#.#} KB)", categoriesWeight / 1024L)));
    }

    public void injectPermission(HashMap<String, String> queryParams) throws Exception {
        List<String> prefixes = this.readPrefixes(queryParams);
        if (prefixes.size() == 3) {
            boolean isCanView = false;
            boolean isCanPost = false;
            String permString = queryParams.get("perm");
            List member = this.readUsersIfExist(queryParams);
            List groups = this.readGroupsIfExist(queryParams);
            List memberships = this.readMembershipIfExist(queryParams);
            List mergeMembers = ListUtils.union((List)ListUtils.union((List)member, (List)groups), (List)memberships);
            String[] memberArray = new String[mergeMembers.size()];
            for (int i = 0; i < mergeMembers.size(); ++i) {
                memberArray[i] = (String)mergeMembers.get(i);
            }
            List<String> itemIds = this.search(prefixes.get(2), ENTITY.TOPIC);
            if (Integer.parseInt(permString.substring(0, 1)) > 0) {
                isCanView = true;
            }
            if (Integer.parseInt(permString.substring(1, 2)) > 0) {
                isCanPost = true;
            }
            for (int i = 0; i < itemIds.size(); ++i) {
                String[] ids = itemIds.get(i).split("/");
                int l = ids.length;
                Topic topic = this.forumService.getTopic(ids[l - 3], ids[l - 2], ids[l - 1], "root");
                if (isCanView) {
                    topic.setCanView(memberArray);
                }
                if (isCanPost) {
                    topic.setCanPost(memberArray);
                }
                this.forumService.saveTopic(ids[l - 3], ids[l - 2], topic, false, false, new MessageBuilder());
            }
        } else {
            throw new IllegalArgumentException("Prefix item is not a topic prefix. It should be [category_prefix],[forum_prefix],[topic_prefix]");
        }
    }

    public void reject(HashMap<String, String> queryParams) throws Exception {
        List<String> prefixes = this.readPrefixes(queryParams);
        List<Object> itemIds = new ArrayList();
        switch (prefixes.size()) {
            case 5: {
                itemIds = this.search(prefixes.get(prefixes.size() - 1), ENTITY.ATTACHMENT);
                for (int i = 0; i < itemIds.size(); ++i) {
                    String[] ids = ((String)itemIds.get(i)).split("/");
                    int l = ids.length;
                    Post post = this.forumService.getPost(ids[l - 6], ids[l - 5], ids[l - 4], ids[l - 3]);
                    List atts = post.getAttachments();
                    ArrayList<ForumAttachment> toRemoveAtts = new ArrayList<ForumAttachment>();
                    for (ForumAttachment att : atts) {
                        if (!att.getId().equals(ids[l - 2])) continue;
                        toRemoveAtts.add(att);
                    }
                    atts = ListUtils.subtract(atts, toRemoveAtts);
                    post.setAttachments(atts);
                    this.forumService.savePost(ids[l - 6], ids[l - 5], ids[l - 4], post, false, new MessageBuilder());
                }
                break;
            }
            case 4: {
                itemIds = this.search(prefixes.get(prefixes.size() - 1), ENTITY.POST);
                for (int i = 0; i < itemIds.size(); ++i) {
                    String[] ids = ((String)itemIds.get(i)).split("/");
                    int l = ids.length;
                    this.forumService.removePost(ids[l - 4], ids[l - 3], ids[l - 2], ids[l - 1]);
                }
                break;
            }
            case 3: {
                itemIds = this.search(prefixes.get(prefixes.size() - 1), ENTITY.TOPIC);
                for (int i = 0; i < itemIds.size(); ++i) {
                    String[] ids = ((String)itemIds.get(i)).split("/");
                    int l = ids.length;
                    this.forumService.removeTopic(ids[l - 3], ids[l - 2], ids[l - 1]);
                }
                break;
            }
            case 2: {
                itemIds = this.search(prefixes.get(prefixes.size() - 1), ENTITY.FORUM);
                for (int i = 0; i < itemIds.size(); ++i) {
                    String[] ids = ((String)itemIds.get(i)).split("/");
                    int l = ids.length;
                    this.forumService.removeForum(ids[l - 2], ids[l - 1]);
                }
                break;
            }
            case 1: {
                itemIds = this.search(prefixes.get(prefixes.size() - 1), ENTITY.CATEGORY);
                for (int i = 0; i < itemIds.size(); ++i) {
                    String[] ids = ((String)itemIds.get(i)).split("/");
                    int l = ids.length;
                    this.forumService.removeCategory(ids[l - 1]);
                }
                break;
            }
        }
    }

    private List<Integer> readQuantities(HashMap<String, String> queryParams) {
        String quantitiesString = queryParams.get("q");
        LinkedList<Integer> quantities = new LinkedList<Integer>();
        for (String s : quantitiesString.split(ARRAY_SPLIT)) {
            if (s.length() <= 0) continue;
            int quantity = Integer.parseInt(s.trim());
            quantities.add(quantity);
        }
        return quantities;
    }

    private List<String> readPrefixes(HashMap<String, String> queryParams) {
        String prefixesString = queryParams.get("pre");
        LinkedList<String> prefixes = new LinkedList<String>();
        for (String s : prefixesString.split(ARRAY_SPLIT)) {
            if (s.length() <= 0) continue;
            prefixes.add(s);
        }
        return prefixes;
    }

    private List<Category> generatesCategories(String prefix, int cateQu) {
        ArrayList<Category> result = new ArrayList<Category>();
        try {
            for (int i = 0; i < cateQu; ++i) {
                Category category = new Category();
                String id = this.generateId(prefix, Utils.CATEGORY, i);
                category.setId(id);
                category.setCategoryName(id);
                category.setCategoryOrder(i);
                category.setCreatedDate(new Date());
                category.setDescription(this.randomWords(10));
                category.setModifiedBy(this.randomUser());
                category.setModifiedDate(new Date());
                category.setOwner(this.randomUser());
                result.add(category);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private List<Forum> generateForums(String prefix, int forumQu) {
        ArrayList<Forum> result = new ArrayList<Forum>();
        try {
            for (int i = 0; i < forumQu; ++i) {
                Forum forum = new Forum();
                String id = this.generateId(prefix, Utils.FORUM, i);
                forum.setId(id);
                forum.setForumName(id);
                forum.setCreatedDate(new Date());
                forum.setDescription(this.randomWords(10));
                forum.setForumOrder(i);
                forum.setOwner(this.randomUser());
                result.add(forum);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<Topic> generateTopics(String prefix, int topicQu) {
        ArrayList<Topic> result = new ArrayList<Topic>();
        try {
            for (int i = 0; i < topicQu; ++i) {
                Topic topic = new Topic();
                String id = this.generateId(prefix, Utils.TOPIC, i);
                topic.setId(id);
                topic.setTopicName(id);
                topic.setCreatedDate(new Date());
                topic.setDescription(this.randomWords(10));
                topic.setOwner("root");
                String[] users = new String[]{"root"};
                topic.setCanPost(users);
                topic.setCanView(users);
                topic.setIcon(ForumDataRandom.getClassIcon());
                result.add(topic);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<Post> generatePosts(String prefix, int postQu) {
        ArrayList<Post> result = new ArrayList<Post>();
        for (int i = 0; i < postQu; ++i) {
            Post post = new Post();
            String id = this.generateId(prefix, Utils.POST, i);
            post.setId(id);
            post.setName(id);
            String content = this.randomParagraphs(5);
            post.setMessage(content);
            post.setOwner(this.randomUser());
            post.setIcon(ForumDataRandom.getClassIcon());
            result.add(post);
        }
        return result;
    }

    private String generateId(String prefix, String entity, int order) {
        StringBuilder sb = new StringBuilder();
        sb.append(entity).append(UNDER_SCORE).append(prefix).append(UNDER_SCORE).append(SIXTEEN_CHARACTERS).append(UNDER_SCORE).append(order);
        return sb.toString();
    }

    private List<String> search(String prefix, ENTITY entity) {
        StringBuffer sb = new StringBuffer();
        String nodeType = "nt:base";
        ArrayList<String> result = new ArrayList<String>();
        switch (entity) {
            case CATEGORY: {
                nodeType = "exo:forumCategory";
                break;
            }
            case FORUM: {
                nodeType = "exo:forum";
                break;
            }
            case TOPIC: {
                nodeType = "exo:topic";
                break;
            }
            case POST: {
                nodeType = "exo:post";
                break;
            }
            case ATTACHMENT: {
                nodeType = "exo:forumResource";
                break;
            }
        }
        prefix = "%" + UNDER_SCORE + prefix + UNDER_SCORE + "%";
        sb.append(this.dataLocation.getForumCategoriesLocation()).append("//element(*,").append(nodeType).append(")[jcr:like(exo:name,'").append(prefix).append("') or jcr:like(exo:fileName,'").append(prefix).append("')]");
        try {
            NodeIterator iter = this.forumService.search(sb.toString());
            while (iter.hasNext()) {
                result.add(iter.nextNode().getPath().toString());
            }
        }
        catch (Exception e) {
            log.debug((Object)"Failure when search for prefix", (Throwable)e);
        }
        return result;
    }

    private List<ForumAttachment> generateAttachments(String prefix, int quantity, int capacity) throws Exception {
        ArrayList<ForumAttachment> listAttachments = new ArrayList<ForumAttachment>();
        String rs = this.createTextResource(capacity);
        for (int i = 0; i < quantity; ++i) {
            String attId = this.generateId(prefix, "attachment", i);
            BufferAttachment att = new BufferAttachment();
            att.setId(attId);
            att.setName(attId);
            att.setInputStream(new ByteArrayInputStream(rs.getBytes("UTF-8")));
            att.setMimeType("text/plain");
            long fileSize = (long)capacity * 1024L;
            att.setSize(fileSize);
            listAttachments.add(att);
        }
        return listAttachments;
    }

    public Object execute(HashMap<String, String> params) throws Exception {
        return new Object();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ENTITY {
        CATEGORY,
        FORUM,
        TOPIC,
        POST,
        ATTACHMENT;

    }
}

