/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.config;

import com.google.caja.config.ConfigUtil;
import com.google.caja.config.ImportResolver;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.util.Charsets;
import com.google.caja.util.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AllowedFileResolver
implements ImportResolver {
    private final Set<File> allowedFiles;

    public AllowedFileResolver(Set<File> allowedFiles) {
        this.allowedFiles = allowedFiles;
    }

    @Override
    public Pair<Reader, FilePosition> resolve(URI uri, URI base, FilePosition refPos) throws IOException {
        File f;
        if (base != null && "file".equals(base.getScheme()) && uri.getScheme() == null && uri.getAuthority() == null && uri.getQuery() == null && uri.getPath() != null) {
            uri = base.resolve(uri);
        }
        if ("file".equals(uri.getScheme()) && this.allowedFiles.contains(f = new File(uri))) {
            return Pair.pair(new InputStreamReader((InputStream)new FileInputStream(f), Charsets.UTF_8.name()), FilePosition.startOfFile(new InputSource(uri)));
        }
        return ConfigUtil.RESOURCE_RESOLVER.resolve(uri, base, refPos);
    }
}

