/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.io.Serializable;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.idm.Tools;
import org.exoplatform.services.organization.idm.UserDAOImpl;
import org.exoplatform.services.organization.impl.UserImpl;
import org.gatein.common.logging.LogLevel;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.picketlink.idm.api.SortOrder;
import org.picketlink.idm.api.query.UserQuery;
import org.picketlink.idm.api.query.UserQueryBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDMUserListAccess
implements ListAccess<User>,
Serializable {
    private static Logger log = LoggerFactory.getLogger(IDMUserListAccess.class);
    private final UserDAOImpl userDAO;
    private final PicketLinkIDMService idmService;
    private final UserQueryBuilder userQueryBuilder;
    private final int pageSize;
    private final boolean countAll;
    private List<org.picketlink.idm.api.User> fullResults;
    private int size = -1;

    public IDMUserListAccess(UserDAOImpl userDAO, PicketLinkIDMService idmService, UserQueryBuilder userQueryBuilder, int pageSize, boolean countAll) {
        this.userDAO = userDAO;
        this.idmService = idmService;
        this.userQueryBuilder = userQueryBuilder;
        this.pageSize = pageSize;
        this.countAll = countAll;
    }

    public User[] load(int index, int length) throws Exception, IllegalArgumentException {
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "load", new Object[]{"index", index, "length", length});
        }
        List users = null;
        if (this.fullResults == null) {
            this.userDAO.getOrgService().flush();
            this.userQueryBuilder.page(index, length);
            UserQuery query = this.userQueryBuilder.sort(SortOrder.ASCENDING).createQuery();
            users = this.idmService.getIdentitySession().list(query);
        } else {
            users = this.fullResults.subList(index, index + length);
        }
        User[] exoUsers = new User[users.size()];
        for (int i = 0; i < users.size(); ++i) {
            org.picketlink.idm.api.User user = users.get(i);
            UserImpl gtnUser = new UserImpl(user.getId());
            this.userDAO.populateUser((User)gtnUser, this.idmService.getIdentitySession());
            exoUsers[i] = gtnUser;
        }
        if (log.isTraceEnabled()) {
            Tools.logMethodOut(log, LogLevel.TRACE, "load", exoUsers);
        }
        return exoUsers;
    }

    public int getSize() throws Exception {
        int result;
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "getSize", null);
        }
        this.userDAO.getOrgService().flush();
        if (this.size < 0) {
            if (this.fullResults != null) {
                result = this.fullResults.size();
            } else if (this.countAll) {
                result = this.idmService.getIdentitySession().getPersistenceManager().getUserCount();
            } else {
                this.userQueryBuilder.page(0, 0);
                UserQuery query = this.userQueryBuilder.sort(SortOrder.ASCENDING).createQuery();
                this.fullResults = this.idmService.getIdentitySession().list(query);
                result = this.fullResults.size();
            }
            this.size = result;
        } else {
            result = this.size;
        }
        if (log.isTraceEnabled()) {
            Tools.logMethodOut(log, LogLevel.TRACE, "getSize", result);
        }
        return result;
    }
}

